/******************************************************************************
 * MiniOthello.java
 *
 * Graphical User Interface for MiniOthello
 *
 * MiniOthello is free software under GNU's General Public License (GPL),
 * version 2 or any later ones.
 *
 * This is a frontend for the console version of MiniOthello (0.02 or higher)
 * or actually any console Othello programs as long as they implement the
 * following specification:
 *
 * Input:
 * -gm <board_encoding (67 chars)>
 *
 * Output:
 * print a move given the current position represented by <board_encoding>
 * to stdout (int 0 - 63)
 *
 * <board_encoding>:
 * [64 chars (0-Empty, 1-B, 2-W)][1 char whose turn (1/2)][2 char last move
 * (10 + actualy move (0-63) e.g. 10 for A1, 73 for H8, so as to gurrantee
 * double digits]
 *
 * Other Switches (optional):
 * -D <search_depth>
 * -E <end_game_search_depth>
 * -stat       (print additional info to stdout, separated by whitespace)
 *
 * The Game.playComputerMove() is the interface between GUI and AI engine
 *
 *
 * Note: Iterative deepening and time-constaint playing is implemented in this
 * GUI, but not in the console version.
 *
 * Note: The engine doesn't search deep when the game is near the point of
 * getting exactly solved, even if large -D parameter is passed to it, since
 * MiniOthello's evaluation quality is rather miserable when there are very few
 * squares left
 *
 *
 * Acknowledgment: The designed idea come from a mix a WZebra and Pointy
 * (both of which are world-class players far above my humble program).
 * MiddGo has been a very helpful reference as I write this program.
 *
 * (This class doesn't really do anythink except starting the game,
 * it really should be merged in to the Game class.)
 *
 *
 * Yunpeng Li
 * Feb. 2005
 *
 */

package othelloGUI;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.applet.Applet;

/* Main class to start a game */
public class MiniOthello {
    public static final String VERSION = "0.01e";

    // Path of class files
    //public static final String PATH = "othelloGUI/";
    public static final String ENGINE_PATH = "engine/";
    public static final String ENGINE_NAME = "othello";
    public static final String PICTURE_PATH = "gui/pics/";
    public static final String ICON_FILE = "icon.gif";
    public static final String SAVE_GAME_PATH = "savegame/";
    public static final String LAST_GAME_FILE_NAME = "lastgame.log";

    public static final boolean DISABLE_TEXT_AREA_IN_LINUX = true;

    public static String osName;

    public static void main(String[] args) {
        osName = System.getProperty("os.name");
        Runtime rt = Runtime.getRuntime();
        Process othello = null;
        String istr = null, ostr = null;
        char[] istrarr = null, ostrarr = null;
        int exitVal = -1;
        //int availBytes = 0;

        Game game = new Game();
        // -- seems unnecessary -- game.start();  // actually no need for multi-threading here

        //System.out.println("done.");
    }
}




/* ---------- Code for experimenting/testing/debugging ------------ */

/*
        try {
            String command = "engine/othello -D 12 -gm 0000000000000000000000000002220000011100000000000000000000000000129 -st";
            String osName = System.getProperty("os.name");
            System.out.println("System: " + osName);
            if(osName.equals("UNIX") || osName.equals("Linux"))
                othello = rt.exec("./othello -L0 -n");
            else
                othello = rt.exec(command);
            InputStream is = othello.getInputStream();
            OutputStream os = othello.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write("blabla.........\n");
            bw.flush();
            ostrarr = new char[1000];
            ostrarr[0] = 'O'; ostrarr[1] = 'K'; ostrarr[2] = (char)0;
            //osw.write(ostrarr, 0, 3);
            //osw.flush();
            //Thread.sleep(1000);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            istrarr = new char[200];
            istr = br.readLine();
            System.out.println("Result: " + istr);

            exitVal = othello.waitFor();
            //isr.read(istrarr);
            //System.out.println("here");
            //availBytes = is.available();
        }
        catch(Throwable e) {
            e.printSrace();
        }

        System.out.println("Exit value: " + exitVal);
        System.out.println("(byte)'A': " + (byte)'A');
        //System.out.println("Available: " + availBytes);
    }
*/

/*


        // test board
        Board b = new Board();
        int move;
        byte[] buf = new byte[1000];
        boolean end = false;
        while(!end) {
            b.print();
            System.out.print("Move: ");
            try {
                System.in.read(buf);
            } catch(IOException e) {}
            if((new String(buf, 0, 4)).equals("quit"))
                end = true;
            else if((new String(buf, 0, 4)).equals("undo"))
                b.undoMove();
            else {
                move = ((byte)buf[0] - (byte)'a') + 8 * ((byte)buf[1] - (byte)'1');
                if(b.legalMove(move)) {
                    b.makeMove(move);
                }
                else {
                    System.out.println("Illegal move: " + move);
                }
            }
        }
*/

