/****
  Minimax.hpp
  
  */
  
#ifndef _MINIMAX_HPP_
#define _MINIMAX_HPP_

#include <time.h>
#include <assert.h>
#include "board.hpp"
#include "endgamecx.h"

#define MAX_INT 2147483647
#define MIN_INT -2147483648
#define LARGE_FLOAT 1.0e35
#define SMALL_FLOAT -1.0e35
#define HUGE_FLOAT 2.0e38
#define TINY_FLOAT -2.0e38

#define HARD_WIRED_FIRST_MOVE 37  // F-5 position
#define HARD_WIRED_FIRST_MOVE_BOARD_FLIPPED 34  // C-5

#define ESTIMATED_CORNER_WORTH 10.0  // wild estimate
#define DENOMINATOR_EXTRA_PREV_MIN_DOF 0.25  // for avoiding divide by 0

// need to be experimented for best values
#define USE_MOVE_ORDERING 1
#define DO_USE_QUIESCENCE_SEARCH  0 // to be implemented!
#define MIN_DEPTH_FOR_ORDERING 6  // min depth to use ordering
#define MAX_ORDERING_SEARCH_DEPTH 6 // max depth of an ordering search
#define ORDERING_SEARCH_DEPTH_OFFSET 4 // how many plies fewer is ordering search than normal search
#define MIN_EMPTIES_FOR_ORDERING 12 // min number of empty squares left for doing search ordering

// test/debug 
#define DEBUG_MINIMAX 0
#define AB_DEBUG 0
#define DEEP_DEBUG 0
#define CURRENT_DEBUG 0
#define CURRENT_DEBUG2 0

#define COUNT_PRUNING 1

extern char searchDepth;
extern char originalSearchDepth;
extern char bruteForceDepth; // for approaching the end of game.
extern char mpcDepth;
extern bool winLarge;
extern bool loseSmall;
extern char randomnessLevel;
extern bool useAndersson;  // use Andersson's sophisticated end game solver

extern bool boardFlipped;
extern bool showDots;  // simply for output


char getMinimaxMove(Board *board, bool *lm);
float getMin(char *a, char lastMove, char color, char depth, char passes, 
             char prevmaxDOF, char prevminDOF, //Mobility in previous getMax and getMin;
             char selfPieces, char oppPieces, float alpha, float beta);
float getMax(char *a, char lastMove, char color, char depth, char passes, 
             char prevmaxDOF, char prevminDOF, 
             char selfPieces, char oppPieces, float alpha, float beta);

void copyBoardArray(char *to, char *from);
bool canFlip(char *a, char place, char dir, char color, char oppcolor);
bool legalMove(char *a, char color, char place);
char findLegalMoves(char *a, char color, char *legalMoves);
char tryMove(char *a, char color, char place, char *flipped);
inline void undo(char *a, char color, char place, char *flipped, char nFlipped);

int evaluateEndGame(char selfPieces, char oppPieces);
int evaluateEndGameWDL(char selfPieces, char oppPieces);
float evaluateBoard(char *a, char forWhom, char whoseTurn, char prevmaxDOF, 
                    char prevminDOF, char selfPieces, char oppPieces);

void printBoardArray(char *a);
int strongEndGameSolve(char *a, char color, char selfPieces, char oppPieces, 
                      char prevNotPass, float alpha, float beta);

#endif
