/*
 * Decompiled with CFR 0.152.
 */
package othelloGUI;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import othelloGUI.Board;
import othelloGUI.Game;
import othelloGUI.GameDriver;
import othelloGUI.InfoDialog;
import othelloGUI.MiniOthello;
import othelloGUI.Util;

public class OthelloFrame
extends Frame {
    public static int DRAWING_AREA_X_OFFSET = 0;
    public static int DRAWING_AREA_Y_OFFSET = 42;
    public static int TOOLBAR_X_OFFSET = 0;
    public static int TOOLBAR_Y_OFFSET = 0;
    public static int TOOLBAR_X_HEIGHT = 0;
    public static int BOARD_FRAME_X_OFFSET = 30;
    public static int BOARD_FRAME_Y_OFFSET = 55;
    public static int BOARD_FRAME_WIDTH = 40;
    public static int LOWER_MARGIN = 15;
    public static int RIGHT_MARGIN = 250;
    public static int BOARD_CELL_SIZE = 60;
    public static int DISC_RADIUS = 25;
    public static int GRAY_DOT_RADIUS = 4;
    public static int BLUE_DOT_RADIUS = 4;
    public static String[] WINDOW_POSITION_OS_NAMES = new String[]{"Windows Vista", "Windows 7", "Linux"};
    public static int[] WINDOW_POSITION_VALUES_X = new int[]{5, 5, 5};
    public static int[] WINDOW_POSITION_VALUES_Y = new int[]{5, 5, 30};
    public static int BOARD_SIZE = BOARD_CELL_SIZE * 8;
    public static int BOARD_X_OFFSET = BOARD_FRAME_X_OFFSET + BOARD_FRAME_WIDTH;
    public static int BOARD_Y_OFFSET = BOARD_FRAME_Y_OFFSET + BOARD_FRAME_WIDTH;
    public static int BOARD_FRAME_SIZE = BOARD_SIZE + 2 * BOARD_FRAME_WIDTH;
    public static int BOARD_FRAME_RIGHT_POS = BOARD_FRAME_X_OFFSET + BOARD_FRAME_SIZE;
    public static int BOARD_FRAME_LOWER_POS = BOARD_FRAME_Y_OFFSET + BOARD_FRAME_SIZE;
    public static int WINDOW_SIZE_X = BOARD_FRAME_RIGHT_POS + RIGHT_MARGIN;
    public static int WINDOW_SIZE_Y = BOARD_FRAME_LOWER_POS + LOWER_MARGIN;
    public static int BIG_BUTTON_WIDTH = 130;
    public static int BIG_BUTTON_HEIGHT = 55;
    public static int BIG_BUTTON_POS_X = WINDOW_SIZE_X - (RIGHT_MARGIN + BIG_BUTTON_WIDTH) / 2;
    public static int BIG_BUTTON_POS_Y = WINDOW_SIZE_Y - 5 - LOWER_MARGIN - BIG_BUTTON_HEIGHT;
    public static int BUTTON_WIDTH = 40;
    public static int BUTTON_HEIGHT = 30;
    public static int BUTTON_SPACE_BETWEEN = 5;
    public static int BUTTON_GROUP_WIDTH = 4 * BUTTON_WIDTH + 3 * BUTTON_SPACE_BETWEEN;
    public static int BUTTON_POS_X = WINDOW_SIZE_X - (RIGHT_MARGIN + BUTTON_GROUP_WIDTH) / 2;
    public static int BUTTON_POS_Y = BIG_BUTTON_POS_Y - BUTTON_HEIGHT - 20;
    public static int CROSS_DIM_S = 6;
    public static int CROSS_DIM_L = 7;
    public static int INFOBOX_POS_X = BOARD_FRAME_RIGHT_POS + 30;
    public static int INFOBOX_POS_Y = BUTTON_POS_Y - 200;
    public static final boolean ADD_P_LEVELS = false;
    public static int[][] DIFFICULTY_LEVEL = new int[][]{{1, 8}, {2, 10}, {4, 12}, {6, 14}, {8, 16}, {10, 18}, {12, 20}};
    public static int[][] PLAYER_ROLES = new int[][]{{1, 0}, {0, 1}, {0, 0}, {1, 1}};
    public static int STOOGE = 0;
    public static int MINDLESS = 1;
    public static int NOVICE = 2;
    public static int BEGINNER = 3;
    public static int AMATEUR = 4;
    public static int AMATEUR_P = 5;
    public static int EXPERIENCED = 6;
    public static int EXPERIENCED_P = 7;
    public static int ADVANCED = 8;
    public static int ADVANCED_P = 9;
    public static int EXPERT = 10;
    public static int CUSTOMIZE = 11;
    public static int COM_HUM = 0;
    public static int HUM_COM = 1;
    public static int HUM_HUM = 2;
    public static int COM_COM = 3;
    public static int[] SOFT_LIMIT = new int[]{1000, 2000, 4000, 8000, 15000, 30000, 60000, 0};
    public static int[] HARD_LIMIT = new int[]{2000, 5000, 10000, 30000, 60000, 0};
    private Image screen;
    private Graphics g;
    private Graphics2D g2;
    private GameDriver gd;
    private OthelloFrame frame;
    private MenuBar menu;
    private Menu fileM;
    private Menu gameM;
    private Menu difficultyM;
    private Menu optionsM;
    private Menu helpM;
    private MenuItem newGameM;
    private MenuItem loadGameM;
    private MenuItem saveGameM;
    private MenuItem exitM;
    private CheckboxMenuItem[] comPlayerM;
    private MenuItem undoM;
    private MenuItem redoM;
    private MenuItem undoAllM;
    private MenuItem redoAllM;
    private MenuItem stopComThinkingM;
    private MenuItem comPlayMoveM;
    private CheckboxMenuItem[] levelMs;
    private CheckboxMenuItem flexibleTimeM;
    private CheckboxMenuItem showAvailMovesM;
    private CheckboxMenuItem showLastMoveM;
    private CheckboxMenuItem showStatM;
    private CheckboxMenuItem mirroredStartM;
    private CheckboxMenuItem saveSettingsM;
    private Menu miscellaneousM;
    private CheckboxMenuItem scaleEvalM;
    private CheckboxMenuItem keepMessagesM;
    private CheckboxMenuItem saveLastGameM;
    private CheckboxMenuItem leftClickToPassM;
    private CheckboxMenuItem rightClickToPassM;
    private CheckboxMenuItem showScoreInEvalM;
    private CheckboxMenuItem rightClickForForcedMoveM;
    private MenuItem saveSettingsNowM;
    private MenuItem refreshScreenM;
    private MenuItem helpContentM;
    private MenuItem aboutMiniOthelloM;
    private Menu fixedDepthM;
    private Menu softLimitM;
    private Menu hardLimitM;
    private CheckboxMenuItem[] sItems;
    private CheckboxMenuItem[] hItems;
    private Menu randomnessM;
    private CheckboxMenuItem[] rItems;
    protected TextArea pastMoves;
    protected TextArea infoBox;
    protected Button startB;
    protected Button undoB;
    protected Button redoB;
    protected Button undoAllB;
    protected Button redoAllB;
    private int comPlayerState;
    private int level;
    private boolean gameStarting;
    private Board board;
    private Game game;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OthelloFrame(String string, Board board, Game game) {
        super(string);
        this.board = board;
        this.game = game;
        OthelloFrame othelloFrame = this;
        synchronized (othelloFrame) {
            int n;
            int n2;
            int n3;
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            Image image = Toolkit.getDefaultToolkit().getImage("gui/pics/icon.gif");
            this.setIconImage(image);
            String string2 = System.getProperty("os.name");
            for (n3 = 0; n3 < WINDOW_POSITION_OS_NAMES.length; ++n3) {
                if (!string2.equals(WINDOW_POSITION_OS_NAMES[n3])) continue;
                this.setLocation(this.getLocation().x + WINDOW_POSITION_VALUES_X[n3], this.getLocation().y + WINDOW_POSITION_VALUES_Y[n3]);
            }
            this.setSize(WINDOW_SIZE_X, WINDOW_SIZE_Y);
            this.setVisible(true);
            this.setResizable(false);
            this.setBackground(Util.WINDOW_BACKGROUND);
            this.screen = this.createImage(this.getSize().width, this.getSize().height);
            this.g = this.getGraphics();
            this.g2 = (Graphics2D)this.screen.getGraphics();
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.menu = new MenuBar();
            this.fileM = new Menu("File");
            this.gameM = new Menu("Game");
            this.difficultyM = new Menu("AI Settings");
            this.optionsM = new Menu("Options");
            this.helpM = new Menu("Help");
            this.newGameM = new MenuItem("New Game", new MenuShortcut(78));
            this.loadGameM = new MenuItem("Load Game...");
            this.saveGameM = new MenuItem("Save Game...");
            this.exitM = new MenuItem("Exit");
            this.comPlayerM = new CheckboxMenuItem[4];
            this.comPlayerM[OthelloFrame.HUM_COM] = new CheckboxMenuItem("Computer Plays White", this.game.player[0] == 0 && this.game.player[1] == 1);
            this.comPlayerM[OthelloFrame.COM_HUM] = new CheckboxMenuItem("Computer Plays Black", this.game.player[0] == 1 && this.game.player[1] == 0);
            this.comPlayerM[OthelloFrame.HUM_HUM] = new CheckboxMenuItem("Computer Doesn't Play", this.game.player[0] == 0 && this.game.player[1] == 0);
            this.comPlayerM[OthelloFrame.COM_COM] = new CheckboxMenuItem("Computer Plays Both Sides", this.game.player[0] == 1 && this.game.player[1] == 1);
            this.undoM = new MenuItem("Undo", new MenuShortcut(66));
            this.redoM = new MenuItem("Redo", new MenuShortcut(70));
            this.undoAllM = new MenuItem("Undo All Moves");
            this.redoAllM = new MenuItem("Redo All Moves");
            this.comPlayMoveM = new MenuItem("Computer Plays This Move", new MenuShortcut(68));
            this.stopComThinkingM = new MenuItem("Stop Computer Thinking (if it is taking too long)");
            this.levelMs = new CheckboxMenuItem[CUSTOMIZE + 1];
            n3 = 0;
            int n4 = this.game.searchDepth == 1 && this.game.endGameDepth == 8 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.STOOGE] = new CheckboxMenuItem("1-Ply, 8-Ply End  (Fastest, Easiest)", n4 != 0);
            n4 = this.game.searchDepth == 2 && this.game.endGameDepth == 10 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.MINDLESS] = new CheckboxMenuItem("2-Ply, 10-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 4 && this.game.endGameDepth == 12 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.NOVICE] = new CheckboxMenuItem("4-Ply, 12-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 6 && this.game.endGameDepth == 14 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.BEGINNER] = new CheckboxMenuItem("6-Ply, 14-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 8 && this.game.endGameDepth == 16 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.AMATEUR] = new CheckboxMenuItem("8-Ply, 16-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 8 && this.game.endGameDepth == 18 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.AMATEUR_P] = new CheckboxMenuItem("8-Ply, 18-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 10 && this.game.endGameDepth == 18 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.EXPERIENCED] = new CheckboxMenuItem("10-Ply, 18-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 10 && this.game.endGameDepth == 20 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.EXPERIENCED_P] = new CheckboxMenuItem("10-Ply, 20-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 12 && this.game.endGameDepth == 20 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.ADVANCED] = new CheckboxMenuItem("12-Ply, 20-Ply End", n4 != 0);
            n4 = this.game.searchDepth == 12 && this.game.endGameDepth == 22 ? 1 : 0;
            n3 |= n4;
            this.levelMs[OthelloFrame.ADVANCED_P] = new CheckboxMenuItem("12-Ply, 22-Ply End  (Slow)", n4 != 0);
            n4 = this.game.searchDepth == 14 && this.game.endGameDepth == 22 ? 1 : 0;
            this.levelMs[OthelloFrame.EXPERT] = new CheckboxMenuItem("14-Ply, 22-Ply End  ( Very Slow !!! )", n4 != 0);
            this.levelMs[OthelloFrame.CUSTOMIZE] = new CheckboxMenuItem("Customize...", (n3 |= n4) == 0);
            this.levelMs[CUSTOMIZE].setEnabled(false);
            this.flexibleTimeM = new CheckboxMenuItem("Flexible Time Limit (more efficient)");
            this.fixedDepthM = new Menu("Fixed-depth Search");
            this.showAvailMovesM = new CheckboxMenuItem("Show Available Moves", this.game.showAvailMoves);
            this.showLastMoveM = new CheckboxMenuItem("Show Last Move", this.game.showLastMove);
            this.showStatM = new CheckboxMenuItem("Show Statistics", this.game.showStat);
            this.mirroredStartM = new CheckboxMenuItem("Mirrored Starting Position", this.game.mirroredStart);
            this.saveSettingsM = new CheckboxMenuItem("Save Settings on Exit");
            this.saveSettingsNowM = new MenuItem("Save Settings Now");
            this.refreshScreenM = new MenuItem("Refresh Screen", new MenuShortcut(82));
            this.miscellaneousM = new Menu("Miscellaneous...");
            this.scaleEvalM = new CheckboxMenuItem("Scale Evaluation to Approximate Score", this.game.scaleEval);
            this.keepMessagesM = new CheckboxMenuItem("Show Cached Messages When Undo/Redo", this.game.keepMessages);
            this.showScoreInEvalM = new CheckboxMenuItem("Show Optimal Final Score in Evaluation", this.game.showScoreInEval);
            this.saveLastGameM = new CheckboxMenuItem("Autosave Last Completed Game", this.game.saveLastGame);
            this.leftClickToPassM = new CheckboxMenuItem("Left-click Anywhere on Board to Pass", this.game.leftClickToPass);
            this.rightClickToPassM = new CheckboxMenuItem("Right-click Anywhere to Pass", this.game.rightClickToPass);
            this.rightClickForForcedMoveM = new CheckboxMenuItem("Right-click Anywhere to Play Forced Move", this.game.rightClickForForcedMove);
            this.helpContentM = new MenuItem("Content...", new MenuShortcut(112));
            this.helpContentM.setEnabled(false);
            this.aboutMiniOthelloM = new MenuItem("About MiddOthello...");
            this.softLimitM = new Menu("Time-dependent Search");
            this.hardLimitM = new Menu("Hard Limit (per-Move)");
            this.sItems = new CheckboxMenuItem[SOFT_LIMIT.length];
            this.hItems = new CheckboxMenuItem[HARD_LIMIT.length];
            this.sItems[0] = new CheckboxMenuItem("1 Second of Move");
            for (n2 = 1; n2 < this.sItems.length - 1; ++n2) {
                this.sItems[n2] = new CheckboxMenuItem(SOFT_LIMIT[n2] / 1000 + " Seconds per Move", false);
            }
            this.sItems[this.sItems.length - 1] = new CheckboxMenuItem("Customize...", false);
            this.sItems[this.sItems.length - 1].setEnabled(false);
            for (n2 = 0; n2 < this.hItems.length - 1; ++n2) {
                this.hItems[n2] = new CheckboxMenuItem(HARD_LIMIT[n2] / 1000 + " Seconds Maximum", false);
            }
            this.hItems[this.hItems.length - 1] = new CheckboxMenuItem("None", false);
            this.randomnessM = new Menu("Randomness Level");
            this.rItems = new CheckboxMenuItem[Game.R_LEVELS.length];
            this.rItems[0] = new CheckboxMenuItem("None", false);
            this.rItems[1] = new CheckboxMenuItem("Known Openings Only", false);
            this.rItems[2] = new CheckboxMenuItem("Small", false);
            this.rItems[3] = new CheckboxMenuItem("Medium", false);
            this.rItems[4] = new CheckboxMenuItem("Large", false);
            this.pastMoves = new TextArea("", 40, 25, 1);
            this.pastMoves.setBackground(Color.white);
            this.pastMoves.setFont(new Font("Courier", 1, 13));
            this.pastMoves.setSize(190, 185);
            this.pastMoves.setLocation(BOARD_FRAME_RIGHT_POS + 30, BUTTON_POS_Y - 345);
            this.pastMoves.setEditable(false);
            this.pastMoves.setFocusable(false);
            this.pastMoves.setCursor(new Cursor(0));
            this.infoBox = new TextArea("Message", 6, 25, 3);
            this.infoBox.setBackground(Color.white);
            this.infoBox.setFont(new Font("Courier", 1, 12));
            this.infoBox.setSize(190, 125);
            this.infoBox.setLocation(BOARD_FRAME_RIGHT_POS + 30, BUTTON_POS_Y - 140);
            this.infoBox.setEditable(false);
            this.infoBox.setFocusable(false);
            this.infoBox.setCursor(new Cursor(0));
            this.startB = new Button("");
            this.undoB = new Button("<-");
            this.redoB = new Button("->");
            this.undoAllB = new Button("|<<");
            this.redoAllB = new Button(">>|");
            Font font = new Font("monospaced", 1, 18);
            this.undoB.setFont(font);
            this.redoB.setFont(font);
            this.undoAllB.setFont(font);
            this.redoAllB.setFont(font);
            this.startB.setFont(new Font("Dialog", 1, 32));
            this.undoAllB.setLocation(BUTTON_POS_X, BUTTON_POS_Y);
            this.undoB.setLocation(BUTTON_POS_X + 1 * (BUTTON_WIDTH + BUTTON_SPACE_BETWEEN), BUTTON_POS_Y);
            this.redoB.setLocation(BUTTON_POS_X + 2 * (BUTTON_WIDTH + BUTTON_SPACE_BETWEEN), BUTTON_POS_Y);
            this.redoAllB.setLocation(BUTTON_POS_X + 3 * (BUTTON_WIDTH + BUTTON_SPACE_BETWEEN), BUTTON_POS_Y);
            this.startB.setLocation(BIG_BUTTON_POS_X, BIG_BUTTON_POS_Y);
            this.undoB.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
            this.redoB.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
            this.undoAllB.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
            this.redoAllB.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
            this.startB.setSize(0, 0);
            this.undoB.setEnabled(false);
            this.redoB.setEnabled(false);
            this.undoAllB.setEnabled(false);
            this.redoAllB.setEnabled(false);
            this.startB.setEnabled(false);
            this.newGameM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.game.newGame();
                }
            });
            this.loadGameM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OthelloFrame.this.game.canPlay()) {
                        OthelloFrame.this.game.loadGame();
                    }
                }
            });
            this.saveGameM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OthelloFrame.this.game.canPlay()) {
                        OthelloFrame.this.game.saveGame();
                    }
                }
            });
            this.exitM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.exit();
                }
            });
            this.comPlayerM[COM_HUM].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.player[0] = PLAYER_ROLES[COM_HUM][0];
                    ((OthelloFrame)OthelloFrame.this).game.player[1] = PLAYER_ROLES[COM_HUM][1];
                    OthelloFrame.this.game.rollSwapped();
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.paint(OthelloFrame.this.getGraphics());
                }
            });
            this.comPlayerM[HUM_COM].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.player[0] = PLAYER_ROLES[HUM_COM][0];
                    ((OthelloFrame)OthelloFrame.this).game.player[1] = PLAYER_ROLES[HUM_COM][1];
                    OthelloFrame.this.game.rollSwapped();
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.paint(OthelloFrame.this.getGraphics());
                }
            });
            this.comPlayerM[HUM_HUM].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.player[0] = PLAYER_ROLES[HUM_HUM][0];
                    ((OthelloFrame)OthelloFrame.this).game.player[1] = PLAYER_ROLES[HUM_HUM][1];
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.paint(OthelloFrame.this.getGraphics());
                }
            });
            this.comPlayerM[COM_COM].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.player[0] = PLAYER_ROLES[COM_COM][0];
                    ((OthelloFrame)OthelloFrame.this).game.player[1] = PLAYER_ROLES[COM_COM][1];
                    OthelloFrame.this.game.rollSwapped();
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.paint(OthelloFrame.this.getGraphics());
                }
            });
            this.comPlayMoveM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((OthelloFrame)OthelloFrame.this).game.player[OthelloFrame.this.game.getCurrPlayer()] != 0 || !OthelloFrame.this.game.canPlay()) {
                        return;
                    }
                    if (OthelloFrame.this.board.hasLegalMove()) {
                        OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                        OthelloFrame.this.gd.setState(3);
                        OthelloFrame.this.gd.start();
                    } else {
                        OthelloFrame.this.board.switchSide();
                        boolean bl = !OthelloFrame.this.board.hasLegalMove();
                        OthelloFrame.this.board.switchSide();
                        if (!bl) {
                            OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                            OthelloFrame.this.gd.setState(4);
                            OthelloFrame.this.gd.start();
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.stopComThinkingM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.game.stopComputerThinking();
                }
            });
            this.levelMs[STOOGE].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 1;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 8;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[MINDLESS].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 2;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 10;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[NOVICE].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 4;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 12;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[BEGINNER].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 6;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[AMATEUR].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 8;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 16;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[AMATEUR_P].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 8;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 18;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[EXPERIENCED].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 10;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 18;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[EXPERIENCED_P].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 10;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 20;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[ADVANCED].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 12;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 20;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[ADVANCED_P].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 12;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 22;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[EXPERT].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 22;
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = false;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.levelMs[CUSTOMIZE].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                }
            });
            this.flexibleTimeM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.smartPlay = !((OthelloFrame)OthelloFrame.this).game.smartPlay;
                    OthelloFrame.this.flexibleTimeM.setState(((OthelloFrame)OthelloFrame.this).game.smartPlay);
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.showAvailMovesM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.showAvailMoves = !((OthelloFrame)OthelloFrame.this).game.showAvailMoves;
                    OthelloFrame.this.showAvailMovesM.setState(((OthelloFrame)OthelloFrame.this).game.showAvailMoves);
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.showLastMoveM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.showLastMove = !((OthelloFrame)OthelloFrame.this).game.showLastMove;
                    OthelloFrame.this.showLastMoveM.setState(((OthelloFrame)OthelloFrame.this).game.showLastMove);
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.showStatM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.showStat = !((OthelloFrame)OthelloFrame.this).game.showStat;
                    OthelloFrame.this.showStatM.setState(((OthelloFrame)OthelloFrame.this).game.showStat);
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.mirroredStartM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.mirroredStart = !((OthelloFrame)OthelloFrame.this).game.mirroredStart;
                    OthelloFrame.this.mirroredStartM.setState(((OthelloFrame)OthelloFrame.this).game.mirroredStart);
                }
            });
            this.saveSettingsM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.saveSettings = !((OthelloFrame)OthelloFrame.this).game.saveSettings;
                    OthelloFrame.this.saveSettingsM.setState(((OthelloFrame)OthelloFrame.this).game.saveSettings);
                }
            });
            this.saveSettingsNowM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.game.saveSettings();
                }
            });
            this.refreshScreenM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.game.recreateFrame();
                }
            });
            this.scaleEvalM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.scaleEval = !((OthelloFrame)OthelloFrame.this).game.scaleEval;
                    OthelloFrame.this.scaleEvalM.setState(((OthelloFrame)OthelloFrame.this).game.scaleEval);
                }
            });
            this.keepMessagesM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.keepMessages = !((OthelloFrame)OthelloFrame.this).game.keepMessages;
                    OthelloFrame.this.keepMessagesM.setState(((OthelloFrame)OthelloFrame.this).game.keepMessages);
                }
            });
            this.showScoreInEvalM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.showScoreInEval = !((OthelloFrame)OthelloFrame.this).game.showScoreInEval;
                    OthelloFrame.this.showScoreInEvalM.setState(((OthelloFrame)OthelloFrame.this).game.showScoreInEval);
                }
            });
            this.saveLastGameM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.saveLastGame = !((OthelloFrame)OthelloFrame.this).game.saveLastGame;
                    OthelloFrame.this.saveLastGameM.setState(((OthelloFrame)OthelloFrame.this).game.saveLastGame);
                }
            });
            this.leftClickToPassM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.leftClickToPass = !((OthelloFrame)OthelloFrame.this).game.leftClickToPass;
                    OthelloFrame.this.leftClickToPassM.setState(((OthelloFrame)OthelloFrame.this).game.leftClickToPass);
                }
            });
            this.rightClickToPassM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.rightClickToPass = !((OthelloFrame)OthelloFrame.this).game.rightClickToPass;
                    OthelloFrame.this.rightClickToPassM.setState(((OthelloFrame)OthelloFrame.this).game.rightClickToPass);
                }
            });
            this.rightClickForForcedMoveM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.rightClickForForcedMove = !((OthelloFrame)OthelloFrame.this).game.rightClickForForcedMove;
                    OthelloFrame.this.rightClickForForcedMoveM.setState(((OthelloFrame)OthelloFrame.this).game.rightClickForForcedMove);
                }
            });
            this.aboutMiniOthelloM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.showAbout();
                }
            });
            this.startB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.startB.setSize(0, 0);
                    OthelloFrame.this.startB.setEnabled(false);
                    if (OthelloFrame.this.startB.getLabel().equals("PASS")) {
                        if (!OthelloFrame.this.game.canPlay()) {
                            return;
                        }
                        OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                        OthelloFrame.this.gd.setState(6);
                        OthelloFrame.this.gd.start();
                    } else if (OthelloFrame.this.startB.getLabel().equals("Start")) {
                        if (!OthelloFrame.this.game.canPlay()) {
                            return;
                        }
                        if (((OthelloFrame)OthelloFrame.this).game.player[0] == 1 && ((OthelloFrame)OthelloFrame.this).game.player[1] == 1) {
                            OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                            OthelloFrame.this.gd.setState(1);
                            OthelloFrame.this.gd.start();
                        } else {
                            OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                            OthelloFrame.this.gd.setState(2);
                            OthelloFrame.this.gd.start();
                        }
                    } else if (OthelloFrame.this.startB.getLabel().equals("New Game")) {
                        if (!OthelloFrame.this.game.canPlay()) {
                            return;
                        }
                        OthelloFrame.this.game.newGame();
                    } else if (OthelloFrame.this.startB.getLabel().equals("Stop")) {
                        OthelloFrame.this.game.stopSelfPlay();
                    }
                }
            });
            this.undoB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                    OthelloFrame.this.gd.setState(7);
                    OthelloFrame.this.gd.start();
                }
            });
            this.undoAllB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OthelloFrame.this.game.canPlay()) {
                        OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                        OthelloFrame.this.gd.setState(9);
                        OthelloFrame.this.gd.start();
                    }
                }
            });
            this.redoB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OthelloFrame.this.game.canPlay()) {
                        OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                        OthelloFrame.this.gd.setState(8);
                        OthelloFrame.this.gd.start();
                    }
                }
            });
            this.redoAllB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OthelloFrame.this.game.canPlay()) {
                        OthelloFrame.this.gd = new GameDriver(OthelloFrame.this.frame, OthelloFrame.this.game, OthelloFrame.this.board);
                        OthelloFrame.this.gd.setState(10);
                        OthelloFrame.this.gd.start();
                    }
                }
            });
            this.sItems[0].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[0];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[1].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[1];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[2].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[2];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[3].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[3];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[4].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[4];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[5].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[5];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[6].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    ((OthelloFrame)OthelloFrame.this).game.softTimeLimit = SOFT_LIMIT[6];
                    ((OthelloFrame)OthelloFrame.this).game.searchDepth = 14;
                    ((OthelloFrame)OthelloFrame.this).game.endGameDepth = 32;
                    OthelloFrame.this.gameStarting = false;
                    OthelloFrame.this.game.updateGraphics();
                }
            });
            this.sItems[7].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.timeDependent = true;
                    OthelloFrame.this.updateMenu();
                }
            });
            this.hItems[0].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.hardTimeLimit = HARD_LIMIT[0];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.hItems[1].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.hardTimeLimit = HARD_LIMIT[1];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.hItems[2].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.hardTimeLimit = HARD_LIMIT[2];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.hItems[3].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.hardTimeLimit = HARD_LIMIT[3];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.hItems[4].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.hardTimeLimit = HARD_LIMIT[4];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.hItems[5].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.hardTimeLimit = HARD_LIMIT[5];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.rItems[0].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.randomnessLevel = Game.R_LEVELS[0];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.rItems[1].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.randomnessLevel = Game.R_LEVELS[1];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.rItems[2].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.randomnessLevel = Game.R_LEVELS[2];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.rItems[3].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.randomnessLevel = Game.R_LEVELS[3];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.rItems[4].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((OthelloFrame)OthelloFrame.this).game.randomnessLevel = Game.R_LEVELS[4];
                    OthelloFrame.this.updateMenu();
                }
            });
            this.fileM.add(this.newGameM);
            this.fileM.addSeparator();
            this.fileM.add(this.loadGameM);
            this.fileM.add(this.saveGameM);
            this.fileM.addSeparator();
            this.fileM.add(this.exitM);
            for (n = 0; n < 4; ++n) {
                this.gameM.add(this.comPlayerM[n]);
            }
            this.gameM.addSeparator();
            this.gameM.add(this.comPlayMoveM);
            this.gameM.addSeparator();
            this.gameM.add(this.stopComThinkingM);
            for (n = 0; n < this.sItems.length - 1; ++n) {
                this.softLimitM.add(this.sItems[n]);
            }
            this.softLimitM.addSeparator();
            this.softLimitM.add(this.sItems[this.sItems.length - 1]);
            this.softLimitM.addSeparator();
            this.softLimitM.add(this.flexibleTimeM);
            for (n = 0; n < this.hItems.length; ++n) {
                this.hardLimitM.add(this.hItems[n]);
            }
            for (n = 0; n <= AMATEUR; ++n) {
                this.fixedDepthM.add(this.levelMs[n]);
            }
            this.fixedDepthM.add(this.levelMs[EXPERIENCED]);
            this.fixedDepthM.add(this.levelMs[ADVANCED]);
            this.fixedDepthM.add(this.levelMs[EXPERT]);
            this.fixedDepthM.addSeparator();
            this.fixedDepthM.add(this.levelMs[CUSTOMIZE]);
            for (n = 0; n < this.rItems.length; ++n) {
                this.randomnessM.add(this.rItems[n]);
            }
            this.difficultyM.add(this.fixedDepthM);
            this.difficultyM.add(this.softLimitM);
            this.difficultyM.add(this.randomnessM);
            this.difficultyM.addSeparator();
            this.difficultyM.add(this.hardLimitM);
            this.optionsM.add(this.showAvailMovesM);
            this.optionsM.add(this.showLastMoveM);
            this.optionsM.add(this.showStatM);
            this.optionsM.addSeparator();
            this.optionsM.add(this.mirroredStartM);
            this.optionsM.add(this.saveSettingsM);
            this.miscellaneousM.add(this.scaleEvalM);
            this.miscellaneousM.add(this.keepMessagesM);
            this.miscellaneousM.add(this.showScoreInEvalM);
            this.miscellaneousM.add(this.saveLastGameM);
            this.miscellaneousM.add(this.rightClickToPassM);
            this.miscellaneousM.add(this.rightClickForForcedMoveM);
            this.optionsM.add(this.miscellaneousM);
            this.optionsM.addSeparator();
            this.optionsM.add(this.saveSettingsNowM);
            this.optionsM.add(this.refreshScreenM);
            this.helpM.add(this.helpContentM);
            this.helpM.addSeparator();
            this.helpM.add(this.aboutMiniOthelloM);
            this.menu.add(this.fileM);
            this.menu.add(this.gameM);
            this.menu.add(this.difficultyM);
            this.menu.add(this.optionsM);
            this.menu.add(this.helpM);
            this.menu.setFont(new Font("Dialog", 0, 11));
            this.setMenuBar(this.menu);
            if (MiniOthello.osName.equalsIgnoreCase("Linux")) {
                // empty if block
            }
            this.add(this.pastMoves);
            this.add(this.infoBox);
            this.add(this.undoB);
            this.add(this.redoB);
            this.add(this.undoAllB);
            this.add(this.redoAllB);
            this.add(this.startB);
            this.initNewGame();
            this.frame = this;
            this.enableEvents(16L);
            this.enableEvents(8L);
            this.enableEvents(64L);
            this.enableEvents(32L);
            this.enableEvents(128L);
            this.setCursor(cursor);
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        if (this.screen == null) {
            this.screen = this.createImage(this.getSize().width, this.getSize().height);
        }
        if (this.g2 == null) {
            this.g2 = (Graphics2D)this.screen.getGraphics();
            this.g2.setBackground(Util.WINDOW_BACKGROUND);
        }
        if (graphics == null) {
            graphics = this.getGraphics();
        }
        int n = 0;
        boolean[] blArray = new boolean[64];
        n = this.board.findLegalMoves(blArray);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(Util.WINDOW_BACKGROUND);
        this.g2.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.g2.setColor(Util.WINDOW_BACKGROUND);
        this.g2.draw3DRect(3, DRAWING_AREA_Y_OFFSET, WINDOW_SIZE_X - 7, 1, false);
        this.updateButtons(n);
        this.updateTextAreas();
        this.drawBoard();
        this.drawDiscs();
        if (this.game.showAvailMoves) {
            this.drawAvailMoves(blArray);
        }
        if (this.game.showLastMove) {
            this.drawLastMove();
        }
        this.drawPlayerStat();
        this.updateMenu();
        if (graphics != null) {
            graphics.drawImage(this.screen, 0, 0, this);
        }
    }

    public void drawBoard() {
        int n;
        this.g2.setColor(Util.BOARD_FRAME);
        this.g2.fill3DRect(BOARD_FRAME_X_OFFSET, BOARD_FRAME_Y_OFFSET, BOARD_FRAME_SIZE, BOARD_FRAME_SIZE, true);
        this.g2.setColor(Util.BOARD_BACKGROUND);
        this.g2.fillRect(BOARD_X_OFFSET, BOARD_Y_OFFSET, BOARD_SIZE, BOARD_SIZE);
        this.g2.setColor(Util.BOARD_GRID);
        for (n = BOARD_Y_OFFSET + BOARD_CELL_SIZE; n <= BOARD_Y_OFFSET + 7 * BOARD_CELL_SIZE; n += BOARD_CELL_SIZE) {
            this.g2.drawLine(BOARD_X_OFFSET + 1, n - 1, BOARD_X_OFFSET + BOARD_SIZE - 2, n - 1);
            this.g2.drawLine(BOARD_X_OFFSET + 1, n, BOARD_X_OFFSET + BOARD_SIZE - 2, n);
        }
        for (n = BOARD_X_OFFSET + BOARD_CELL_SIZE; n <= BOARD_X_OFFSET + 7 * BOARD_CELL_SIZE; n += BOARD_CELL_SIZE) {
            this.g2.drawLine(n - 1, BOARD_Y_OFFSET + 1, n - 1, BOARD_Y_OFFSET + BOARD_SIZE - 2);
            this.g2.drawLine(n, BOARD_Y_OFFSET + 1, n, BOARD_Y_OFFSET + BOARD_SIZE - 2);
        }
        this.g2.drawRect(BOARD_X_OFFSET, BOARD_Y_OFFSET, BOARD_SIZE - 1, BOARD_SIZE - 1);
        this.g2.setColor(Util.FOUR_DOTS);
        this.drawDisc(BOARD_X_OFFSET + 2 * BOARD_CELL_SIZE, BOARD_Y_OFFSET + 2 * BOARD_CELL_SIZE, GRAY_DOT_RADIUS);
        this.drawDisc(BOARD_X_OFFSET + 2 * BOARD_CELL_SIZE, BOARD_Y_OFFSET + 6 * BOARD_CELL_SIZE, GRAY_DOT_RADIUS);
        this.drawDisc(BOARD_X_OFFSET + 6 * BOARD_CELL_SIZE, BOARD_Y_OFFSET + 2 * BOARD_CELL_SIZE, GRAY_DOT_RADIUS);
        this.drawDisc(BOARD_X_OFFSET + 6 * BOARD_CELL_SIZE, BOARD_Y_OFFSET + 6 * BOARD_CELL_SIZE, GRAY_DOT_RADIUS);
        this.g2.setFont(new Font("Dialog", 1, 24));
        for (n = 0; n < 8; ++n) {
            this.g2.drawString("" + (char)(65 + n), BOARD_X_OFFSET + n * BOARD_CELL_SIZE + 20, BOARD_FRAME_Y_OFFSET + 33);
            this.g2.drawString("" + (char)(49 + n), BOARD_FRAME_X_OFFSET + 16, BOARD_Y_OFFSET + n * BOARD_CELL_SIZE + 37);
        }
    }

    public void drawDiscs(boolean bl) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = this.board.getPiece(j, i);
                if (n == 1) {
                    this.drawDisc(j, i, Util.BLACK);
                    continue;
                }
                if (n == 2) {
                    this.drawDisc(j, i, Util.WHITE);
                    continue;
                }
                if (!bl) continue;
                this.drawDisc(j, i, Util.BOARD_BACKGROUND);
            }
        }
    }

    public void drawDiscs() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = this.board.getPiece(j, i);
                if (n == 1) {
                    this.drawDisc(j, i, Util.BLACK);
                    continue;
                }
                if (n != 2) continue;
                this.drawDisc(j, i, Util.WHITE);
            }
        }
    }

    public void drawPlayerStat() {
        this.g2.setColor(this.board.whoseTurn() == 1 ? Color.black : Color.white);
        this.g2.fillOval(BOARD_FRAME_RIGHT_POS + 60, BOARD_FRAME_Y_OFFSET + 5, 32, 32);
        this.g2.setColor(Color.black);
        this.g2.setFont(new Font("Dialog", 0, 18));
        this.g2.drawString("to Move", BOARD_FRAME_RIGHT_POS + 103, BOARD_FRAME_Y_OFFSET + 30);
        this.g2.setFont(new Font("Dialog", 0, 18));
        this.g2.drawString("Black:", BOARD_FRAME_RIGHT_POS + 60, BOARD_FRAME_Y_OFFSET + 62);
        this.g2.drawString("White:", BOARD_FRAME_RIGHT_POS + 60, BOARD_FRAME_Y_OFFSET + 85);
        this.g2.drawString(this.board.getDiscCount(1) + " discs", BOARD_FRAME_RIGHT_POS + 120, BOARD_FRAME_Y_OFFSET + 62);
        this.g2.drawString(this.board.getDiscCount(2) + " discs", BOARD_FRAME_RIGHT_POS + 120, BOARD_FRAME_Y_OFFSET + 85);
    }

    public void updateButtons(int n) {
        if (this.undoB != null) {
            this.undoB.setEnabled(this.board.canUndo());
        }
        if (this.redoB != null) {
            this.redoB.setEnabled(this.board.canRedo());
        }
        if (this.undoAllB != null) {
            this.undoAllB.setEnabled(this.board.canUndo());
        }
        if (this.redoAllB != null) {
            this.redoAllB.setEnabled(this.board.canRedo());
        }
        if (this.startB != null) {
            if (this.game.hasEnded()) {
                this.startB.setEnabled(false);
                this.startB.setLocation(BIG_BUTTON_POS_X, BIG_BUTTON_POS_Y);
                this.startB.setSize(BIG_BUTTON_WIDTH, BIG_BUTTON_HEIGHT);
                if (MiniOthello.osName.equalsIgnoreCase("Linux")) {
                    this.startB.setFont(new Font("Dialog", 1, 15));
                } else {
                    this.startB.setFont(new Font("Dialog", 1, 20));
                }
                this.startB.setLabel("Game Over");
            } else if (this.game.player[0] == 1 && this.game.player[1] == 1 && this.game.isSelfPlaying()) {
                this.startB.setEnabled(true);
                this.startB.setLocation(BIG_BUTTON_POS_X, BIG_BUTTON_POS_Y);
                this.startB.setSize(BIG_BUTTON_WIDTH, BIG_BUTTON_HEIGHT);
                this.startB.setFont(new Font("Dialog", 1, 28));
                this.startB.setLabel("Stop");
            } else if (this.game.player[this.game.getCurrPlayer()] == 1 && this.game.isWaitingToStart() && !this.game.hasEnded()) {
                this.startB.setEnabled(true);
                this.startB.setLocation(BIG_BUTTON_POS_X, BIG_BUTTON_POS_Y);
                this.startB.setSize(BIG_BUTTON_WIDTH, BIG_BUTTON_HEIGHT);
                this.startB.setFont(new Font("Dialog", 1, 28));
                this.startB.setLabel("Start");
            } else if (this.game.player[this.game.getCurrPlayer()] == 0 && n == 0 && !this.game.hasEnded()) {
                this.startB.setEnabled(true);
                this.startB.setLocation(BIG_BUTTON_POS_X, BIG_BUTTON_POS_Y);
                this.startB.setSize(BIG_BUTTON_WIDTH, BIG_BUTTON_HEIGHT);
                this.startB.setFont(new Font("Dialog", 1, 28));
                this.startB.setLabel("PASS");
            } else if (!this.game.canPlay() && (this.startB.getLabel().equals("Stop") || this.startB.getLabel().equals("Stopping..."))) {
                if (MiniOthello.osName.equalsIgnoreCase("Linux")) {
                    this.startB.setFont(new Font("Dialog", 1, 15));
                } else {
                    this.startB.setFont(new Font("Dialog", 1, 22));
                }
                this.startB.setSize(BIG_BUTTON_WIDTH, BIG_BUTTON_HEIGHT);
                this.startB.setLabel("Stopping...");
                this.startB.setEnabled(false);
            } else {
                this.startB.setEnabled(false);
                this.startB.setLabel("");
                if (this.startB.getWidth() != 0) {
                    this.startB.setSize(0, 0);
                }
            }
        }
    }

    public void updateMenu() {
        int n;
        if (this.comPlayerM == null || this.comPlayerM[COM_COM] == null) {
            return;
        }
        if (this.levelMs == null || this.levelMs[CUSTOMIZE] == null) {
            return;
        }
        this.comPlayerM[HUM_COM].setState(this.game.player[0] == 0 && this.game.player[1] == 1);
        this.comPlayerM[COM_HUM].setState(this.game.player[0] == 1 && this.game.player[1] == 0);
        this.comPlayerM[HUM_HUM].setState(this.game.player[0] == 0 && this.game.player[1] == 0);
        this.comPlayerM[COM_COM].setState(this.game.player[0] == 1 && this.game.player[1] == 1);
        boolean bl = false;
        boolean bl2 = this.game.searchDepth == 1 && this.game.endGameDepth == 8;
        bl |= bl2;
        this.levelMs[STOOGE].setState(bl2);
        bl2 = this.game.searchDepth == 2 && this.game.endGameDepth == 10;
        bl |= bl2;
        this.levelMs[MINDLESS].setState(bl2);
        bl2 = this.game.searchDepth == 4 && this.game.endGameDepth == 12;
        bl |= bl2;
        this.levelMs[NOVICE].setState(bl2);
        bl2 = this.game.searchDepth == 6 && this.game.endGameDepth == 14;
        bl |= bl2;
        this.levelMs[BEGINNER].setState(bl2);
        bl2 = this.game.searchDepth == 8 && this.game.endGameDepth == 16;
        bl |= bl2;
        this.levelMs[AMATEUR].setState(bl2);
        bl2 = this.game.searchDepth == 8 && this.game.endGameDepth == 18;
        bl |= bl2;
        this.levelMs[AMATEUR_P].setState(bl2);
        bl2 = this.game.searchDepth == 10 && this.game.endGameDepth == 18;
        bl |= bl2;
        this.levelMs[EXPERIENCED].setState(bl2);
        bl2 = this.game.searchDepth == 10 && this.game.endGameDepth == 20;
        bl |= bl2;
        this.levelMs[EXPERIENCED_P].setState(bl2);
        bl2 = this.game.searchDepth == 12 && this.game.endGameDepth == 20;
        bl |= bl2;
        this.levelMs[ADVANCED].setState(bl2);
        bl2 = this.game.searchDepth == 12 && this.game.endGameDepth == 22;
        bl |= bl2;
        this.levelMs[ADVANCED_P].setState(bl2);
        bl2 = this.game.searchDepth == 14 && this.game.endGameDepth == 22;
        this.levelMs[EXPERT].setState(bl2);
        this.levelMs[CUSTOMIZE].setState(!(bl |= bl2) && !this.game.timeDependent);
        this.flexibleTimeM.setState(this.game.smartPlay);
        bl = false;
        for (n = 0; n < this.sItems.length - 1; ++n) {
            bl2 = this.game.timeDependent && this.game.softTimeLimit == SOFT_LIMIT[n];
            bl |= bl2;
            this.sItems[n].setState(bl2);
        }
        this.sItems[this.sItems.length - 1].setState(!bl && this.game.timeDependent);
        for (n = 0; n < this.hItems.length; ++n) {
            this.hItems[n].setState(this.game.hardTimeLimit == HARD_LIMIT[n]);
        }
        for (n = 0; n < this.rItems.length; ++n) {
            this.rItems[n].setState(this.game.randomnessLevel == Game.R_LEVELS[n]);
        }
        this.showAvailMovesM.setState(this.game.showAvailMoves);
        this.showLastMoveM.setState(this.game.showLastMove);
        this.showStatM.setState(this.game.showStat);
        this.mirroredStartM.setState(this.game.mirroredStart);
        this.saveSettingsM.setState(this.game.saveSettings);
    }

    public void updateTextAreas() {
        String string = "";
        String string2 = this.pastMoves.getText();
        int n = this.board.getM();
        for (int i = 1; i <= n; ++i) {
            string = (i & 1) == 0 ? string + (this.board.getRecordedMove(i - 1) == 89 ? "   " : "   ") : string + (i != 1 ? "\n " : " ");
            string = string + (i < 10 ? "  " : " ") + i + ". ";
            int n2 = this.board.getRecordedMove(i);
            string = n2 == 89 ? string + "--" : string + "" + (char)((n2 & 7) + 97) + ((n2 >> 3) + 1);
        }
        if (!(this.pastMoves == null || this.gameStarting && this.board.getM() <= 0)) {
            if (!string.equals(string2)) {
                this.pastMoves.setText("");
                this.pastMoves.append(string);
            }
            this.gameStarting = false;
        }
    }

    public void drawAvailMoves(boolean[] blArray) {
        int n = blArray.length;
        if (n != 64) {
            System.out.println("Error: incorrect boolean array size in drawAvailMoves");
        }
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            int n2 = (i & 7) * BOARD_CELL_SIZE + BOARD_X_OFFSET + BOARD_CELL_SIZE / 2;
            int n3 = (i >> 3) * BOARD_CELL_SIZE + BOARD_Y_OFFSET + BOARD_CELL_SIZE / 2;
            this.drawCross(n2, n3);
        }
    }

    public void drawLastMove() {
        int n = this.board.getLastMove();
        if (n == 89) {
            return;
        }
        Point point = Board.conv1to2(n);
        int n2 = point.x;
        int n3 = point.y;
        this.g2.setColor(Util.LAST_MOVE_DOT);
        this.drawDisc(BOARD_X_OFFSET + (BLUE_DOT_RADIUS + 2) + n2 * BOARD_CELL_SIZE, BOARD_Y_OFFSET - (BLUE_DOT_RADIUS + 2) + (n3 + 1) * BOARD_CELL_SIZE, BLUE_DOT_RADIUS);
    }

    public void drawDisc(int n, int n2, int n3) {
        this.g2.fillOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    public void drawDisc(int n, int n2, Color color) {
        this.g2.setColor(color);
        this.drawDisc(BOARD_X_OFFSET + BOARD_CELL_SIZE / 2 + n * BOARD_CELL_SIZE, BOARD_Y_OFFSET + BOARD_CELL_SIZE / 2 + n2 * BOARD_CELL_SIZE, DISC_RADIUS);
    }

    public void drawCross(int n, int n2) {
        int[] nArray = new int[]{n - CROSS_DIM_L, n - CROSS_DIM_S, n + CROSS_DIM_L, n + CROSS_DIM_S};
        int[] nArray2 = new int[]{n2 - CROSS_DIM_S, n2 - CROSS_DIM_L, n2 + CROSS_DIM_S, n2 + CROSS_DIM_L};
        int[] nArray3 = new int[]{n - CROSS_DIM_S, n - CROSS_DIM_L, n + CROSS_DIM_S, n + CROSS_DIM_L};
        int[] nArray4 = new int[]{n2 + CROSS_DIM_L, n2 + CROSS_DIM_S, n2 - CROSS_DIM_L, n2 - CROSS_DIM_S};
        this.g2.setColor(Util.LEGAL_MOVE_CROSS);
        this.g2.drawPolygon(nArray, nArray2, 4);
        this.g2.drawPolygon(nArray3, nArray4, 4);
    }

    public void disableButtons() {
        this.undoB.setEnabled(false);
        this.redoB.setEnabled(false);
        this.undoAllB.setEnabled(false);
        this.redoAllB.setEnabled(false);
    }

    public void initNewGame() {
        this.gameStarting = true;
        this.board = this.game.getBoard();
        this.gd = new GameDriver(this.frame, this.game, this.board);
        this.pastMoves.setText("--- New Game ---\nBlack: " + (this.game.player[0] == 0 ? "Human\n" : "Computer\n") + "White: " + (this.game.player[1] == 0 ? "Human\n" : "Computer\n"));
        if (this.game.player[0] == 1 || this.game.player[1] == 1) {
            if (this.game.timeDependent) {
                if (this.game.softTimeLimit <= this.game.hardTimeLimit || this.game.hardTimeLimit == 0) {
                    this.pastMoves.append("Time: " + this.game.softTimeLimit / 1000 + " sec. per Move");
                    if (this.game.smartPlay) {
                        this.pastMoves.append(" (flexible)\n");
                    } else {
                        this.pastMoves.append(" (fixed)\n");
                    }
                } else {
                    this.pastMoves.append("Time (Hard limit): " + this.game.hardTimeLimit / 1000 + " sec per Move\n");
                }
            } else {
                this.pastMoves.append("Search depth: " + this.game.searchDepth + ", " + this.game.endGameDepth + "\n");
            }
        }
        this.pastMoves.append("Board mirrored: " + (this.game.mirroredStart ? "Yes" : "No"));
        this.infoBox.setText("Message");
        this.paint(this.getGraphics());
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public void showAbout() {
        String string = "";
        string = string + "*** MiddOthello (MiniOthello GUI Version) ***\nWritten by: Yunpeng Li (Middlebury '05)\nGUI version: 0.01i2\nEngine version: " + this.game.engineVer + "\n" + "(Grey menu item = Not yet implemented. Sorry... :)";
        InfoDialog infoDialog = new InfoDialog(this, "About...", false, string, 20, 60, new Font("Dialog", 0, 14));
        infoDialog.setVisible(true);
    }

    public TextArea getPastMoves() {
        return this.pastMoves;
    }

    public TextArea getInfoBox() {
        return this.infoBox;
    }

    public Game getGame() {
        return this.game;
    }

    public void exit() {
        if (this.game.saveSettings) {
            this.game.saveSettings();
        }
        this.game.terminate();
        this.dispose();
        System.exit(0);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exit();
        }
    }

    protected void processActionEvent(AWTEvent aWTEvent) {
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1 && this.game.player[this.game.getCurrPlayer()] == 0 && this.game.canPlay()) {
            if (this.board.hasLegalMove()) {
                int n = (mouseEvent.getX() - BOARD_X_OFFSET) / BOARD_CELL_SIZE;
                int n2 = (mouseEvent.getY() - BOARD_Y_OFFSET) / BOARD_CELL_SIZE;
                this.gd = new GameDriver(this.frame, this.game, this.board);
                this.gd.setState(5);
                this.gd.setCoord(n, n2);
                this.gd.start();
            } else if (this.game.leftClickToPass && !this.game.hasEnded()) {
                this.gd = new GameDriver(this.frame, this.game, this.board);
                this.gd.setState(6);
                this.gd.start();
            }
        } else if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 3 && this.game.player[this.game.getCurrPlayer()] == 0 && !this.game.hasEnded() && this.game.canPlay()) {
            int[] nArray;
            if (this.game.rightClickToPass && !this.board.hasLegalMove()) {
                this.gd = new GameDriver(this.frame, this.game, this.board);
                this.gd.setState(6);
                this.gd.start();
            } else if (this.game.rightClickForForcedMove && this.board.findLegalMoves(nArray = new int[64]) == 1) {
                this.gd = new GameDriver(this.frame, this.game, this.board);
                this.gd.setState(5);
                this.gd.setCoord(Board.conv1to2((int)nArray[0]).x, Board.conv1to2((int)nArray[0]).y);
                this.gd.start();
            }
        }
    }

    public void drawSomething() {
        int n;
        if (this.screen == null) {
            this.screen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics = this.screen.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setBackground(Util.WINDOW_BACKGROUND);
        graphics2D.setColor(Util.WINDOW_BACKGROUND);
        graphics2D.fillRect(0, 0, 700, 600);
        graphics2D.setColor(Util.TABLE_BACKGROUND);
        graphics2D.setColor(Util.BOARD_FRAME);
        graphics2D.fill3DRect(30, 50, 540, 540, true);
        graphics.setColor(Util.BOARD_BACKGROUND);
        graphics2D.fillRect(60, 60, 480, 480);
        graphics2D.setColor(Util.BLACK);
        graphics2D.fillOval(125, 185, 50, 50);
        graphics2D.fillOval(65, 65, 50, 50);
        graphics2D.fillOval(305, 245, 50, 50);
        graphics2D.fillOval(245, 305, 50, 50);
        graphics2D.setColor(Util.WHITE);
        graphics2D.fillOval(185, 185, 50, 50);
        graphics2D.fillOval(485, 485, 50, 50);
        graphics2D.fillOval(245, 245, 50, 50);
        graphics2D.fillOval(305, 305, 50, 50);
        graphics2D.setColor(Util.BOARD_GRID);
        graphics2D.drawRect(60, 60, 479, 479);
        for (n = 120; n <= 480; n += 60) {
            graphics2D.drawLine(61, n, 538, n);
            graphics2D.drawLine(61, n - 1, 538, n - 1);
        }
        for (n = 120; n <= 480; n += 60) {
            graphics2D.drawLine(n, 61, n, 538);
            graphics2D.drawLine(n - 1, 61, n - 1, 538);
        }
        graphics2D.setColor(Util.FOUR_DOTS);
        graphics2D.fillOval(175, 175, 10, 10);
        graphics2D.fillOval(415, 175, 10, 10);
        graphics2D.fillOval(175, 415, 10, 10);
        graphics2D.fillOval(415, 415, 10, 10);
        graphics2D.setColor(Util.WINDOW_BACKGROUND);
        graphics2D.draw3DRect(3, 42, 693, 1, false);
        this.getGraphics().drawImage(this.screen, 0, 0, this);
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        Image image = Toolkit.getDefaultToolkit().getImage("gui/pics/icon3.gif");
        this.setIconImage(image);
    }
}

