/*
 * Decompiled with CFR 0.152.
 */
package othelloGUI;

import othelloGUI.Board;
import othelloGUI.Game;
import othelloGUI.OthelloFrame;

public class GameDriver
extends Thread {
    public static final int SELF_PLAY = 1;
    public static final int MAKE_COM_MOVE = 2;
    public static final int COM_HELP_MAKE_MOVE = 3;
    public static final int COM_HELP_MAKE_PASS = 4;
    public static final int PLAY_HUMAN_MOVE = 5;
    public static final int MAKE_HUMAN_PASS = 6;
    public static final int UNDO = 7;
    public static final int REDO = 8;
    public static final int UNDO_ALL = 9;
    public static final int REDO_ALL = 10;
    public static final int NULL_STATE = 0;
    private int state;
    private Board board;
    private Game game;
    private OthelloFrame frame;
    private int x;
    private int y;

    public GameDriver(OthelloFrame othelloFrame, Game game, Board board) {
        this.game = game;
        this.board = board;
        this.frame = othelloFrame;
        this.state = 0;
    }

    @Override
    public void run() {
        switch (this.state) {
            case 1: {
                this.game.selfPlay();
                break;
            }
            case 2: {
                this.game.makeComMove();
                break;
            }
            case 3: {
                this.game.makeComMove();
                if (this.game.player[this.game.getCurrPlayer()] != 1) break;
                this.game.makeComMove();
                break;
            }
            case 4: {
                this.game.makePass();
                if (this.game.player[this.game.getCurrPlayer()] != 1) break;
                this.game.makeComMove();
                break;
            }
            case 5: {
                this.game.playMove(this.x, this.y);
                break;
            }
            case 6: {
                this.game.makePass();
                break;
            }
            case 7: {
                this.game.undo();
                break;
            }
            case 8: {
                this.game.redo();
                break;
            }
            case 9: {
                this.game.undoAll();
                break;
            }
            case 10: {
                this.game.redoAll();
                break;
            }
            default: {
                System.out.println("Unkown state (or NULL) state in GameDriver");
            }
        }
        this.state = 0;
    }

    public void setCoord(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setState(int n) {
        this.state = n;
    }
}

