/*
 * Decompiled with CFR 0.152.
 */
package othelloGUI;

import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Date;
import othelloGUI.Board;
import othelloGUI.OthelloFrame;

public class Game {
    public static final int HUMAN_PLAYER = 0;
    public static final int COMPUTER_PLAYER = 1;
    public static final String SETTINGS_FILE_NAME = "MiddOthello.ini";
    public static final int DEF_PLAYER0 = 0;
    public static final int DEF_PLAYER1 = 1;
    public static final int DEF_SEARCH_DEPTH = 8;
    public static final int DEF_END_GAME_DEPTH = 16;
    public static final boolean DEF_SHOW_STAT = true;
    public static final boolean DEF_SHOW_LAST_MOVE = true;
    public static final boolean DEF_SHOW_AVAIL_MOVES = true;
    public static final boolean DEF_MIRRORED_START = false;
    public static final boolean DEF_SAVE_SETTINGS = true;
    public static final boolean DEF_SCALE_EVAL = true;
    public static final boolean DEF_KEEP_MESSAGES = true;
    public static final boolean DEF_SHOW_SCORE_IN_EVAL = false;
    public static final boolean DEF_SAVE_LAST_GAME = true;
    public static final boolean DEF_LEFT_CLICK_TO_PASS = false;
    public static final boolean DEF_RIGHT_CLICK_TO_PASS = true;
    public static final boolean DEF_RIGHT_CLICK_FOR_FORCED_MOVE = false;
    public static final int START_DEPTH = 6;
    public static final int START_E_DEPTH = 14;
    public static final int MAX_SEARCH_DEPTH = 14;
    public static final int MAX_END_GAME_DEPTH = 32;
    public static final double ESTIMATED_MAX_BRANCHING_FACTOR = 10.0;
    public static final double SMART_PLAY_SPENDING_FACTOR = 2.0;
    public static final double SMART_PLAY_SAVING_FACTOR = 0.2;
    public static final int RL_NONE = 0;
    public static final int RL_KNOWN_OPENINGS = 1;
    public static final int RL_SMALL = 2;
    public static final int RL_MEDIUM = 4;
    public static final int RL_LARGE = 8;
    public static final int[] R_LEVELS = new int[]{0, 1, 2, 4, 8};
    public static final int DEF_RANDOMNESS_LEVEL = 1;
    public static final int MIN_EMPTIES_FOR_EVALUATION = 12;
    private Board board;
    private OthelloFrame frame;
    protected int[] player = new int[2];
    protected int searchDepth;
    protected int endGameDepth;
    protected boolean showAvailMoves;
    protected boolean showLastMove;
    protected boolean showStat;
    protected boolean mirroredStart;
    protected boolean saveSettings;
    protected boolean scaleEval;
    protected boolean keepMessages;
    protected boolean showScoreInEval;
    protected boolean saveLastGame;
    protected boolean leftClickToPass;
    protected boolean rightClickToPass;
    protected boolean rightClickForForcedMove;
    protected int currPlayer;
    protected int currColor;
    protected boolean waitingToStart;
    protected boolean gameEnded;
    private Process engine;
    protected String engineFile;
    protected String engineVer;
    protected boolean iterativeDeepening;
    protected boolean timeDependent;
    protected int softTimeLimit;
    protected int hardTimeLimit;
    protected int randomnessLevel;
    protected boolean smartPlay;
    private boolean canPlay = true;
    private boolean isSelfPlaying = false;
    private boolean comNoMove = false;
    private String[] messages;
    private boolean[] messageAvailable;

    public Game() {
        this.player[0] = 0;
        this.player[1] = 1;
        this.searchDepth = 8;
        this.endGameDepth = 16;
        this.showStat = true;
        this.showLastMove = true;
        this.showAvailMoves = true;
        this.mirroredStart = false;
        this.saveSettings = true;
        this.scaleEval = true;
        this.keepMessages = true;
        this.showScoreInEval = false;
        this.saveLastGame = true;
        this.leftClickToPass = false;
        this.rightClickToPass = true;
        this.rightClickForForcedMove = false;
        this.currPlayer = 0;
        this.currColor = 1;
        this.waitingToStart = false;
        this.gameEnded = false;
        this.iterativeDeepening = true;
        this.timeDependent = false;
        this.softTimeLimit = 2000;
        this.hardTimeLimit = 0;
        this.smartPlay = true;
        this.randomnessLevel = 1;
        this.messages = new String[120];
        this.messages[0] = "Start of game";
        this.messageAvailable = new boolean[120];
        this.messageAvailable[0] = true;
        for (int i = 1; i < 120; ++i) {
            this.messageAvailable[i] = false;
        }
        if (this.timeDependent) {
            this.searchDepth = 14;
            this.endGameDepth = 32;
        }
        this.engineFile = "engine/othello";
        this.engineVer = "Unknown";
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            this.engine = Runtime.getRuntime().exec(this.engineFile + " -vn");
            InputStream inputStream = this.engine.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            this.engineVer = string.split("\n")[0];
            this.engine.waitFor();
        }
        catch (IOException iOException) {
            this.sendEngineError("Cannot execute engine/othello");
        }
        catch (InterruptedException interruptedException) {
            this.sendEngineError("Interrupted");
            if (this.engine != null) {
                this.engine.destroy();
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.engine != null && bufferedReader != null && string != null) {
                throw nullPointerException;
            }
            try {
                this.engineFile = this.engineFile + "_se";
                this.engine = Runtime.getRuntime().exec(this.engineFile + " -vn");
                InputStream inputStream = this.engine.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                string = bufferedReader.readLine();
                this.engineVer = string.split("\n")[0];
                this.engineVer = this.engineVer + " (SE)";
                this.engine.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.sendEngineError("Interrupted");
                if (this.engine != null) {
                    this.engine.destroy();
                }
            }
            catch (Exception exception) {
                this.sendEngineError("Cannot execute engine/othello or engine/othello_se");
            }
        }
        this.loadSettings();
        this.board = new Board(this.mirroredStart);
        this.frame = new OthelloFrame("MiddOthello", this.board, this);
    }

    public synchronized boolean canPlay() {
        return this.canPlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playMove(int n, int n2) {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return false;
            }
            this.canPlay = false;
        }
        if (!this.board.legalMove(n, n2)) {
            this.canPlay = true;
            return false;
        }
        this.board.makeMove(n, n2);
        this.storeMessage("Human's move: " + Board.move2str(n, n2));
        this.currPlayer = 1 - this.currPlayer;
        this.currColor = this.board.whoseTurn();
        if (this.board.hasLegalMove()) {
            this.updateGraphics();
            if (this.player[this.currPlayer] == 1) {
                this.playComputerMove();
            }
            if (!this.board.hasLegalMove()) {
                this.board.switchSide();
                boolean bl = !this.board.hasLegalMove();
                this.board.switchSide();
                if (bl) {
                    this.endGame();
                }
            }
        } else {
            this.board.makePass();
            this.currPlayer = 1 - this.currPlayer;
            this.currColor = this.board.whoseTurn();
            if (!this.board.hasLegalMove()) {
                this.board.undoMoveIrreversible();
                this.currPlayer = 1 - this.currPlayer;
                this.currColor = this.board.whoseTurn();
                this.endGame();
            } else if (this.player[1 - this.currPlayer] == 1) {
                this.frame.getInfoBox().setText("Computer passed.");
                this.storeMessage("Computer passed.");
            }
        }
        this.updateGraphics();
        this.canPlay = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makePass() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return false;
            }
            this.canPlay = false;
        }
        if (this.board.hasLegalMove()) {
            System.out.println("Warning: Trying to pass while having legal moves !");
            this.canPlay = true;
            return false;
        }
        this.board.makePass();
        this.storeMessage("Human passed.");
        this.currPlayer = 1 - this.currPlayer;
        this.currColor = this.board.whoseTurn();
        this.updateGraphics();
        if (!this.board.hasLegalMove()) {
            this.endGame();
        } else if (this.player[this.currPlayer] == 1) {
            this.playComputerMove();
            if (!this.board.hasLegalMove()) {
                this.board.switchSide();
                boolean bl = !this.board.hasLegalMove();
                this.board.switchSide();
                if (bl) {
                    this.endGame();
                }
            }
        }
        this.updateGraphics();
        this.canPlay = true;
        return true;
    }

    public void rollSwapped() {
        this.waitingToStart = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeComMove() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        if (this.board.hasLegalMove()) {
            this.playComputerMove();
            if (!this.board.hasLegalMove()) {
                this.board.switchSide();
                boolean bl = !this.board.hasLegalMove();
                this.board.switchSide();
                if (bl) {
                    this.endGame();
                }
            }
        } else {
            this.board.makePass();
            this.currPlayer = 1 - this.currPlayer;
            this.currColor = this.board.whoseTurn();
            if (!this.board.hasLegalMove()) {
                this.board.undoMoveIrreversible();
                this.currPlayer = 1 - this.currPlayer;
                this.currColor = this.board.whoseTurn();
                this.endGame();
            } else {
                this.frame.getInfoBox().setText("Computer passed.");
                this.storeMessage("Compter passed.");
            }
        }
        this.updateGraphics();
        this.canPlay = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selfPlay() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        this.isSelfPlaying = true;
        long l = new Date().getTime();
        while (this.isSelfPlaying && this.player[this.currPlayer] == 1) {
            this.updateGraphics();
            if (this.board.hasLegalMove()) {
                this.playComputerMove();
                if (this.board.hasLegalMove()) continue;
                this.board.switchSide();
                boolean bl = !this.board.hasLegalMove();
                this.board.switchSide();
                if (!bl) continue;
                this.isSelfPlaying = false;
                this.endGame();
                continue;
            }
            this.board.makePass();
            this.currPlayer = 1 - this.currPlayer;
            this.currColor = this.board.whoseTurn();
            if (!this.board.hasLegalMove()) {
                this.board.undoMoveIrreversible();
                this.currPlayer = 1 - this.currPlayer;
                this.currColor = this.board.whoseTurn();
                this.isSelfPlaying = false;
                this.endGame();
                continue;
            }
            this.frame.getInfoBox().setText("Computer passed.");
            this.storeMessage("Computer passed.");
        }
        long l2 = new Date().getTime();
        double d = (double)((l2 - l) / 10L) / 100.0;
        this.frame.getInfoBox().append("\nTotal time: " + d + " sec. ");
        this.isSelfPlaying = false;
        this.waitingToStart = true;
        this.updateGraphics();
        this.canPlay = true;
    }

    public void stopSelfPlay() {
        this.isSelfPlaying = false;
        this.frame.updateButtons(1);
    }

    public void stopSelfPlayForced() {
        this.isSelfPlaying = false;
        this.frame.updateButtons(1);
        this.stopComputerThinking();
    }

    public boolean isSelfPlaying() {
        return this.isSelfPlaying;
    }

    public void undo() {
        if (this.isSelfPlaying) {
            return;
        }
        this.comNoMove = true;
        this.stopComputerThinking();
        while (!this.canPlay) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.comNoMove = false;
        this.undo_sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo_sync() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        int n = 0;
        if (this.board.undoMove()) {
            this.currPlayer = 1 - this.currPlayer;
            this.currColor = this.board.whoseTurn();
            ++n;
            if (this.player[this.currPlayer] == 1 && this.player[1 - this.currPlayer] == 0 && this.board.undoMove()) {
                this.currPlayer = 1 - this.currPlayer;
                this.currColor = this.board.whoseTurn();
                ++n;
            }
            this.gameEnded = false;
        }
        if (this.keepMessages && this.hasAvailMessage()) {
            this.displayStoredMessage();
        } else {
            this.frame.getInfoBox().setText("Undo " + n + (n <= 1 ? " move. " : " moves."));
        }
        if (this.player[this.currPlayer] == 1) {
            this.waitingToStart = true;
        }
        this.updateGraphics();
        this.canPlay = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoAll() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        int n = this.board.undoAll();
        if (this.keepMessages && this.hasAvailMessage()) {
            this.displayStoredMessage();
        } else {
            this.frame.getInfoBox().setText("Undo " + n + (n <= 1 ? " move. " : " moves."));
        }
        this.updateGraphics();
        this.currPlayer = 0;
        this.currColor = this.board.whoseTurn();
        this.gameEnded = false;
        if (this.player[this.currPlayer] == 1) {
            this.waitingToStart = true;
        }
        this.updateGraphics();
        this.canPlay = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        int n = 0;
        if (this.board.redoMove()) {
            this.currPlayer = 1 - this.currPlayer;
            this.currColor = this.board.whoseTurn();
            ++n;
            if (this.player[this.currPlayer] == 1 && this.player[1 - this.currPlayer] == 0 && this.board.redoMove()) {
                this.currPlayer = 1 - this.currPlayer;
                this.currColor = this.board.whoseTurn();
                ++n;
            }
            if (this.keepMessages && this.hasAvailMessage()) {
                this.displayStoredMessage();
            } else {
                this.frame.getInfoBox().setText("Redo " + n + (n <= 1 ? " move. " : " moves."));
            }
        }
        if (!this.board.hasLegalMove()) {
            this.board.switchSide();
            boolean bl = !this.board.hasLegalMove();
            this.board.switchSide();
            if (bl) {
                this.endGame();
            }
        }
        if (this.player[this.currPlayer] == 1) {
            this.waitingToStart = true;
        }
        this.updateGraphics();
        this.canPlay = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoAll() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        int n = this.board.redoAll();
        if (this.keepMessages && this.hasAvailMessage()) {
            this.displayStoredMessage();
        } else {
            this.frame.getInfoBox().setText("Redo " + n + (n <= 1 ? " move. " : " moves."));
        }
        this.currPlayer = this.currPlayer + n & 1;
        this.currColor = this.board.whoseTurn();
        if (!this.board.hasLegalMove()) {
            this.board.switchSide();
            boolean bl = !this.board.hasLegalMove();
            this.board.switchSide();
            if (bl) {
                this.endGame();
            }
        }
        if (this.player[this.currPlayer] == 1) {
            this.waitingToStart = true;
        }
        this.updateGraphics();
        this.canPlay = true;
    }

    public void updateGraphics() {
        this.frame.paint(this.frame.getGraphics());
        if (this.currColor != this.currPlayer + 1) {
            System.out.println("Error Warning: CurrColor and CurrPlayer mismatch in Game.java");
        }
    }

    public Board getBoard() {
        return this.board;
    }

    public int getCurrPlayer() {
        return this.currPlayer;
    }

    public int getCurrColor() {
        return this.currColor;
    }

    public boolean isWaitingToStart() {
        return this.waitingToStart;
    }

    public boolean hasEnded() {
        return this.gameEnded;
    }

    public void stopComputerThinking() {
        try {
            this.engine.destroy();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void terminate() {
        this.stopComputerThinking();
    }

    public synchronized void newGame() {
        boolean bl = false;
        if (!this.canPlay) {
            this.comNoMove = true;
            this.stopSelfPlayForced();
            bl = true;
            while (!this.canPlay) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.comNoMove = false;
        }
        this.board = new Board(this.mirroredStart);
        this.currPlayer = 0;
        this.currColor = 1;
        this.waitingToStart = false;
        this.gameEnded = false;
        if (this.player[0] == 1) {
            this.waitingToStart = true;
        }
        this.frame.initNewGame();
        for (int i = 1; i < 120; ++i) {
            this.messageAvailable[i] = false;
        }
        if (bl) {
            this.updateGraphics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGame() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        boolean bl = false;
        boolean bl2 = false;
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Load Game", 0);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            this.canPlay = true;
            return;
        }
        this.frame.getInfoBox().setText("Loading...");
        try {
            File file = new File(fileDialog.getDirectory() + string);
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[1000];
            fileReader.read(cArray);
            String[] stringArray = new String(cArray).split(" ");
            try {
                if (stringArray.length < 3) {
                    bl = true;
                } else {
                    boolean bl3 = Integer.parseInt(stringArray[0]) != 0;
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    if (0 > n || n > n2 || n2 > 120) {
                        bl = true;
                    }
                    if (n2 + 3 > stringArray.length) {
                        bl = true;
                    }
                    if (!bl) {
                        int n3;
                        Board board = new Board(bl3);
                        for (n3 = 1; n3 <= n2; ++n3) {
                            if (stringArray[n3 + 2].equals("pass")) {
                                if (board.hasLegalMove()) {
                                    bl = true;
                                    break;
                                }
                                board.makePass();
                                continue;
                            }
                            char[] cArray2 = stringArray[n3 + 2].toCharArray();
                            if (cArray2.length != 2) {
                                bl = true;
                                break;
                            }
                            int n4 = cArray2[0] - 97;
                            int n5 = cArray2[1] - 49;
                            if (!board.legalMove(n4, n5)) {
                                bl = true;
                                break;
                            }
                            board.makeMove(n4, n5);
                        }
                        if (!bl && !bl2) {
                            while (board.gameOver() && board.getLastMove() == 89) {
                                board.undoMoveIrreversible();
                                if (n <= --n2) continue;
                                n = n2;
                            }
                            board.undo(n2 - n);
                            this.board = board;
                            this.gameEnded = this.board.gameOver();
                            this.currPlayer = this.board.whoseTurn() - 1;
                            this.currColor = this.board.whoseTurn();
                            if (this.player[this.currPlayer] == 1) {
                                this.waitingToStart = true;
                            }
                            this.frame.setBoard(this.board);
                            this.frame.getInfoBox().setText("Game loaded");
                            this.updateGraphics();
                            for (n3 = 1; n3 < 120; ++n3) {
                                this.messageAvailable[n3] = false;
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        if (bl2) {
            this.frame.getInfoBox().append("\nCannot read from file " + string + "!");
        } else if (bl) {
            this.frame.getInfoBox().append("\nInvalid save file!");
        }
        this.canPlay = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame() {
        Game game = this;
        synchronized (game) {
            if (!this.canPlay) {
                return;
            }
            this.canPlay = false;
        }
        boolean bl = true;
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Save Game", 1);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            this.canPlay = true;
            return;
        }
        try {
            File file = new File(fileDialog.getDirectory() + string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.board.isMirrored() ? "1 " : "0 ");
            fileWriter.write(this.board.getM() + " " + this.board.getTop() + " ");
            for (int i = 1; i <= this.board.getTop(); ++i) {
                int n = this.board.getRecordedMove(i);
                if (n == 89) {
                    fileWriter.write("pass ");
                    continue;
                }
                char[] cArray = new char[]{(char)((n & 7) + 97), (char)((n >> 3) + 49)};
                fileWriter.write(cArray);
                fileWriter.write(" ");
            }
            fileWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("Warning: Error writing to file " + string + ". Message: " + iOException.getMessage());
            this.frame.getInfoBox().setText("Can't write to file " + string + "!");
            bl = false;
        }
        if (bl) {
            this.frame.getInfoBox().append("\nGame saved");
        }
        this.canPlay = true;
    }

    public void saveSettings() {
        try {
            File file = new File(SETTINGS_FILE_NAME);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.canWrite()) {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("searchDepth " + this.searchDepth + "\r\n" + "endGameDepth " + this.endGameDepth + "\r\n" + "timeDependent " + this.timeDependent + "\r\n" + "softTimeLimit " + this.softTimeLimit + "\r\n" + "hardTimeLimit " + this.hardTimeLimit + "\r\n" + "smartPlay " + this.smartPlay + "\r\n" + "randomnessLevel " + this.randomnessLevel + "\r\n" + "\r\n" + "showAvailMoves " + this.showAvailMoves + "\r\n" + "showLastMove " + this.showLastMove + "\r\n" + "showStat " + this.showStat + "\r\n" + "mirroredStart " + this.mirroredStart + "\r\n" + "saveSettings " + this.saveSettings + "\r\n" + "scaleEval " + this.scaleEval + "\r\n" + "keepMessages " + this.keepMessages + "\r\n" + "showScoreInEval " + this.showScoreInEval + "\r\n" + "saveLastGame " + this.saveLastGame + "\r\n" + "leftClickToPass " + this.leftClickToPass + "\r\n" + "rightClickToPass " + this.rightClickToPass + "\r\n" + "rightClickForForcedMove " + this.rightClickForForcedMove + "\r\n");
                fileWriter.flush();
                this.frame.getInfoBox().append("\nSettings saved");
            } else {
                System.out.println("Warning: Cannot write to MiddOthello.ini");
            }
        }
        catch (IOException iOException) {
            System.out.println("Warning: Cannot write to MiddOthello.ini. Message: " + iOException.getMessage());
        }
    }

    public void loadSettings() {
        try {
            File file = new File(SETTINGS_FILE_NAME);
            if (!file.exists() || !file.canRead()) {
                return;
            }
            long l = file.length();
            char[] cArray = new char[(int)l];
            FileReader fileReader = new FileReader(file);
            fileReader.read(cArray);
            String[] stringArray = new String(cArray).split("\r\n");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n;
                    String[] stringArray2 = stringArray[i].split(" ");
                    if (stringArray2.length < 2) continue;
                    String string = stringArray2[0];
                    String string2 = stringArray2[1];
                    if (string.equals("searchDepth")) {
                        n = Integer.parseInt(string2);
                        if (n <= 0) continue;
                        this.searchDepth = n;
                        continue;
                    }
                    if (string.equals("endGameDepth")) {
                        n = Integer.parseInt(string2);
                        if (n <= 0) continue;
                        this.endGameDepth = n;
                        continue;
                    }
                    if (string.equals("timeDependent")) {
                        this.timeDependent = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("softTimeLimit")) {
                        n = Integer.parseInt(string2);
                        if (n < 0) continue;
                        this.softTimeLimit = n;
                        continue;
                    }
                    if (string.equals("hardTimeLimit")) {
                        n = Integer.parseInt(string2);
                        if (n < 0) continue;
                        this.hardTimeLimit = n;
                        continue;
                    }
                    if (string.equals("smartPlay")) {
                        this.smartPlay = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("randomnessLevel")) {
                        n = Integer.parseInt(string2);
                        if (n < 0 || n > 9) continue;
                        this.randomnessLevel = n;
                        continue;
                    }
                    if (string.equals("showAvailMoves")) {
                        this.showAvailMoves = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("showLastMove")) {
                        this.showLastMove = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("showStat")) {
                        this.showStat = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("mirroredStart")) {
                        this.mirroredStart = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("saveSettings")) {
                        this.saveSettings = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("scaleEval")) {
                        this.scaleEval = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("keepMessages")) {
                        this.keepMessages = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("showScoreInEval")) {
                        this.showScoreInEval = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("saveLastGame")) {
                        this.saveLastGame = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("leftClickToPass")) {
                        this.leftClickToPass = Boolean.valueOf(string2);
                        continue;
                    }
                    if (string.equals("rightClickToPass")) {
                        this.rightClickToPass = Boolean.valueOf(string2);
                        continue;
                    }
                    if (!string.equals("rightClickForForcedMove")) continue;
                    this.rightClickForForcedMove = Boolean.valueOf(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void recreateFrame() {
        this.frame.dispose();
        this.frame = new OthelloFrame("MiddOthello", this.board, this);
    }

    private boolean playComputerMove() {
        boolean bl = true;
        this.waitingToStart = false;
        this.frame.updateButtons(1);
        Cursor cursor = this.frame.getCursor();
        this.frame.setCursor(new Cursor(3));
        String string = this.board.getStringEncoding();
        TextArea textArea = this.frame.getInfoBox();
        textArea.setText("Computer is thinking...");
        int n = this.searchDepth;
        int n2 = this.endGameDepth;
        int n3 = 0;
        if (this.timeDependent || this.iterativeDeepening) {
            n = Math.min(this.searchDepth, 6);
            n2 = Math.min(this.endGameDepth, 14);
            this.iterativeDeepening = true;
        }
        int n4 = 10000000;
        if (this.hardTimeLimit != 0) {
            n4 = this.hardTimeLimit;
        }
        if (this.timeDependent && this.softTimeLimit != 0 && (this.softTimeLimit < this.hardTimeLimit || this.hardTimeLimit == 0)) {
            n4 = this.softTimeLimit;
        }
        if (this.smartPlay) {
            n4 = (int)((double)n4 * 2.0);
            if (this.hardTimeLimit != 0 && this.hardTimeLimit < n4) {
                n4 = this.hardTimeLimit;
            }
        }
        long l = new Date().getTime();
        int n5 = 99;
        String string2 = "";
        int n6 = 0;
        double d = 0.0;
        String string3 = "";
        int n7 = Math.min(this.searchDepth, Math.max(4, this.board.getEmptyCount() - 12));
        boolean bl2 = true;
        int n8 = n;
        for (int i = n2; bl2 || n8 <= n7 || i <= this.endGameDepth; n8 += 2, i += 2) {
            int n9;
            block59: {
                long l2;
                int n10;
                int n11;
                if (n8 > n7 && i < 64 - this.board.getTotalDiscCount() - 2) {
                    n8 -= 2;
                    continue;
                }
                bl2 = false;
                if (n8 > n7) {
                    n8 -= 2;
                }
                if (i > this.endGameDepth) {
                    i = this.endGameDepth;
                }
                if ((n11 = n4 - (n10 = (int)((l2 = new Date().getTime()) - l))) <= 0 || this.smartPlay && this.timeDependent && (double)n10 > (double)n4 * 0.1) break;
                String string4 = string3 = this.engineFile;
                string3 = string3 + " -D " + n8;
                string3 = string3 + " -E " + i;
                string3 = string3 + " -t -st";
                string3 = string3 + " -r " + this.randomnessLevel;
                if (n11 < 10000000) {
                    string3 = string3 + " -tm " + n11;
                }
                string3 = string3 + " -gm " + string;
                int n12 = 0;
                int n13 = 0;
                n9 = 999;
                double d2 = 999.0;
                int n14 = 999;
                int n15 = 0;
                try {
                    int n16;
                    if (this.showStat) {
                        if (i < 64 - this.board.getTotalDiscCount() - 2) {
                            textArea.append("\nTry depth " + n8 + "... ");
                        } else if (i < 64 - this.board.getTotalDiscCount()) {
                            textArea.append("\nTry WDL... ");
                        } else {
                            textArea.append("\nTry solving... ");
                        }
                    }
                    this.engine = Runtime.getRuntime().exec(string3);
                    InputStream inputStream = this.engine.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string5 = bufferedReader.readLine();
                    String[] stringArray = string5.split(" ");
                    int n17 = Integer.parseInt(stringArray[0]);
                    if (n17 == 64) {
                        if (!this.showStat) break;
                        textArea.append(this.smartPlay ? "Abort" : "Time out");
                        break;
                    }
                    n5 = n17;
                    string2 = "" + (char)((n5 & 7) + 65) + ((n5 >> 3) + 1);
                    if (stringArray.length >= 7) {
                        n12 = Integer.parseInt(stringArray[1]);
                        n6 += n12;
                        n13 = Integer.parseInt(stringArray[2]);
                        d2 = Double.parseDouble(stringArray[3]);
                        n9 = Integer.parseInt(stringArray[4]);
                        d = (double)(new Date().getTime() - l) / 1000.0;
                        n14 = Integer.parseInt(stringArray[6]);
                        if (d != 0.0) {
                            n15 = (int)((double)n6 / (1000.0 * d));
                        }
                        DecimalFormat decimalFormat = new DecimalFormat("0.00");
                        DecimalFormat decimalFormat2 = new DecimalFormat("0.00");
                        DecimalFormat decimalFormat3 = new DecimalFormat("0.0");
                        if (this.showStat) {
                            textArea.setText("");
                            if (this.board.getM() == 0) {
                                textArea.append("* Indifferent Opening *");
                            } else if (this.board.getM() == 1) {
                                if (n5 == 18 || n5 == 21 || n5 == 42 || n5 == 45) {
                                    textArea.append("* Diagonal Opening *");
                                } else if (d2 < 0.0) {
                                    textArea.append("* Parallel Opening *");
                                } else {
                                    textArea.append("* Perpendicular Opening *");
                                }
                            } else if (i < 64 - this.board.getTotalDiscCount() && n9 >= 999) {
                                textArea.append("Depth: " + n8);
                            } else {
                                textArea.append("Depth: " + (64 - this.board.getTotalDiscCount()));
                            }
                            textArea.append("\nBest move: " + string2);
                            if (n6 < 1000000) {
                                textArea.append("\nSearched: " + n6 / 1000 + "K nodes");
                            } else if (n6 >= 10000000) {
                                textArea.append("\nSearched: " + decimalFormat3.format((double)n6 / 1000000.0) + "M nodes");
                            } else {
                                textArea.append("\nSearched: " + decimalFormat.format((double)n6 / 1000000.0) + "M nodes");
                            }
                            textArea.append("\nTime: " + decimalFormat.format(d) + " sec.");
                            if (d >= 0.01) {
                                textArea.append("\nSpeed: " + n15 + " Kn/s");
                            } else {
                                textArea.append("\nSpeed: N/A");
                            }
                            if (n9 < 999) {
                                textArea.append("\nEval: " + (n9 > 0 ? "+" : "") + n9);
                                if (this.showScoreInEval) {
                                    textArea.append(" (" + (32 + n9 / 2) + " - " + (32 - n9 / 2) + ")");
                                }
                            } else if (n9 > 999) {
                                textArea.append("\nEval: >= +" + (n9 >> 10));
                            } else if (d2 != 999.0) {
                                if (this.scaleEval && n14 != 2 && n14 != -2) {
                                    textArea.append("\nEval: " + (d2 > 0.0 ? "+" : "") + decimalFormat2.format(this.scaleEvaluation(d2)));
                                } else {
                                    textArea.append("\nEval: " + (d2 > 0.0 ? "+" : "") + decimalFormat2.format(d2));
                                }
                                int n18 = 64 - this.board.getTotalDiscCount();
                                if (i + 2 >= n18 && i < n18 && n14 != 999) {
                                    textArea.append(d2 > 0.0 ? " (Win)" : (d2 < 0.0 ? " (Loss)" : " (Draw)"));
                                }
                            } else {
                                textArea.append("\nEval: 0.0");
                            }
                        }
                    }
                    if ((n16 = this.engine.waitFor()) == 0) break block59;
                    System.out.println("Warnig: Engine return value is " + n16);
                }
                catch (IOException iOException) {
                    this.sendEngineError("Cannot execute engine/othello");
                    bl = false;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    if (this.engine != null) {
                        this.engine.destroy();
                    }
                    textArea.append("\n(Interrupted at Depth " + n8 + ")");
                    bl = false;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.sendEngineError("Invalid Response from Engine. " + numberFormatException.getMessage());
                    if (this.engine != null) {
                        this.engine.destroy();
                    }
                    bl = false;
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    textArea.append("\n(Interrupted at Depth " + n8 + ")");
                    bl = false;
                    break;
                }
            }
            n3 = n8;
            if (i >= 64 - this.board.getTotalDiscCount()) {
                n3 = i;
                break;
            }
            if (n9 < 999 || this.board.getM() < 2) break;
        }
        if (!this.board.legalMove(n5)) {
            this.sendEngineError("Illegal Move Received from Engine. Value: " + n5 + "\ncmd: " + string3);
            bl = false;
        } else if (n3 == 0) {
            this.sendEngineError("No Search Completed");
            bl = false;
        } else if (!this.comNoMove) {
            if (!this.showStat) {
                textArea.setText("Computer's Move: " + string2);
            }
            this.board.makeMove(n5);
            this.storeMessage(textArea.getText());
            this.currPlayer = 1 - this.currPlayer;
            this.currColor = this.board.whoseTurn();
        }
        this.frame.setCursor(cursor);
        return bl;
    }

    private void updateGUI() {
        this.frame.repaint();
    }

    private void sendEngineError(String string) {
        System.out.println("Engine Error Message: " + string);
    }

    private void endGame() {
        this.gameEnded = true;
        int n = this.board.getDiscCount(1);
        int n2 = this.board.getDiscCount(2);
        String string = "";
        string = n > n2 ? "BLACK WINS BY: " + (64 - n2) + " - " + n2 : (n < n2 ? "WHITE WINS BY: " + (64 - n) + " - " + n : "GAME IS DRAWN AT: " + n + " - " + n2);
        this.frame.getInfoBox().append("\n" + string);
        if (this.saveLastGame) {
            this.saveLastGame();
        }
    }

    private double scaleEvaluation(double d) {
        if (d == 0.0) {
            return d;
        }
        double d2 = d / Math.abs(d) * 10.0 * Math.sqrt(Math.abs(d));
        return d2;
    }

    private void storeMessage(String string) {
        this.messages[this.board.getM()] = string;
        this.messageAvailable[this.board.getM()] = true;
    }

    private void displayStoredMessage() {
        if (this.hasAvailMessage()) {
            this.frame.getInfoBox().setText(this.messages[this.board.getM()]);
        } else {
            this.frame.getInfoBox().setText("");
        }
    }

    private boolean hasAvailMessage() {
        return this.messageAvailable[this.board.getM()];
    }

    private void saveLastGame() {
        String string = "savegame/lastgame.log";
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.board.isMirrored() ? "1 " : "0 ");
            fileWriter.write("0 " + this.board.getTop() + " ");
            for (int i = 1; i <= this.board.getTop(); ++i) {
                int n = this.board.getRecordedMove(i);
                if (n == 89) {
                    fileWriter.write("pass ");
                    continue;
                }
                char[] cArray = new char[]{(char)((n & 7) + 97), (char)((n >> 3) + 49)};
                fileWriter.write(cArray);
                fileWriter.write(" ");
            }
            fileWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("Warning: Error writing to file " + string + ". Message: " + iOException.getMessage());
        }
    }
}

