/* liberty.cpp  -- Maintains the liberty map which is use to calculate
                potential mobility

*/

#include <stdlib.h>
#include "board.hpp"

// Liberty map
int libmap[91];
int pMobDiff; // BLACK's - WHITE's

static const char directions[] = {1, -1, 8, -8, 9, -9, 10, -10};

/* Initialize the map given a 91-entry array board representation
    Also intialize potentialMobDiff
*/
void initLibmap(int *a) {
    int *lmp = libmap;
    pMobDiff = 0;
    for(int i=10; i<81; i++) {
        int lib = 0;
        for(int j=0; j<8; j++)
            if(a[i+directions[j]] == EMPTY)
                lib++;
        lmp[i] = lib;
        int color = a[i];
        if(color == BLACK)
            pMobDiff -= lib;
        else if(color == WHITE)
            pMobDiff += lib; // opponent liberty is self's mobility
    }
    //printf("pMobDiff - init: %d\n", pMobDiff);
    
    // testing
    /*
    for(int i=10; i<81; i+=9) {
        for(int j=0; j<8; j++)
            printf("%d ", libmap[i+j]);
        printf("\n");
    }
    */
}

/* Generate compact adjacency table.
  Adjacent(a, b) = (adjacent[(a<<2)+(b>>5)] >> (b & 31)) & 1
*/
void main_genAdjacencyTable() { // rename to main() to generate the file
    FILE *fp = fopen("adj_table.hpp", "w");
    if(fp == NULL) {
    fprintf(stderr, "Unable to open file mob_table.hpp for writing\n");
    exit(1);
    }
    fprintf(fp, "\
/*****************************************\n\
  adj_table.hpp -- this file is automatically generated from liberty.cpp\n\
  \n\
  Test whether two given positions are adjacent (incl. diagonal).\n\
*/\n\
\n\
#ifndef __ADJ_TABLE_HPP__\n\
#define __ADJ_TABLE_HPP__\n\
\n\
#define ADJACENT(p1, p2) ((adjacent[((p1)<<2)+((p2)>>5)] >> ((p2) & 31)) & 1)\n\
\n\n");

    fprintf(fp, "unsigned int adjacent[81*4] = {\n");
    for(int i=0; i<81; i++) {
        unsigned int b[4] = {0, 0, 0, 0};
        if(i >= 10 && i % 9 != 0) {
            for(int j=10; j<81; j++) {
                if(j % 9 == 0)
                    continue;
                if(abs(i-j) == 1 || abs(i-j) == 8 || abs(i-j) == 9 || abs(i-j) == 10)
                    b[j >> 5] |= 1 << (j & 31);
            }
        }
        fprintf(fp, "    0x%08x, 0x%08x, 0x%08x, 0x%08x, \n", b[0], b[1], b[2], b[3]);
    }    
    fprintf(fp, "};\n\n");
    fprintf(fp, "#endif\n");
}
