/***********************************************************
 * InfoDialog.java
 *
 * The most basic dialog box with a message and one button
 *
 * Yunpeng
 *
 */

package othelloGUI;

import java.awt.*;
import java.awt.event.*;

public class InfoDialog extends Dialog implements ActionListener {
    // one button
    private Button okay;
    private String message;
    private int x, y;
    private Font font;
    private TextArea ta;

    public InfoDialog(Frame frame, String title, boolean modal, String message,
                      int x, int y, Font font) {
        super(frame, title, modal);
        this.message = message;
        this.x = x;
        this.y = y;
        this.font = font;
        setVisible(true);
        setBackground(Util.WINDOW_BACKGROUND);
        setLocation(frame.getLocation().x + x, frame.getLocation().y + y);
        setSize(400, 180);
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        //setLocation(frame.getLocation().x + 200, frame.getLocation().y + 200);
        ta = new TextArea(message, 5, 42, TextArea.SCROLLBARS_NONE);
        ta.setFont(font);
        ta.setEditable(false);
        ta.setFocusable(false);
        okay = new Button("OK");
        okay.addActionListener(this);
        okay.setFocusable(true);
        Panel pa = new Panel();
        pa.add(ta);
        pa.add(okay);
        add(pa);
    }

/*
    public void paint() {
        Image scr = createImage(getSize().width, getSize().height);
        okay.setLocation(getSize().width/2 - 20, getSize().height - 50);
        if(scr == null)
            return;
        Graphics2D g2 = (Graphics2D)scr.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(font);
        g2.setColor(Color.black);
        g2.drawString(message, x, y);
        getGraphics().drawImage(scr, 0, 0, this);
    }
 */

    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        dispose();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == e.WINDOW_CLOSING) {
            dispose();
        }
    }

}
