/*
 * Decompiled with CFR 0.152.
 */
package othelloGUI;

import java.awt.Point;

public class Board {
    public static final byte EMPTY = 0;
    public static final byte BLACK = 1;
    public static final byte WHITE = 2;
    public static final byte PASS = 89;
    public static final byte[][] DIRECTION = new byte[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private byte[][] a = new byte[61][64];
    private byte[] moves = new byte[128];
    private int n = 0;
    private int m = 0;
    private int top = 0;
    private byte wt = 1;
    private boolean mirrored;

    public Board() {
        this(false);
    }

    public Board(boolean bl) {
        this.mirrored = bl;
        byte[] byArray = this.a[0];
        for (int i = 0; i < 64; ++i) {
            byArray[i] = 0;
        }
        if (this.mirrored) {
            byArray[27] = 1;
            byArray[28] = 2;
            byArray[35] = 2;
            byArray[36] = 1;
        } else {
            byArray[27] = 2;
            byArray[28] = 1;
            byArray[35] = 1;
            byArray[36] = 2;
        }
        this.moves[0] = 89;
    }

    public void setPiece(int n, int n2) {
        this.a[this.n][n] = (byte)n2;
    }

    public void setPiece(int n, int n2, int n3) {
        this.setPiece(Board.conv2to1(n, n2), n3);
    }

    public int getPiece(int n) {
        return this.a[this.n][n];
    }

    public int getPiece(int n, int n2) {
        return this.a[this.n][Board.conv2to1(n, n2)];
    }

    public void flipPiece(int n) {
        this.a[this.n][n] = Board.other(this.a[this.n][n]);
    }

    public void flipPiece(int n, int n2) {
        this.flipPiece(Board.conv2to1(n, n2));
    }

    public int getDiscCount(int n) {
        int n2 = 0;
        byte[] byArray = this.a[this.n];
        for (int i = 0; i < 64; ++i) {
            if (byArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getTotalDiscCount() {
        return this.n + 4;
    }

    public int getEmptyCount() {
        return 60 - this.n;
    }

    public int getRecordedMove(int n) {
        return this.moves[n];
    }

    public int getN() {
        return this.n;
    }

    public int getM() {
        return this.m;
    }

    public int getTop() {
        return this.top;
    }

    public int whoseTurn() {
        return this.wt;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public int getLastMove() {
        return this.moves[this.m];
    }

    public boolean legalMove(int n, int n2) {
        byte[] byArray = this.a[this.n];
        byte by = Board.conv2to1(n, n2);
        if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
            return false;
        }
        if (byArray[by] != 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            byte by2 = DIRECTION[i][0];
            int n3 = n + 2 * by2;
            byte by3 = DIRECTION[i][1];
            int n4 = n2 + 2 * by3;
            if (!Board.onBoard(n3, n4) || byArray[Board.conv2to1(n + by2, n2 + by3)] != Board.other(this.wt)) continue;
            while (Board.onBoard(n3, n4) && byArray[Board.conv2to1(n3, n4)] == Board.other(this.wt)) {
                n3 += by2;
                n4 += by3;
            }
            if (!Board.onBoard(n3, n4) || byArray[Board.conv2to1(n3, n4)] != this.wt) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean legalMove(int n) {
        Point point = Board.conv1to2(n);
        return this.legalMove(point.x, point.y);
    }

    public int findLegalMoves(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                byte by = Board.conv2to1(j, i);
                blArray[by] = this.legalMove(j, i);
                if (!blArray[by]) continue;
                ++n;
            }
        }
        return n;
    }

    public int findLegalMoves(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                byte by = Board.conv2to1(j, i);
                if (!this.legalMove(j, i)) continue;
                nArray[n++] = by;
            }
        }
        return n;
    }

    public boolean hasLegalMove() {
        return this.findLegalMoves(new boolean[64]) > 0;
    }

    public boolean gameOver() {
        if (this.hasLegalMove()) {
            return false;
        }
        this.switchSide();
        boolean bl = !this.hasLegalMove();
        this.switchSide();
        return bl;
    }

    public void makeMove(int n, int n2) {
        int n3;
        byte[] byArray = this.a[this.n];
        byte[] byArray2 = this.a[this.n + 1];
        byte by = Board.conv2to1(n, n2);
        int n4 = 0;
        for (n3 = 0; n3 < 64; ++n3) {
            byArray2[n3] = byArray[n3];
        }
        for (n3 = 0; n3 < 8; ++n3) {
            byte by2 = DIRECTION[n3][0];
            int n5 = n + 2 * by2;
            byte by3 = DIRECTION[n3][1];
            int n6 = n2 + 2 * by3;
            if (!Board.onBoard(n5, n6) || byArray[Board.conv2to1(n + by2, n2 + by3)] != Board.other(this.wt)) continue;
            while (Board.onBoard(n5, n6) && byArray[Board.conv2to1(n5, n6)] == Board.other(this.wt)) {
                n5 += by2;
                n6 += by3;
            }
            if (!Board.onBoard(n5, n6) || byArray[Board.conv2to1(n5, n6)] != this.wt) continue;
            n5 -= by2;
            n6 -= by3;
            while (byArray[Board.conv2to1(n5, n6)] == Board.other(this.wt)) {
                byArray2[Board.conv2to1((int)n5, (int)n6)] = this.wt;
                n5 -= by2;
                n6 -= by3;
                ++n4;
            }
        }
        if (n4 == 0) {
            System.err.println("ERROR: Illegal move received in makeMove()!");
            System.exit(1);
        }
        byArray2[by] = this.wt;
        this.wt = Board.other(this.wt);
        ++this.n;
        ++this.m;
        if (this.m > this.top || this.moves[this.m] != by) {
            this.top = this.m;
            this.moves[this.m] = by;
        }
    }

    public void makeMove(int n) {
        Point point = Board.conv1to2(n);
        this.makeMove(point.x, point.y);
    }

    public void makePass() {
        ++this.m;
        this.wt = Board.other(this.wt);
        if (this.m > this.top || this.moves[this.m] != 89) {
            this.top = this.m;
            this.moves[this.m] = 89;
        }
    }

    public void switchSide() {
        this.wt = Board.other(this.wt);
    }

    public boolean undoMove() {
        if (this.m == 0) {
            return false;
        }
        if (this.moves[this.m] == 89) {
            --this.m;
            this.wt = Board.other(this.wt);
        } else {
            --this.m;
            --this.n;
            this.wt = Board.other(this.wt);
        }
        return true;
    }

    public boolean undoMoveIrreversible() {
        if (this.m == 0) {
            return false;
        }
        if (this.moves[this.m] == 89) {
            --this.m;
            this.wt = Board.other(this.wt);
        } else {
            --this.m;
            --this.n;
            this.wt = Board.other(this.wt);
        }
        this.top = this.m;
        return true;
    }

    public boolean redoMove() {
        if (this.m == this.top) {
            return false;
        }
        if (this.moves[this.m + 1] == 89) {
            ++this.m;
            this.wt = Board.other(this.wt);
        } else {
            ++this.m;
            ++this.n;
            this.wt = Board.other(this.wt);
        }
        return true;
    }

    public int undoAll() {
        int n = 0;
        while (this.undoMove()) {
            ++n;
        }
        return n;
    }

    public int redoAll() {
        int n = 0;
        while (this.redoMove()) {
            ++n;
        }
        return n;
    }

    public int undo(int n) {
        int n2;
        for (n2 = 0; n2 < n && this.undoMove(); ++n2) {
        }
        return n2;
    }

    public int redo(int n) {
        int n2;
        for (n2 = 0; n2 < n && this.redoMove(); ++n2) {
        }
        return n2;
    }

    public String getStringEncoding() {
        String string = "";
        byte[] byArray = this.a[this.n];
        for (int i = 0; i < 64; ++i) {
            string = string + byArray[i];
        }
        string = string + this.wt;
        if ((string = string + (10 + this.moves[this.m])).length() != 67) {
            System.out.println("ERROR: length == " + string.length());
            System.exit(1);
        }
        return string;
    }

    public boolean canUndo() {
        return this.m > 0;
    }

    public boolean canRedo() {
        return this.m < this.top;
    }

    public static byte conv2to1(int n, int n2) {
        return (byte)(n + (n2 << 3));
    }

    public static Point conv1to2(int n) {
        return new Point(n & 7, n >> 3);
    }

    public static byte other(int n) {
        return (byte)(3 - n);
    }

    public static boolean onBoard(int n, int n2) {
        return n >= 0 && n < 8 && n2 >= 0 && n2 < 8;
    }

    public static String move2str(int n) {
        return "" + (char)((n & 7) + 65) + ((n >> 3) + 1);
    }

    public static String move2str(int n, int n2) {
        return "" + (char)(n + 65) + (n2 + 1);
    }

    public void print() {
        boolean[] blArray = new boolean[64];
        this.findLegalMoves(blArray);
        byte[] byArray = this.a[this.n];
        byte by = this.moves[this.m];
        int n = this.getDiscCount(1);
        int n2 = this.getDiscCount(2);
        System.out.print("\n     A B C D E F G H\n");
        for (int i = 0; i < 8; ++i) {
            if (by == 8 * i) {
                System.out.print("  " + (i + 1) + " (");
            } else {
                System.out.print("  " + (i + 1) + "  ");
            }
            for (int j = 0; j < 8; ++j) {
                byte by2 = Board.conv2to1(j, i);
                String string = byArray[by2] == 1 ? "X" : (byArray[by2] == 2 ? "O" : (blArray[by2] ? "+" : "."));
                if (by2 + 1 == by && j != 7) {
                    System.out.print(string + "(");
                    continue;
                }
                if (by2 == by) {
                    System.out.print(string + ")");
                    continue;
                }
                System.out.print(string + " ");
            }
            if (i == 0) {
                System.out.print("\tBlack: " + n);
            } else if (i == 1) {
                System.out.print("\tWhite: " + n2);
            }
            System.out.print("\n");
        }
        System.out.print("\n");
    }
}

