----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    15:29:26 04/13/2015 
-- Design Name: 
-- Module Name:    UART_TOP - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity UART_TOP is
    Port ( sys_clk : in  STD_LOGIC;
           rst : in  STD_LOGIC;
           rx : in  STD_LOGIC;
           tx : out  STD_LOGIC;
           rx_data : in  STD_LOGIC_VECTOR (7 downto 0);
           tx_data : out  STD_LOGIC_VECTOR (7 downto 0);
           rx_data_valid : in  STD_LOGIC;
			  tx_data_valid : out  STD_LOGIC);
end UART_TOP;

-- To convert testing UART into working UART comment lines 51,53,81,85 and uncomment lines 80,84.
-- To convert working UART into testing UART comment lines 80,84 and uncomment lines 51,53,81,85.


architecture Behavioral of UART_TOP is
signal baud_clk : std_logic :='0';

-- temporary signals for transferring tx_data to rx_data
signal loop_back : std_logic_vector(7 downto 0) :="00000000";
-- temporary signals for transferring tx_data_valid to rx_data_valid
signal loop_back_valid : std_logic :='0';

-- Clock Generator Module
component CLOCK_GEN
    port (sys_clk,rst: in std_logic;
			s_rate: out std_logic);
end component;

-- Receiving Module
component RX_UART
    port (rx,rst,rx_clk: in std_logic;
			tx_data: out std_logic_vector;
			tx_data_valid: out std_logic);
end component;

-- Transmitting Module
component TX_UART
    port (rx_data: in std_logic_vector;
			rst,rx_data_valid,tx_clk: in std_logic;
			tx: out std_logic);
end component;
begin
-- Mapping ports to internal ports
  CLOCK_GEN_INS: CLOCK_GEN
    port map (sys_clk,rst,baud_clk);

  RX_UART_INS: RX_UART
--   port map (rx,rst,baud_clk,tx_data,tx_data_valid);
   port map (rx,rst,baud_clk,loop_back,loop_back_valid);

  TX_UART_INS: TX_UART
--    port map (rx_data,rst,rx_data_valid,baud_clk,tx);
    port map (loop_back,rst,loop_back_valid,baud_clk,tx);
	
end Behavioral;