--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   19:43:38 04/14/2015
-- Design Name:   
-- Module Name:   G:/xilinx_files/UART/TX_UART_TB.vhd
-- Project Name:  UART
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: TX_UART
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY TX_UART_TB IS
END TX_UART_TB;
 
ARCHITECTURE behavior OF TX_UART_TB IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT TX_UART
    PORT(
         rx_data : IN  std_logic_vector(7 downto 0);
         rx_data_valid : IN  std_logic;
         tx : OUT  std_logic;
         rst : IN  std_logic;
         tx_clk : IN  std_logic
        );
    END COMPONENT;
    

   --Inputs
   signal rx_data : std_logic_vector(7 downto 0) := (others => '0');
   signal rx_data_valid : std_logic := '0';
   signal rst : std_logic := '0';
   signal tx_clk : std_logic := '0';

 	--Outputs
   signal tx : std_logic;

   -- Clock period definitions
   constant tx_clk_period : time := 1 ns;

BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: TX_UART PORT MAP (
          rx_data => rx_data,
          rx_data_valid => rx_data_valid,
          tx => tx,
          rst => rst,
          tx_clk => tx_clk
        );

   -- Clock process definitions
   tx_clk_process :process
   begin
		tx_clk <= '0';
		wait for tx_clk_period/2;
		tx_clk <= '1';
		wait for tx_clk_period/2;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ns.
		-- resetting the circuit
		rst<='1';
		wait for 3 ns;
		rst<='0';
		
		wait for 100 ns;
		-- setting bits to be transmitted = 00101111
		rx_data_valid<='1';
		rx_data<="00101111";
		wait for 20 ns; -- wait for atleast for 1/baud rate time
		rx_data_valid<='0';
		rx_data<="00000000";
		wait for 190 ns;
		-- repeating same
		rx_data_valid<='1';
		rx_data<="01001100";
		wait for 20 ns;
		rx_data_valid<='0';
		rx_data<="00000000";
		wait for 190 ns;

		rx_data_valid<='1';
		rx_data<="11111111";
		wait for 20 ns;
		rx_data_valid<='0';
		rx_data<="00000000";
		wait for 190 ns;
		
		rx_data_valid<='1';		
      wait;
   end process;

END;
