----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    00:01:59 04/14/2015 
-- Design Name: 
-- Module Name:    TX_UART - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

-- rx_data,rx_data_valid,tx_clk,rst inputs
-- tx, output
entity TX_UART is
    Port ( rx_data : in  STD_LOGIC_VECTOR (7 downto 0);
           rx_data_valid : in  STD_LOGIC;
           tx : out  STD_LOGIC:='0';
           rst : in  STD_LOGIC;
           tx_clk : in  STD_LOGIC);
end TX_UART;

architecture Behavioral of TX_UART is

Type STATE_TYPE is(resting,starting,transmitting,stop);
Signal tx_FSM:STATE_TYPE:=resting;
Signal tx_counter: STD_LOGIC_vector(2 downto 0):="000";				-- counter keeping track of 8 transmitted bits
Signal sampling_counter: STD_LOGIC_vector(3 downto 0):="0000";     --counter for sampling
Signal tx_register: STD_LOGIC_vector(7 downto 0):="11111111";     -- stores bit to be transmitted temporarily
Signal valid_reg: STD_LOGIC:='0'; -- sanity checks over transmitted bits

begin
process (rst, tx_clk)
begin
	if rising_edge(tx_clk) then
		tx<='1';
		if rst='1' then
			tx_register <= "00000000";
			valid_reg<= '0';
			tx_counter <= "000";
			tx<='1';
			sampling_counter <= "0000";
			tx_FSM <= resting;
		else
			case tx_FSM is
			when resting =>
				if rx_data_valid='1' then
					valid_reg<='1';
--					tx<='0';
					tx_register<=rx_data;
					tx_counter<="000";
					if sampling_counter="1111" then
						sampling_counter<="0000";
						tx_FSM <= starting;
					end if;
					sampling_counter <= sampling_counter+"1";
				else
					tx<='1';
					tx_FSM<=resting;
					sampling_counter<="0000";
					tx_counter<="000";
				end if;
			when starting =>
				valid_reg<='1';
				tx<='0';
				tx_counter<="000";
				if sampling_counter="1111" then
					sampling_counter<="0000";
					tx_FSM <= transmitting;
				end if;
				sampling_counter <= sampling_counter+"1";
			when transmitting =>
				if valid_reg='1' then
					tx<=tx_register(conv_integer(tx_counter));
					if sampling_counter="1111" then
						if tx_counter="111" then
							tx_FSM <= stop;
						end if;
						tx_counter<=tx_counter+"1";
					end if;
					sampling_counter<=sampling_counter+"1";
				end if;
			when stop =>
				if valid_reg='1' then
					tx<='1';
					if(sampling_counter="1111") then
						sampling_counter<="0000";
						tx_FSM <= resting;
					end if;
					sampling_counter<=sampling_counter+"1";
				end if;
			when others =>
				tx_FSM <= resting;
				sampling_counter<="0000";
			end case;
		end if;
	end if;
end process;
end Behavioral;

