--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   20:17:46 04/14/2015
-- Design Name:   
-- Module Name:   G:/xilinx_files/UART/RX_UART_TB.vhd
-- Project Name:  UART
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: RX_UART
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY RX_UART_TB IS
END RX_UART_TB;
 
ARCHITECTURE behavior OF RX_UART_TB IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT RX_UART
    PORT(
         rx : IN  std_logic;
         tx_data : OUT  std_logic_vector(7 downto 0);
         tx_data_valid : OUT  std_logic;
         rst : IN  std_logic;
         rx_clk : IN  std_logic
        );
    END COMPONENT;
    

   --Inputs
   signal rx : std_logic := '0';
   signal rst : std_logic := '0';
   signal rx_clk : std_logic := '0';

 	--Outputs
   signal tx_data : std_logic_vector(7 downto 0);
   signal tx_data_valid : std_logic;

   -- Clock period definitions
   constant rx_clk_period : time := 1 ns;

BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: RX_UART PORT MAP (
          rx => rx,
          tx_data => tx_data,
          tx_data_valid => tx_data_valid,
          rst => rst,
          rx_clk => rx_clk
        );

   -- Clock process definitions
   rx_clk_process :process
   begin
		rx_clk <= '0';
		wait for rx_clk_period/2;
		rx_clk <= '1';
		wait for rx_clk_period/2;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin
		rx<='1';
		--resetting the circuit.
		rst<='1';
		wait for 50 ns;
		rst<='0';
		wait for 100 ns;
		-- receiving the start bit.
		rx<='0';
		wait for 16 ns;
		
		-- receiving 8 bits from LSB to MSB
		rx<='1';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		
		-- stop bit
		rx<='1';
		wait for 16 ns;
-- repeating same process for different pattern of bits.
		wait for 50 ns;
		rst<='0';
		wait for 100 ns;
		rx<='0';
		wait for 16 ns;
		
		rx<='1';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		rx<='0';
		wait for 16 ns;
		rx<='1';
		wait for 16 ns;
		
		rx<='1';
		wait for 16 ns;
		
      wait;
   end process;

END;
