----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    02:21:54 04/14/2015 
-- Design Name: 
-- Module Name:    RX_UART - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

-- rx,rst,rs_clk inputs
-- tx_data, tx_data_valid output
entity RX_UART is
    Port ( rx : in  STD_LOGIC;
           tx_data : out  STD_LOGIC_vector(7 downto 0);
           tx_data_valid : out  STD_LOGIC:='0';
           rst : in  STD_LOGIC;
           rx_clk : in  STD_LOGIC);
end RX_UART;

architecture Behavioral of RX_UART is

Type STATE_TYPE is(resting,receiving,storing,stop);
Signal rx_FSM:STATE_TYPE:=resting;
Signal rx_counter: STD_LOGIC_vector(2 downto 0):="000";        -- counter keeping track of 8 receiving bits
Signal sampling_counter: STD_LOGIC_vector(3 downto 0):="0000";  --counter for sampling
Signal rx_register: STD_LOGIC_vector(7 downto 0):="00000000";  -- stores receiving bit temporarily
Signal valid_reg: STD_LOGIC:='0'; -- sanity checks over received bits

begin

process (rst, rx_clk)
begin
	if rising_edge(rx_clk) then
		tx_data<="00000000";
		tx_data_valid<='0';
		if rst='1' then
			rx_register <= "00000000";
			valid_reg<= '0';
			rx_counter <= "000";
			rx_FSM <= resting;
		else
			case rx_FSM is
			when resting =>
				if rx='0' then
					if sampling_counter = "1111" then
						rx_FSM <= receiving;
					end if;
					sampling_counter<=sampling_counter+"1";
				else
					sampling_counter<="0000";
					rx_FSM<=resting;
				end if;
			when receiving =>
				if sampling_counter="0111" then
					rx_register(conv_integer(rx_counter))<=rx;
				end if;
				if sampling_counter="1111" then
					if rx_counter="111" then
						rx_FSM <= storing;
					end if;
					rx_counter<=rx_counter+"1";
				end if;
				sampling_counter<=sampling_counter+"1";
			when storing =>
				tx_data<=rx_register;
				tx_data_valid<='1';	
				valid_reg<='1';
				if sampling_counter="1111" then
					if rx='1' then
						rx_FSM <= stop;
					else
						rx_FSM <= resting;
					end if;
				end if;
				sampling_counter<=sampling_counter+"1";
			when stop =>
				if valid_reg='1' then
					valid_reg<='0';
					rx_register<="00000000";
					rx_FSM <= resting;
				end if;
			when others =>
				rx_FSM <= resting;
			end case;
		end if;
	end if;
end process;

end Behavioral;

