----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    15:33:10 04/13/2015 
-- Design Name: 
-- Module Name:    CLOCK_GEN - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

--sys_clk and rst are input
--s_rate is output
entity CLOCK_GEN is
    Port ( sys_clk : in  STD_LOGIC;
           s_rate : out  STD_LOGIC;
           rst : in  STD_LOGIC);
end CLOCK_GEN;

architecture Behavioral of CLOCK_GEN is
-- clk_count till 163 
signal clk_count : STD_LOGIC_VECTOR(7 downto 0):= "00000000";
signal s_rate_reg : STD_LOGIC := '0';

begin

process(rst,sys_clk)
begin
	if(rising_edge(sys_clk)) then
		s_rate<=s_rate_reg;
		if(rst='1') then
			s_rate_reg<= '0';
			s_rate<=s_rate_reg;
			clk_count<= "00000000";
		elsif(clk_count="10100011") then  --count till 163 then reset.
			clk_count<="00000000";
			if(s_rate_reg='1')then
				s_rate_reg<='0';
				s_rate<=s_rate_reg;  -- revert the clock
			else	
				s_rate_reg<='1';
				s_rate<=s_rate_reg;
			end if;
		else
			clk_count<=clk_count+"1";
		end if;
	end if;
end process;
end Behavioral;
