import networkx

def CurrentFlow(G):
    C = networkx.current_flow_closeness_centrality(G)
    vals = []
    for n in C:
        vals.append(C[n])
    vals.sort()
    return vals

def det(M):

    M = [ list(r) for r in M ]
    
    n = len(M)
    D = 1.0
    
    for j in xrange(n-1, 0, -1):
    
        p, i = max((abs(M[k][j]), k) for k in xrange(j+1))
        p = M[i][j]
        if p == 0.0:
            return 0.0
        M[i], M[j] = M[j], M[i]
        if i != j:
            D = -D
        D *= p
        fact = -1.0/p
        
        for i in xrange(j):
            f = fact * M[i][j]
            for k in xrange(j):
                M[i][k] += f * M[j][k]
    D *= M[0][0]
    return D

def zero(m,n):
    # Create zero matrix
    return [[0 for r in range(n)] for c in range(m)]
    

def mult(M, N):
    # Matrix multiplication
    P = zero(len(M),len(N))
    for i in range(len(M)):
        for j in range(len(N[0])):
            for k in range(len(M)):
                P[i][j] += M[i][k]*N[k][j]
    return P

#def TreeSum(C, edges):
#    big = {}
#    if len(C) not in big:
#        C_Laplacian = []
#        for i in range(len(C) - 1):
#            row = []
#            for j in range(len(C) - 1):
#                if i == j:
#                    row.append(len(C) - 1)
#                else:
#                    row.append(-1)
#            C_Laplacian.append(row)
#        big[len(C)] = det(C_Laplacian)
#    Laplacian = []
#    index = {}
#    idx = 0
#    for i in C:
#        index[idx] = i
#        idx += 1
#    for i in range(len(index)):
#        adj = edges[index[i]]
##                print adj
##                print index
#        adj_in = set([])
#        for a in index:
#            if index[a] in adj:
#                adj_in.add(a)
##                print adj_in
#        row = []
#        for j in range(len(index) - 1):
#            if index[j] in adj:
#                row.append(-1)
#            elif index[j] != index[i]:
#                row.append(0)
#            else:
#                row.append(len(adj_in))
#        Laplacian.append(row)
#    Laplacian = Laplacian[0:len(Laplacian) - 1]
#    Det = det(Laplacian)
#    return str(float(Det)/float(big[len(C)]))

def TreeSum(C, edges):
    Laplacian = []
    index = {}
    idx = 0
    for i in C:
        index[idx] = i
        idx += 1
    for i in range(len(index)):
        adj = edges[index[i]]
        adj_in = set([])
        for a in index:
            if index[a] in adj:
                adj_in.add(a)
        row = []
        for j in range(len(index) - 1):
            if index[j] in adj:
                row.append(-1)
            elif index[j] != index[i]:
                row.append(0)
            else:
                row.append(len(adj_in))
        Laplacian.append(row)
    Laplacian = Laplacian[0:len(Laplacian) - 1]
    M = []
    y = float(1)/float((len(index)))
    x = 2.0 * y
    for i in range(len(index) - 1):
        row = []
        for j in range(len(index) - 1):
            if i == j:
                row.append(x)
            else:
                row.append(y)
        M.append(row)
   
    V = mult(Laplacian, M)
    return det(V)

def GetTriangleDensity(H):
    count = 0
    for w in H.nodes():
        leg1 = H.neighbors(w)
        for x in leg1:
            for y in leg1:
                if x!= y:
                    if x in H.neighbors(y):
                        count += 1
    return float(count)/float(len(H.nodes()) * len(H.nodes()) * len(H.nodes()))

def GetABVals(I, H):
    alpha_vals = []
    beta_vals = []
    G = I.subgraph(set(I.nodes()).difference(set(H.nodes())))
    for w in H.nodes():                       
        in_degree = H.degree(w)
        beta_vals.append(in_degree)
    for w in G.nodes():
        degree = I.degree(w)     
        out_degree = G.degree(w)
        in_degree = degree - out_degree
        alpha_vals.append(in_degree)
    if len(alpha_vals) == 0:
        alpha_vals = list([0])
    return [alpha_vals, beta_vals]

