/* 
 *  Copyright (c) 2008  Noah Snavely (snavely (at) cs.washington.edu)
 *    and the University of Washington
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 */

/* BaseApp.cpp */
/* Base application */

#include "BaseApp.h"

#include "defines.h"

Keypoint &BaseApp::GetKey(int img, int key) {
    return m_image_data[img].m_keys[key];
}

KeypointWithDesc &BaseApp::GetKeyWithDesc(int img, int key) {
    return m_image_data[img].m_keys_desc[key];
}

int BaseApp::GetNumKeys(int img) {
    return (int) m_image_data[img].m_keys.size();
}

/* Get the index of a registered camera */
int BaseApp::GetRegisteredCameraIndex(int cam) {
    int num_images = GetNumImages();

    int count = 0;
    for (int i = 0; i < num_images; i++) {
	if (m_image_data[i].m_camera.m_adjusted) {
	    if (count == cam)
		return i;
	    
	    count++;
	}
    }

    printf("[SifterApp::GetRegisteredCameraIndex] "
	   "Error: ran out of cameras\n");

    return -1;
}

/* Return the number of images */
int BaseApp::GetNumImages() {
    return (int) m_image_data.size();
}

/* Return the number of original images */
int BaseApp::GetNumOriginalImages() {
    return m_num_original_images;
}

int BaseApp::GetNumMatches(int i1, int i2) 
{
    int i_min = MIN(i1, i2);
    int i_max = MAX(i1, i2);
    
    MatchIndex idx = GetMatchIndex(i_min, i_max);

    // if (m_match_lists.find(idx) == m_match_lists.end())
    //    return 0; 
    // return m_match_lists[idx].size();

    return m_matches.GetNumMatches(idx);
}

/* Get match information */
MatchIndex BaseApp::GetMatchIndex(int i1, int i2) {
    // MatchIndex num_images = GetNumImages();
    // return i1 * num_images + i2;
    return MatchIndex((unsigned long) i1, (unsigned long) i2);
}

void BaseApp::SetMatch(int i1, int i2) {
    m_matches.SetMatch(GetMatchIndex(i1, i2));
}

void BaseApp::RemoveMatch(int i1, int i2) {
    m_matches.RemoveMatch(GetMatchIndex(i1, i2));
}
    
bool BaseApp::ImagesMatch(int i1, int i2) {
    return m_matches.Contains(GetMatchIndex(i1, i2));
}
