#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "IdxQueue.h"

void init_idx_queue(IDXQUEUE* piq)
{
	piq -> length = 0;
	piq -> head = NULL;
	piq -> tail = NULL;

}
void free_idx_queue(IDXQUEUE* piq)
{
	QELEM* p;
	QELEM* pp;
	if(piq -> length == 0)
	{
		piq -> head = NULL;
		piq -> tail = NULL;
	}
	else
	{
		p = piq -> head;
		while(p != NULL)
		{
			pp = p;
			p = p -> pnext;
			free(pp);
		}
		piq -> head = NULL;
		piq -> tail = NULL;
		piq -> length = 0;
	}
}
int exist_in_idx_queue(int q, IDXQUEUE* piq)
{
	QELEM* p;
	if(piq -> length == 0)
		return 0;
	else
	{
		p = piq -> head;
		while(p != NULL)
		{
			if(p -> idx == q)
				return 1;
			else
				p = p -> pnext;
		}
		return 0;
	}
}
void push_in_idx_queue(int q, IDXQUEUE* piq)
{
	if(piq -> length == 0)
	{
		//printf("Entering 0 case.\n");
		piq -> tail = (QELEM*)malloc(sizeof(QELEM));
		piq -> head = piq -> tail;
		(piq -> tail) -> idx = q;
		(piq -> tail) -> pnext = NULL;
	}
	else
	{
		//printf("Entering >0 case.\n");
		(piq -> tail) -> pnext = (QELEM*)malloc(sizeof(QELEM));
		piq -> tail = (piq -> tail) -> pnext;
		(piq -> tail) -> idx = q;
		(piq -> tail) -> pnext = NULL;
	}
	piq -> length += 1;
}
int pop_from_idx_queue(IDXQUEUE* piq)
{
	int temp;
	QELEM* p;
	if(piq -> length == 0)
	{
		printf("Trying to pop from an empty queue!\n");
		exit(1);
	}
	else if(piq -> length == 1)
	{
		temp = piq -> head -> idx;
		free(piq -> head);
		piq -> head = NULL;
		piq -> tail = NULL;
		piq -> length = 0;
		return temp;
	}
	else
	{
		temp = piq -> head -> idx;
		p = piq -> head;
		piq -> head = piq -> head -> pnext;
		free(p);
		piq -> length -= 1;
		return temp;
	}
}

void delete_from_idx_queue(IDXQUEUE* piq, int idx_to_delete)
{
	QELEM* p;
	QELEM* pp;
	if(piq -> length == 0)
	{
		printf("Trying to delete from an empty queue!\n");
		exit(1);
	}
	else if(piq -> length == 1)
	{
		if((piq -> head) -> idx != idx_to_delete)
		{
			printf("Cannot find the index to delete.\n");
			exit(1);
		}
		else
		{
			free(piq -> head);
			piq -> head = NULL;
			piq -> tail = NULL;
			piq -> length = 0;
		}
	}
	else
	{
		p = piq -> head;
		pp = NULL;
		while(p != NULL)
		{
			if(p -> idx == idx_to_delete)
			{
				//delete the head
				if(pp == NULL)
				{
					pp = piq -> head;
					piq -> head = p -> pnext;
					free(pp);
				}
				else if(p == piq -> tail)
				{
					piq -> tail = pp;
					pp -> pnext = NULL;
					free(p);
				}
				else
				{
					pp -> pnext = p -> pnext;
					free(p);
				}
				(piq -> length)--;
				return;
			}
			else
			{
				pp = p;
				p = p -> pnext;
			}
		}
		printf("Cannot find the index to delete.\n");
		exit(1);
	}
}
