#!/usr/bin/env python

# Copyright (C) 2009 Cornell University
# All rights reserved

import socket
import cPickle
import sys
import hashlib

INDEX_PORT = 7000
CONTENT_PORT = 7001

keyValStore = dict()

def main(argv=None):
    if argv is None:
        argv = sys.argv

    if len(argv) != 2 or argv[1] not in ('index', 'content'):
        print "Usage: %s < index | content >" % argv[0]
        return None
    port = (INDEX_PORT if argv[1] == 'index' else CONTENT_PORT)
    writeOnce = (argv[1] == 'index')
    if writeOnce:
        rsaPub = cPickle.load(open("rsa_public", "r"))
    
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    sock.bind(('', port))
    sock.listen(5)

    try:
        def put(key, value):
            if key in keyValStore:
                if not writeOnce:
                    keyValStore[key].add(value)
            else:
                if writeOnce:
                    try:
                        caphash = hashlib.sha1(value[0][0]).digest()
                        if not rsaPub.verify(caphash, value[0][1]):
                            print "Invalid signature"
                            return None
                    except IndexError, e:
                        print "Error indexing into captcha", e
                        return None 
                keyValStore[key] = set([value])

        while True:
            newSocket, address = sock.accept()
            try:
                # Fetch data
                recvData = ""
                while True:
                    data = newSocket.recv(8192)
                    if not data: break
                    recvData = recvData + data
                recvTuple = cPickle.loads(recvData)
                results = []

                # Perform put/get
                if recvTuple[0] == "get":
                    for curKey in recvTuple[1]:
                        try:
                            val = keyValStore[curKey]
                        except KeyError:
                            val = set()
                        if writeOnce:
                            results.extend(list(val))
                        elif type(results) is list:
                            results = val
                        else:
                            results = results.intersection(val)
                elif recvTuple[0] == "put":
                    for i in xrange(len(recvTuple[1])):
                        curKey = recvTuple[1][i]
                        put(curKey, recvTuple[2][i])
                elif recvTuple[0] == "multiput":
                    for curKey in recvTuple[1]:
                        put(curKey, recvTuple[2])
                else:
                    print "Unexpected command: ", recvTuple[0]
                newSocket.sendall(cPickle.dumps(tuple(results)))
            except IndexError, e:
                print "Index error into tuple"
            finally:
                newSocket.close()
    finally:
        sock.close()

if __name__ == "__main__":
    sys.exit(main())
