#!/usr/bin/env python

# Copyright (C) 2009 Cornell University
# All rights reserved

import socket
import StringIO
import cPickle
import hashlib
from Captcha.Visual import Tests
from Captcha import Factory

captchaFac = Factory()
sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
sock.bind(('', 7002))
sock.listen(5)

# Read rsaKeyPair
rsa = cPickle.load(open("rsa_private", "r"))

try:
    while True:
        newSocket, address = sock.accept()
        # Fetch data
        recvData = ""
        while True:
            data = newSocket.recv(8192)
            if not data: break
            recvData = recvData + data
        # Unpickle
        numCap = cPickle.loads(recvData)
        capList = []
        for i in xrange(numCap):
            newTest  = captchaFac.new(getattr(Tests, "PseudoGimpy"))
            newImage = captchaFac.get(newTest.id)
            output   = StringIO.StringIO()
            newImage.render().save(output, format="PNG")
            imageStr = output.getvalue()
            imageSig = rsa.sign(hashlib.sha1(imageStr).digest(), 0)
            capList.append((imageStr, imageSig))
            output.close()
        # Send data
        sendData = cPickle.dumps(capList)
        newSocket.sendall(sendData)
        newSocket.close()
finally:
    sock.close()
