Require Import List.
Require Import Relation_Definitions.
Require Import Coq.Arith.Arith.

Import Relation_Operators.
Import ListNotations.

Ltac promotehyp H := match (type of H) with
  | ?g -> ?h => let H' := fresh H in rename H into H'; assert (H: h); [apply H'; try assumption; try (constructor; assumption); auto|]; clear H'
  end.

Ltac remove_eq_implications := match goal with
  | [H : ?x = ?x -> _ |- _] => let H' := fresh H in pose proof (H (eq_refl x)) as H'; clear H
  | [H : ?p, H' : ?p -> _ |- _] => let H'' := fresh H' in rename H' into H''; pose proof (H'' H) as H'; clear H''
  end.

Ltac existing x := match goal with
  | [H : x |- _] => idtac
  end.
Ltac missing x := tryif (existing x) then fail else idtac.

Definition uncurry {A B C : Type} (X : A -> B -> C) : (A * B) -> C := fun p => (X (fst p) (snd p)).
Definition curry {A B C : Type} (X : (A * B) -> C) : A -> B -> C := fun a b => X (a, b).
Lemma uncurry_eq {A B C : Type} (X : A -> B -> C) (a : A) (b : B) : X a b = (uncurry X (a,b)).
  reflexivity.
Qed.
Lemma curry_eq {A B C : Type} (X : (A * B) -> C) (a : A) (b : B) : X (a, b) = (curry X a b).
  reflexivity.
Qed.

Lemma clos_refl_trans_refl_or_trans {A : Type} (R : relation A) (l r : A) : clos_refl_trans A R l r -> l = r \/ clos_trans A R l r.
  intros H. induction H.
    right. apply t_step. assumption.
    left. reflexivity.
    destruct IHclos_refl_trans1; destruct IHclos_refl_trans2; subst; try (right; assumption).
      left. reflexivity.
      right. apply t_trans with y; assumption.
Qed.

Lemma clos_t_rt : forall {A : Type} {R : relation A} (x y z : A), clos_trans A R x y -> clos_refl_trans A R y z -> clos_trans A R x z.
  intros A R x y z Hxy Hyz. generalize dependent x. induction Hyz; intros x' Hxy.
    apply t_trans with x; [|apply t_step]; assumption.
    assumption.
    apply IHHyz1 in Hxy. apply IHHyz2 in Hxy. assumption.
Qed.

Lemma Forall_mono {A : Type} (P P': A -> Prop) (ls : list A) : Forall P ls -> (forall a : A, In a ls -> P a -> P' a) -> Forall P' ls.
  intros Hforall Hconvert. induction Hforall; [constructor; assumption | constructor].
    apply Hconvert; auto; constructor; auto.
    apply IHHforall. intros a HIn HP. apply Hconvert; auto. apply in_cons. assumption.
Qed.

Lemma Forall_map_Forall {A B : Type} (PA : A -> Prop) (PB : B -> Prop) (f : A -> B) (ls : list A) : Forall PB (map f ls) -> (forall a : A, In a ls -> PB (f a) -> PA a) -> Forall PA ls.
  intros Hforall. induction ls; intros Hconv; try constructor.
    apply Hconv.
      apply in_eq.
      rewrite -> Forall_forall in Hforall. apply Hforall. apply in_map. apply in_eq.
    apply IHls.
      rewrite -> Forall_forall in *. intros x HIn. apply Hforall. apply in_map_iff. apply in_map_iff in HIn. destruct HIn as [x' [Heq HIn]]. exists x'. split; [|apply in_cons]; assumption.
      intros a0 HIn Hpb. apply Hconv. apply in_cons. assumption. assumption.
Qed.

Lemma Forall_app {A : Type} (P : A -> Prop) (ls ls' : list A) : Forall P (ls ++ ls') <-> (Forall P ls /\ Forall P ls').
  repeat (split; try intros H).
    induction ls; simpl in *; constructor.
      inversion H. assumption.
      inversion H. apply IHls. assumption.
    induction ls; simpl in *; try constructor.
      assumption.
      inversion H. apply IHls. assumption.
    destruct H as [Hl Hr]. induction ls; simpl; try assumption.
      inversion Hl. constructor; try apply IHls; assumption.
Qed.

Lemma Forall_map {A B : Type} (f : A -> B) (p : B -> Prop) (l : list A) : Forall p (map f l) <-> Forall (fun x : A => p (f x)) l.
  split; intros H; apply Forall_forall; rewrite -> Forall_forall in H; intros x H'.
    apply H. apply in_map_iff. exists x; auto.
    apply in_map_iff in H'. destruct H' as [x0 [Hf HIn]]. apply H in HIn. rewrite -> Hf in HIn. assumption.
Qed.

Lemma Forall_singleton { A : Type } : forall (P : A -> Prop) ( a : A), Forall P [a] -> P a.
  intros P a H. inversion H; assumption.
Qed.

Lemma Forall_and {A : Type} (P P' : A -> Prop) (l : list A) : Forall P l /\ Forall P' l <-> Forall (fun a => P a /\ P' a) l.
  split; intros H.
    destruct H as [Hl Hr]. rewrite -> Forall_forall in *. intros x HIn. split; [apply Hl | apply Hr]; assumption.
    split; rewrite -> Forall_forall in *; intros x HIn; apply H; assumption.
Qed.

Ltac forall_and Hname := match goal with
| [H : Forall ?f ?l, H' : Forall ?f' ?l |- _] => let Hfresh := fresh in assert (Hfresh : Forall (fun x => f x /\ f' x) l) by (apply Forall_and; split; assumption); clear H H'; rename Hfresh into Hname
end.

Lemma Exists_mono {A : Type} (p q : A -> Prop) (l : list A) : Exists p l -> (forall a : A, In a l -> p a -> q a) -> Exists q l.
  intros HEx Hmono.
  apply Exists_exists. apply Exists_exists in HEx. destruct HEx as [x [HIn Hp]]. exists x. split.
    apply HIn.
    apply Hmono; auto.
Qed.

Lemma Exists_singleton {A : Type} : forall (P : A -> Prop) (a : A), Exists P [a] <-> P a.
  intros P a. split; intros.
    inversion H as [a' H'| a' l' H' Heqa]; subst.
      assumption.
      inversion H'.
    constructor; assumption.
Qed.

Lemma Exists_singleton_forward {A : Type} (P : A -> Prop) (a : A): Exists P [a] -> P a.
  apply Exists_singleton.
Qed.

Lemma Exists_app_or {A : Type} (P : A -> Prop) (ls ls' : list A) : Exists P (ls ++ ls') <-> (Exists P ls \/ Exists P ls').
  split; intros H.
    induction ls; simpl in *; auto.
      inversion H; subst. 
        left. constructor; assumption.
        apply IHls in H1. destruct H1 as [H1 | H1].
          left. constructor; assumption.
          right. assumption.
    destruct H as [H | H].
      induction H; simpl; constructor; assumption.
      induction ls; simpl; try constructor; assumption.
Qed.

Ltac mono := match goal with
| [H : Forall ?p ?l |- Forall ?p' ?l] => apply (Forall_mono p p'); try assumption; clear H
| [H : Forall ?p (map ?f ?l) |- Forall ?p' ?l] => apply (Forall_map_Forall p' p f l H); try assumption; auto; clear H
| [H : Exists ?p ?l |- Exists ?q ?l] => apply (Exists_mono p q l H); clear H
end.

Definition ForallCrossPairs {L R : Type} (P : L -> R -> Prop) (ls : list L) (rs : list R) : Prop
:= Forall (fun l => Forall (P l) rs) ls.

Lemma ForallCrossPairs_nil_l {L R : Type} {P : L -> R -> Prop} {rs : list R} : ForallCrossPairs P nil rs.
  constructor.
Qed.
Lemma ForallCrossPairs_nil_r {L R : Type} {P : L -> R -> Prop} {ls : list L} : ForallCrossPairs P ls nil.
  apply Forall_forall. intros x HIn. constructor.
Qed.
Lemma ForallCrossPairs_singleton {L R : Type} (P : L -> R -> Prop) {l : L} {r : R} : ForallCrossPairs P [l] [r] <-> P l r.
  split; intros H.
    apply Forall_singleton in H. apply Forall_singleton in H. assumption.
    repeat constructor; assumption.
Qed.
Lemma ForallCrossPairs_singleton_forward {L R : Type} (P : L -> R -> Prop) {l : L} {r : R} : ForallCrossPairs P [l] [r] -> P l r.
  intros H.
    apply Forall_singleton in H. apply Forall_singleton in H. assumption.
Qed.
Lemma ForallCrossPairs_app_l {L R : Type} {P : L -> R -> Prop} {ls ls' : list L} {rs : list R} : ForallCrossPairs P (ls ++ ls') rs <-> ForallCrossPairs P ls rs /\ ForallCrossPairs P ls' rs.
  split; intros H.
    apply Forall_app in H. split; apply H.
    apply Forall_app; apply H.
Qed.
Lemma ForallCrossPairs_app_r {L R : Type} {P : L -> R -> Prop} {ls : list L} {rs rs' : list R} : ForallCrossPairs P ls (rs ++ rs') <-> ForallCrossPairs P ls rs /\ ForallCrossPairs P ls rs'.
  split; intros H.
    split; unfold ForallCrossPairs in *; mono; intros l HIn H'; apply Forall_app in H'; apply H'.
    destruct H as [Hl Hr]. unfold ForallCrossPairs in *. forall_and H. mono; intros l HIn H'. apply Forall_app; assumption.
Qed.

Lemma Forall_exists_project {A B : Type} (P : A -> B -> Prop) : forall (la : list A) (lb : list B), Forall (fun a => Exists (P a) lb) la -> exists l : list B, incl l lb /\ Forall2 P la l.
  intros la lb Hfa. induction Hfa.
    exists []. split; [intros x HIn; inversion HIn | apply Forall2_nil].
    destruct IHHfa as [ls [Hincl IH]]. apply Exists_exists in H. destruct H as [b [HIn H]]. exists (b :: ls). split; [|constructor; assumption]. intros b' [HIn' | HIn']; subst; [|apply Hincl]; assumption.
Qed.

Lemma flat_map_app { A B : Type } (f : A -> list B) (ll lr : list A) : flat_map f (ll ++ lr) = (flat_map f ll) ++ (flat_map f lr).
  generalize dependent lr. induction ll; intros lr; simpl.
    reflexivity.
    rewrite -> IHll. apply app_assoc.
Qed.

Lemma flat_map_flat_map {A B C : Type} : forall (l : list A) (f : A -> list B) (f' : B -> list C), flat_map f' (flat_map f l) = flat_map (fun a : A => flat_map f' (f a)) l.
  induction l; intros f f'.
    reflexivity.
    simpl. rewrite -> flat_map_app. rewrite -> IHl. reflexivity.
Qed.

Lemma flat_map_mono {A B : Type} (f f' : A -> list B) (l : list A) : (forall a : A, In a l -> f a = f' a) -> flat_map f l = flat_map f' l.
  intros Heq. induction l; [reflexivity|]; simpl; rewrite -> Heq; [|apply in_eq]; rewrite -> IHl; [reflexivity|]; intros a' HIn; apply Heq; apply in_cons; assumption.
Qed.

Lemma cons_eq {A : Type} (a a' : A) (l l' : list A) : a = a' -> l = l' -> a :: l = a' :: l'.
  intros Ha Hl. subst. reflexivity.
Qed.

Lemma app_eq {A : Type} (l1 l2 l3 l4 : list A) : l1 = l3 -> l2 = l4 -> l1 ++ l2 = l3 ++ l4.
  intros H13 H24. rewrite -> H13. rewrite -> H24. reflexivity.
Qed.

Lemma In_singleton { A : Type } : forall (a b : A), In a [b] -> a = b.
  intros a b HIn. inversion HIn; subst. reflexivity. inversion H.
Qed.

Lemma Forall2_forall_r {A B : Type} {f : A -> B -> Prop} {la : list A} {lb : list B} : Forall2 f la lb -> forall b : B, In b lb -> exists a : A, In a la /\ f a b.
  intros Hfa b HIn. induction Hfa.
    inversion HIn.
    destruct HIn as [HIn | HIn]; subst.
      exists x. split; [apply in_eq | assumption].
      apply IHHfa in HIn. destruct HIn as [a [HIn Hf]]. exists a; split; [apply in_cons|]; assumption.
Qed.

Lemma Forall2_forall_l {A B : Type} {f : A -> B -> Prop} {la : list A} {lb : list B} : Forall2 f la lb -> forall a : A, In a la -> exists b : B, In b lb /\ f a b.
  intros Hfa a HIn. induction Hfa.
    inversion HIn.
    destruct HIn as [HIn | HIn]; subst.
      exists y. split; [apply in_eq | assumption].
      apply IHHfa in HIn. destruct HIn as [b [HIn Hf]]. exists b; split; [apply in_cons|]; assumption.
Qed.

Fixpoint map_in_incl {A B : Type} (l : list A) (f : forall a : A, In a l -> B) (l' : list A) : incl l' l -> list B
:= match l' with
   | nil => fun _ => nil
   | cons a l' => fun l'l => cons (f a (l'l a (or_introl (eq_refl a)))) (map_in_incl l f l' (fun a' a'inl' => l'l a' (or_intror a'inl')))
   end.

Definition map_in {A B : Type} (l : list A) (f : forall a : A, In a l -> B) : list B
:= map_in_incl l f l (incl_refl l).

Lemma incl_max : forall ll lr : list nat, incl ll lr -> fold_right max 0 ll <= fold_right max 0 lr.
  intros ll lr Hincl. induction ll.
    apply Nat.le_0_l.
    simpl. destruct (Nat.max_dec a (fold_right max 0 ll)) as [Hmax | Hmax]; rewrite -> Hmax; clear Hmax; [|apply IHll; intros x HIn; apply Hincl; apply in_cons; assumption].
      assert (HIn : In a lr) by (apply Hincl; apply in_eq). apply in_split in HIn. destruct HIn as [l1 [l2 Heq]]. subst. clear. induction l1. simpl.
        apply Nat.le_max_l.
        simpl. apply le_trans with (fold_right max 0 (l1 ++ a :: l2)); [assumption|]. apply Nat.le_max_r.
Qed.