Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
Require Import Sets.
(** printing set $\mathit{set}$ *)
(** printing setv $\isa{\coqdocvar{set}}$ *)
(** printing sete $\iseq{\coqdocvar{set}}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import RCAs.
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import PCAs.
Require Import HOFs.
(** printing PROP $\Phi$ *)
(** printing PROPV $\isa{\Phi}$ *)
(** printing Entails $\vdash$ *)
(** printing subst $\dot{\phi}[\cdot]$ *)
(** printing top $\top$ *)
(** printing conj $\conj$ *)
(** printing bot $\bot$ *)
(** printing disj $\disj$ *)
(** printing imp $\imp$ *)
(** printing sforall $\forall$ *)
(** printing sexists $\exists$ *)
(** printing seq $=$ *)
(** printing oprop $\Omega$ *)
(** printing character $\chi$ *)
(** printing holds $\mathit{holds}$ *)
(** printing isnat $\isnat$ *)
Require Import RCAstoHOFs.
(** printing cnat $c^\lambda_\cdot$ *)
Require Import CountableChoice.
(** printing sexistsr $\exists\mathord{\mid}$ *)
Require Import Lambdas.
(** printing Lambda $L$ *)
(** printing LambdaV $\isa{L}$ *)
(** printing lsubst $\ell[\cdot] *)
(** printing lcode $(\cdot)$ *)
(** printing lapp $\app$ *)
(** printing Prim $P$ *)
(** printing PrimV $\isa{P}$ *)
(** printing PCode $C_?$ *)
(** printing cprim $(\cdot)$ *)
(** printing clam $\lambda^\cdot$ *)
(** printing PCodeV $\isa{C_?}$ *)
Require Import FreeRCA.
(** printing PrimV' $\isa{P}'$ *)
(** printing RedLambda $\downarrow_c^\lambda$ *)
(** printing RedCode $\downarrow_c^{C_?}$ *)
(** printing RedPrim $\downarrow_c^p$ *)
(** printing TermLambda $\downarrow^\lambda$ *)
(** printing TermCode $\downarrow^{C_?}$ *)
(** printing TermPrim $\downarrow^p$ *)
(** printing TermRedLambda $\downarrow_\phi^\lambda$ *)
(** printing TermRedCode $\downarrow_\phi^{C_?}$ *)
(** printing TermRedPrim $\downarrow_\phi^p$ *)
Require Import PeanoNat.
Require Import List.
Require Import Plus.
Import Nat.
(**)
(** printing Op $\mathcal{O}$ *)
(** printing RedOp $\downarrow_{\mathcal{O}}$ *)
(** printing oconst $\const{\!}$ *)
(** printing osucc $\plusone$ *)
(** printing oflip $\flip$ *)
(** printing obranch $\onte{\!\cdot\!}{\!\cdot\!}{\!\cdot\!}$ *)
(** printing HoleOp $\dot{\mathcal{O}}$ *)
(** printing HolePrim $\dot{P}$ *)
(** printing HoleCode $\dot{C}$ *)
(**)
(** printing s $\sigma$ *)
(** printing s' $\sigma'$ *)
(** printing s'' $\sigma''$ *)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pr $\phi_r$ *)
(** printing Pr' $\phi_r'$ *)
(** printing Pi $\phi_\cdot$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)
(** printing na $n_a$ *)
(** printing nr $n_r$ *)
(** printing ns $\vec{n}$ *)
(** printing oin $o_{\textit{on}}$ *)
(** printing oon $o_{\textit{on}}$ *)
(** printing ooff $o_{\textit{off}}$ *)
(** printing ios $\vec{io}$ *)
(** printing l $\ell$ *)
(** printing lf $\ell_f$ *)
(** printing la $\ell_a$ *)
(** printing hl $\dot{\ell} *)
(** printing hlf $\dot{\ell}_f *)
(** printing hla $\dot{\ell}_a *)
(** printing ho $\dot{o}$ *)
(** printing hoon $\dot{o}_{\textit{on}}$ *)
(** printing hooff $\dot{o}_{\textit{off}}$ *)
(** printing hc $\dot{c}$ *)
(** printing hcf $\dot{c}_f$ *)
(** printing hca $\dot{c}_a$ *)
(** printing hcr $\dot{c}_r$ *)
(** printing hp $\dot{p}$ *)
(** printing pf $p_f$ *)
(** printing cns $c_{ns}$ *)
(** printing cnm $c_{nm}$ *)
(**)
(* printing Prim' $P$ *)


(** *** Definition of %\Flip{}% *)
(** This is the formal definition of %\Flip{}% in Figure %\ref{fig:nd-rca}%.
    It uses the [FreeRCA] module for $\lambda$-terms, so the following module specifies the primitives and their behavior.
    Note that primitives here include the $\overline{n}$ codes, with [pvalue] being the corresponding constructor.
    We use [Op] here to refer to what the paper refers to as primitives. *)

Module FlipApplicativeStructure <: PrimitiveApplicativeStructure.
  Import FreeRelationalCombinatoryCode.

  Inductive Op : SET := oconst (n : nat) | osucc | obranch (ns : list nat) (oin ooff : Op) | oflip.
  Inductive Prim' : SET := pvalue (n : nat) | pop (o : Op).
(* begin hide *)
  Definition Prim : SET
  := Prim'.
(* end hide *)
  Definition PrimV (p : Prim) : Prop := True.

  Inductive RedOp : Op -> nat -> nat -> Prop
  := roconst (n na : nat) : RedOp (oconst n) na n
   | rosucc (n : nat) : RedOp osucc n (S n)
   | robranchon (ns : list nat) (oon ooff : Op) (na nr : nat) : In na ns -> RedOp oon na nr -> RedOp (obranch ns oon ooff) na nr
   | robranchoff (ns : list nat) (oon ooff : Op) (na nr : nat) : (In na ns -> False) -> RedOp ooff na nr -> RedOp (obranch ns oon ooff) na nr
   | rotails (na : nat) : RedOp oflip na 0
   | roheads (na : nat) : RedOp oflip na 1.
  Definition RedPrim (pf : Prim) (ca : PCode Prim) (cr : PCode Prim) : Prop
  := exists2 of : Op, pop of = pf & exists2 na : nat, cprim (pvalue na) = ca & exists2 nr : nat, cprim (pvalue nr) = cr & RedOp of na nr.
  Definition TermPrim (pf : Prim) (ca : PCode Prim) : Prop := exists2 of : Op, pop of = pf & exists na : nat, cprim (pvalue na) = ca.

  Lemma preservation_prim (pf : Prim) (ca : PCode Prim) (cr : PCode Prim) : PrimV pf -> PCodeV PrimV ca -> RedPrim pf ca cr -> PCodeV PrimV cr.
    intros _ _ [ of ef [ na ea [ nr er ro ] ] ]. destruct er. split.
  Qed.
  Lemma progress_prim (pf : Prim) (ca : PCode Prim) : PrimV pf -> PCodeV PrimV ca -> TermPrim pf ca -> exists cr : PCode Prim, RedPrim pf ca cr.
    intros _ _ [ of ef [ na ea ] ]. destruct ef. destruct ea. assert (exists nr : nat, RedOp of na nr) as [ nr ro ].
     induction of.
      exists n. constructor.
      exists (S na). constructor.
      destruct (in_dec eq_dec na ns) as [ i | ni ].
       destruct IHof1 as [ nr ro ]. exists nr. apply robranchon; assumption.
       destruct IHof2 as [ nr rp ]. exists nr. apply robranchoff; assumption.
      exists 0. constructor.
     exists (cprim (pvalue nr)). exists of; try reflexivity. exists na; try reflexivity. exists nr; try reflexivity. assumption.
  Qed.

End FlipApplicativeStructure.


(** *** Proof that %\Flip{}% is an RCA. *)
(** %\label{coq:flip-rca}%The proof of %Lemma~\ref{flip-rca}% is a trival application of the [FreeRCA] module. *)

Module FlipRCA := FreeRelationalCombinatoryAlgebra FlipApplicativeStructure.


(** *** Definition of %\Flip{}% Codes with Primitive Holes *)
(** %\label{coq:flip-holes}%The first part of this module provides the formal definitions of codes with holes and of the operations for filling those holes used in %Lemma~\ref{lem:flip-cont}%. *)

Module FlipNCC.
(* begin hide *)
  Import FlipApplicativeStructure.
  Import RelationalApplicativeExpression.
  Import FlipRCA.
  Module CCinRCA := CCinRCA FlipRCA.
  Import CCinRCA.
  Import HOF.
  Import InhabitedSets.
  Import InhabitedSetsNat.
  Import CC.
  Import RCAT.
(* end hide *)

(* begin hide *)
  Lemma propv (p : set oprop) : setv oprop p. simpl. trivial. Qed.

  Lemma codev (c : Code) : CodeV c.
    unfold CodeV. revert c. fix codev 1. intro c. destruct c; simpl.
     exact I.
     induction lb.
      apply codev.
      exact I.
      split; assumption.
  Qed.

  Lemma progress' (cf ca : Code) (Pr : Code -> Prop) : TermRed Red Term cf ca Pr -> exists2 cr : Code, RedCode RedPrim cf ca cr & Pr cr.
    intro r. destruct r as [ t r ]. apply (progress_code PrimV) in t; try exact I; try apply codev.
     destruct t as [ cr rc ]. exists cr; try assumption. apply r; try exact I; try apply codev. assumption.
     exact preservation_prim.
     exact progress_prim.
  Qed.
(* end hide *)

  Inductive HoleOp : Type := hohole | hoconst (n : nat) | hosucc | hobranch (ns : list nat) (hoon hooff : HoleOp) | hoflip.
  Fixpoint fill_op (o : Op) (ho : HoleOp) : Op
  := match ho with
     | hohole => o
     | hoconst n => oconst n
     | hosucc => osucc
     | hobranch ns hoon hooff => obranch ns (fill_op o hoon) (fill_op o hooff)
     | hoflip => oflip
     end.

  Inductive HolePrim : Type := hpvalue (n : nat) | hpop (ho : HoleOp).
  Definition HoleCode : Type := PCode HolePrim.

  Definition fill_prim (o : Op) (hp : HolePrim) : Prim := match hp with hpvalue n => pvalue n | hpop ho => pop (fill_op o ho) end.
  Definition fill_lambda (fill_code : HoleCode -> Code) {n : nat} : Lambda HoleCode n -> Lambda Code n
  := fix fill_lambda (hl : Lambda HoleCode n) : Lambda Code n
  := match hl with lcode hc => lcode (fill_code hc) | lvar _ v => lvar n v | lapp hlf hla => lapp (fill_lambda hlf) (fill_lambda hla) end.
  Fixpoint fill_code (o : Op) (hc : HoleCode) : Code := match hc with cprim hp => cprim (fill_prim o hp) | clam n hl => clam n (fill_lambda (fill_code o) hl) end.

(** *** Proof that %\Flip{}% is Extensional and Finitary *)
(** %\label{coq:flip-cont}%The actual proof is elided here, as it is straightforward from induction on the given proof of application. Only the formal statement of %Lemma~\ref{lem:flip-cont}% is shown. *)

(* begin hide *)
  Lemma fill_lsubst (fill_code : HoleCode -> Code) (hc : HoleCode) {n : nat} (hl : Lambda HoleCode (S n)) : fill_lambda fill_code (lsubst hc hl) = lsubst (fill_code hc) (fill_lambda fill_code hl).
    induction hl; simpl; f_equal; try assumption. destruct v; reflexivity.
  Qed.

  Lemma Forall_app {E : Type} (P : E -> Prop) (ll lr : list E) : Forall P (app ll lr) <-> Forall P ll /\ Forall P lr.
    split.
     intro f. induction ll.
      repeat constructor. assumption.
      inversion f; clear f; subst. apply IHll in H2. destruct H2. repeat constructor; assumption.
     intros [ fl fr ]. induction fl.
      assumption.
      constructor; assumption.
  Qed.
(* end hide *)

  Lemma continuity_code (hcf hca : HoleCode) (o : Op) (cr : Code)
  : RedCode RedPrim (fill_code o hcf) (fill_code o hca) cr
 -> exists2 hcr : HoleCode,
    fill_code o hcr = cr
  & exists2 ios : list (prod nat nat),
    Forall (fun io => RedOp o (fst io) (snd io)) ios
  & forall o' : Op, Forall (fun io => RedOp o' (fst io) (snd io)) ios -> RedCode RedPrim (fill_code o' hcf) (fill_code o' hca) (fill_code o' hcr).
    remember (fill_code o hcf) as cf. remember (fill_code o hca) as ca. revert cf ca cr hcf hca Heqcf Heqca. fix continuity_code 8. intros cf ca cr hcf hca ef ea r. destruct r.
     clear continuity_code. destruct H as [ of ef' [ na ea' [ nr er op ] ] ]. destruct ef'. destruct hcf; inversion ef; clear ef. destruct p; inversion H0; clear H0. rename ho into hof. rename H1 into ef. destruct ea'. destruct hca; inversion ea; clear ea. destruct p; inversion H0; clear H0. destruct H1. destruct er. exists (cprim (hpvalue nr)); try reflexivity. simpl. assert (exists2 ios, Forall (fun io => RedOp o (fst io) (snd io)) ios & forall o', Forall (fun io => RedOp o' (fst io) (snd io)) ios -> RedOp (fill_op o' hof) na nr) as [ ios bo cont_op ].
      revert hof ef. induction op; intros hof ef.
       destruct hof; inversion ef; clear ef.
        simpl in H. destruct H. exists (cons (pair na n) nil); repeat constructor. intros o' bo'. inversion bo'; clear bo'; subst. assumption.
        destruct H0. exists nil; constructor.
       destruct hof; inversion ef; clear ef.
        simpl in H. destruct H. exists (cons (pair n (S n)) nil); repeat constructor. intros o' bo'. inversion bo'; clear bo'; subst. assumption.
        exists nil; constructor.
       rename H into i. destruct hof; inversion ef; clear ef.
        simpl in H. destruct H. exists (cons (pair na nr) nil); try (repeat constructor; assumption). intros o' bo'. inversion bo'; clear bo'; subst. assumption.
        destruct H0. pose proof (IHop hof1 H1) as IHop. clear H1 H2. destruct IHop as [ ios bo cont_op ]. exists ios; try assumption. intros o' bo'. simpl. apply robranchon; try assumption. apply cont_op. assumption.
       rename H into ni. destruct hof; inversion ef; clear ef.
        simpl in H. destruct H. exists (cons (pair na nr) nil); try (repeat constructor; assumption). intros o' bo'. inversion bo'; clear bo'; subst. assumption.
        destruct H0. pose proof (IHop hof2 H2) as IHop. clear H1 H2. destruct IHop as [ ios bo cont_op ]. exists ios; try assumption. intros o' bo'. simpl. apply robranchoff; try assumption. apply cont_op. assumption.
       destruct hof; inversion ef; clear ef.
        simpl in H. destruct H. exists (cons (pair na 0) nil); repeat constructor. intros o' bo'. inversion bo'; clear bo'; subst. assumption.
        exists nil; constructor.
       destruct hof; inversion ef; clear ef.
        simpl in H. destruct H. exists (cons (pair na 1) nil); repeat constructor. intros o' bo'. inversion bo'; clear bo'; subst. assumption.
        exists nil; constructor.
      exists ios; try assumption. intros o' bo'. constructor. exists (fill_op o' hof); try reflexivity. exists na; try reflexivity. exists nr; try reflexivity. apply cont_op. assumption.
     rename H into rl. destruct hcf; inversion ef; clear ef. destruct H0. inj_pair2_nat. rename lb0 into hl. rename H1 into el. subst. rewrite <- fill_lsubst in rl. remember (fill_lambda (fill_code o) (lsubst hca hl)). assert (exists2 hcr, fill_code o hcr = cr & exists2 ios, Forall (fun io => RedOp o (fst io) (snd io)) ios & forall o', Forall (fun io => RedOp o' (fst io) (snd io)) ios -> RedLambda (RedCode RedPrim) (fill_lambda (fill_code o') (lsubst hca hl)) (fill_code o' hcr)) as [ hcr er [ ios bo cont_lambda ] ].
      revert Heql rl. generalize (lsubst hca hl). clear hl hca. intros hl el rl. revert l cr hl el rl. fix cont_lambda 5. intros l cr hl el rl. destruct rl.
       destruct hl; inversion el; clear el. rename c0 into hc. rename H0 into ec. exists hc; try reflexivity. exists nil; constructor.
       rename rl1 into rf. rename rl2 into ra. rename H into rc. destruct hl; inversion el; clear el. rename hl1 into hlf. rename hl2 into hla. rename H0 into ef. rename H1 into ea. apply cont_lambda with (hl := hlf) in rf; try assumption. clear lf ef. destruct rf as [ hcf ef [ iosf bof cont_f ] ]. apply cont_lambda with (hl := hla) in ra; try assumption. clear la ea. destruct ra as [ hca ea [ iosa boa cont_a ] ]. apply continuity_code with (hcf := hcf) (hca := hca) in rc; try (symmetry; assumption). clear cf ef ca ea. destruct rc as [ hcr er [ iosr bor cont_r ] ]. exists hcr; try assumption. exists (app iosf (app iosa iosr)).
        apply Forall_app. split; try assumption. apply Forall_app. split; assumption.
        intros o' bo'. apply Forall_app in bo'. destruct bo' as [ bof' bo' ]. apply Forall_app in bo'. destruct bo' as [ boa' bor' ]. simpl. apply rlapp with (fill_code o' hcf) (fill_code o' hca); auto.
      exists hcr; try assumption. exists ios; try assumption. intros o' bo'. simpl. constructor. rewrite <- fill_lsubst. apply cont_lambda. assumption.
     clear continuity_code. destruct hcf; inversion ef; clear ef. destruct H0. apply inj_pair2_nat in H1. rename lb0 into hl. rename H1 into el. exists (clam n (lsubst hca hl)).
      simpl. f_equal. subst. apply fill_lsubst.
      exists nil; try (constructor; fail). intros o' _. simpl. rewrite fill_lsubst. constructor.
  Qed.

(** *** Proof that %\Flip{}% Internally Negates Countable Choice *)
(** %\label{coq:flip-ncc}%The detailed proof of %Theorem~\ref{flip-ncc}% is elided here, but we provide the primary lemmas to provide some insight. *)

  Fixpoint filled_op (o : Op) : HoleOp
  := match o with oconst n => hoconst n | osucc => hosucc | obranch ns oon ooff => hobranch ns (filled_op oon) (filled_op ooff) | oflip => hoflip end.
  Definition filled_prim (p : Prim) : HolePrim := match p with pvalue n => hpvalue n | pop o => hpop (filled_op o) end.
  Definition filled_lambda (filled_code : Code -> HoleCode) {n : nat} : Lambda Code n -> Lambda HoleCode n
  := fix filled_lambda (l : Lambda Code n) : Lambda HoleCode n
  := match l with lcode c => lcode (filled_code c) | lvar _ v => lvar n v | lapp lf la => lapp (filled_lambda lf) (filled_lambda la) end.
  Fixpoint filled_code (c : Code) : HoleCode := match c with cprim p => cprim (filled_prim p) | clam n l => clam n (filled_lambda filled_code l) end.
  Lemma fill_filled_code (o : Op) (c : Code) : fill_code o (filled_code c) = c.
    revert c. fix fill_filled_code 1. intro c. destruct c; simpl.
     f_equal. destruct p; simpl.
      reflexivity.
      f_equal. rename o0 into o'. induction o'; try reflexivity. simpl. f_equal; assumption.
     f_equal. induction lb; simpl.
      f_equal. apply fill_filled_code.
      reflexivity.
      f_equal; assumption.
  Qed.

  Lemma red_cnat (n : nat) : TermCode RedPrim TermPrim (cnat n) (cprim (pop osucc)) /\ forall cns : Code, RedCode RedPrim (cnat n) (cprim (pop osucc)) cns -> forall m : nat, TermCode RedPrim TermPrim cns (cprim (pvalue m)) /\ forall cnm : Code, RedCode RedPrim cns (cprim (pvalue m)) cnm -> cprim (pvalue (n + m)) = cnm.
    induction n.
     split.
      constructor.
      intros cns rns m. inversion rns; clear rns; subst. inj_pair2_nat. subst. simpl. split.
       constructor. simpl. constructor.
       intros cnm rnm. inversion rnm; clear rnm; subst. inj_pair2_nat. subst. simpl in H0. inversion H0; clear H0; subst. reflexivity.
     split.
      constructor.
      intros cns rns m. inversion rns; clear rns; subst. inj_pair2_nat. subst. simpl. split.
       constructor. simpl. constructor.
        constructor.
        intros c r. inversion r; clear r; subst. split.
         constructor.
          constructor.
           constructor.
           intros c r. inversion r; clear r; subst. split.
            constructor.
            intros c r. inversion r; clear r; subst. apply IHn.
          intros c r. inversion r; clear r; subst. inversion H1; clear H1; subst. inversion H2; clear H2; subst. rename c into cns. rename H4 into rns. split.
           constructor.
           intros c r. inversion r; clear r; subst. apply IHn. assumption.
         intros c r. inversion r; clear r; subst. inversion H2; clear H2; subst. inversion H1; clear H1; subst. inversion H2; clear H2; subst. inversion H3; clear H3; subst. rename cf into cns. rename H6 into rns. rename H4 into rnm. constructor. exists osucc; try reflexivity. exists (n + m). destruct IHn as [ _ IHn ]. apply IHn with (m := m) in rns. apply rns. assumption.
       intros ncm rnm. inversion rnm; clear rnm; subst. inj_pair2_nat. subst. simpl in H0. inversion H0; clear H0; subst. inversion H2; clear H2; subst. inversion H5; clear H5; subst. inversion H3; clear H3; subst. inversion H4; clear H4; subst. inversion H2; clear H2; subst. inversion H3; clear H3; subst. inversion H4; clear H4; subst. destruct H0 as [ o eo [ na ea [ nr er ro ] ] ]. inversion eo; clear eo; subst. inversion ro; clear ro; subst. rename cf into cns. rename na into nm. rename H7 into rns. rename H6 into rnm. f_equal. f_equal. f_equal. destruct IHn as [ _ IHn ]. apply IHn in rnm; try assumption. inversion rnm; clear rnm; subst. reflexivity.
  Qed.

  Definition cop (o : Op) : Code := clam 0 (lapp (lcode (cprim (pop o))) (lapp (lapp (lvar 1 None) (lcode (cprim (pop osucc)))) (lcode (cprim (pvalue 0))))).
(* begin hide *)
  Lemma copv (o : Op) : CodeV (cop o). apply codev. Qed.
(* end hide *)
  Lemma red_cop (o : Op) (m : nat) (cm : Code) (Pr : Code -> Prop) : isnat m cm -> (forall n : nat, RedOp o m n -> Pr (cprim (pvalue n))) -> TermRed Red Term (cop o) cm Pr.
    intros pmcm ro. split.
     constructor. simpl. constructor.
      constructor.
      intros c r. inversion r; clear r; subst. split.
       clear o Pr ro. constructor.
        constructor.
         constructor.
         intros c r. inversion r; clear r; subst. rename c into cm. split.
          constructor.
          intros c r. inversion r; clear r; subst. destruct pmcm. apply red_cnat.
        intros cms r. inversion r; clear r; subst. inversion H1; clear H1; subst. inversion H2; clear H2; subst. rename cf into cm. rename H4 into rms. split.
         constructor.
         intros c r. inversion r; clear r; subst. destruct pmcm. pose proof (red_cnat m) as [ _ red_cnat ]. apply red_cnat. assumption.
       intros c r. inversion r; clear r; subst. inversion H2; clear H2; subst. inversion H1; clear H1; subst. inversion H2; clear H2; subst. inversion H3; clear H3; subst. constructor. exists o; try reflexivity. exists m. destruct pmcm. pose proof (red_cnat m) as [ _ red_cnat ]. apply red_cnat in H4; try assumption. rewrite plus_comm in H4. assumption.
     intros cr rc. inversion rc; clear rc; subst. inj_pair2_nat. subst. simpl in H0. inversion H0; clear H0; subst. inversion H2; clear H2; subst. inversion H5; clear H5; subst. inversion H3; clear H3; subst. inversion H4; clear H4; subst. inversion H2; clear H2; subst. inversion H3; clear H3; subst. inversion H4; clear H4; subst. destruct H0 as [ o' eo [ na ea [ nr er ro' ] ] ]. inversion eo; clear eo; subst. apply ro. destruct pmcm. pose proof (red_cnat m) as [ _ red_cnat ]. apply red_cnat in H6; try assumption. inversion H6; clear H6; subst. rewrite plus_comm in ro'. assumption.
  Qed.
  Definition hcop (ho : HoleOp) : HoleCode := clam 0 (lapp (lcode (cprim (hpop ho))) (lapp (lapp (lvar 1 None) (lcode (cprim (hpop hosucc)))) (lcode (cprim (hpvalue 0))))).
  Lemma fill_cop (o : Op) (ho : HoleOp) : fill_code o (hcop ho) = cop (fill_op o ho). reflexivity. Qed.

  Definition Rop (o : Op) : set (oexp onat (oexp onat oprop)) := fun m n c => RedOp o m n /\ (cprim (pvalue n)) = c.
  Lemma Ropv (o : Op) : setv (oexp onat (oexp onat oprop)) (Rop o).
    split.
     intros. simpl. split; try auto. intros. subst. split; trivial.
     simpl. intros. subst. split; trivial.
  Qed.
  Lemma Rop_total (o : Op) : total onat onat isnat (Rop o) (cop o).
    intros m _. intros cm _ pncm. apply red_cop with m; try assumption. clear cm pncm. intros n ro. exists n; repeat split; trivial.
  Qed.

  Definition ncc : Code := caxiom.
(* begin hide *)
  Lemma nccv : CodeV ncc. exact caxiomv. Qed.
(* end hide *)
  Theorem neg_countable_choice : exists o : Object, Entails (countable_choice o) (bot ounit).
    exists onat. apply trans with (rca_countable_choice onat); try apply rca_countable_choice_equiv; try auto. exists ncc; try exact nccv. intros [] cc _ _ pcc. elimtype False. pose proof (pcc (Rop (oconst 0)) (Ropv (oconst 0))) as cc0. unfold subst in cc0. simpl in cc0. specialize (cc0 (cop (oconst 0)) (codev (cop (oconst 0))) (Rop_total (oconst 0))). apply progress' in cc0. destruct cc0 as [ ctot0 r0 _ ]. rewrite <- (fill_filled_code (oconst 0) cc) in r0. change (oconst 0) with (fill_op (oconst 0) hohole) in r0. rewrite <- fill_cop in r0. apply continuity_code in r0. destruct r0 as [ hctot etot [ ios b0 cont ] ]. destruct etot. assert (forall o : Op, RedCode RedPrim cc (cop (obranch (map fst ios) (oconst 0) o)) (fill_code (obranch (map fst ios) (oconst 0) o) hctot)) as rcc.
     clear pcc. intro o. rewrite <- (fill_filled_code (obranch (map fst ios) (oconst 0) o) cc). change (obranch (map fst ios) (oconst 0) o) with (fill_op o (hobranch (map fst ios) (hoconst 0) hohole)). rewrite <- fill_cop. apply cont. clear cc hctot cont. apply Forall_forall. intros io i. simpl. assert (forall io, In io ios -> RedOp (oconst 0) (fst io) (snd io)) as b0'; [ apply Forall_forall; assumption | clear b0; rename b0' into b0 ]. pose proof i as r0. apply b0 in r0. clear b0. destruct io as [ m n ]. simpl in *. inversion r0; clear r0; subst. apply robranchon; try constructor. apply (in_map fst) in i. assumption.
     clear b0 cont. pose proof (rcc oflip) as rflip. pose proof (pcc (Rop (obranch (map fst ios) (oconst 0) oflip)) (Ropv (obranch (map fst ios) (oconst 0) oflip))) as ccflip. unfold subst in ccflip. simpl in ccflip. specialize (ccflip (cop (obranch (map fst ios) (oconst 0) oflip)) (codev (cop (obranch (map fst ios) (oconst 0) oflip))) (Rop_total (obranch (map fst ios) (oconst 0) oflip))). apply ccflip in rflip; try exact I; try apply codev. clear ccflip. destruct rflip as [ Sflip _ [ SflipR Sflipdet ] Sfliptot ]. pose proof (rcc (oconst 0)) as r0. pose proof (pcc (Rop (obranch (map fst ios) (oconst 0) (oconst 0))) (Ropv (obranch (map fst ios) (oconst 0) (oconst 0)))) as cc0. unfold subst in cc0. simpl in cc0. specialize (cc0 (cop (obranch (map fst ios) (oconst 0) (oconst 0))) (codev (cop (obranch (map fst ios) (oconst 0) (oconst 0)))) (Rop_total (obranch (map fst ios) (oconst 0) (oconst 0)))). apply cc0 in r0; try exact I; try apply codev. clear cc0. destruct r0 as [ S0 _ [ S0R _ ] S0tot ]. pose proof (rcc (oconst 1)) as r1. pose proof (pcc (Rop (obranch (map fst ios) (oconst 0) (oconst 1))) (Ropv (obranch (map fst ios) (oconst 0) (oconst 1)))) as cc1. unfold subst in cc1. simpl in cc1. specialize (cc1 (cop (obranch (map fst ios) (oconst 0) (oconst 1))) (codev (cop (obranch (map fst ios) (oconst 0) (oconst 1)))) (Rop_total (obranch (map fst ios) (oconst 0) (oconst 1)))). apply cc1 in r1; try exact I; try apply codev. clear cc1. destruct r1 as [ S1 _ [ S1R _ ] S1tot ]. clear cc pcc rcc. assert (exists m, In m (map fst ios) -> False) as [ m ni ].
      assert (exists m : nat, Forall (ge m) (map fst ios)) as [ m g ].
       clear. induction ios.
        exists 0. constructor.
        destruct IHios as [ m g ]. exists (max m (fst a)). simpl. constructor.
         apply le_max_r.
         revert g. apply Forall_impl. intros. unfold ge. transitivity m; try assumption. apply le_max_l.
       exists (S m). assert (forall n, In n (map fst ios) -> ge m n) as g'; [ revert g; apply Forall_forall | clear g; rename g' into g ]. intro i. apply g in i. apply lt_irrefl in i. assumption.
      specialize (fun n c => SflipR m n c I (codev c)). specialize (fun n n' c c' => Sflipdet m n n' c c' I I (codev c) (codev c')). specialize (Sfliptot m I (cnat m) (codev (cnat m)) Logic.eq_refl). specialize (fun n c => S0R m n c I (codev c)). specialize (S0tot m I (cnat m) (codev (cnat m)) Logic.eq_refl). specialize (fun n c => S1R m n c I (codev c)). specialize (S1tot m I (cnat m) (codev (cnat m)) Logic.eq_refl). apply progress' in S0tot. destruct S0tot as [ c0 r0 [ n0 _ s0 ] ]. apply S0R in s0. simpl in *. clear S0 S0R. inversion s0; clear s0; subst. inversion H; clear H; subst; try auto. clear H5. inversion H6; clear H6; subst. apply progress' in S1tot. destruct S1tot as [ c1 r1 [ n1 _ s1 ] ]. apply S1R in s1. simpl in *. clear S1 S1R. inversion s1; clear s1; subst. inversion H; clear H; subst; try auto. clear H5. inversion H6; clear H6; subst. assert (exists hctot', forall o, fill_code o hctot' = fill_code (obranch (map fst ios) (oconst 0) o) hctot) as [ hctot' abstract ].
       clear. revert hctot. fix abstract 1. intro hctot. destruct hctot.
        clear abstract. destruct p.
         exists (cprim (hpvalue n)). reflexivity.
         assert (exists ho', forall o, fill_op o ho' = fill_op (obranch (map fst ios) (oconst 0) o) ho) as [ ho' fill ].
          induction ho.
           exists (hobranch (map fst ios) (hoconst 0) hohole). reflexivity.
           exists (hoconst n). reflexivity.
           exists hosucc. reflexivity.
           destruct IHho1 as [ ho1' abstract1 ]. destruct IHho2 as [ ho2' abstract2 ]. exists (hobranch ns ho1' ho2'). intro o. simpl. f_equal; auto.
           exists hoflip. reflexivity.
          exists (cprim (hpop ho')). intro o. simpl. f_equal. f_equal. apply fill.
        simpl. assert (exists hl', forall o, fill_lambda (fill_code o) hl' = fill_lambda (fill_code (obranch (map fst ios) (oconst 0) o)) lb) as [ hl' labstract ].
         induction lb.
          pose proof (abstract c) as [ hc' abstractc ]. exists (lcode hc'). intro o. simpl. f_equal. apply abstractc.
          exists (lvar (S n) v). reflexivity.
          destruct IHlb1 as [ hlf' abstractf ]. destruct IHlb2 as [ hla' abstracta ]. exists (lapp hlf' hla'). intro o. simpl. f_equal; auto.
         exists (clam n hl'). intro o. simpl. f_equal. apply labstract.
       rewrite <- abstract in r0. rewrite <- abstract in r1. rewrite <- abstract in Sfliptot. clear hctot abstract. rewrite <- (fill_filled_code (oconst 0) (cnat m)) in r0. rewrite <- (fill_filled_code (oconst 1) (cnat m)) in r1. apply continuity_code in r0. destruct r0 as [ hc0 ec0 [ ios0 b0 cont0 ] ]. destruct hc0; inversion ec0; clear ec0; subst. destruct p; inversion H0; clear H0; subst. apply continuity_code in r1. destruct r1 as [ hc1 ec1 [ ios1 b1 cont1 ] ]. destruct hc1; inversion ec1; clear ec1; subst. destruct p; inversion H0; clear H0; subst. simpl in *. pose proof (cont0 oflip) as cont0. pose proof (cont1 oflip) as cont1. rewrite fill_filled_code in cont0. rewrite fill_filled_code in cont1. apply Sfliptot in cont0; try exact I; try apply codev.
        clear ios0 b0. apply Sfliptot in cont1; try exact I; try apply codev.
         clear hctot' Sfliptot ios1 b1. destruct cont0 as [ n0 _ s0 ]. destruct cont1 as [ n1 _ s1 ]. assert (n0 = n1) as e; [ revert s0 s1; apply Sflipdet | destruct e ]. clear Sflipdet. apply SflipR in s0. inversion s0; clear s0; subst; try trivial. clear H. inversion H0; clear H0; subst. apply SflipR in s1. inversion s1; clear s1; subst; try trivial. clear H. inversion H0.
         clear Sflip m SflipR Sflipdet hctot' Sfliptot cont0 cont1 ni H. induction b1; constructor; try assumption. destruct x as [ m n ]. inversion H. constructor.
        clear Sflip m SflipR Sflipdet hctot' Sfliptot cont0 ios1 b1 cont1 ni H. induction b0; constructor; try assumption. destruct x as [ m n ]. inversion H. constructor.
  Qed.

End FlipNCC.
