Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
Require Import Sets.
(** printing set $\mathit{set}$ *)
(** printing setv $\isa{\coqdocvar{set}}$ *)
(** printing sete $\iseq{\coqdocvar{set}}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import RCAs.
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import PCAs.
Require Import HOFs.
(** printing PROP $\Phi$ *)
(** printing PROPV $\isa{\Phi}$ *)
(** printing Entails $\vdash$ *)
(** printing subst $\dot{\phi}[\cdot]$ *)
(** printing top $\top$ *)
(** printing conj $\conj$ *)
(** printing bot $\bot$ *)
(** printing disj $\disj$ *)
(** printing imp $\imp$ *)
(** printing sforall $\forall$ *)
(** printing sexists $\exists$ *)
(** printing seq $=$ *)
(** printing oprop $\Omega$ *)
(** printing character $\chi$ *)
(** printing holds $\mathit{holds}$ *)
(** printing isnat $\isnat$ *)
Require Import RCAstoHOFs.
(** printing cnat $c^\lambda_\cdot$ *)
Require Import CountableChoice.
(** printing sexistsr $\exists\mathord{\mid}$ *)
Require Import Peano_dec.
Require Import PeanoNat.
Import Nat.
(**)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pi $\phi_\cdot$ *)
(** printing s $\sigma$ *)
(** printing s' $\sigma'$ *)


(** *** Proof that Partial Combinatory Algebras Internally Model Countable Choice *)
(** %\label{coq:pca-cc}%This module demonstrates that the higher-order fibration for any PCA internally models countable choice, as claimed in %Theorem~\ref{pca-cc}%.
    We only show the metatheoretic assumption made and the key lemma enabled by determinism that permits PCAs to model countable choice; we elide here the detailed proof of the theorem. *)

Module CCPCA (PCA : PartialCombinatoryAlgebra).
(* begin hide *)
  Import PCA.
  Import RelationalApplicativeExpression.
  Module CCinRCA := CCinRCA PCA.
  Import CCinRCA.
  Import HOF.
  Import InhabitedSets.
  Import InhabitedSetsNat.
  Import CC.
  Import RCAT.
(* end hide *)

(** Here we assume the axiom of countable choice in the metatheory. *)

  Axiom axiom_of_countable_choice : forall I : SET, forall IV : I -> Prop, forall R : nat -> I -> Prop, (forall n : nat, exists2 i : I, IV i & R n i) -> exists3 S : nat -> I -> Prop, (forall n : nat, forall i : I, S n i -> R n i) & (forall n : nat, forall i i' : I, S n i -> S n i' -> i = i') & forall n : nat, exists2 i : I, IV i & S n i.

(** This is the key lemma that enables us to prove choice. It requires the [red_deterministic] property of PCAs. *)

  Lemma red_exists (cf ca : Code) (I : SET) (IV : I -> Prop) (Pi : I -> Code -> Prop) : CodeV cf -> CodeV ca -> (exists i : I, IV i) -> TermRed Red Term cf ca (fun cr => exists2 i : I, IV i & Pi i cr) -> exists2 i : I, IV i & TermRed Red Term cf ca (Pi i).
    intros cfv cav iinh tr. destruct tr as [ t r ]. pose proof t as i. apply progress in i; try auto. destruct i as [ cr rcr ]. assert (CodeV cr) as crv by (revert rcr; apply preservation; auto). specialize (r cr). destruct r as [ i iv picr ]; try auto. exists i; try auto. split; try auto. intros cr' rcr'. assert (CodeV cr') as crv' by (revert rcr'; apply preservation; auto). replace cr' with cr; try auto. revert rcr rcr'. apply red_deterministic; auto.
  Qed.

  Definition cc : Code := cencode 0 (ecode caxiom).
(* begin hide *)
  Lemma ccv : CodeV cc. unfold cc. auto. Qed.
  Hint Resolve ccv.
(* end hide *)
  Theorem countable_choice (o : Object) : ObjectV o -> Entails (top ounit) (countable_choice o).
    intro ov. apply trans with (rca_countable_choice o); try apply rca_countable_choice_equiv; try auto. exists cc; try auto. intros [] c _ cv _. unfold cc. termred. clear c cv. unfold rca_countable_choice. intros R Rv. unfold subst. simpl. intros ctot ctotv ptotctot. apply tr_caxiom; try auto. pose proof (axiom_of_countable_choice (set o) (setv o) (fun n x => TermRed Red Term ctot (cnat n) (R n x))) as [ S SR Sdet Stot ].
      intro n. specialize (ptotctot n I (cnat n)). unfold subst in ptotctot. unfold holds in ptotctot. simpl in ptotctot. apply red_exists in ptotctot; try auto. reflexivity.
      exists (fun n x c => R n x c /\ exists3 x', setv o x' & sete o x x' & S n x'); simpl.
       split.
        intros n nv. split; try auto. intros x x' xv xv' xx' cr crv. split; intros [ rcr [ x'' xv'' xe sx ] ]; split.
         apply Rv with x; auto.
         exists x''; try auto. apply strans with x; auto.
         apply Rv with x'; auto.
         exists x''; try auto. apply strans with x'; auto.
        intros n n' nv _ nn'. destruct nn'. intros x x' xv xv' xx' cr crv. split; intros [ rcr [ x'' xv'' xe sx ] ]; split.
         apply Rv with x; auto.
         exists x''; try auto. apply strans with x; auto.
         apply Rv with x'; auto.
         exists x''; try auto. apply strans with x'; auto.
       repeat apply Logic.conj.
        unfold rca_included. simpl. auto.
        unfold rca_determined. simpl. intros n x x' c c' xv xv' _ _ [ _ [ x'' xv'' xx'' sx'' ] ] [ _ [ x''' xv''' x'x''' sx''' ] ]. apply strans with x''; try auto. apply ssym in x'x'''; try auto. apply strans with x'''; try auto. replace x''' with x''; try auto. revert sx'' sx'''. apply Sdet.
        intros n _ c _ e. destruct e. clear ptotctot. specialize (Stot n). destruct Stot as [ x xv sx ]. specialize (SR n x sx). revert SR. apply termred_mono; try auto. intros cr srv r. exists x; try assumption. unfold subst. unfold holds. simpl. split; try assumption. exists x; auto.
  Qed.

End CCPCA.
