Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
(**)
(** printing set $\mathit{set}$ *)
(** printing setv $\isa{\coqdocvar{set}}$ *)
(** printing sete $\iseq{\coqdocvar{set}}$ *)
(**)
(** printing o1 $o_1$ *)
(** printing o2 $o_2$ *)
(** printing o3 $o_3$ *)
(** printing o4 $o_4$ *)
(** printing m' $m'$ *)
(** printing m1 $m_1$ *)
(** printing m2 $m_2$ *)
(** printing m3 $m_3$ *)
(** printing mz $m_z$ *)
(** printing ms $m_s$ *)
(** printing m12 $m_{12}$ *)
(** printing m23 $m_{23}$ *)
(** printing m34 $m_{34}$ *)
(** printing m12' $m_{12}'$ *)
(** printing m23' $m_{23}'$ *)
(**)
(** printing Object' $\mathcal{O}$ *)
(** printing ObjectV' $\isa{\mathcal{O}}$ *)
(** printing MorphismV' $\isa{\leadsto}$ *)


(** *** Definition of the Category of Inhabited Sets *)

Module InhabitedSets <: CartesianClosedCategory.

  Record Object' : Type := { set : SET; setv : set -> Prop; sete : set -> set -> Prop }.
(* begin hide *)
  Definition Object : Type := Object'.
(* end hide *)

(** Objects are required to be _inhabited_ sets (but not pointed sets), as indicated by [sinh]. *)

  Record ObjectV' (o : Object) : Prop
  := { sinh : exists s : set o, setv o s
     ; srefl : forall s : set o, setv o s -> sete o s s
     ; ssym : forall s s' : set o, setv o s -> setv o s' -> sete o s s' -> sete o s' s
     ; strans : forall s s' s'' : set o, setv o s -> setv o s' -> setv o s'' -> sete o s s' -> sete o s' s'' -> sete o s s'' }.
(* begin hide *)
  Definition ObjectV : Object -> Prop
  := ObjectV'.
(* end hide *)
  Definition Morphism (o1 o2 : Object) : Type := set o1 -> set o2.

(** Note that morphisms are not required to preserve the required inhabitant, making this the category of inhabited sets rather than pointed sets. *)

  Record MorphismV' (o1 o2 : Object) (m : Morphism o1 o2) : Prop
  := { mpresv : forall s1 : set o1, setv o1 s1 -> setv o2 (m s1)
     ; mprese : forall s1 s1' : set o1, setv o1 s1 -> setv o1 s1' -> sete o1 s1 s1' -> sete o2 (m s1) (m s1') }.
(* begin hide *)
  Definition MorphismV : forall {o1 o2 : Object}, Morphism o1 o2 -> Prop
  := MorphismV'.
(* end hide *)
  Definition MorphismE {o1 o2 : Object} (m1 m2 : Morphism o1 o2) : Prop := forall s1 s1' : set o1, setv o1 s1 -> setv o1 s1' -> sete o1 s1 s1' -> sete o2 (m1 s1) (m2 s1').

(** We omit the remainder of this module as it simply demonstrates that inhabited sets form a cartesian-closed category, which is not novel.
    Note, though, that the ability to customize the validity predicate and equivalence relation are necessary for this construction. *)
(* begin hide *)
  Lemma mrefl (o1 o2 : Object) (m : Morphism o1 o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m m.
    intros ov1 ov2 mv. intros s1 s1' sv1 sv1' se1. apply mprese; assumption.
  Qed.
  Lemma msym (o1 o2 : Object) (m1 m2 : Morphism o1 o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismE m1 m2 -> MorphismE m2 m1.
    intros ov1 ov2 mv1 mv2 me. intros s1 s1' sv1 sv1' se1. apply ssym; try (apply mv1 || apply mv2); try assumption. apply me; try assumption. apply ssym; assumption.
  Qed.
  Lemma mtrans (o1 o2 : Object) (m1 m2 m3 : Morphism o1 o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismV m3 -> MorphismE m1 m2 -> MorphismE m2 m3 -> MorphismE m1 m3.
    intros ov1 ov2 mv1 mv2 mv3 me12 me23. intros s1 s1' sv1 sv1' se1. apply strans with (m2 s1); try (apply mv1 || apply mv2 || apply mv3); try assumption.
     apply me12; try assumption. apply srefl; assumption.
     apply me23; assumption.
  Qed.

  Definition mid (o : Object) : Morphism o o
  := fun s => s.
  Definition mcomp {o1 o2 o3 : Object} (m12 : Morphism o1 o2) (m23 : Morphism o2 o3) : Morphism o1 o3
  := fun s1 => m23 (m12 s1).
  Lemma midv (o : Object) : ObjectV o -> MorphismV (mid o).
    intro ov. constructor; simpl; trivial.
  Qed.
  Lemma mcompv (o1 o2 o3 : Object) (m12 : Morphism o1 o2) (m23 : Morphism o2 o3) : ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> MorphismV m12 -> MorphismV m23 -> MorphismV (mcomp m12 m23).
    intros ov1 ov2 ov3 mv12 mv23. constructor; simpl; unfold mcomp.
     intros s1 sv1. repeat apply mpresv; assumption.
     intros s1 s1' sv1 sv1' e1. repeat (apply mprese || apply mpresv); assumption.
  Qed.
  Lemma mcompe (o1 o2 o3 : Object) (m12 m12' : Morphism o1 o2) (m23 m23' : Morphism o2 o3) : ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> MorphismV m12 -> MorphismV m12' -> MorphismV m23 -> MorphismV m23' -> MorphismE m12 m12' -> MorphismE m23 m23' -> MorphismE (mcomp m12 m23) (mcomp m12' m23').
    intros ov1 ov2 ov3 mv12 mv12' mv23 mv23' me12 me23. intros s1 s1' sv1 sv1' se1. unfold mcomp. apply me23; try apply me12; try apply mpresv; assumption.
  Qed.

  Lemma mid_mcomp (o1 o2 : Object) (m : Morphism o1 o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m (mcomp (mid o1) m).
    intros ov1 ov2 mv. intros s1 s1' sv1 sv1' se1. apply mv; assumption.
  Qed.
  Lemma mcomp_mid (o1 o2 : Object) (m : Morphism o1 o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m (mcomp m (mid o2)).
    intros ov1 ov2 mv. intros s1 s1' sv1 sv1' se1. apply mv; assumption.
  Qed.
  Lemma mcomp_assoc (o1 o2 o3 o4 : Object) (m12 : Morphism o1 o2) (m23 : Morphism o2 o3) (m34 : Morphism o3 o4) : ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> ObjectV o4 -> MorphismV m12 -> MorphismV m23 -> MorphismV m34 -> MorphismE (mcomp (mcomp m12 m23) m34) (mcomp m12 (mcomp m23 m34)).
    intros ov1 ov2 ov3 ov4 mv12 mv23 mv34. intros s1 s1' sv1 sv1' se1. apply mv34; try apply (mcompv o1 o2 o3 m12 m23); assumption.
  Qed.

  Definition ounit : Object
  :=
  {| set := unit
   ; setv := fun _ => True
   ; sete := fun _ _ => True
   |}.
  Definition muniti (o : Object) : Morphism o ounit
  := fun _ => tt.
  Lemma ounitv : ObjectV ounit.
    constructor; simpl; try exists tt; trivial.
  Qed.
  Lemma munitiv (o : Object) : ObjectV o -> MorphismV (muniti o).
    intro ov. constructor; simpl; trivial.
  Qed.

  Lemma munitie (o : Object) (m : Morphism o ounit) : ObjectV o -> MorphismV m -> MorphismE (muniti o) m.
    intros ov mv. intros s s' sv sv' se. reflexivity.
  Qed.

  Definition oprod (o1 o2 : Object) : Object
  :=
  {| set := prod (set o1) (set o2)
   ; setv := fun s12 => setv o1 (fst s12) /\ setv o2 (snd s12)
   ; sete := fun s12 s12' => sete o1 (fst s12) (fst s12') /\ sete o2 (snd s12) (snd s12')
   |}.
  Definition mprodi {o : Object} {o1 o2 : Object} (m1 : Morphism o o1) (m2 : Morphism o o2) : Morphism o (oprod o1 o2)
  := fun s => pair (m1 s) (m2 s).
  Definition mprode1 (o1 o2 : Object) : Morphism (oprod o1 o2) o1
  := fst.
  Definition mprode2 (o1 o2 : Object) : Morphism (oprod o1 o2) o2
  := snd.
  Lemma oprodv (o1 o2 : Object) : ObjectV o1 -> ObjectV o2 -> ObjectV (oprod o1 o2).
    intros ov1 ov2. constructor; simpl.
     apply sinh in ov1. apply sinh in ov2. destruct ov1 as [ s1 sv1 ]. destruct ov2 as [ s2 sv2 ]. exists (pair s1 s2); auto.
     intros [ s1 s2 ]; simpl. intros [ v1 v2 ]. split; apply srefl; assumption.
     intros [ s1 s2 ] [ s1' s2' ]; simpl. intros [ v1 v2 ] [ v1' v2' ] [ e1 e2 ]. split; apply ssym; assumption.
     intros [ s1 s2 ] [ s1' s2' ] [ s1'' s2'' ]; simpl. intros [ v1 v2 ] [ v1' v2' ] [ v1'' v2'' ] [ e1 e2 ] [ e1' e2' ]. split; [ apply strans with s1' | apply strans with s2' ]; assumption.
  Qed.
  Lemma mprodiv (o o1 o2 : Object) (m1 : Morphism o o1) (m2 : Morphism o o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismV (mprodi m1 m2).
    intros ov1 ov2 ov mv1 mv2. constructor; simpl.
     intros s v. repeat split; apply mpresv; assumption.
     intros s s' v v' e. split; apply mprese; assumption.
  Qed.
  Lemma mprode1v (o1 o2 : Object) : ObjectV o1 -> ObjectV o2 -> MorphismV (mprode1 o1 o2).
    intros ov1 ov2. constructor; simpl.
     intros [ s1 s2 ]; simpl. intros [ v1 v2 ]. assumption.
     intros [ s1 s2 ] [ s1' s2' ]; simpl. intros [ v1 v2 ] [ v1' v2' ] [ e1 e2 ]. assumption.
  Qed.
  Lemma mprode2v (o1 o2 : Object) : ObjectV o1 -> ObjectV o2 -> MorphismV (mprode2 o1 o2).
    intros ov1 ov2. constructor; simpl.
     intros [ s1 s2 ]; simpl. intros [ v1 v2 ]. assumption.
     intros [ s1 s2 ] [ s1' s2' ]; simpl. intros [ v1 v2 ] [ v1' v2' ] [ e1 e2 ]. assumption.
  Qed.

  Lemma mprodie (o o1 o2 : Object) (m : Morphism o (oprod o1 o2)) (m1 : Morphism o o1) (m2 : Morphism o o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismV m1 -> MorphismV m2 -> MorphismE m1 (mcomp m (mprode1 o1 o2)) -> MorphismE m2 (mcomp m (mprode2 o1 o2)) -> MorphismE m (mprodi m1 m2).
    intros ov ov1 ov2 mv mv1 mv2 me1 me2. intros s s' sv sv' se. split; simpl.
     apply ssym; try ((apply mprode1v; try apply mv) || apply mv1); try assumption. apply me1; try assumption. apply ssym; assumption.
     apply ssym; try ((apply mprode2v; try apply mv) || apply mv2); try assumption. apply me2; try assumption. apply ssym; assumption.
  Qed.
  Lemma mprode1e (o o1 o2 : Object) (m1 : Morphism o o1) (m2 : Morphism o o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismE m1 (mcomp (mprodi m1 m2) (mprode1 o1 o2)).
    intros ov ov1 ov2 mv1 mv2. intros s s' sv sv' se. apply mv1; assumption.
  Qed.
  Lemma mprode2e (o o1 o2 : Object) (m1 : Morphism o o1) (m2 : Morphism o o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismE m2 (mcomp (mprodi m1 m2) (mprode2 o1 o2)).
    intros ov ov1 ov2 mv1 mv2. intros s s' sv sv' se. apply mv2; assumption.
  Qed.

  Definition oexp (o1 o2 : Object) : Object
  :=
  {| set := set o1 -> set o2
   ; setv := fun sf => (forall s1 : set o1, setv o1 s1 -> setv o2 (sf s1))
                    /\ (forall s1 s1' : set o1, setv o1 s1 -> setv o1 s1' -> sete o1 s1 s1' -> sete o2 (sf s1) (sf s1'))
   ; sete := fun sf sf' => forall s1 s1' : set o1, setv o1 s1 -> setv o1 s1' -> sete o1 s1 s1' -> sete o2 (sf s1) (sf' s1')
   |}.
  Lemma oexpv (o1 o2 : Object) : ObjectV o1 -> ObjectV o2 -> ObjectV (oexp o1 o2).
    intros ov1 ov2. constructor.
     pose proof (sinh o2 ov2) as [ s2 sv2 ]. exists (fun _ => s2). split.
      intros _ _. assumption.
      intros _ _ _ _ _. apply srefl; assumption.
     intros sf sfv. destruct sfv. assumption.
     intros sf sf' sfv sfv' sfe. intros s1 s1' sv1 sv1' se1. apply ssym; try (apply sfv || apply sfv'); try assumption. apply sfe; try assumption. apply ssym; assumption.
     intros sf sf' sf'' sfv sfv' sfv'' sfe sfe'. intros s1 s1' sv1 sv1' se1. apply strans with (sf' s1); try (apply sfv || apply sfv' || apply sfv''); try assumption.
      apply sfe; try assumption. apply srefl; assumption.
      apply sfe'; assumption.
  Qed.

  Definition mexpi {o o1 o2 : Object} (m : Morphism (oprod o o1) o2) : Morphism o (oexp o1 o2)
  := fun s => fun s1 => m (pair s s1).
  Lemma mexpiv (o o1 o2 : Object) (m : Morphism (oprod o o1) o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismV (mexpi m).
    intros ov ov1 ov2 mv. constructor.
     intros s sv. split.
      intros s1 sv1. apply mv. split; assumption.
      intros s1 s1' sv1 sv1' se1. apply mv; split; try assumption. apply srefl; assumption.
     intros s s' sv sv' se. intros s1 s1' sv1 sv1' se1. apply mv; split; assumption.
  Qed.

  Definition mexpe (o1 o2 : Object) : Morphism (oprod (oexp o1 o2) o1) o2
  := fun s => (fst s) (snd s).
  Lemma mexpev (o1 o2 : Object) : ObjectV o1 -> ObjectV o2 -> MorphismV (mexpe o1 o2).
    intros ov1 ov2. constructor.
     intros [ sf s1 ] [ sfv sv1 ]. apply sfv; assumption.
     intros [ sf s1 ] [ sf' s1' ] [ sfv sv1 ] [ sfv' sv1' ] [ sfe se1 ]. apply sfe; assumption.
  Qed.

  Lemma mexpie (o o1 o2 : Object) (m : Morphism o (oexp o1 o2)) (m' : Morphism (oprod o o1) o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismV m' -> MorphismE m' (mcomp (mprodi (mcomp (mprode1 o o1) m) (mprode2 o o1)) (mexpe o1 o2)) -> MorphismE m (mexpi m').
    intros ov ov1 ov2 mv mv' me. intros s s' sv sv' se. intros s1 s1' sv1 sv1' se1. unfold mcomp in me. unfold mexpe in me. unfold mprodi in me. unfold mprode1 in me. unfold mprode2 in me. simpl in me. unfold mexpi. apply strans with (m' (pair s s1)); try (apply mv' || apply mv); try apply conj; try assumption. apply ssym; try (apply mv || apply mv'); try apply conj; try assumption. change (m s s1) with (m (fst (pair s s1)) (snd (pair s s1))). apply me; split; try apply srefl; assumption.
  Qed.
  Lemma mexpee (o o1 o2 : Object) (m : Morphism (oprod o o1) o2) : ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m (mcomp (mprodi (mcomp (mprode1 o o1) (mexpi m)) (mprode2 o o1)) (mexpe o1 o2)).
    intros ov ov1 ov2 mv. intros [ s s1 ] [ s' s1' ] [ sv sv1 ] [ sv' sv1' ] [ se se1 ]. apply mv; split; assumption.
  Qed.
(* end hide *)

End InhabitedSets.


Module InhabitedSetsNat <: NaturalNumberObject InhabitedSets.
  Import InhabitedSets.

(** We omit the contents of this module as they simply demonstrate that inhabited sets have the obvious natural-number object. *)
(* begin hide *)
  Definition onat : Object
  :=
  {| set := nat
   ; setv := fun _ => True
   ; sete := @eq nat
   |}.
  Lemma onatv : ObjectV onat.
    constructor; simpl; auto. intros s1 s2 s3 _ _ _ e12 e23. transitivity s2; assumption.
  Qed.
  Definition mnatiz : Morphism ounit onat
  := fun _ => O.
  Definition mnatis : Morphism onat onat
  := S.
  Lemma mnatizv : MorphismV mnatiz.
    constructor; simpl; trivial.
  Qed.
  Lemma mnatisv : MorphismV mnatis.
    constructor; simpl; try trivial. intros s1 s1' _ _ e. destruct e. reflexivity.
  Qed.

  Definition mnate {o : Object} (mz : Morphism ounit o) (ms : Morphism o o) : Morphism onat o
  := fix mnate (n : nat) : set o
  := match n with
     | 0 => mz tt
     | S n => ms (mnate n)
     end.
  Lemma mnatev (o : Object) (mz : Morphism ounit o) (ms : Morphism o o) : ObjectV o -> MorphismV mz -> MorphismV ms -> MorphismV (mnate mz ms).
    intros ov mzv msv. constructor.
     intros n _. induction n.
      apply mzv. constructor.
      simpl. apply msv. assumption.
     intros n n' _ _ e. destruct e. apply srefl; try assumption. induction n.
      apply mzv. constructor.
      simpl. apply msv. assumption.
  Qed.

  Lemma mnatze (o : Object) (mz : Morphism ounit o) (ms : Morphism o o) : ObjectV o -> MorphismV mz -> MorphismV ms -> MorphismE mz (mcomp mnatiz (mnate mz ms)).
    intros ov mzv msv. intros [] [] _ _ _. unfold mcomp. simpl. apply srefl; try assumption. apply mzv. constructor.
  Qed.
  Lemma mnatse (o : Object) (mz : Morphism ounit o) (ms : Morphism o o) : ObjectV o -> MorphismV mz -> MorphismV ms -> MorphismE (mcomp (mnate mz ms) ms) (mcomp mnatis (mnate mz ms)).
    intros ov mzv msv. intros n n' _ _ e. destruct e. unfold mcomp. simpl. apply msv; try apply srefl; try apply mnatev; try assumption; constructor.
  Qed.
  Lemma mnatee (o : Object) (m : Morphism onat o) (mz : Morphism ounit o) (ms : Morphism o o) : ObjectV o -> MorphismV m -> MorphismV mz -> MorphismV ms -> MorphismE mz (mcomp mnatiz m) -> MorphismE (mcomp m ms) (mcomp mnatis m) -> MorphismE m (mnate mz ms).
    intros ov mv mzv msv mez mes. intros n n' _ _ e. destruct e. apply ssym; try (apply mv || apply mnatev); try assumption; try constructor. induction n; simpl.
     change (m 0) with (m ((fun _ => 0) tt)). apply mez; constructor.
     apply strans with (ms (m n)); try apply msv; try (apply mnatev || apply mv); try assumption; try constructor. apply mes; constructor.
  Qed.
(* end hide *)

End InhabitedSetsNat.
