Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import SCAs.
(** printing State $\Sigma$ *)
(** printing StateV $\isa{\Sigma}$ *)
(** printing Fut $\leq$ *)
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import HOFs.
(** printing PROP $\Phi$ *)
(** printing PROPV $\isa{\Phi}$ *)
(** printing Entails $\vdash$ *)
(** printing subst $\dot{\phi}[\cdot]$ *)
(** printing top $\top$ *)
(** printing conj $\conj$ *)
(** printing bot $\bot$ *)
(** printing disj $\disj$ *)
(** printing imp $\imp$ *)
(** printing sforall $\forall$ *)
(** printing sexists $\exists$ *)
(** printing seq $=$ *)
(** printing oprop $\Omega$ *)
(** printing character $\chi$ *)
(** printing holds $\mathit{holds}$ *)
(** printing isnat $\isnat$ *)
Require Import Sets.
(** printing set $\mathit{set}$ *)
(** printing setv $\isa{\coqdocvar{set}}$ *)
(** printing sete $\iseq{\coqdocvar{set}}$ *)
(**)
(** printing cnat $c^\lambda_\cdot$ *)
(**)
(** printing PROPV' $\isa{\Phi}$ *)
(** printing PROPI $\subseteq_\Phi$ *)
(** printing p $\hat{\phi}$ *)
(** printing p1 $\hat{\phi}_1$ *)
(** printing p2 $\hat{\phi}_2$ *)
(** printing p3 $\hat{\phi}_3$ *)
(** printing p1' $\hat{\phi}_1'$ *)
(** printing p2' $\hat{\phi}_2'$ *)
(** printing p12 $\hat{\phi}_{12}$ *)
(** printing p1'2 $\hat{\phi}_{12}'$ *)
(** printing p122 $\hat{\phi}_{122}$ *)
(** printing o1 $o_1$ *)
(** printing o2 $o_2$ *)
(** printing o3 $o_3$ *)
(** printing o1' $o_1'$ *)
(** printing m1 $m_1$ *)
(** printing m2 $m_2$ *)
(** printing m12 $m_{12}$ *)
(** printing m23 $m_{23}$ *)


(** *** Proof that a Stateful Combinatory Algebra forms a Higher-Order Fibration *)
(** %\label{coq:sca-hol}%This module demonstrates that every stateful combinatory algebra forms a consistent higher-order fibration over the inhabited sets, as claimed in Theorem %\ref{thm:sca-hol}%.
    It is the formal statement of Figure %\ref{fig:sca-hol}%.
    We only show the definitions of the constructions and omit the lemmas required by [NatHigherOrderFibration], the proofs of which are straightforward from the definitions (and the realizers of entailment for which are the same as for RCAs). *)

Module SCAtoHOF (SCA : StatefulCombinatoryAlgebra) <: NatHigherOrderFibration InhabitedSets InhabitedSetsNat.
(* begin hide *)
  Import InhabitedSets.
  Import InhabitedSetsNat.
  Import SCA.
  Import StatefulApplicativeExpression.
  Module SCAT := StatefulCombinatoryAlgebraTools SCA.
  Import SCAT.
  Module CCCT := CartesianClosedCategoryTools InhabitedSets.
  Import CCCT.
(* end hide *)

  Definition PROP (o : Object) : Type := set o -> State -> Code -> Prop.
  Record PROPV' {o : Object} (p : PROP o) : Prop
  :=
   { propv : forall x : set o, forall s s' : State, forall c : Code, setv o x -> StateV s -> StateV s' -> Fut s s' -> CodeV s c -> p x s c -> p x s' c
   ; prope : forall x x' : set o, forall s : State, forall c : Code, setv o x -> setv o x' -> sete o x x' -> StateV s -> CodeV s c -> p x s c -> p x' s c
   }.
(* begin hide *)
  Definition PROPV := @PROPV'.
  Arguments PROPV { o }.
  Local Hint Extern 1 ( PROPV' _ ) => fold @PROPV.
(* end hide *)

  Definition Entails {o : Object} (p1 p2 : PROP o) : Prop := exists2 c : Code, forall s : State, StateV s -> CodeV s c & forall x : set o, forall s : State, forall c1 : Code, setv o x -> StateV s -> CodeV s c1 -> p1 x s c1 -> TermRed Red Term s c c1 (p2 x).

  Definition PROPI {o : Object} (p1 p2 : PROP o) : Prop := forall x : set o, forall s : State, forall c : Code, setv o x -> StateV s -> CodeV s c -> p1 x s c -> p2 x s c.
  Hint Unfold PROPI.
(* begin hide *)
  Definition caxiom : Code := cencode 0 (evar 1 None).
  Lemma caxiomv : forall s : State, StateV s -> CodeV s caxiom. unfold caxiom. auto. Qed.
  Lemma tr_caxiom (s : State) (ca : Code) (Pr : State -> Code -> Prop) : StateV s -> CodeV s ca -> Pr s ca -> TermRed Red Term s caxiom ca Pr. intros. unfold caxiom. termred. Qed.
  Hint Resolve caxiomv tr_caxiom.
  Local Lemma epropi (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> PROPI p1 p2 -> Entails p1 p2. intros ov pv1 pv2 i12. exists caxiom; auto. Qed.
  Hint Resolve epropi.

  Lemma refl (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> Entails p p. auto. Qed.
  Hint Resolve refl.
  Definition ccut (c1 c2 : Code) : Code := cencode 0 (eapp (ecode c2) (eapp (ecode c1) (evar 1 None))).
  Lemma ccutv (s : State) (c1 c2 : Code) : StateV s -> CodeV s c1 -> CodeV s c2 -> CodeV s (ccut c1 c2). unfold ccut. auto 10. Qed.
  Hint Resolve ccutv.
  Lemma trans (o : Object) (p1 p2 p3 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV p3 -> Entails p1 p2 -> Entails p2 p3 -> Entails p1 p3.
    intros ov pv1 pv2 pv3 [ c12 cv12 p12 ] [ c23 cv23 p23 ]. exists (ccut c12 c23); try auto. intros. unfold ccut. termred. eapply termred_mono; try apply p12; auto.
  Qed.
(* end hide *)

  Definition subst {o1 o2 : Object} (m : Morphism o1 o2) (p2 : PROP o2) : PROP o1 := fun s1 => p2 (m s1).
(* begin hide *)
  Hint Extern 10 => match goal with [ |- context[subst ?m ?p ?s] ] => change (subst m p s) with (p (m s)) end.
  Hint Extern 10 => match goal with [ H : context[subst ?m ?p ?s] |- _ ] => change (subst m p s) with (p (m s)) in H end.
  Lemma substv (o1 o2 : Object) (m : Morphism o1 o2) (p2 : PROP o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p2 -> PROPV (subst m p2). unfold subst. constructor; auto. Qed.
  Hint Resolve substv.
  Lemma substi (o1 o2 : Object) (m : Morphism o1 o2) (p2 p2' : PROP o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p2 -> PROPV p2' -> Entails p2 p2' -> Entails (subst m p2) (subst m p2').
    intros ov1 ov2 mv pv2 pv2' [ c2 cv2 e2 ]. exists c2; auto.
  Qed.
  Lemma subste (o1 o2 : Object) (m1 m2 : Morphism o1 o2) (p2 : PROP o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> PROPV p2 -> MorphismE m1 m2 -> Entails (subst m1 p2) (subst m2 p2) /\ Entails (subst m2 p2) (subst m1 p2). auto 10. Qed.

  Lemma substid (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> Entails p (subst (mid o) p) /\ Entails (subst (mid o) p) p. auto. Qed.
  Lemma substcomp (o1 o2 o3 : Object) (m12 : Morphism o1 o2) (m23 : Morphism o2 o3) (p3 : PROP o3) : ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> MorphismV m12 -> MorphismV m23 -> PROPV p3 -> Entails (subst m12 (subst m23 p3)) (subst (mcomp m12 m23) p3) /\ Entails (subst (mcomp m12 m23) p3) (subst m12 (subst m23 p3)). auto. Qed.
(* end hide *)

  Definition top (o : Object) : PROP o := fun x s c => True.
(* begin hide *)
  Lemma topv (o : Object) : ObjectV o -> PROPV (top o). repeat constructor. Qed.
  Hint Resolve topv.
  Lemma topi (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> Entails p (top o). intros ov pv. apply epropi; try auto. unfold top. auto. Qed.
  Lemma tops (o1 o2 : Object) (m : Morphism o1 o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> Entails (top o1) (subst m (top o2)). intros ov1 ov2 mv. apply epropi; auto. Qed.
(* end hide *)

  Definition c2sel1 : Code := cencode 1 (evar 2 None).
  Definition c2sel2 : Code := cencode 1 (evar 2 (Some None)).
  Definition conj {o : Object} (p1 p2 : PROP o) : PROP o := fun x s c => forall s' : State, StateV s' -> Fut s s' -> TermRed Red Term s' c c2sel1 (p1 x) /\ TermRed Red Term s' c c2sel2 (p2 x).
(* begin hide *)
  Definition cconji (e1 e2 : Code) : Code := cencode 1 (eapp (eapp (evar 2 (Some None)) (eapp (ecode e1) (evar 2 None))) (eapp (ecode e2) (evar 2 None))).
  Definition cconje1 : Code := cencode 0 (eapp (evar 1 None) (ecode c2sel1)).
  Definition cconje2 : Code := cencode 0 (eapp (evar 1 None) (ecode c2sel2)).
  Lemma c2sel1v : forall s : State, StateV s -> CodeV s c2sel1. unfold c2sel1. auto. Qed.
  Lemma c2sel2v : forall s : State, StateV s -> CodeV s c2sel2. unfold c2sel2. auto. Qed.
  Lemma cconjiv (s : State) (c1 c2 : Code) : StateV s -> CodeV s c1 -> CodeV s c2 -> CodeV s (cconji c1 c2). unfold cconji. auto 10. Qed.
  Hint Resolve c2sel1v c2sel2v cconjiv.
  Lemma cconje1v : forall s : State, StateV s -> CodeV s cconje1. unfold cconje1. auto. Qed.
  Lemma cconje2v : forall s : State, StateV s -> CodeV s cconje2. unfold cconje2. auto. Qed.
  Lemma conjv (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV (conj p1 p2).
    intros ov pv1 pv2. unfold conj. constructor; try auto. intros x x' s c xv xv' xx' sv cv pc s' sv' ss'; split; eapply termred_mono; try apply pc; auto.
  Qed.
  Hint Resolve cconje1v cconje2v conjv.
  Lemma conji (o : Object) (p p1 p2 : PROP o) : ObjectV o -> PROPV p -> PROPV p1 -> PROPV p2 -> Entails p p1 -> Entails p p2 -> Entails p (conj p1 p2).
    intros ov pv pv1 pv2 [ c1 cv1 e1 ] [ c2 cv2 e2 ]. exists (cconji c1 c2); try auto. intros x s. intros. unfold cconji. termred; try auto 10. unfold conj. intros s'. intros. split; termred; try auto 10.
     eapply termred_mono; try apply e1; try auto.
      intros s''. intros. unfold c2sel1. termred. eapply termred_mono; try apply e2; try auto.
       intros s'''. intros. termred. apply pv1 with s''; auto.
       apply pv with s; auto.
      apply pv with s; auto.
     eapply termred_mono; try apply e1; try auto.
      intros s''. intros. unfold c2sel2. termred. eapply termred_mono; try apply e2; try auto. apply pv with s; auto.
      apply pv with s; auto.
  Qed.
  Lemma conje1 (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> Entails (conj p1 p2) p1.
    intros ov pv1 pv2. exists cconje1; try auto. intros. unfold cconje1. termred.
  Qed.
  Lemma conje2 (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> Entails (conj p1 p2) p2.
    intros ov pv1 pv2. exists cconje2; try auto. intros. unfold cconje2. termred.
  Qed.
  Lemma conjs (o1 o2 : Object) (m : Morphism o1 o2) (p1 p2 : PROP o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p1 -> PROPV p2 -> Entails (conj (subst m p1) (subst m p2)) (subst m (conj p1 p2)). auto. Qed.
(* end hide *)

  Definition bot (o : Object) : PROP o := fun x s c => False.
(* begin hide *)
  Lemma botv (o : Object) : ObjectV o -> PROPV (bot o). repeat constructor; auto. Qed.
  Hint Resolve botv.
  Lemma bote (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> Entails (bot o) p. intros. apply epropi; try auto. unfold bot. unfold PROPI. intros. exfalso. auto. Qed.
  Lemma bots : forall o1 o2 : Object, forall m : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> Entails (subst m (bot o2)) (bot o1). auto. Qed.
(* end hide *)

  Definition disj {o : Object} (p1 p2 : PROP o) : PROP o := fun x s c => (exists3 c1 : Code, CodeV s c1 & p1 x s c1 & cencode 1 (eapp (evar 2 None) (ecode c1)) = c) \/ (exists3 c2 : Code, CodeV s c2 & p2 x s c2 & cencode 1 (eapp (evar 2 (Some None)) (ecode c2)) = c).
(* begin hide *)
  Definition cdisji1 : Code := cencode 2 (eapp (evar 3 (Some None)) (evar 3 None)).
  Definition cdisji2 : Code := cencode 2 (eapp (evar 3 (Some (Some None))) (evar 3 None)).
  Definition cdisje (e1 e2 : Code) : Code := cencode 0 (eapp (eapp (evar 1 None) (ecode e1)) (ecode e2)).
  Lemma disjv (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV (disj p1 p2).
    intros ov pv1 pv2. constructor.
     intros x s s' c12 xv sv sv' ss' _ [ [ c cv p1c e ] | [ c cv p2c e ] ]; constructor; exists c; try (apply pv1 with s + apply pv2 with s); auto; fail.
     intros x x' s c12 xv xv' xx' sv _ [ [ c cv p1c e ] | [ c cv p2c e ] ]; constructor; exists c; try (apply pv1 with x + apply pv2 with x); auto; fail.
  Qed.
  Lemma cdisji1v : forall s : State, StateV s -> CodeV s cdisji1. unfold cdisji1. auto. Qed.
  Lemma cdisji2v : forall s : State, StateV s -> CodeV s cdisji2. unfold cdisji2. auto. Qed.
  Lemma cdisjev (s : State) (c1 c2 : Code) : StateV s -> CodeV s c1 -> CodeV s c2 -> CodeV s (cdisje c1 c2). unfold cdisje. auto 10. Qed.
  Hint Resolve disjv cdisji1v cdisji2v cdisjev.
  Lemma disji1 (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> Entails p1 (disj p1 p2).
    intros. exists cdisji1; try auto. intros x s c1. intros. unfold cdisji1. termred. left. exists c1; auto.
  Qed.
  Lemma disji2 (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> Entails p2 (disj p1 p2).
    intros. exists cdisji2; try auto. intros x s c2. intros. unfold cdisji2. termred. right. exists c2; auto.
  Qed.
  Lemma disje (o : Object) (p1 p2 p : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV p -> Entails p1 p -> Entails p2 p -> Entails (disj p1 p2) p.
    intros ov pv1 pv2 pv [ c1 cv1 e1 ] [ c2 cv2 e2 ]. exists (cdisje c1 c2); try auto. unfold cdisje. intros x s c12 xv sv _ [ [ c1' cv1' p1c1' e ] | [ c2' cv2' p2c2' e ] ]; destruct e; termred.
  Qed.
  Lemma disjs : forall o1 o2 : Object, forall m : Morphism o1 o2, forall p1 p2 : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p1 -> PROPV p2 -> Entails (subst m (disj p1 p2)) (disj (subst m p1) (subst m p2)). auto. Qed.
(* end hide *)

  Definition imp {o : Object} (p1 p2 : PROP o) : PROP o := fun x s c => forall s' : State, forall c1 : Code, StateV s' -> Fut s s' -> CodeV s' c1 -> p1 x s' c1 -> TermRed Red Term s' c c1 (p2 x).
(* begin hide *)
  Definition ctuple2 : Code := cencode 2 (eapp (eapp (evar 3 (Some (Some None))) (evar 3 None)) (evar 3 (Some None))).
  Definition cimpi (e : Code) : Code := cencode 1 (eapp (ecode e) (eapp (eapp (ecode ctuple2) (evar 2 None)) (evar 2 (Some None)))).
  Definition cimpe : Code := cencode 0 (eapp (eapp (evar 1 None) (ecode c2sel1)) (eapp (evar 1 None) (ecode c2sel2))).
  Lemma impv (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV (imp p1 p2).
    intros ov pv1 pv2. unfold imp. constructor; try auto. intros x x' s c xv xv' xx' sv cv tr; intros. eapply termred_mono; try apply tr; try auto. apply pv1 with x'; auto.
  Qed.
  Lemma ctuple2v : forall s : State, StateV s -> CodeV s ctuple2. unfold ctuple2. auto 10. Qed.
  Hint Resolve impv ctuple2v.
  Lemma cimpiv (s : State) (c : Code) : StateV s -> CodeV s c -> CodeV s (cimpi c). unfold cimpi. auto 10. Qed.
  Lemma cimpev : forall s : State, StateV s -> CodeV s cimpe. unfold cimpe. auto 10. Qed.
  Hint Resolve cimpiv cimpev.
  Lemma impi (o : Object) (p p1 p2 : PROP o) : ObjectV o -> PROPV p -> PROPV p1 -> PROPV p2 -> Entails (conj p p1) p2 -> Entails p (imp p1 p2).
    intros ov pv pv1 pv2 [ ce cev e ]. exists (cimpi ce); try auto. intros. unfold cimpi. termred; try auto 10. unfold imp. intros. termred; try auto 10. unfold ctuple2. termred; try auto 10. apply e; try auto 10. unfold conj. intros. unfold c2sel1. unfold c2sel2. split; termred; try auto 10.
     apply pv with s; auto.
     apply pv1 with s'; auto.
  Qed.
  Lemma impe (o : Object) (p1 p2 : PROP o) : ObjectV o -> PROPV p1 -> PROPV p2 -> Entails (conj (imp p1 p2) p1) p2.
    intros. exists cimpe; try auto. intros x s c xv sv cv pc. unfold cimpe. termred. eapply termred_mono; try apply pc; try auto. intros. eapply termred_mono; try apply pc; auto.
  Qed.
  Lemma imps (o1 o2 : Object) (m : Morphism o1 o2) (p1 p2 : PROP o2) : ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p1 -> PROPV p2 -> Entails (imp (subst m p1) (subst m p2)) (subst m (imp p1 p2)). auto. Qed.
(* end hide *)

  Definition sforall {o1 : Object} (o2 : Object) (p12 : PROP (oprod o1 o2)) : PROP o1 := fun x1 s c => forall x2 : set o2, setv o2 x2 -> p12 (pair x1 x2) s c.
(* begin hide *)
  Hint Resolve sinh.
  Hint Extern 1 => match goal with [ x : set (oprod _ _) |- _ ] => destruct x; simpl in * end.
  Hint Extern 1 ( setv (oprod _ _) (pair _ _) ) => split.
  Hint Extern 1 ( sete (oprod _ _) (pair _ _) (pair _ _) ) => split.
  Ltac destruct_oprod := match goal with [ H : forall x : set (oprod ?o1 ?o2), setv (oprod ?o1 ?o2) x -> _ |- _ ] => specialize (fun x1 x2 xv1 xv2 => H (pair x1 x2) (Logic.conj xv1 xv2)) end.
  Local Hint Extern 5 => destruct_oprod.
  Lemma sforallv (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV (sforall o2 p12).
    intros ov1 ov2 pv12. unfold sforall. constructor.
     intros. apply pv12 with s; auto.
     intros x1 x1' s c12 xv1 xv1' x1x1' sv cv12 p12c12 x2 xv2. apply pv12 with (pair x1 x2); auto.
  Qed.
  Hint Resolve sforallv.
  Lemma sforalli (o1 o2 : Object) (p1 : PROP o1) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> PROPV p1 -> PROPV p12 -> Entails (subst (mprode1 o1 o2) p1) p12 -> Entails p1 (sforall o2 p12).
    intros ov1 ov2 pv1 pv12 [ ce cev e ]. exists ce; try auto. intros. unfold sforall. apply termred_forall; auto.
  Qed.
  Lemma sforalle (o1 o2 : Object) (p1 : PROP o1) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> PROPV p1 -> PROPV p12 -> Entails p1 (sforall o2 p12) -> Entails (subst (mprode1 o1 o2) p1) p12.
    unfold sforall. intros ov1 ov2 pv1 pv12 [ ce cev e ]. exists ce; [ auto | ]. intros. eapply termred_mono; try apply e; try auto. simpl. intros. auto.
  Qed.
  Lemma sforalls (o1 o1' o2 : Object) (m : Morphism o1 o1') (p1'2 : PROP (oprod o1' o2)) : ObjectV o1 -> ObjectV o1' -> ObjectV o2 -> MorphismV m -> PROPV p1'2 -> Entails (sforall o2 (subst (mprodi (mcomp (mprode1 o1 o2) m) (mprode2 o1 o2)) p1'2)) (subst m (sforall o2 p1'2)). auto. Qed.
(* end hide *)

  Definition sexists {o1 : Object} (o2 : Object) (p12 : PROP (oprod o1 o2)) : PROP o1 := fun x1 s c => exists2 x2 : set o2, setv o2 x2 & p12 (pair x1 x2) s c.
(* begin hide *)
  Lemma sexistsv (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV (sexists o2 p12).
    intros ov1 ov2 pv12. unfold sexists. constructor.
     intros x1 s s' c12 xv1 sv sv' ss' cv12 [ x2 xv2 p12c12 ]. exists x2; try assumption. apply pv12 with s; auto.
     intros x1 x1' s c12 xv1 xv1' x1x1' sv cv12 [ x2 xv2 p12c12 ]. exists x2; try assumption. apply pv12 with (pair x1 x2); auto.
  Qed.
  Hint Resolve sexistsv.
  Lemma sexistsi (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) (p1 : PROP o1) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p1 -> Entails p12 (subst (mprode1 o1 o2) p1) -> Entails (sexists o2 p12) p1.
    intros ov1 ov2 pv12 pv1 [ c cv e ]. exists c; try assumption. intros x1 s c12 xv1 sv cv12 [ x2 xv2 p12c12 ]. apply (e (pair x1 x2)); auto.
  Qed.
  Lemma sexistse (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) (p1 : PROP o1) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p1 -> Entails (sexists o2 p12) p1 -> Entails p12 (subst (mprode1 o1 o2) p1).
    intros ov1 ov2 pv12 pv1 [ c cv e ]. exists c; try assumption. intros [ x1 x2 ] s c12. intros. unfold subst. simpl. apply e; try auto. exists x2; auto.
  Qed.
  Lemma sexistss (o1 o1' o2 : Object) (m : Morphism o1 o1') (p1'2 : PROP (oprod o1' o2)) : ObjectV o1 -> ObjectV o1' -> ObjectV o2 -> MorphismV m -> PROPV p1'2 -> Entails (subst m (sexists o2 p1'2)) (sexists o2 (subst (mprodi (mcomp (mprode1 o1 o2) m) (mprode2 o1 o2)) p1'2)). auto 10. Qed.
(* end hide *)

  Definition seq {o1 : Object} (o2 : Object) (p12 : PROP (oprod o1 o2)) : PROP (oprod o1 (oprod o2 o2))
  := fun x122 s c => sete o2 (fst (snd x122)) (snd (snd x122)) /\ p12 (pair (fst x122) (fst (snd x122))) s c.
(* begin hide *)
  Lemma seqv (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV (seq o2 p12).
    intros ov1 ov2 pv12. unfold seq. constructor.
     intros [ x1 [ x2 x2' ] ] s s' c12. simpl. intros. split; try auto. apply pv12 with s; auto.
     intros [ x1 [ x2a x2b ] ] [ x1' [ x2a' x2b' ] ] s c12. simpl. intros. split.
      apply strans with x2a; try auto. apply strans with x2b; auto.
      apply pv12 with (pair x1 x2a); auto.
  Qed.
  Hint Resolve seqv.
  Lemma seqi (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) (p122 : PROP (oprod o1 (oprod o2 o2))) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p122 -> Entails p12 (subst (mprodi (mprode1 o1 o2) (mprodi (mprode2 o1 o2) (mprode2 o1 o2))) p122) -> Entails (seq o2 p12) p122.
    intros ov1 ov2 pv12 pv122 [ ce cev e ]. exists ce; try assumption. intros [ x1 [ x2 x2' ] ] s c12 [ xv1 [ xv2 xv2' ] ] sv cv12 [ x2x2' p12c12 ]. simpl in *. eapply termred_mono; try apply (e (pair x1 x2)); try auto. unfold subst. unfold mprodi. simpl. intros. apply pv122 with (pair x1 (pair x2 x2)); repeat split; auto.
  Qed.
  Lemma seqe (o1 o2 : Object) (p12 : PROP (oprod o1 o2)) (p122 : PROP (oprod o1 (oprod o2 o2))) : ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p122 -> Entails (seq o2 p12) p122 -> Entails p12 (subst (mprodi (mprode1 o1 o2) (mprodi (mprode2 o1 o2) (mprode2 o1 o2))) p122).
    intros ov1 ov2 pv12 pv122 [ ce cev e ]. exists ce; try assumption. intros [ x1 x2 ]. unfold subst. unfold mprodi. simpl. intros. eapply termred_mono; try apply e; repeat split; auto.
  Qed.
  Lemma seqs (o1 o1' o2 : Object) (m : Morphism o1 o1') (p1'2 : PROP (oprod o1' o2)) : ObjectV o1 -> ObjectV o1' -> ObjectV o2 -> MorphismV m -> PROPV p1'2 -> Entails (subst (mprodi (mcomp (mprode1 o1 (oprod o2 o2)) m) (mprode2 o1 (oprod o2 o2))) (seq o2 p1'2)) (seq o2 (subst (mprodi (mcomp (mprode1 o1 o2) m) (mprode2 o1 o2)) p1'2)). auto 10. Qed.
(* end hide *)

  Definition oprop : Object
  := {| set := State -> Code -> Prop
      ; setv := fun p => forall s s' : State, forall c : Code, StateV s -> StateV s' -> Fut s s' -> CodeV s c -> p s c -> p s' c
      ; sete := fun p p' => forall s : State, forall c : Code, StateV s -> CodeV s c -> p s c <-> p' s c |}.
  Definition holds : PROP oprop := fun p => p.
  Definition character {o : Object} (p : PROP o) : Morphism o oprop := p.
(* begin hide *)
  Lemma opropv : ObjectV oprop.
    unfold oprop. constructor; simpl.
     exists (fun _ _ => True). constructor.
     intros. split; trivial.
     intros. split; auto.
     intros p p' p'' pv pv' pv'' pp' p'p''. intros. split; intro.
      apply p'p''; try apply pp'; assumption.
      apply pp'; try apply p'p''; assumption.
  Qed.
  Lemma holdsv : PROPV holds. unfold holds. constructor; auto. Qed.
  Lemma characterv (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> MorphismV (character p).
    intros ov pv. unfold character. constructor; unfold oprop; simpl; try auto. intros x x'. intros. split; intro.
     apply pv with x; auto.
     apply pv with x'; auto.
  Qed.
  Lemma holdsi (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> Entails p (subst (character p) holds). auto. Qed.
  Lemma holdse (o : Object) (p : PROP o) : ObjectV o -> PROPV p -> Entails (subst (character p) holds) p. auto. Qed.
(* end hide *)

  Fixpoint cnat (n : nat) : Code
  := match n with 0 => cencode 1 (evar 2 (Some None)) | S n => cencode 1 (eapp (evar 2 None) (eapp (eapp (ecode (cnat n)) (evar 2 None)) (evar 2 (Some None)))) end.
  Definition isnat : PROP onat := fun n _ => eq (cnat n).
(* begin hide *)
  Definition cnatiz : Code := cencode 0 (ecode (cnat 0)).
  Definition cnatis : Code := cencode 2 (eapp (evar 3 (Some None)) (eapp (eapp (evar 3 None) (evar 3 (Some None))) (evar 3 (Some (Some None))))).
  Definition cnate (cz cs : Code) : Code := cencode 0 (eapp (eapp (ecode (cencode 1 (eapp (eapp (evar 2 None) (ecode cs)) (evar 2 (Some None))))) (evar 1 None)) (eapp (ecode cz) (ecode caxiom))).
  Lemma cnatv (n : nat) : forall s : State, StateV s -> CodeV s (cnat n). intros. induction n; simpl; auto 10. Qed.
  Lemma cnatizv : forall s : State, StateV s -> CodeV s cnatiz. unfold cnatiz. auto. Qed.
  Lemma cnatisv : forall s : State, StateV s -> CodeV s cnatis. unfold cnatis. auto 10. Qed.
  Lemma cnatev (s : State) (cz cs : Code) : StateV s -> CodeV s cz -> CodeV s cs -> CodeV s (cnate cz cs). unfold cnate. auto 10. Qed.
  Lemma isnatv : PROPV isnat. unfold isnat. unfold onat. constructor; simpl; intros; subst; auto. Qed.
  Hint Resolve cnatv cnatizv cnatisv cnatev isnatv.
  Lemma isnatiz : Entails (top ounit) (subst mnatiz isnat). exists cnatiz; try auto. unfold cnatiz. unfold subst. unfold mnatiz. unfold isnat. intros. termred. Qed.
  Lemma isnatis : Entails isnat (subst mnatis isnat). exists cnatis; try auto. unfold cnatis. unfold subst. unfold mnatis. unfold isnat. intros. subst. termred. Qed.
  Lemma isnate (p : PROP onat) : PROPV p -> Entails (top ounit) (subst mnatiz p) -> Entails p (subst mnatis p) -> Entails isnat p.
    intros pv [ cz czv ez ] [ cs csv es ]. specialize (fun s c sv cv => ez tt s c I sv cv I). specialize (fun n s c => es n s c I). exists (cnate cz cs); try auto. intros n s cn _ sv _ e. destruct e. unfold cnate. termred; try auto 10. eapply termred_mono; try apply ez; try auto. intros. termred; try auto 10. induction n; simpl; termred; try auto 10. revert IHn. apply termred_mono; try auto. intros ? ? ? ? ?. apply termred_mono; auto.
  Qed.
(* end hide *)

  Inductive Realizable (p : PROP ounit) : Prop := realizable (s : State) (c : Code) : StateV s -> CodeV s c -> p tt s c -> Realizable p.

  Theorem entails_realizable (p1 p2 : PROP ounit) : PROPV p1 -> PROPV p2 -> Entails p1 p2 -> Realizable p1 -> Realizable p2.
    intros pv1 pv2 [ ce cev e ] [ s c1 sv cv1 p1c1 ]. apply e in p1c1; try (assumption || constructor). apply termred_progress in p1c1; try auto. destruct p1c1 as [ s' sv' ss' [ c2 cv2 p2c2 ] ]. exists s' c2; assumption.
  Qed.

  Theorem consistent : Entails (top ounit) (bot ounit) -> False.
    intro e. cut (Realizable (bot ounit)).
     intro r. destruct r. assumption.
     apply entails_realizable with (top ounit); try auto. destruct sinhabited as [ s sv ]. exists s caxiom; try auto. constructor.
  Qed.

End SCAtoHOF.
