Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
(**)
(** printing State $\Sigma$ *)
(** printing StateV $\isa{\Sigma}$ *)
(** printing Fut $\leq$ *)
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
(**)
(** printing s $\sigma$ *)
(** printing s' $\sigma'$ *)
(** printing s'' $\sigma''$ *)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pr $\phi_r$ *)
(** printing Pr' $\phi_r'$ *)
(** printing Pi $\phi_\cdot$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)


(** *** Definition of a Stateful Applicative Structure *)
(** This is the formal statement of %Definition~\ref{sas}%.
    %\label{coq:sca-valid}%One difference, though, is that in this definition we allow code-validity to depend on the current state so long as code-validity is future-stable.
    Although our proofs do not rely on this additional degree of flexibility, it can be convenient for keeping the model clean, say by guaranteeing that any references a valid code has to the state necessarily refer to allocated locations.*)

Module Type StatefulApplicativeStructure.

  Parameter State : SET.
  Parameter StateV : State -> Prop.
  Parameter sinhabited : exists s : State, StateV s.

  Parameter Fut : State -> State -> Prop.
  Parameter frefl : forall s : State, StateV s -> Fut s s.
  Parameter ftrans : forall s s' s'' : State, StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s''.

  Parameter Code : SET.

  Parameter CodeV : State -> Code -> Prop.
  Parameter codev_fut : forall s s' : State, forall c : Code, StateV s -> StateV s' -> Fut s s' -> CodeV s c -> CodeV s' c.

  Parameter Red : State -> Code -> Code -> State -> Code -> Prop.
  Parameter Term : State -> Code -> Code -> Prop.

  Parameter preservation : forall s : State, forall cf ca : Code, forall s' : State, forall cr : Code, StateV s -> CodeV s cf -> CodeV s ca -> Red s cf ca s' cr -> StateV s' /\ Fut s s' /\ CodeV s' cr.
  Parameter progress : forall s : State, forall cf ca : Code, StateV s -> CodeV s cf -> CodeV s ca -> Term s cf ca -> exists s' : State, exists cr : Code, Red s cf ca s' cr.

End StatefulApplicativeStructure.


(** *** Definition of Stateful Reduction and Termination of Applicative Expressions *)

Module StatefulApplicativeExpression.
  Export ApplicativeExpression.

  Inductive RedExpr {State Code : SET} (Red : State -> Code -> Code -> State -> Code -> Prop) : State -> Expr Code -> State -> Code -> Prop
  := revar (s : State) (c : Code) : RedExpr Red s (evar 0 c) s c
   | reapp (s : State) (ef ea : Expr Code) (s' : State) (cf : Code) (s'' : State) (ca : Code) (s''' : State) (cr : Code) : RedExpr Red s ef s' cf -> RedExpr Red s' ea s'' ca -> Red s'' cf ca s''' cr -> RedExpr Red s (eapp ef ea) s''' cr.
  Inductive TermExpr {State Code : SET} (Red : State -> Code -> Code -> State -> Code -> Prop) (Term : State -> Code -> Code -> Prop) : State -> Expr Code -> Prop
  := tevar (s : State) (c : Code) : TermExpr Red Term s (evar 0 c)
   | teapp (s : State) (ef ea : Expr Code) : TermExpr Red Term s ef -> (forall s' : State, forall cf : Code, RedExpr Red s ef s' cf -> TermExpr Red Term s' ea /\ (forall s'' : State, forall ca : Code, RedExpr Red s' ea s'' ca -> Term s'' cf ca)) -> TermExpr Red Term s (eapp ef ea).
  Definition TermRed {State Code : SET} (Red : State -> Code -> Code -> State -> Code -> Prop) (Term : State -> Code -> Code -> Prop) (s : State) (cf ca : Code) (Pr : State -> Code -> Prop) : Prop
  := Term s cf ca /\ (forall s' : State, forall cr : Code, Red s cf ca s' cr -> Pr s' cr).

  Lemma termred_forall {State Code I : SET} (Red : State -> Code -> Code -> State -> Code -> Prop) (Term : State -> Code -> Code -> Prop) (IV : I -> Prop) (s : State) (cf ca : Code) (Pr : I -> State -> Code -> Prop) : (exists i : I, IV i) -> (forall i : I, IV i -> TermRed Red Term s cf ca (Pr i)) -> TermRed Red Term s cf ca (fun s' cr => forall i : I, IV i -> Pr i s' cr).
    intros [ i iv ] tr. split.
     apply tr with i. assumption.
     intros. apply tr; assumption.
  Qed.

  Fixpoint TermRedExpr {State Code : SET} (Red : State -> Code -> Code -> State -> Code -> Prop) (Term : State -> Code -> Code -> Prop) (s : State) (e : Expr Code) (Pr : State -> Code -> Prop) : Prop
  := match e with evar _ c => Pr s c | eapp ef ea => TermRedExpr Red Term s ef (fun s' cf => TermRedExpr Red Term s' ea (fun s'' ca => TermRed Red Term s'' cf ca Pr)) end.
  Lemma termredexpr {State Code : SET} (Red : State -> Code -> Code -> State -> Code -> Prop) (Term : State -> Code -> Code -> Prop) (s : State) (e : Expr Code) (Pr : State -> Code -> Prop) : TermRedExpr Red Term s e Pr -> TermExpr Red Term s e /\ (forall s' : State, forall cr : Code, RedExpr Red s e s' cr -> Pr s' cr).
    revert s Pr. induction e; simpl; intros s Pr tre.
     split; try constructor. intros s' cr r. inversion r; clear r; subst. assumption.
     apply IHe1 in tre. destruct tre as [ te1 tre ]. split.
      constructor; try assumption. intros s' c1 re. apply tre in re. apply IHe2 in re. destruct re as [ te tr ]. split; try assumption. intros s'' cr re. apply tr in re. apply re.
      intros s' cr re. inversion re; clear re; subst. rename H1 into rf. rename H3 into ra. rename H6 into rr. apply tre in rf. apply IHe2 in rf. destruct rf as [ _ rf ]. apply rf in ra. auto.
  Qed.

End StatefulApplicativeExpression.


(** *** Definition of a Stateful Combinatory Algebra *)
(** This is the formal statement of %Definition~\ref{sca}%. *)

Module Type StatefulCombinatoryAlgebra.
  Include StatefulApplicativeStructure.
  Import StatefulApplicativeExpression.

  Parameter cencode : forall n : nat, ExprVar Code (S n) -> Code.
  Parameter cencodev : forall n : nat, forall e : ExprVar Code (S n), forall s : State, StateV s -> ExprVarV (CodeV s) e -> CodeV s (cencode n e).
  Parameter red_encode_S : forall s s' : State, forall n : nat, forall e : ExprVar Code (S (S n)), forall ca cr : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Red s (cencode (S n) e) ca s' cr -> s' = s /\ cencode n (esubst ca e) = cr.
  Parameter red_encode_0 : forall s s' : State, forall e : ExprVar Code 1, forall ca cr : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Red s (cencode 0 e) ca s' cr -> RedExpr Red s (esubst ca e) s' cr.
  Parameter term_encode_S : forall s : State, forall n : nat, forall e : ExprVar Code (S (S n)), forall ca : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Term s (cencode (S n) e) ca.
  Parameter term_encode_0 : forall s : State, forall e : ExprVar Code 1, forall ca : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> TermExpr Red Term s (esubst ca e) -> Term s (cencode 0 e) ca.

End StatefulCombinatoryAlgebra.


(* begin hide *)
Module StatefulCombinatoryAlgebraTools (SCA : StatefulCombinatoryAlgebra).
  Import SCA.
  Import StatefulApplicativeExpression.

  Hint Resolve frefl.

  Hint Extern 5 (Fut _ ?s') => match goal with [ _ : Fut ?s s' |- _ ] => apply ftrans with s end.
  Hint Extern 5 (CodeV ?s' _) => match goal with [ _ : Fut ?s s' |- _ ] => apply codev_fut with s end.

  Hint Resolve cencodev.

  Lemma termred_mono (s : State) (cf ca : Code) (Pr Pr' : State -> Code -> Prop) : StateV s -> CodeV s cf -> CodeV s ca -> (forall s' : State, forall cr : Code, StateV s' -> Fut s s' -> CodeV s' cr -> Pr s' cr -> Pr' s' cr) -> TermRed Red Term s cf ca Pr -> TermRed Red Term s cf ca Pr'.
    intros sv cfv cav mono [ t r ]. split; try assumption. intros s' cr r'. pose proof r' as r''. apply preservation in r''; auto.
  Qed.

  Lemma termred_progress (s : State) (cf ca : Code) (Pr : State -> Code -> Prop) : StateV s -> CodeV s cf -> CodeV s ca -> TermRed Red Term s cf ca Pr -> exists3 s' : State, StateV s' & Fut s s' & exists2 cr : Code, CodeV s' cr & Pr s' cr.
    intros sv cfv cav [ t pr ]. apply progress in t; try assumption. destruct t as [ s' [ cr r ] ]. assert (StateV s' /\ Fut s s' /\ CodeV s' cr) as [ sv' [ ss' crv ] ] by (revert r; apply preservation; assumption). apply pr in r. exists s'; try assumption. exists cr; assumption.
  Qed.

  Lemma termred_encode_S : forall s : State, forall n : nat, forall e : ExprVar Code (S (S n)), forall ca : Code, forall Pr : State -> Code -> Prop, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Pr s (cencode n (esubst ca e)) -> TermRed Red Term s (cencode (S n) e) ca Pr.
    intros. split.
     apply term_encode_S; auto.
     intros s' cr r. apply red_encode_S in r; try auto. destruct r. subst. assumption.
  Qed.
  Lemma termred_encode_0 : forall s : State, forall e : ExprVar Code 1, forall ca : Code, forall Pr : State -> Code -> Prop, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> TermRedExpr Red Term s (esubst ca e) Pr -> TermRed Red Term s (cencode 0 e) ca Pr.
    intros s e ca Pr sv ev cav tre. apply termredexpr in tre. destruct tre as [ te re ]. split.
     apply term_encode_0; auto.
     intros s' cr r. apply red_encode_0 in r; auto.
  Qed.

  Ltac termred := repeat (match goal with [ |- TermRed _ _ _ (cencode ?n _) _ _ ] => match n with 0 => apply termred_encode_0 | S _ => apply termred_encode_S end; simpl; try auto end).

End StatefulCombinatoryAlgebraTools.
(* end hide *)
