Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
(**)
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
(**)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pr $\phi_r$ *)
(** printing Pr' $\phi_r'$ *)
(** printing Pi $\phi_\cdot$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)


(** *** Definition of a Relational Applicative Structure *)
(** This is the formal statement of %Definition~\ref{ras}%. *)

Module Type RelationalApplicativeStructure.

  Parameter Code : SET.
  Parameter CodeV : Code -> Prop.

  Parameter Red : Code -> Code -> Code -> Prop.
  Parameter Term : Code -> Code -> Prop.

  Parameter preservation : forall cf ca cr : Code, CodeV cf -> CodeV ca -> Red cf ca cr -> CodeV cr.
  Parameter progress : forall cf ca : Code, CodeV cf -> CodeV ca -> Term cf ca -> exists cr : Code, Red cf ca cr.

End RelationalApplicativeStructure.


(** *** Definition of Relational Reduction and Termination of Applicative Expressions *)

Module RelationalApplicativeExpression.
  Export ApplicativeExpression.

  Inductive RedExpr {Code : SET} (Red : Code -> Code -> Code -> Prop) : Expr Code -> Code -> Prop
  := revar (c : Code) : RedExpr Red (evar 0 c) c
   | reapp (ef ea : Expr Code) (cf ca cr : Code) : RedExpr Red ef cf -> RedExpr Red ea ca -> Red cf ca cr -> RedExpr Red (eapp ef ea) cr.
  Inductive TermExpr {Code : SET} (Red : Code -> Code -> Code -> Prop) (Term : Code -> Code -> Prop) : Expr Code -> Prop
  := tevar (c : Code) : TermExpr Red Term (evar 0 c)
   | teapp (ef ea : Expr Code) : TermExpr Red Term ef -> (forall cf : Code, RedExpr Red ef cf -> TermExpr Red Term ea /\ (forall ca : Code, RedExpr Red ea ca -> Term cf ca)) -> TermExpr Red Term (eapp ef ea).
  Definition TermRed {Code : SET} (Red : Code -> Code -> Code -> Prop) (Term : Code -> Code -> Prop) (cf ca : Code) (Pr : Code -> Prop) : Prop
  := Term cf ca /\ (forall cr : Code, Red cf ca cr -> Pr cr).

  Lemma termred_forall {Code I : SET} (Red : Code -> Code -> Code -> Prop) (Term : Code -> Code -> Prop) (IV : I -> Prop) (cf ca : Code) (Pr : I -> Code -> Prop) : (exists i : I, IV i) -> (forall i : I, IV i -> TermRed Red Term cf ca (Pr i)) -> TermRed Red Term cf ca (fun cr => forall i : I, IV i -> Pr i cr).
    intros [ i iv ] tr. split.
     apply tr with i. assumption.
     intros. apply tr; assumption.
  Qed.

  Fixpoint TermRedExpr {Code : SET} (Red : Code -> Code -> Code -> Prop) (Term : Code -> Code -> Prop) (e : Expr Code) (Pr : Code -> Prop) : Prop
  := match e with evar _ c => Pr c | eapp ef ea => TermRedExpr Red Term ef (fun cf => TermRedExpr Red Term ea (fun ca => TermRed Red Term cf ca Pr)) end.
  Lemma termredexpr {Code : SET} (Red : Code -> Code -> Code -> Prop) (Term : Code -> Code -> Prop) (e : Expr Code) (Pr : Code -> Prop) : TermRedExpr Red Term e Pr -> TermExpr Red Term e /\ (forall cr : Code, RedExpr Red e cr -> Pr cr).
    revert Pr. induction e; simpl; intros Pr tre.
     split; try constructor. intros cr r. inversion r; clear r; subst. assumption.
     apply IHe1 in tre. destruct tre as [ te1 tre ]. split.
      constructor; try assumption. intros c1 re. apply tre in re. apply IHe2 in re. destruct re as [ te tr ]. split; try assumption. intros cr re. apply tr in re. apply re.
      intros cr re. inversion re; clear re; subst. rename H1 into rf. rename H2 into ra. rename H4 into rr. apply tre in rf. apply IHe2 in rf. destruct rf as [ _ rf ]. apply rf in ra. auto.
  Qed.

End RelationalApplicativeExpression.


(** *** Definition of a Relational Combinatory Algebra *)
(** This is the formal statement of %Definition~\ref{rca}%. *)

Module Type RelationalCombinatoryAlgebra.
  Include RelationalApplicativeStructure.
  Import RelationalApplicativeExpression.

  Parameter cencode : forall n : nat, ExprVar Code (S n) -> Code.
  Parameter cencodev : forall n : nat, forall e : ExprVar Code (S n), ExprVarV CodeV e -> CodeV (cencode n e).
  Parameter red_encode_S : forall n : nat, forall e : ExprVar Code (S (S n)), forall ca cr : Code, ExprVarV CodeV e -> CodeV ca -> Red (cencode (S n) e) ca cr -> cencode n (esubst ca e) = cr.
  Parameter red_encode_0 : forall e : ExprVar Code 1, forall ca cr : Code, ExprVarV CodeV e -> CodeV ca -> Red (cencode 0 e) ca cr -> RedExpr Red (esubst ca e) cr.
  Parameter term_encode_S : forall n : nat, forall e : ExprVar Code (S (S n)), forall ca : Code, ExprVarV CodeV e -> CodeV ca -> Term (cencode (S n) e) ca.
  Parameter term_encode_0 : forall e : ExprVar Code 1, forall ca : Code, ExprVarV CodeV e -> CodeV ca -> TermExpr Red Term (esubst ca e) -> Term (cencode 0 e) ca.

End RelationalCombinatoryAlgebra.


(* begin hide *)
Module RelationalCombinatoryAlgebraTools (RCA : RelationalCombinatoryAlgebra).
  Import RCA.
  Import RelationalApplicativeExpression.

  Hint Resolve cencodev.

  Lemma termred_mono (cf ca : Code) (Pr Pr' : Code -> Prop) : CodeV cf -> CodeV ca -> (forall cr : Code, CodeV cr -> Pr cr -> Pr' cr) -> TermRed Red Term cf ca Pr -> TermRed Red Term cf ca Pr'.
    intros cfv cav mono [ t r ]. split; try assumption. intros cr r'. pose proof r' as r''. apply preservation in r''; auto.
  Qed.

  Lemma termred_progress (cf ca : Code) (Pr : Code -> Prop) : CodeV cf -> CodeV ca -> TermRed Red Term cf ca Pr -> exists2 cr : Code, CodeV cr & Pr cr.
    intros cfv cav [ t pr ]. apply progress in t; try assumption. destruct t as [ cr r ]. assert (CodeV cr) as crv by (revert r; apply preservation; assumption). apply pr in r. exists cr; assumption.
  Qed.

  Lemma termred_encode_S : forall n : nat, forall e : ExprVar Code (S (S n)), forall ca : Code, forall Pr : Code -> Prop, ExprVarV CodeV e -> CodeV ca -> Pr (cencode n (esubst ca e)) -> TermRed Red Term (cencode (S n) e) ca Pr.
    intros. split.
     apply term_encode_S; auto.
     intros cr r. apply red_encode_S in r; try auto. destruct r. subst. assumption.
  Qed.
  Lemma termred_encode_0 : forall e : ExprVar Code 1, forall ca : Code, forall Pr : Code -> Prop, ExprVarV CodeV e -> CodeV ca -> TermRedExpr Red Term (esubst ca e) Pr -> TermRed Red Term (cencode 0 e) ca Pr.
    intros e ca Pr ev cav tre. apply termredexpr in tre. destruct tre as [ te re ]. split.
     apply term_encode_0; auto.
     intros cr r. apply red_encode_0 in r; auto.
  Qed.

  Ltac termred := repeat (match goal with [ |- TermRed _ _ (cencode ?n _) _ _ ] => match n with 0 => apply termred_encode_0 | S _ => apply termred_encode_S end; simpl; try auto end).

End RelationalCombinatoryAlgebraTools.
(* end hide *)
