Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import RCAs.
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing RedTerm $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing RedTermExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
(**)
(** printing Lambda $L$ *)
(** printing LambdaV $\isa{L}$ *)
(** printing lsubst $\ell[\cdot] *)
(** printing lcode $(\cdot)$ *)
(** printing lapp $\app$ *)
(** printing Prim $P$ *)
(** printing PrimV $\isa{P}$ *)
(** printing PCode $C_?$ *)
(** printing cprim $(\cdot)$ *)
(** printing clam $\lambda^\cdot$ *)
(** printing PCodeV $\isa{C_?}$ *)
(**)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)
(** printing l $\ell$ *)
(** printing lf $\ell_f$ *)
(** printing la $\ell_a$ *)
(** printing lb $\ell_b$ *)
(** printing pf $p_f$ *)


(** *** Framework for Building Codes with Lambda-Terms and Primitives *)

Module LambdaTerm.

(** Defines $\lambda$-body expressions [Lambda] parameterized by a set of codes [Code], and defines codes [PCode] parameterized by a set of primitives [Prim] such that a code is either a primitive or a $\lambda$-code of a $\lambda$-body expression. *)
(* begin hide *)
  Fixpoint LVar (n : nat) : SET
  := match n with
     | 0 => Empty
     | S n => option (LVar n)
     end.

  Inductive Lambda {Code : SET} {n : nat} : SET
  := lcode (c : Code)
   | lvar (v : LVar n)
   | lapp (lf la : Lambda).
  Arguments Lambda : clear implicits.
  Arguments lvar { Code } _ _.
  Definition LambdaV {Code : SET} (CodeV : Code -> Prop) {n : nat} : Lambda Code n -> Prop
  := fix LambdaV (l : Lambda Code n) : Prop
  := match l with
     | lcode c => CodeV c
     | lvar _ v => True
     | lapp lf la => LambdaV lf /\ LambdaV la
     end.

  Definition lambdav_mono (Code : SET) (CodeV CodeV' : Code -> Prop) (n : nat) (l : Lambda Code n) : (forall c : Code, CodeV c -> CodeV' c) -> LambdaV CodeV l -> LambdaV CodeV' l.
    intros incl. revert l. fix lambdav_mono 1. intros l lv. destruct l; simpl in *.
     apply incl. assumption.
     assumption.
     destruct lv as [ lv1 lv2 ]. split; auto.
  Defined.

  Fixpoint lsubst {Code : SET} (c : Code) {n : nat} (l : Lambda Code (S n)) : Lambda Code n
  := match l with
     | lvar _ v => match v with
                   | None => lcode c
                   | Some v => lvar _ v
                   end
     | lcode c => lcode c
     | lapp lf la => lapp (lsubst c lf) (lsubst c la)
     end.

  Lemma lsubstv (Code : SET) (CodeV : Code -> Prop) (c : Code) (n : nat) (l : Lambda Code (S n)) : CodeV c -> LambdaV CodeV l -> LambdaV CodeV (lsubst c l).
    intros cv lv. induction l; simpl in *.
     assumption.
     destruct v; simpl.
      constructor.
      assumption.
     destruct lv as [ lv1 lv2 ]. split; auto.
  Qed.

  Inductive PCode {Prim : SET} : SET
  := cprim (p : Prim)
   | clam (n : nat) (lb : Lambda PCode (S n)).
  Arguments PCode : clear implicits.
  Fixpoint PCodeV {Prim : SET} (PrimV : Prim -> Prop) (c : PCode Prim) : Prop
  := match c with
     | cprim p => PrimV p
     | clam n l => LambdaV (PCodeV PrimV) l
     end.

  Lemma pcodev_mono (Prim : SET) (PrimV PrimV' : Prim -> Prop) (c : PCode Prim) : (forall p : Prim, PrimV p -> PrimV' p) -> PCodeV PrimV c -> PCodeV PrimV' c.
   intros incl cv. revert c cv. fix codev_fut 1. intros c cv. destruct c; simpl in *.
    apply incl. assumption.
    apply lambdav_mono with (PCodeV PrimV); assumption.
  Qed.

  Import ApplicativeExpression.

  Fixpoint levar {Code : SET} {n : nat} : EVar Code n -> sum (LVar n) Code
  := match n with
     | 0 => inr
     | S n => fun v => match v with
                       | None => inl None
                       | Some v => match levar v with
                                   | inl v => inl (Some v)
                                   | inr c => inr c
                                   end
                       end
     end.

  Fixpoint lexpr {Code : SET} {n : nat} (e : ExprVar Code n) : Lambda Code n
  := match e with
     | evar _ v => match levar v with
                   | inl v => lvar n v
                   | inr c => lcode c
                   end
     | eapp ef ea => lapp (lexpr ef) (lexpr ea)
     end.
  Lemma lexprv (Code : SET) (CodeV : Code -> Prop) (n : nat) (e : ExprVar Code n) : ExprVarV CodeV e -> LambdaV CodeV (lexpr e).
    intro ev. induction ev; simpl; auto. cut (match levar c with inl v => True | inr c => CodeV c end).
     destruct (levar c); trivial.
     induction n; try trivial. destruct c; try constructor. simpl. pose proof (IHn e) as IHn. destruct (levar e); auto.
  Qed.

  Lemma lexpr_esubst (Code : SET) (c : Code) (n : nat) (e : ExprVar Code (S n)) : lsubst c (lexpr e) = lexpr (esubst c e).
    induction e as [ v | ef ea ]; simpl.
     destruct v; simpl.
      destruct (levar e); reflexivity.
      assert (inr c = levar (vcode c n)) as e.
       induction n; simpl; try reflexivity. rewrite <- IHn. reflexivity.
       rewrite <- e. reflexivity.
     f_equal; assumption.
  Qed.
(* end hide *)

End LambdaTerm.
