Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
(**)
(** printing PROP $\Phi$ *)
(** printing PROPV $\isa{\Phi}$ *)
(** printing Entails $\vdash$ *)
(** printing subst $\dot{\phi}[\cdot]$ *)
(** printing top $\top$ *)
(** printing conj $\conj$ *)
(** printing bot $\bot$ *)
(** printing disj $\disj$ *)
(** printing imp $\imp$ *)
(** printing sforall $\forall$ *)
(** printing sexists $\exists$ *)
(** printing seq $=$ *)
(** printing oprop $\Omega$ *)
(** printing character $\chi$ *)
(** printing holds $\mathit{holds}$ *)
(** printing isnat $\isnat$ *)
(**)
(** printing p $\phi$ *)
(** printing p1 $\phi_1$ *)
(** printing p2 $\phi_2$ *)
(** printing p3 $\phi_3$ *)
(** printing p1' $\phi_1'$ *)
(** printing p2' $\phi_2'$ *)
(** printing p12 $\phi_{12}$ *)
(** printing p1'2 $\phi_{12}'$ *)
(** printing p122 $\phi_{122}$ *)
(** printing o1 $o_1$ *)
(** printing o2 $o_2$ *)
(** printing o3 $o_3$ *)
(** printing o1' $o_1'$ *)
(** printing m1 $m_1$ *)
(** printing m2 $m_2$ *)
(** printing m12 $m_{12}$ *)
(** printing m23 $m_{23}$ *)


(** *** Definition of a Higher-Order Fibration *)

Module Type HigherOrderFibration (CCC : CartesianClosedCategory).
  Import CCC.

(** **** Propositions *)

  Parameter PROP : Object -> Type.
  Parameter PROPV : forall {o : Object}, PROP o -> Prop.

(** **** Entailment *)

  Parameter Entails : forall {o : Object}, PROP o -> PROP o -> Prop.

  Parameter refl : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> Entails p p.
  Parameter trans : forall o : Object, forall p1 p2 p3 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV p3 -> Entails p1 p2 -> Entails p2 p3 -> Entails p1 p3.

(** **** Substition *)

  Parameter subst : forall {o1 o2 : Object}, forall m : Morphism o1 o2, PROP o2 -> PROP o1.
  Parameter substv : forall o1 o2 : Object, forall m : Morphism o1 o2, forall p2 : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p2 -> PROPV (subst m p2).
  Parameter substi : forall o1 o2 : Object, forall m : Morphism o1 o2, forall p2 p2' : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p2 -> PROPV p2' -> Entails p2 p2' -> Entails (subst m p2) (subst m p2').
  Parameter subste : forall o1 o2 : Object, forall m1 m2 : Morphism o1 o2, forall p2 : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> PROPV p2 -> MorphismE m1 m2 -> Entails (subst m1 p2) (subst m2 p2) /\ Entails (subst m2 p2) (subst m1 p2).

  Parameter substid : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> Entails p (subst (mid o) p) /\ Entails (subst (mid o) p) p.
  Parameter substcomp : forall o1 o2 o3 : Object, forall m12 : Morphism o1 o2, forall m23 : Morphism o2 o3, forall p3 : PROP o3, ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> MorphismV m12 -> MorphismV m23 -> PROPV p3 -> Entails (subst m12 (subst m23 p3)) (subst (mcomp m12 m23) p3) /\ Entails (subst (mcomp m12 m23) p3) (subst m12 (subst m23 p3)).

(** **** True *)

  Parameter top : forall o : Object, PROP o.
  Parameter topv : forall o : Object, ObjectV o -> PROPV (top o).
  Parameter topi : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> Entails p (top o).
  Parameter tops : forall o1 o2 : Object, forall m : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> Entails (top o1) (subst m (top o2)).

(** **** Conjunction *)

  Parameter conj : forall {o : Object}, PROP o -> PROP o -> PROP o.
  Parameter conjv : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV (conj p1 p2).
  Parameter conji : forall o : Object, forall p p1 p2 : PROP o, ObjectV o -> PROPV p -> PROPV p1 -> PROPV p2 -> Entails p p1 -> Entails p p2 -> Entails p (conj p1 p2).
  Parameter conje1 : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> Entails (conj p1 p2) p1.
  Parameter conje2 : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> Entails (conj p1 p2) p2.
  Parameter conjs : forall o1 o2 : Object, forall m : Morphism o1 o2, forall p1 p2 : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p1 -> PROPV p2 -> Entails (conj (subst m p1) (subst m p2)) (subst m (conj p1 p2)).

(** **** False *)

  Parameter bot : forall o : Object, PROP o.
  Parameter botv : forall o : Object, ObjectV o -> PROPV (bot o).
  Parameter bote : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> Entails (bot o) p.
  Parameter bots : forall o1 o2 : Object, forall m : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> Entails (subst m (bot o2)) (bot o1).

(** **** Disjunction *)

  Parameter disj : forall {o : Object}, PROP o -> PROP o -> PROP o.
  Parameter disjv : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV (disj p1 p2).
  Parameter disji1 : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> Entails p1 (disj p1 p2).
  Parameter disji2 : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> Entails p2 (disj p1 p2).
  Parameter disje : forall o : Object, forall p1 p2 p : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV p -> Entails p1 p -> Entails p2 p -> Entails (disj p1 p2) p.
  Parameter disjs : forall o1 o2 : Object, forall m : Morphism o1 o2, forall p1 p2 : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p1 -> PROPV p2 -> Entails (subst m (disj p1 p2)) (disj (subst m p1) (subst m p2)).

(** **** Implication *)

  Parameter imp : forall {o : Object}, PROP o -> PROP o -> PROP o.
  Parameter impv : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> PROPV (imp p1 p2).
  Parameter impi : forall o : Object, forall p p1 p2 : PROP o, ObjectV o -> PROPV p -> PROPV p1 -> PROPV p2 -> Entails (conj p p1) p2 -> Entails p (imp p1 p2).
  Parameter impe : forall o : Object, forall p1 p2 : PROP o, ObjectV o -> PROPV p1 -> PROPV p2 -> Entails (conj (imp p1 p2) p1) p2.
  Parameter imps : forall o1 o2 : Object, forall m : Morphism o1 o2, forall p1 p2 : PROP o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> PROPV p1 -> PROPV p2 -> Entails (imp (subst m p1) (subst m p2)) (subst m (imp p1 p2)).

(** **** Universal Quantification *)

  Parameter sforall : forall {o1 : Object}, forall o2 : Object, PROP (oprod o1 o2) -> PROP o1.
  Parameter sforallv : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV (sforall o2 p12).
  Parameter sforalli : forall o1 o2 : Object, forall p1 : PROP o1, forall p12 : PROP (oprod o1 o2), ObjectV o1 -> ObjectV o2 -> PROPV p1 -> PROPV p12 -> Entails (subst (mprode1 o1 o2) p1) p12 -> Entails p1 (sforall o2 p12).
  Parameter sforalle : forall o1 o2 : Object, forall p1 : PROP o1, forall p12 : PROP (oprod o1 o2), ObjectV o1 -> ObjectV o2 -> PROPV p1 -> PROPV p12 -> Entails p1 (sforall o2 p12) -> Entails (subst (mprode1 o1 o2) p1) p12.
  Parameter sforalls : forall o1 o1' o2 : Object, forall m : Morphism o1 o1', forall p1'2 : PROP (oprod o1' o2), ObjectV o1 -> ObjectV o1' -> ObjectV o2 -> MorphismV m -> PROPV p1'2 -> Entails (sforall o2 (subst (mprodi (mcomp (mprode1 o1 o2) m) (mprode2 o1 o2)) p1'2)) (subst m (sforall o2 p1'2)).

(** **** Existential Quantification *)

  Parameter sexists : forall {o1 : Object}, forall o2 : Object, PROP (oprod o1 o2) -> PROP o1.
  Parameter sexistsv : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV (sexists o2 p12).
  Parameter sexistsi : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), forall p1 : PROP o1, ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p1 -> Entails p12 (subst (mprode1 o1 o2) p1) -> Entails (sexists o2 p12) p1.
  Parameter sexistse : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), forall p1 : PROP o1, ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p1 -> Entails (sexists o2 p12) p1 -> Entails p12 (subst (mprode1 o1 o2) p1).
  Parameter sexistss : forall o1 o1' o2 : Object, forall m : Morphism o1 o1', forall p1'2 : PROP (oprod o1' o2), ObjectV o1 -> ObjectV o1' -> ObjectV o2 -> MorphismV m -> PROPV p1'2 -> Entails (subst m (sexists o2 p1'2)) (sexists o2 (subst (mprodi (mcomp (mprode1 o1 o2) m) (mprode2 o1 o2)) p1'2)).

(** **** Equality *)

  Parameter seq : forall {o1 : Object}, forall o2 : Object, PROP (oprod o1 o2) -> PROP (oprod o1 (oprod o2 o2)).
  Parameter seqv : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV (seq o2 p12).
  Parameter seqi : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), forall p122 : PROP (oprod o1 (oprod o2 o2)), ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p122 -> Entails p12 (subst (mprodi (mprode1 o1 o2) (mprodi (mprode2 o1 o2) (mprode2 o1 o2))) p122) -> Entails (seq o2 p12) p122.
  Parameter seqe : forall o1 o2 : Object, forall p12 : PROP (oprod o1 o2), forall p122 : PROP (oprod o1 (oprod o2 o2)), ObjectV o1 -> ObjectV o2 -> PROPV p12 -> PROPV p122 -> Entails (seq o2 p12) p122 -> Entails p12 (subst (mprodi (mprode1 o1 o2) (mprodi (mprode2 o1 o2) (mprode2 o1 o2))) p122).
  Parameter seqs : forall o1 o1' o2 : Object, forall m : Morphism o1 o1', forall p1'2 : PROP (oprod o1' o2), ObjectV o1 -> ObjectV o1' -> ObjectV o2 -> MorphismV m -> PROPV p1'2 -> Entails (subst (mprodi (mcomp (mprode1 o1 (oprod o2 o2)) m) (mprode2 o1 (oprod o2 o2))) (seq o2 p1'2)) (seq o2 (subst (mprodi (mcomp (mprode1 o1 o2) m) (mprode2 o1 o2)) p1'2)).

(** **** Impredicativity *)

  Parameter oprop : Object.
  Parameter holds : PROP oprop.
  Parameter character : forall {o : Object}, PROP o -> Morphism o oprop.
  Parameter opropv : ObjectV oprop.
  Parameter holdsv : PROPV holds.
  Parameter characterv : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> MorphismV (character p).
  Parameter holdsi : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> Entails p (subst (character p) holds).
  Parameter holdse : forall o : Object, forall p : PROP o, ObjectV o -> PROPV p -> Entails (subst (character p) holds) p.

End HigherOrderFibration.


(* begin hide *)
Module HigherOrderFibrationTools (CCC : CartesianClosedCategory) (HOF : HigherOrderFibration CCC).
  Import CCC.
  Import HOF.

  Hint Resolve substv topv conjv botv disjv impv sforallv sexistsv seqv opropv holdsv characterv.

End HigherOrderFibrationTools.
(* end hide *)


(** When a higher-order fibration is defined over a category with a natural-number object [onat], it automatically has an [isnat] predicate over [onat].
    However, the automatic construction of [isnat] tends to be complicated, so here we allow one to specify an optimized, necessarily equivalent, construction. *)

Module Type NatHigherOrderFibration (CCC : CartesianClosedCategory) (NNO : NaturalNumberObject CCC).
  Import CCC.
  Import NNO.
  Include HigherOrderFibration CCC.

  Parameter isnat : PROP onat.
  Parameter isnatv : PROPV isnat.
  Parameter isnatiz : Entails (top ounit) (subst mnatiz isnat).
  Parameter isnatis : Entails isnat (subst mnatis isnat).
  Parameter isnate : forall p : PROP onat, PROPV p -> Entails (top ounit) (subst mnatiz p) -> Entails p (subst mnatis p) -> Entails isnat p.

End NatHigherOrderFibration.


(* begin hide *)
Module NatHigherOrderFibrationTools (CCC : CartesianClosedCategory) (NNO : NaturalNumberObject CCC) (HOF : NatHigherOrderFibration CCC NNO).
  Import HOF.
  Module HOFT := HigherOrderFibrationTools CCC HOF.
  Include HOFT.

  Hint Resolve isnatv.

End NatHigherOrderFibrationTools.
(* end hide *)
