Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import SCAs.
(** printing State $\Sigma$ *)
(** printing StateV $\isa{\Sigma}$ *)
(** printing Fut $\leq$ *)
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import Lambdas.
(** printing Lambda $L$ *)
(** printing LambdaV $\isa{L}$ *)
(** printing lsubst $\ell[\cdot] *)
(** printing lcode $(\cdot)$ *)
(** printing lapp $\app$ *)
(** printing Prim $P$ *)
(** printing PrimV $\isa{P}$ *)
(** printing PCode $C_?$ *)
(** printing cprim $(\cdot)$ *)
(** printing clam $\lambda^\cdot$ *)
(** printing PCodeV $\isa{C_?}$ *)
(**)
(** printing RedLambda $\downarrow_c^\lambda$ *)
(** printing RedCode $\downarrow_c^{C_?}$ *)
(** printing RedPrim $\downarrow_c^p$ *)
(** printing TermLambda $\downarrow^\lambda$ *)
(** printing TermCode $\downarrow^{C_?}$ *)
(** printing TermPrim $\downarrow^p$ *)
(**)
(** printing PrimV' $\isa{P}'$ *)
(** printing s $\sigma$ *)
(** printing s' $\sigma'$ *)
(** printing s'' $\sigma''$ *)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pr $\phi_r$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)
(** printing l $\ell$ *)
(** printing lf $\ell_f$ *)
(** printing la $\ell_a$ *)
(** printing pf $p_f$ *)


(** *** Framework for Building Stateful Combinatory Algebras with Lambda-Terms and Primitives *)
(** We elide the construction as it is just tedious and made complex by the fact that there is no direct way to define mutually dependent inductive types or propositions across modules.
    We only show the module type for specifying the set of primitives and their termination and reduction behavior. *)

Module FreeStatefulCombinatoryCode.
  Export LambdaTerm.

(** Defines stateful application [RedLambda] and termination [TermLambda] for $\lambda$-body expressions, and application [RedCode] and termination [TermCode] for codes, each parameterized by application and termination rules for the appropriate unknown sets of codes/primitives and states. *)
(* begin hide *)
  Inductive RedLambda {State Code : SET} (RedCode : State -> Code -> Code -> State -> Code -> Prop) (s : State) : Lambda Code 0 -> State -> Code -> Prop
  := rlcode (c : Code) : RedLambda RedCode s (lcode c) s c
   | rlapp (lf la : Lambda Code 0) (s' : State) (cf : Code) (s'' : State) (ca : Code) (s''' : State) (cr : Code) : RedLambda RedCode s lf s' cf -> RedLambda RedCode s' la s'' ca -> RedCode s'' cf ca s''' cr -> RedLambda RedCode s (lapp lf la) s''' cr.

  Inductive RedCode {State Prim : SET} (RedPrim : State -> Prim -> PCode Prim -> State -> PCode Prim -> Prop) : State -> PCode Prim -> PCode Prim -> State -> PCode Prim -> Prop
  := rcprim (s : State) (pf : Prim) (ca : PCode Prim) (s' : State) (cr : PCode Prim) : RedPrim s pf ca s' cr -> RedCode RedPrim s (cprim pf) ca s' cr
   | rclam0 (s : State) (lb : Lambda (PCode Prim) 1) (ca : PCode Prim) (s' : State) (cr : PCode Prim) : RedLambda (RedCode RedPrim) s (lsubst ca lb) s' cr -> RedCode RedPrim s (clam 0 lb) ca s' cr
   | rclamS (s : State) (n : nat) (lb : Lambda (PCode Prim) (S (S n))) (ca : PCode Prim) : RedCode RedPrim s (clam (S n) lb) ca s (clam n (lsubst ca lb)).

  Inductive TermLambda {State Code : SET} (RedCode : State -> Code -> Code -> State -> Code -> Prop) (TermCode : State -> Code -> Code -> Prop) : State -> Lambda Code 0 -> Prop
  := slcode (s : State) (c : Code) : TermLambda RedCode TermCode s (lcode c)
   | slapp (s : State) (lf la : Lambda Code 0) : TermLambda RedCode TermCode s lf -> (forall s' : State, forall cf : Code, RedLambda RedCode s lf s' cf -> TermLambda RedCode TermCode s' la /\ forall s'' : State, forall ca : Code, RedLambda RedCode s' la s'' ca -> TermCode s'' cf ca) -> TermLambda RedCode TermCode s (lapp lf la).

  Inductive TermCode {State Prim : SET} (RedPrim : State -> Prim -> PCode Prim -> State -> PCode Prim -> Prop) (TermPrim : State -> Prim -> PCode Prim -> Prop) : State -> PCode Prim -> PCode Prim -> Prop
  := tcprim (s : State) (pf : Prim) (ca : PCode Prim) : TermPrim s pf ca -> TermCode RedPrim TermPrim s (cprim pf) ca
   | tclam0 (s : State) (lb : Lambda (PCode Prim) 1) (ca : PCode Prim) : TermLambda (RedCode RedPrim) (TermCode RedPrim TermPrim) s (lsubst ca lb) -> TermCode RedPrim TermPrim s (clam 0 lb) ca
   | tclamS (s : State) (n : nat) (lb : Lambda (PCode Prim) (S (S n))) (ca : PCode Prim) : TermCode RedPrim TermPrim s (clam (S n) lb) ca.

  Definition preservation_lambda {State Code : SET} (StateV : State -> Prop) (Fut : State -> State -> Prop) (CodeV : State -> Code -> Prop) (RedCode : State -> Code -> Code -> State -> Code -> Prop) (frefl : forall s : State, StateV s -> Fut s s) (ftrans : forall s s' s'' : State, StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s'') (codev_fut : forall s s' : State, forall c : Code, StateV s -> StateV s' -> Fut s s' -> CodeV s c -> CodeV s' c) (preserve_code : forall s : State, forall cf ca : Code, forall s' : State, forall cr : Code, StateV s -> CodeV s cf -> CodeV s ca -> RedCode s cf ca s' cr -> StateV s' /\ Fut s s' /\ CodeV s' cr) (s : State) (l : Lambda Code 0) (s' : State) (c : Code) : StateV s -> LambdaV (CodeV s) l -> RedLambda RedCode s l s' c -> StateV s' /\ Fut s s' /\ CodeV s' c.
    intros sv lv r. induction r; simpl in lv.
     repeat split; try apply frefl; assumption.
     clear r1 r2. rename IHr1 into IHrf. rename IHr2 into IHra. rename H into rc. destruct lv as [ lfv lav ]. apply IHrf in lfv; try assumption. destruct lfv as [ sv' [ ss' cfv ] ]. apply lambdav_mono with (CodeV' := CodeV s') in lav; try (intro c; apply codev_fut; assumption). apply IHra in lav; try assumption. destruct lav as [ sv'' [ s's'' cav ] ]. apply codev_fut with (s' := s'') in cfv; try assumption. apply preserve_code in rc; try assumption. destruct rc as [ sv''' [ s''s''' crv ] ]. repeat split; try assumption. apply ftrans with s''; try assumption. apply ftrans with s'; assumption.
  Defined.

  Definition preservation_code {State Prim : SET} (StateV : State -> Prop) (Fut : State -> State -> Prop) (PrimV : State -> Prim -> Prop) (RedPrim : State -> Prim -> PCode Prim -> State -> PCode Prim -> Prop) (frefl : forall s : State, StateV s -> Fut s s) (ftrans : forall s s' s'' : State, StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s'') (primv_fut : forall s s' : State, forall p : Prim, StateV s -> StateV s' -> Fut s s' -> PrimV s p -> PrimV s' p) (preserve_prim : forall s : State, forall pf : Prim, forall ca : PCode Prim, forall s' : State, forall cr : PCode Prim, StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> RedPrim s pf ca s' cr -> StateV s' /\ Fut s s' /\ PCodeV (PrimV s') cr) (s : State) (cf ca : PCode Prim) (s' : State) (cr : PCode Prim) : StateV s -> PCodeV (PrimV s) cf -> PCodeV (PrimV s) ca -> RedCode RedPrim s cf ca s' cr -> StateV s' /\ Fut s s' /\ PCodeV (PrimV s') cr.
    revert s cf ca s' cr. fix preserve_code 9. intros s cf ca s' cr sv cfv cav rc. destruct rc.
     rename H into rp. apply preserve_prim in rp; assumption.
     rename H into rl. apply (preservation_lambda StateV Fut (fun s => PCodeV (PrimV s))) in rl; try assumption.
      clear s sv lb cfv ca cav s' cr rl. intros s s' c sv sv' ss'. apply pcodev_mono. intro p. apply primv_fut; assumption.
      apply lsubstv; assumption.
     repeat split; try assumption.
      apply frefl; assumption.
      apply lsubstv; assumption.
  Defined.

  Definition progress_lambda {State Code : SET} (StateV : State -> Prop) (Fut : State -> State -> Prop) (CodeV : State -> Code -> Prop) (RedCode : State -> Code -> Code -> State -> Code -> Prop) (TermCode : State -> Code -> Code -> Prop) (frefl : forall s : State, StateV s -> Fut s s) (ftrans : forall s s' s'' : State, StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s'') (codev_fut : forall s s' : State, forall c : Code, StateV s -> StateV s' -> Fut s s' -> CodeV s c -> CodeV s' c) (preserve_code : forall s : State, forall cf ca : Code, forall s' : State, forall cr : Code, StateV s -> CodeV s cf -> CodeV s ca -> RedCode s cf ca s' cr -> StateV s' /\ Fut s s' /\ CodeV s' cr) (progress_code : forall s : State, forall cf ca : Code, StateV s -> CodeV s cf -> CodeV s ca -> TermCode s cf ca -> exists s' : State, exists cr : Code, RedCode s cf ca s' cr) (s : State) (l : Lambda Code 0) : StateV s -> LambdaV (CodeV s) l -> TermLambda RedCode TermCode s l -> exists s' : State, exists cr : Code, RedLambda RedCode s l s' cr.
    revert s l. fix progress_lambda 5. intros s lr sv lrv t. destruct t as [ s c | s lf la tf t ]; simpl in lrv.
     exists s; try apply frefl; try assumption. exists c; try assumption. constructor.
     destruct lrv as [ lfv lav ]. apply progress_lambda in tf; try assumption. destruct tf as [ s' [ cf rf ] ]. pose proof rf as ta. apply t in ta; try assumption. clear t. destruct ta as [ ta t ]. pose proof rf as rf'. apply (preservation_lambda StateV Fut CodeV) in rf'; try assumption. destruct rf' as [ sv' [ ss' cfv ] ]. apply lambdav_mono with (CodeV' := CodeV s') in lav; try (intro c; apply codev_fut); try assumption. apply progress_lambda in ta; try assumption. destruct ta as [ s'' [ ca ra ] ]. pose proof ra as ra'. apply (preservation_lambda StateV Fut CodeV) in ra'; try assumption. destruct ra' as [ sv'' [ s's'' cav ] ]. pose proof ra as tfa. apply t in tfa; try assumption. clear t. pose proof cfv as cfv'. apply codev_fut with (s' := s'') in cfv'; try assumption. apply progress_code in tfa; try assumption. destruct tfa as [ s''' [ cr r ] ]. exists s'''; try (apply ftrans with s'; try assumption; apply ftrans with s''); try assumption. exists cr; try assumption. apply rlapp with s' cf s'' ca; assumption.
  Defined.

  Definition progress_code {State Prim : SET} (StateV : State -> Prop) (Fut : State -> State -> Prop) (PrimV : State -> Prim -> Prop) (RedPrim : State -> Prim -> PCode Prim -> State -> PCode Prim -> Prop) (TermPrim : State -> Prim -> PCode Prim -> Prop) (frefl : forall s : State, StateV s -> Fut s s) (ftrans : forall s s' s'' : State, StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s'') (primv_fut : forall s s' : State, forall p : Prim, StateV s -> StateV s' -> Fut s s' -> PrimV s p -> PrimV s' p) (preserve_prim : forall s : State, forall pf : Prim, forall ca : PCode Prim, forall s' : State, forall cr : PCode Prim, StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> RedPrim s pf ca s' cr -> StateV s' /\ Fut s s' /\ PCodeV (PrimV s') cr) (progress_prim : forall s : State, forall pf : Prim, forall ca : PCode Prim, StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> TermPrim s pf ca -> exists s' : State, exists cr : PCode Prim, RedPrim s pf ca s' cr) (s : State) (cf ca : PCode Prim) : StateV s -> PCodeV (PrimV s) cf -> PCodeV (PrimV s) ca -> TermCode RedPrim TermPrim s cf ca -> exists s' : State, exists cr : PCode Prim, RedCode RedPrim s cf ca s' cr.
    revert s cf ca. fix progress_code 7. intros s cf ca sv cfv cav t. destruct t as [ s pf ca tp | s lb ca tl | s n lb ca ]; simpl in cfv.
     rename cfv into pfv. apply progress_prim in tp; try assumption. destruct tp as [ s' [ cr r ] ]. pose proof r as r'. apply preserve_prim in r'; try assumption. destruct r' as [ sv' [ ss' crv ] ]. exists s'; try assumption. exists cr; try assumption. constructor. assumption.
     apply (progress_lambda StateV Fut (fun s => PCodeV (PrimV s))) in tl; try apply lsubstv; try assumption.
      destruct tl as [ s' [ cr r ] ]. exists s'; try assumption. exists cr; try assumption. constructor. assumption.
      clear s sv lb cfv ca cav tl. intros s s' c sv sv' ss'. apply pcodev_mono. intro p. apply primv_fut; assumption.
      apply preservation_code; assumption.
     exists s; try apply frefl; try assumption. exists (clam n (lsubst ca lb)); try apply lsubstv; try assumption. constructor.
  Defined.
(* end hide *)

End FreeStatefulCombinatoryCode.


Module Type PrimitiveApplicativeStructure.
  Import FreeStatefulCombinatoryCode.

  Parameter State : SET.
  Parameter Prim : SET.

  Parameter StateV : State -> Prop.
  Parameter sinhabited : exists s : State, StateV s.

  Parameter Fut : State -> State -> Prop.
  Parameter frefl : forall s : State, StateV s -> Fut  s s.
  Parameter ftrans : forall s s' s'' : State, StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s''.

  Parameter PrimV : State -> Prim -> Prop.
  Parameter primv_fut : forall s s' : State, forall p : Prim, StateV s -> StateV s' -> Fut s s' -> PrimV s p -> PrimV s' p.

  Parameter RedPrim : State -> Prim -> PCode Prim -> State -> PCode Prim -> Prop.
  Parameter TermPrim : State -> Prim -> PCode Prim -> Prop.

  Parameter preservation_prim : forall s : State, forall pf : Prim, forall ca : PCode Prim, forall s' : State, forall cr : PCode Prim, StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> RedPrim s pf ca s' cr -> StateV s' /\ Fut s s' /\ PCodeV (PrimV s') cr.
  Parameter progress_prim : forall s : State, forall pf : Prim, forall ca : PCode Prim, StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> TermPrim s pf ca -> exists s' : State, exists cr : PCode Prim, RedPrim s pf ca s' cr.

End PrimitiveApplicativeStructure.


Module FreeStatefulCombinatoryAlgebra (PAS : PrimitiveApplicativeStructure) <: StatefulCombinatoryAlgebra.
  Include FreeStatefulCombinatoryCode.
  Include PAS.

(** Tediously ties the mutually recursive knot. *)

(* begin hide *)
  Definition Code : SET
  := PCode Prim.

  Definition CodeV (s : State) : Code -> Prop
  := PCodeV (PrimV s).

  Lemma codev_fut (s s' : State) (c : Code) : StateV s -> StateV s' -> Fut s s' -> CodeV s c -> CodeV s' c.
   intros sv sv' ss'. apply pcodev_mono. intro p. apply primv_fut; assumption.
  Qed.

  Lemma lambdav_fut (s s' : State) (n : nat) (l : Lambda Code n) : StateV s -> StateV s' -> Fut s s' -> LambdaV (CodeV s) l -> LambdaV (CodeV s') l.
    intros sv sv' ss'. apply lambdav_mono. intro c. apply codev_fut; assumption.
  Qed.

  Definition Red : State -> Code -> Code -> State -> Code -> Prop
  := RedCode RedPrim.
  Definition Term : State -> Code -> Code -> Prop
  := TermCode RedPrim TermPrim.

  Definition preservation := preservation_code StateV Fut PrimV RedPrim frefl ftrans primv_fut preservation_prim.
  Definition progress := progress_code StateV Fut PrimV RedPrim TermPrim frefl ftrans primv_fut preservation_prim progress_prim.
  Definition preservation_lambda' := preservation_lambda StateV Fut CodeV (RedCode RedPrim) frefl ftrans codev_fut preservation.
  Definition progress_lambda' := progress_lambda StateV Fut CodeV (RedCode RedPrim) (TermCode RedPrim TermPrim) frefl ftrans codev_fut preservation progress.

  Import StatefulApplicativeExpression.

  Fixpoint levar {n : nat} : EVar Code n -> sum (LVar n) Code
  := match n with
     | 0 => inr
     | S n => fun v => match v with
                       | None => inl None
                       | Some v => match levar v with
                                   | inl v => inl (Some v)
                                   | inr c => inr c
                                   end
                       end
     end.

  Fixpoint lexpr {n : nat} (e : ExprVar Code n) : Lambda Code n
  := match e with
     | evar _ v => match levar v with
                   | inl v => lvar n v
                   | inr c => lcode c
                   end
     | eapp ef ea => lapp (lexpr ef) (lexpr ea)
     end.

  Lemma lexprv (n : nat) (e : ExprVar Code n) (s : State) : StateV s -> ExprVarV (CodeV s) e -> LambdaV (CodeV s) (lexpr e).
    intros sv ev. unfold CodeV in *. induction ev; simpl; auto. cut (match levar c with inl v => True | inr c => CodeV s c end).
     destruct (levar c); trivial.
     induction n; try trivial. destruct c; try constructor. simpl. pose proof (IHn e) as IHn. destruct (levar e); auto.
  Qed.

  Definition cencode (n : nat) (e : ExprVar Code (S n)) : Code
  := clam n (lexpr e).

  Lemma cencodev (n : nat) (e : ExprVar Code (S n)) (s : State) : StateV s -> ExprVarV (CodeV s) e -> CodeV s (cencode n e).
    intros sv ev. apply lexprv; assumption.
  Qed.

  Lemma lexpr_esubst (c : Code) (n : nat) (e : ExprVar Code (S n)) : lsubst c (lexpr e) = lexpr (esubst c e).
    induction e as [ v | ef ea ]; simpl.
     destruct v; simpl.
      destruct (levar e); reflexivity.
      assert (inr c = levar (vcode c n)) as e.
       induction n; simpl; try reflexivity. rewrite <- IHn. reflexivity.
       rewrite <- e. reflexivity.
     f_equal; assumption.
  Qed.

  Lemma exprv_fut (s s' : State) (e : Expr Code) : StateV s -> StateV s' -> Fut s s' -> ExprVarV (CodeV s) e -> ExprVarV (CodeV s') e.
    intros sv sv' ss' ev. induction ev; constructor; auto. apply codev_fut with s; assumption.
  Qed.

  Lemma red_lambda_expr (s : State) (e : ExprVar Code 0) (s' : State) (cr : Code) : StateV s -> ExprVarV (CodeV s) e -> RedLambda (RedCode RedPrim) s (lexpr e) s' cr -> RedExpr Red s e s' cr.
    intros sv ev r. remember (lexpr e) as l in r. revert e ev Heql. induction r; intros e ev Heql.
     destruct e; simpl in Heql; inversion Heql; clear Heql; subst. constructor.
     destruct e; simpl in Heql; inversion Heql; clear Heql; subst. inversion ev; clear ev; subst. apply reapp with s' cf s'' ca; try auto. apply preservation_lambda' in r1; try auto using lexprv. apply IHr2; try auto. apply exprv_fut with s; auto.
  Qed.

  Lemma red_encode_S : forall s s' : State, forall n : nat, forall e : ExprVar Code (S (S n)), forall ca cr : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Red s (cencode (S n) e) ca s' cr -> s' = s /\ cencode n (esubst ca e) = cr.
    intros s s' n e ca cr sv ev cav r. inversion r; clear r; inj_pair2_nat; subst. split; try reflexivity. unfold cencode. f_equal. symmetry. apply lexpr_esubst.
  Qed.
  Lemma red_encode_0 : forall s s' : State, forall e : ExprVar Code 1, forall ca cr : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Red s (cencode 0 e) ca s' cr -> RedExpr Red s (esubst ca e) s' cr.
    intros s s' e ca cr sv ev cav r. inversion r; clear r; inj_pair2_nat; subst. apply red_lambda_expr; try auto using esubstv. rewrite <- lexpr_esubst. assumption.
  Qed.
  Lemma term_encode_S : forall s : State, forall n : nat, forall e : ExprVar Code (S (S n)), forall ca : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> Term s (cencode (S n) e) ca.
    constructor.
  Qed.
  Lemma term_encode_0 : forall s : State, forall e : ExprVar Code 1, forall ca : Code, StateV s -> ExprVarV (CodeV s) e -> CodeV s ca -> TermExpr Red Term s (esubst ca e) -> Term s (cencode 0 e) ca.
    intros s e ca sv ev cav t. constructor. rewrite lexpr_esubst. revert t. assert (ExprVarV (CodeV s) (esubst ca e)) as ecav by (apply esubstv; assumption). revert ecav. generalize (esubst ca e). clear e ca ev cav. revert s sv. fix term 5. intros s sv e ev t. destruct t; simpl.
     constructor.
     inversion ev; clear ev; subst. constructor; try auto. intros s' cf r. destruct (H s' cf).
      apply red_lambda_expr; auto.
      apply preservation_lambda' in r; try auto using lexprv. split.
       apply term; try auto. apply exprv_fut with s; auto.
       intros. apply H1. apply red_lambda_expr; auto. apply exprv_fut with s; auto.
  Qed.
(* end hide *)

End FreeStatefulCombinatoryAlgebra.
