Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import RCAs.
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import Lambdas.
(** printing Lambda $L$ *)
(** printing LambdaV $\isa{L}$ *)
(** printing lsubst $\ell[\cdot] *)
(** printing lcode $(\cdot)$ *)
(** printing lapp $\app$ *)
(** printing Prim $P$ *)
(** printing PrimV $\isa{P}$ *)
(** printing PCode $C_?$ *)
(** printing cprim $(\cdot)$ *)
(** printing clam $\lambda^\cdot$ *)
(** printing PCodeV $\isa{C_?}$ *)
(**)
(** printing PrimV' $\isa{P}'$ *)
(** printing RedLambda $\downarrow_c^\lambda$ *)
(** printing RedCode $\downarrow_c^{C_?}$ *)
(** printing RedPrim $\downarrow_c^p$ *)
(** printing TermLambda $\downarrow^\lambda$ *)
(** printing TermCode $\downarrow^{C_?}$ *)
(** printing TermPrim $\downarrow^p$ *)
(** printing TermRedLambda $\downarrow_\phi^\lambda$ *)
(** printing TermRedCode $\downarrow_\phi^{C_?}$ *)
(** printing TermRedPrim $\downarrow_\phi^p$ *)
(**)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pr $\phi_r$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)
(** printing l $\ell$ *)
(** printing lf $\ell_f$ *)
(** printing la $\ell_a$ *)
(** printing pf $p_f$ *)


(** *** Framework for Building Relational Combinatory Algebras with Lambda-Terms and Primitives *)
(** We elide the construction as it is just tedious and made complex by the fact that there is no direct way to define mutually dependent inductive types or propositions across modules.
    We only show the module type for specifying the set of primitives and their termination and reduction behavior. *)

Module FreeRelationalCombinatoryCode.
  Export LambdaTerm.

(** Defines relational application [RedLambda] and termination [TermLambda] for $\lambda$-body expressions, and application [RedCode] and termination [TermCode] for codes, each parameterized by application and termination rules for the appropriate unknown sets of codes/primitives. *)
(* begin hide *)
  Inductive RedLambda {Code : SET} (RedCode : Code -> Code -> Code -> Prop) : Lambda Code 0 -> Code -> Prop
  := rlcode (c : Code) : RedLambda RedCode (lcode c) c
   | rlapp (lf la : Lambda Code 0) (cf ca cr : Code) : RedLambda RedCode lf cf -> RedLambda RedCode la ca -> RedCode cf ca cr -> RedLambda RedCode (lapp lf la) cr.

  Inductive RedCode {Prim : SET} (RedPrim : Prim -> PCode Prim -> PCode Prim -> Prop) : PCode Prim -> PCode Prim -> PCode Prim -> Prop
  := rcprim (pf : Prim) (ca : PCode Prim) (cr : PCode Prim) : RedPrim pf ca cr -> RedCode RedPrim (cprim pf) ca cr
   | rclam0 (lb : Lambda (PCode Prim) 1) (ca : PCode Prim) (cr : PCode Prim) : RedLambda (RedCode RedPrim) (lsubst ca lb) cr -> RedCode RedPrim (clam 0 lb) ca cr
   | rclamS (n : nat) (lb : Lambda (PCode Prim) (S (S n))) (ca : PCode Prim) : RedCode RedPrim (clam (S n) lb) ca (clam n (lsubst ca lb)).

  Inductive TermLambda {Code : SET} (RedCode : Code -> Code -> Code -> Prop) (TermCode : Code -> Code -> Prop) : Lambda Code 0 -> Prop
  := slcode (c : Code) : TermLambda RedCode TermCode (lcode c)
   | slapp (lf la : Lambda Code 0) : TermLambda RedCode TermCode lf -> (forall cf : Code, RedLambda RedCode lf cf -> TermLambda RedCode TermCode la /\ forall ca : Code, RedLambda RedCode la ca -> TermCode cf ca) -> TermLambda RedCode TermCode (lapp lf la).

  Inductive TermCode {Prim : SET} (RedPrim : Prim -> PCode Prim -> PCode Prim -> Prop) (TermPrim : Prim -> PCode Prim -> Prop) : PCode Prim -> PCode Prim -> Prop
  := tcprim (pf : Prim) (ca : PCode Prim) : TermPrim pf ca -> TermCode RedPrim TermPrim (cprim pf) ca
   | tclam0 (lb : Lambda (PCode Prim) 1) (ca : PCode Prim) : TermLambda (RedCode RedPrim) (TermCode RedPrim TermPrim) (lsubst ca lb) -> TermCode RedPrim TermPrim (clam 0 lb) ca
   | tclamS (n : nat) (lb : Lambda (PCode Prim) (S (S n))) (ca : PCode Prim) : TermCode RedPrim TermPrim (clam (S n) lb) ca.

  Definition preservation_lambda {Code : SET} (CodeV : Code -> Prop) (RedCode : Code -> Code -> Code -> Prop) (preserve_code : forall cf ca cr : Code, CodeV cf -> CodeV ca -> RedCode cf ca cr -> CodeV cr) (l : Lambda Code 0) (c : Code) : LambdaV CodeV l -> RedLambda RedCode l c -> CodeV c.
    intros lv r. induction r; simpl in lv.
     repeat split; try apply frefl; assumption.
     clear r1 r2. rename IHr1 into IHrf. rename IHr2 into IHra. rename H into rc. destruct lv as [ lfv lav ]. apply IHrf in lfv; try assumption. apply IHra in lav; try assumption. apply preserve_code in rc; assumption.
  Defined.

  Definition preservation_code {Prim : SET} (PrimV : Prim -> Prop) (RedPrim : Prim -> PCode Prim -> PCode Prim -> Prop) (preserve_prim : forall pf : Prim, forall ca : PCode Prim, forall cr : PCode Prim, PrimV pf -> PCodeV PrimV ca -> RedPrim pf ca cr -> PCodeV PrimV cr) (cf ca cr : PCode Prim) : PCodeV PrimV cf -> PCodeV PrimV ca -> RedCode RedPrim cf ca cr -> PCodeV PrimV cr.
    revert cf ca cr. fix preserve_code 6. intros cf ca cr cfv cav rc. destruct rc.
     rename H into rp. apply preserve_prim in rp; assumption.
     rename H into rl. apply (preservation_lambda (PCodeV PrimV)) in rl; try assumption. apply lsubstv; assumption.
     apply lsubstv; assumption.
  Defined.

  Definition progress_lambda {Code : SET} (CodeV : Code -> Prop) (RedCode : Code -> Code -> Code -> Prop) (TermCode : Code -> Code -> Prop) (preserve_code : forall cf ca cr : Code, CodeV cf -> CodeV ca -> RedCode cf ca cr -> CodeV cr) (progress_code : forall cf ca : Code, CodeV cf -> CodeV ca -> TermCode cf ca -> exists cr : Code, RedCode cf ca cr) (l : Lambda Code 0) : LambdaV CodeV l -> TermLambda RedCode TermCode l -> exists cr : Code, RedLambda RedCode l cr.
    revert l. fix progress_lambda 3. intros lr lrv t. destruct t as [ c | lf la tf t ]; simpl in lrv.
     exists c; try assumption. constructor.
     destruct lrv as [ lfv lav ]. apply progress_lambda in tf; try assumption. destruct tf as [ cf rf ]. pose proof rf as ta. apply t in ta; try assumption. clear t. destruct ta as [ ta t ]. pose proof rf as cfv. apply (preservation_lambda CodeV) in cfv; try assumption. apply progress_lambda in ta; try assumption. destruct ta as [ ca ra ]. pose proof ra as cav. apply (preservation_lambda CodeV) in cav; try assumption. pose proof ra as tfa. apply t in tfa; try assumption. clear t. apply progress_code in tfa; try assumption. destruct tfa as [ cr r ]. exists cr; try assumption. apply rlapp with cf ca; assumption.
  Defined.

  Definition progress_code {Prim : SET} (PrimV : Prim -> Prop) (RedPrim : Prim -> PCode Prim -> PCode Prim -> Prop) (TermPrim : Prim -> PCode Prim -> Prop) (preserve_prim : forall pf : Prim, forall ca : PCode Prim, forall cr : PCode Prim, PrimV pf -> PCodeV PrimV ca -> RedPrim pf ca cr -> PCodeV PrimV cr) (progress_prim : forall pf : Prim, forall ca : PCode Prim, PrimV pf -> PCodeV PrimV ca -> TermPrim pf ca -> exists cr : PCode Prim, RedPrim pf ca cr) (cf ca : PCode Prim) : PCodeV PrimV cf -> PCodeV PrimV ca -> TermCode RedPrim TermPrim cf ca -> exists cr : PCode Prim, RedCode RedPrim cf ca cr.
    revert cf ca. fix progress_code 5. intros cf ca cfv cav t. destruct t as [ pf ca tp | lb ca tl | n lb ca ]; simpl in cfv.
     rename cfv into pfv. apply progress_prim in tp; try assumption. destruct tp as [ cr r ]. pose proof r as crv. apply preserve_prim in crv; try assumption. exists cr; try assumption. constructor. assumption.
     apply (progress_lambda (PCodeV PrimV)) in tl; try apply lsubstv; try assumption.
      destruct tl as [ cr r ]. exists cr; try assumption. constructor. assumption.
      apply preservation_code; assumption.
     exists (clam n (lsubst ca lb)); try apply lsubstv; try assumption. constructor.
  Defined.
(* end hide *)

End FreeRelationalCombinatoryCode.


Module Type PrimitiveApplicativeStructure.
  Import FreeRelationalCombinatoryCode.

  Parameter Prim : SET.
  Parameter PrimV : Prim -> Prop.

  Parameter RedPrim : Prim -> PCode Prim -> PCode Prim -> Prop.
  Parameter TermPrim : Prim -> PCode Prim -> Prop.

  Parameter preservation_prim : forall pf : Prim, forall ca : PCode Prim, forall cr : PCode Prim, PrimV pf -> PCodeV PrimV ca -> RedPrim pf ca cr -> PCodeV PrimV cr.
  Parameter progress_prim : forall pf : Prim, forall ca : PCode Prim, PrimV pf -> PCodeV PrimV ca -> TermPrim pf ca -> exists cr : PCode Prim, RedPrim pf ca cr.

End PrimitiveApplicativeStructure.


Module FreeRelationalCombinatoryAlgebra (PAS : PrimitiveApplicativeStructure) <: RelationalCombinatoryAlgebra.
  Include FreeRelationalCombinatoryCode.
  Include PAS.

(** Tediously ties the mutually recursive knot. *)

(* begin hide *)
  Definition Code : SET
  := PCode Prim.
  Definition CodeV : Code -> Prop
  := PCodeV PrimV.

  Definition Red : Code -> Code -> Code -> Prop
  := RedCode RedPrim.
  Definition Term : Code -> Code -> Prop
  := TermCode RedPrim TermPrim.

  Definition preservation := preservation_code PrimV RedPrim preservation_prim.
  Definition progress := progress_code PrimV RedPrim TermPrim preservation_prim progress_prim.
  Definition preservation_lambda' := preservation_lambda CodeV (RedCode RedPrim) preservation.
  Definition progress_lambda' := progress_lambda CodeV (RedCode RedPrim) (TermCode RedPrim TermPrim) preservation progress.

  Import RelationalApplicativeExpression.

  Definition cencode (n : nat) (e : ExprVar Code (S n)) : Code
  := clam n (lexpr e).
  Lemma cencodev (n : nat) (e : ExprVar Code (S n)) : ExprVarV CodeV e -> CodeV (cencode n e). intro ev. apply lexprv; assumption. Qed.

  Lemma red_lambda_expr (e : ExprVar Code 0) (cr : Code) : ExprVarV CodeV e -> RedLambda (RedCode RedPrim) (lexpr e) cr -> RedExpr Red e cr.
    intros ev r. remember (lexpr e) as l in r. revert e ev Heql. induction r; intros e ev Heql.
     destruct e; simpl in Heql; inversion Heql; clear Heql; subst. constructor.
     destruct e; simpl in Heql; inversion Heql; clear Heql; subst. inversion ev; clear ev; subst. apply reapp with cf ca; auto.
  Qed.

  Lemma red_encode_S : forall n : nat, forall e : ExprVar Code (S (S n)), forall ca cr : Code, ExprVarV CodeV e -> CodeV ca -> Red (cencode (S n) e) ca cr -> cencode n (esubst ca e) = cr.
    intros n e ca cr ev cav r. inversion r; clear r; inj_pair2_nat; subst. unfold cencode. f_equal. symmetry. apply lexpr_esubst.
  Qed.
  Lemma red_encode_0 : forall e : ExprVar Code 1, forall ca cr : Code, ExprVarV CodeV e -> CodeV ca -> Red (cencode 0 e) ca cr -> RedExpr Red (esubst ca e) cr.
    intros e ca cr ev cav r. inversion r; clear r; inj_pair2_nat; subst. apply red_lambda_expr; try auto using esubstv. rewrite <- lexpr_esubst. assumption.
  Qed.
  Lemma term_encode_S : forall n : nat, forall e : ExprVar Code (S (S n)), forall ca : Code, ExprVarV CodeV e -> CodeV ca -> Term (cencode (S n) e) ca.
    constructor.
  Qed.
  Lemma term_encode_0 : forall e : ExprVar Code 1, forall ca : Code, ExprVarV CodeV e -> CodeV ca -> TermExpr Red Term (esubst ca e) -> Term (cencode 0 e) ca.
    intros e ca ev cav t. constructor. rewrite lexpr_esubst. revert t. assert (ExprVarV CodeV (esubst ca e)) as ecav by (apply esubstv; assumption). revert ecav. generalize (esubst ca e). clear e ca ev cav. fix term 3. intros e ev t. destruct t; simpl.
     constructor.
     inversion ev; clear ev; subst. constructor; try auto. intros cf r. destruct (H cf).
      apply red_lambda_expr; auto.
      apply preservation_lambda' in r; try auto using lexprv. split.
       apply term; auto.
       intros. apply H1. apply red_lambda_expr; auto.
  Qed.
(* end hide *)

End FreeRelationalCombinatoryAlgebra.
