Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Expressions.
(** printing Code $C$ *)
(** printing CodeV $\isa{C}$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing ecode $(\cdot)$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $\dot{e}[\cdot]$ *)
Require Import RCAs.
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import SCAs.
(** printing State $\Sigma$ *)
(** printing StateV $\isa{\Sigma}$ *)
(** printing Fut $\leq$ *)
(** printing Red $\downarrow_c$ *)
(** printing Term $\downarrow$ *)
(** printing TermRed $\downarrow_\phi$ *)
(** printing Expr $E_0$ *)
(** printing RedExpr $\downarrow^E_c$ *)
(** printing TermExpr $\downarrow^E$ *)
(** printing TermRedExpr $\downarrow^E_\phi$ *)
(** printing preservation $\mathit{preservation}$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
Require Import Sets.
(** printing set $\mathit{set}$ *)
(** printing setv $\isa{\coqdocvar{set}}$ *)
(** printing sete $\iseq{\coqdocvar{set}}$ *)
Require Import HOFs.
(** printing PROP $\Phi$ *)
(** printing PROPV $\isa{\Phi}$ *)
(** printing Entails $\vdash$ *)
(** printing subst $\dot{\phi}[\cdot]$ *)
(** printing top $\top$ *)
(** printing conj $\conj$ *)
(** printing bot $\bot$ *)
(** printing disj $\disj$ *)
(** printing imp $\imp$ *)
(** printing sforall $\forall$ *)
(** printing sexists $\exists$ *)
(** printing seq $=$ *)
(** printing oprop $\Omega$ *)
(** printing character $\chi$ *)
(** printing holds $\mathit{holds}$ *)
(** printing isnat $\isnat$ *)
Require Import RCAstoHOFs.
(** printing cnat $c^\lambda_\cdot$ *)
Require Import SCAstoHOFs.
(** printing cnat $c^\lambda_\cdot$ *)
(**)
(** printing sexistsr $\exists\mathord{\mid}$ *)
(**)
(** printing cc $\cc$ *)
(** printing p $\phi$ *)
(** printing p1 $\phi_1$ *)
(** printing p2 $\phi_2$ *)
(** printing s $\sigma$ *)
(** printing s' $\sigma'$ *)
(** printing s'' $\sigma''$ *)
(** printing c $c$ *)
(** printing c1 $c_1$ *)
(** printing c2 $c_2$ *)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing cz $c_z$ *)
(** printing cs $c_s$ *)
(** printing c2sel1 $c_{\texttt{fst}}$ *)
(** printing c2sel2 $c_{\texttt{snd}}$ *)
(** printing ctuple2 $c_{\epair{\cdot}{\cdot}}$ *)
(** printing cnat $c^\lambda_\cdot$ *)
(** printing Pr $\phi_r$ *)
(** printing Pr' $\phi_r'$ *)
(** printing Pi $\phi_\cdot$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)
(** printing P $\Psi$ *)
(** printing P1 $\Psi_1$ *)
(** printing P2 $\Psi_2$ *)
(** printing o1 $o_1$ *)
(** printing o2 $o_2$ *)


(** *** Definition of Internal Countable Choice in Evidenced Frames *)
(** This is the formal statement of Definition %\ref{cc-tripos}%.
    It is in point-free notation because it is defined over any cartesian-closed category, not just sets. *)

Module CCinHOF (CCC : CartesianClosedCategory) (NNO : NaturalNumberObject CCC) (HOF : NatHigherOrderFibration CCC NNO).
(* begin hide *)
  Import CCC.
  Import NNO.
  Import HOF.
  Module CCCT := CartesianClosedCategoryTools CCC.
  Import CCCT.
  Module NNOT := NaturalNumberObjectTools CCC NNO.
  Import NNOT.
  Module NHOFT := NatHigherOrderFibrationTools CCC NNO HOF.
  Import NHOFT.

  Arguments muniti {o}.
  Arguments mprode1 {o1 o2}.
  Arguments mprode2 {o1 o2}.
(* end hide *)

  Definition total (o1 o2 : Object) (p1 : PROP o1) : PROP (oexp o1 (oexp o2 oprop))
  := sforall o1 (imp (subst mprode2 p1) (subst (mexpe o1 (oexp o2 oprop)) (sexists o2 (subst (mexpe o2 oprop) holds)))).
  Definition includes : PROP (oprod oprop oprop) := imp (subst mprode2 holds) (subst mprode1 holds).
  Definition lift (o1 o2 : Object) (p2 : PROP (oprod o2 o2)) : PROP (oprod (oexp o1 o2) (oexp o1 o2))
  := sforall o1 (subst (mprodi (mcomp (mprodi (mcomp mprode1 mprode1) mprode2) (mexpe o1 o2)) (mcomp (mprodi (mcomp mprode1 mprode2) mprode2) (mexpe o1 o2))) p2).
  Definition determined (o1 o2 : Object) : PROP (oexp o1 (oexp o2 oprop))
  := sforall o1 (subst (mexpe o1 (oexp o2 oprop)) (sforall o2 (sforall o2 (imp (subst (mcomp (mprodi (mcomp mprode1 mprode1) (mcomp mprode1 mprode2)) (mexpe o2 oprop)) holds)
                                             (imp (subst (mcomp (mprodi (mcomp mprode1 mprode1) mprode2) (mexpe o2 oprop)) holds)
                                                (subst (mprodi muniti (mprodi (mcomp mprode1 mprode2) mprode2)) (seq o2 (top (oprod ounit o2))))))))).
  Definition countable_choice (o : Object) : PROP ounit
  := sforall (oexp onat (oexp o oprop)) (subst mprode2 (imp (total onat o isnat)
                                (sexists (oexp onat (oexp o oprop)) (conj (conj (subst mprode2 (total onat o isnat)) (lift onat (oexp o oprop) (lift o oprop includes))) (subst mprode2 (determined onat o)))))).

(* begin hide *)
  Lemma totalv (o1 o2 : Object) (p1 : PROP o1) : ObjectV o1 -> ObjectV o2 -> PROPV p1 -> PROPV (total o1 o2 p1). unfold total. auto 10. Qed.
  Lemma includesv : PROPV includes. unfold includes. auto. Qed.
  Lemma liftv (o1 o2 : Object) (p2 : PROP (oprod o2 o2)) : ObjectV o1 -> ObjectV o2 -> PROPV p2 -> PROPV (lift o1 o2 p2). unfold lift. auto 10. Qed.
  Lemma determinedv (o1 o2 : Object) : ObjectV o1 -> ObjectV o2 -> PROPV (determined o1 o2). unfold determined. auto 15. Qed.
  Hint Resolve totalv includesv liftv determinedv.
  Lemma countable_choicev (o : Object) : ObjectV o -> PROPV (countable_choice o). unfold countable_choice. auto 15. Qed.
  Hint Resolve countable_choicev.
(* end hide *)

End CCinHOF.


(** *** Definition of Internal Countable Choice in Relational Combinatory Algebras *)
(** This is the formal statement of the definition in Lemmas %\ref{lem:pca-simple}% and %\ref{lem:rca-simple}%. *)

Module CCinRCA (RCA : RelationalCombinatoryAlgebra).
(* begin hide *)
  Import RCA.
  Module HOF := RCAtoHOF RCA.
  Import HOF.
  Import RCAT.
  Import InhabitedSets.
  Import InhabitedSetsNat.
  Module CC := CCinHOF InhabitedSets InhabitedSetsNat HOF.
  Import CC.
  Import CCCT.
  Import NNOT.
  Import NHOFT.
(* end hide *)

  Definition sexistsr {o1 : Object} (o2 : Object) (P12 : set o1 -> set o2 -> Prop) (p12 : PROP (oprod o1 o2)) : PROP o1
  := fun x1 c => exists3 x2 : set o2, setv o2 x2 & P12 x1 x2 & p12 (pair x1 x2) c.
(* begin hide *)
  Lemma sexistsrv (o1 o2 : Object) (P12 : set o1 -> set o2 -> Prop) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> (forall x1 x1' : set o1, forall x2 x2' : set o2, setv o1 x1 -> setv o1 x1' -> setv o2 x2 -> setv o2 x2' -> sete o1 x1 x1' -> sete o2 x2 x2' -> P12 x1 x2 -> P12 x1' x2') -> PROPV p12 -> PROPV (sexistsr o2 P12 p12).
    intros ov1 ov2 Pv12 pv12. intros x1 x1' c12 xv1 xv1' x1x1' cv12 [ x2 xv2 p12c12 ]. exists x2; try assumption.
     apply Pv12 with x1 x2; auto.
     apply pv12 with (pair x1 x2); auto.
  Qed.
  Hint Resolve sexistsrv.
(* end hide *)

  Definition rca_included {o : Object} (S R : set (oexp onat (oexp o oprop))) : Prop := forall n : nat, forall x : set o, forall c : Code, setv o x -> CodeV c -> S n x c-> R n x c.
  Definition rca_determined {o : Object} (S : set (oexp onat (oexp o oprop))) : Prop
  := forall n : nat, forall x x' : set o, forall c c' : Code, setv o x -> setv o x' -> CodeV c -> CodeV c' -> S n x c -> S n x' c' -> sete o x x'.
  Definition rca_countable_choice (o : Object) : PROP ounit
  := sforall (oexp onat (oexp o oprop)) (subst mprode2 (imp (total onat o isnat)
                                (sexistsr (oexp onat (oexp o oprop)) (fun R S => rca_included S R /\ rca_determined S) (subst mprode2 (total onat o isnat))))).
(* begin hide *)
  Lemma rca_countable_choicev (o : Object) : ObjectV o -> PROPV (rca_countable_choice o).
    intro. unfold rca_countable_choice. apply sforallv; try auto 3. apply substv; try auto 4. apply impv; try auto 3. apply sexistsrv; try auto 5. unfold rca_included. unfold rca_determined. intros R R' S S' _ _ _ _ RR' SS' [ SR Sdet ]. simpl in *. split.
     intros n x. intros. apply RR' with n x; try auto. apply SR; try auto. apply SS' with n x; auto.
     intros n x x' c c'. intros. apply Sdet with n c c'; try auto.
      apply SS' with n x; auto.
      apply SS' with n x'; auto.
  Qed.
  Hint Resolve rca_countable_choicev.
(* end hide *)

(** *** Proof that Internal CC for a PCA/RCA is Equivalent to Internal CC for its Higher-Order Fibration *)
(** %\label{coq:pca-simple}\label{coq:rca-simple}%We provide the codes exhibiting equivalence, but we elide here the actual proof of Lemmas %\ref{lem:pca-simple}% and %\ref{lem:rca-simple}% as it is rather tedious and follows from the definitions of the codes. *)

(* begin hide *)
  Import RelationalApplicativeExpression.
(* end hide *)

  Definition csimplify : Code := cencode 1 (eapp (ecode (cencode 1 (eapp (eapp (evar 2 None) (ecode c2sel2)) (eapp (eapp (evar 2 None) (ecode c2sel1)) (evar 2 (Some None)))))) (eapp (eapp (evar 2 None) (evar 2 (Some None))) (ecode c2sel1))).
  Definition ccomplicate : Code := cencode 1 (eapp (ecode (cencode 1 (eapp (eapp (evar 2 (Some None)) (eapp (ecode (cencode 1 (eapp (eapp (evar 2 (Some None)) (evar 2 None)) (ecode (cencode 0 (evar 1 None)))))) (evar 2 None))) (ecode (cencode 2 (evar 3 (Some (Some None)))))))) (eapp (evar 2 None) (evar 2 (Some None)))).
(* begin hide *)
  Lemma csimplifyv : CodeV csimplify. unfold csimplify. auto 10. Qed.
  Lemma ccomplicatev : CodeV ccomplicate. intros. unfold ccomplicate. auto 15. Qed.
  Hint Resolve csimplifyv ccomplicatev.
(* end hide *)
  Lemma rca_countable_choice_equiv (o : Object) : ObjectV o -> Entails (countable_choice o) (rca_countable_choice o) /\ Entails (rca_countable_choice o) (countable_choice o).
    intro ov. split.
     exists csimplify; try auto. intros [] cc _ ccv pcccc. unfold csimplify. termred; try auto 10. unfold rca_countable_choice. unfold subst. simpl. intros R Rv ctot ctotv ptotctot. termred; try auto 10. unfold countable_choice in pcccc. unfold subst in pcccc. specialize (pcccc R Rv ctot ctotv ptotctot). revert pcccc. apply termred_mono; try auto. clear cc ccv ctot ctotv ptotctot. intros ctotincldet ctotincldetv [ S Sv ptotincldetctotincldet ]. pose proof ptotincldetctotincldet as [ ptotinclctotincl _ ]. revert ptotinclctotincl. apply termred_mono; try auto. intros ctotincl ctotinclv ptotinclctotincl. termred; try auto 10. exists (fun n i c => R n i c /\ exists2 c : Code, CodeV c & S n i c).
      split.
       clear ctotincldetv ptotincldetctotincldet ctotinclv ptotinclctotincl. simpl. intros n nv. split.
        intros x xv cr crv [ rcr [ cs csv scs ] ]. split; try assumption. exists cs; assumption.
        intros x x' xv xv' xx' cr crv. split; intros [ rcr [ cs csv scs ] ]; repeat split; try assumption.
         apply Rv with x; auto.
         exists cs; try assumption. apply Sv with x; auto.
         apply Rv with x'; auto.
         exists cs; try assumption. apply Sv with x'; auto.
       clear ctotincldetv ptotincldetctotincldet ctotinclv ptotinclctotincl. intros n n' nv _ nn'. destruct nn'. simpl. intros x x' xv xv' xx' cr crv. split; intros [ rcr [ cs csv scs ] ]; repeat split; try assumption.
         apply Rv with x; auto.
         exists cs; try assumption. apply Sv with x; auto.
         apply Rv with x'; auto.
         exists cs; try assumption. apply Sv with x'; auto.
      split.
       unfold rca_included. auto.
       unfold rca_determined. intros n x x' cr cr' xv xv' cv cv' [ rcr [ cs csv scs ] ] [ rcr' [ cs' csv' scs' ] ]. assert (setv onat n) as nv by constructor. destruct ptotincldetctotincldet as [ _ pdetcdet ]; try assumption. apply termred_progress in pdetcdet; try auto. destruct pdetcdet as [ cdet cdetv pdetcdet ]. simpl in pdetcdet. specialize (pdetcdet n nv x xv x' xv' cs). unfold subst in pdetcdet. unfold mcomp in pdetcdet. unfold holds in pdetcdet. simpl in pdetcdet. apply termred_progress in pdetcdet; try apply Sv with s''; try auto. destruct pdetcdet as [ cdet' cdetv' pdetcdet' ]. specialize (pdetcdet' cs'). simpl in pdetcdet'. apply termred_progress in pdetcdet'; try auto. destruct pdetcdet' as [ cdet'' cdetv'' pdetcdet'' ]. apply pdetcdet''.
      unfold total. intros n nv. unfold imp. unfold subst. simpl. intros cn cnv pncn. termred; try auto 10. pose proof ptotinclctotincl as pinclcincl'. destruct pinclcincl' as [ _ pinclcincl ]; try auto. revert pinclcincl. apply termred_mono; try auto. intros cincl cinclv pinclcincl. destruct ptotinclctotincl as [ ptotctot _ ]; try auto. revert ptotctot. apply termred_mono; try auto. intros ctot ctotv ptotctot. specialize (ptotctot n nv cn cnv pncn). unfold subst in ptotctot. unfold holds in ptotctot. simpl in ptotctot. revert ptotctot. apply termred_mono; try auto. intros cs csv scs. destruct scs as [ x xv scs ]. specialize (pinclcincl n nv x xv cs csv scs). unfold subst in pinclcincl. unfold holds in pinclcincl. unfold mcomp in pinclcincl. simpl in pinclcincl. revert pinclcincl. apply termred_mono; try auto. intros cr crv rcr. exists x; try assumption. unfold holds. simpl. repeat split; try auto. exists cs; auto.
     exists ccomplicate; try auto. intros [] cc _ ccv pcccc. unfold ccomplicate. termred; try auto 15. unfold countable_choice. intros R Rv ctot ctotv ptotctot. termred; try auto 15. unfold rca_countable_choice in pcccc. specialize (pcccc R Rv ctot ctotv ptotctot). revert pcccc. apply termred_mono; try auto. clear cc ccv ctot ctotv ptotctot. intros ctot ctotv [ S Sv [ Sincl Sdet ] ptot ]. unfold subst in ptot. simpl in Sincl. simpl in Sdet. simpl in ptot. termred; try auto 10. exists S; try assumption. unfold subst. simpl. split; termred; try auto 15.
      unfold c2sel1. termred; try auto 10. split; termred.
       unfold c2sel1. termred.
       unfold c2sel2. termred. intros n nv. unfold subst. unfold mprodi. unfold mcomp. simpl. intros x xv. unfold subst. unfold mprodi. unfold mcomp. simpl. unfold includes. unfold imp. unfold subst. unfold holds. simpl. intros. termred.
      unfold c2sel2. termred; try auto 10. unfold determined. intros n nv. unfold subst. intros x xv x' xv'. unfold imp. unfold holds. unfold mcomp. simpl. intros cs. intros. termred. intros cs'. intros. termred. unfold seq. unfold top. simpl. repeat split. apply Sdet with n cs cs'; auto.
  Qed.

End CCinRCA.


(** *** Definition of Internal Countable Choice in Stateful Combinatory Algebras *)
(** This is the formal statement of the definition in %Lemma~\ref{lem:sca-simple}%. *)

Module CCinSCA (SCA : StatefulCombinatoryAlgebra).
(* begin hide *)
  Import SCA.
  Module HOF := SCAtoHOF SCA.
  Import HOF.
  Import SCAT.
  Import InhabitedSets.
  Import InhabitedSetsNat.
  Module CC := CCinHOF InhabitedSets InhabitedSetsNat HOF.
  Import CC.
  Import CCCT.
  Import NNOT.
  Import NHOFT.
(* end hide *)

  Definition sexistsr {o1 : Object} (o2 : Object) (P12 : set o1 -> set o2 -> Prop) (p12 : PROP (oprod o1 o2)) : PROP o1
  := fun x1 s c => exists3 x2 : set o2, setv o2 x2 & P12 x1 x2 & p12 (pair x1 x2) s c.
(* begin hide *)
  Lemma sexistsrv (o1 o2 : Object) (P12 : set o1 -> set o2 -> Prop) (p12 : PROP (oprod o1 o2)) : ObjectV o1 -> ObjectV o2 -> (forall x1 x1' : set o1, forall x2 x2' : set o2, setv o1 x1 -> setv o1 x1' -> setv o2 x2 -> setv o2 x2' -> sete o1 x1 x1' -> sete o2 x2 x2' -> P12 x1 x2 -> P12 x1' x2') -> PROPV p12 -> PROPV (sexistsr o2 P12 p12).
    intros ov1 ov2 Pv12 pv12. unfold sexistsr. constructor.
     intros x1 s s' c12 xv1 sv sv' ss' cv12 [ x2 xv2 P12x1x2 p12c12 ]. exists x2; try assumption. apply pv12 with s; auto.
     intros x1 x1' s c12 xv1 xv1' x1x1' sv cv12 [ x2 xv2 P12x1x2 p12c12 ]. exists x2; try assumption.
      apply Pv12 with x1 x2; auto.
      apply pv12 with (pair x1 x2); auto.
  Qed.
  Hint Resolve sexistsrv.
(* end hide *)

  Definition sca_included {o : Object} (S R : set (oexp onat (oexp o oprop))) : Prop
  := forall n : nat, forall x : set o, forall s : State, forall c : Code, setv o x -> StateV s -> CodeV s c -> S n x s c-> R n x s c.
  Definition sca_determined {o : Object} (S : set (oexp onat (oexp o oprop))) : Prop
  := forall n : nat, forall x x' : set o, forall s : State, forall c c' : Code, setv o x -> setv o x' -> StateV s -> CodeV s c -> CodeV s c' -> S n x s c -> S n x' s c' -> sete o x x'.
  Definition sca_countable_choice (o : Object) : PROP ounit
  := sforall (oexp onat (oexp o oprop)) (subst mprode2 (imp (total onat o isnat)
                                (sexistsr (oexp onat (oexp o oprop)) (fun R S => sca_included S R /\ sca_determined S) (subst mprode2 (total onat o isnat))))).
(* begin hide *)
  Lemma sca_countable_choicev (o : Object) : ObjectV o -> PROPV (sca_countable_choice o).
    intro. unfold sca_countable_choice. apply sforallv; try auto. apply substv; try auto. apply impv; try auto. apply sexistsrv; try auto. unfold sca_included. unfold sca_determined. intros R R' S S' _ _ _ _ RR' SS' [ SR Sdet ]. simpl in *. split.
     intros n x. intros. apply RR' with n x; try auto. apply SR; try auto. apply SS' with n x; auto.
     intros n x x' s c c'. intros. apply Sdet with n s c c'; try auto.
      apply SS' with n x; auto.
      apply SS' with n x'; auto.
  Qed.
  Hint Resolve sca_countable_choicev.
(* end hide *)

(** *** Proof that Internal CC for an SCA is Equivalent to Internal CC for its Higher-Order Fibration *)
(** %\label{coq:sca-simple}%We provide the codes exhibiting equivalence, but we elide here the actual proof of Lemma %\ref{lem:sca-simple}% as it is rather tedious and follows from the definitions of the codes. *)

(*begin hide *)
  Import StatefulApplicativeExpression.
(* end hide *)

  Definition csimplify : Code := cencode 1 (eapp (ecode (cencode 1 (eapp (eapp (evar 2 None) (ecode c2sel2)) (eapp (eapp (evar 2 None) (ecode c2sel1)) (evar 2 (Some None)))))) (eapp (eapp (evar 2 None) (evar 2 (Some None))) (ecode c2sel1))).
  Definition ccomplicate : Code := cencode 1 (eapp (ecode (cencode 1 (eapp (eapp (evar 2 (Some None)) (eapp (ecode (cencode 1 (eapp (eapp (evar 2 (Some None)) (evar 2 None)) (ecode (cencode 0 (evar 1 None)))))) (evar 2 None))) (ecode (cencode 2 (evar 3 (Some (Some None)))))))) (eapp (evar 2 None) (evar 2 (Some None)))).
(* begin hide *)
  Lemma csimplifyv : forall s : State, StateV s -> CodeV s csimplify. unfold csimplify. auto 10. Qed.
  Lemma ccomplicatev : forall s : State, StateV s -> CodeV s ccomplicate. intros. unfold ccomplicate. auto 15. Qed.
  Hint Resolve csimplifyv ccomplicatev.
(* end hide *)
  Lemma sca_countable_choice_equiv (o : Object) : ObjectV o -> Entails (countable_choice o) (sca_countable_choice o) /\ Entails (sca_countable_choice o) (countable_choice o).
    intro ov. split.
     exists csimplify; try auto. intros [] s cc _ sv ccv pcccc. unfold csimplify. termred; try auto 10. unfold sca_countable_choice. unfold subst. simpl. intros R Rv s' ctot sv' ss' ctotv ptotctot. termred; try auto 10. unfold countable_choice in pcccc. unfold subst in pcccc. specialize (pcccc R Rv s' ctot sv' ss' ctotv ptotctot). revert pcccc. apply termred_mono; try auto. clear s sv sv' ss' cc ccv ctot ctotv ptotctot. rename s' into s0. intros s ctotincldet sv _ ctotincldetv [ S Sv ptotincldetctotincldet ]. clear s0. pose proof (ptotincldetctotincldet s sv (frefl s sv)) as [ ptotinclctotincl _ ]. revert ptotinclctotincl. apply termred_mono; try auto. intros s' ctotincl sv' ss' ctotinclv ptotinclctotincl. termred; try auto 10. exists (fun n i s'' c => R n i s'' c /\ Fut s' s'' /\ exists2 c : Code, CodeV s'' c & S n i s'' c).
      split.
       clear s sv ss' ctotincldetv ptotincldetctotincldet ctotinclv ptotinclctotincl. simpl. intros n nv. split.
        intros x xv s'' s''' cr sv'' sv''' s''s''' crv [ rcr [ s's'' [ cs csv scs ] ] ]. repeat split.
         apply Rv with (s := s''); assumption.
         apply ftrans with s''; assumption.
         exists cs; try auto. apply Sv with (s := s''); assumption.
        intros x x' xv xv' xx' s'' cr sv'' crv. split; intros [ rcr [ s's'' [ cs csv scs ] ] ]; repeat split; try assumption.
         apply Rv with x; auto.
         exists cs; try assumption. apply Sv with x; auto.
         apply Rv with x'; auto.
         exists cs; try assumption. apply Sv with x'; auto.
       clear s sv ss' ctotincldetv ptotincldetctotincldet ctotinclv ptotinclctotincl. intros n n' nv _ nn'. destruct nn'. simpl. intros x x' xv xv' xx' s'' cr sv'' crv. split; intros [ rcr [ s's'' [ cs csv scs ] ] ]; repeat split; try assumption.
         apply Rv with x; auto.
         exists cs; try assumption. apply Sv with x; auto.
         apply Rv with x'; auto.
         exists cs; try assumption. apply Sv with x'; auto.
      split.
       unfold sca_included. auto.
       unfold sca_determined. intros n x x' s'' cr cr' xv xv' sv'' cv cv' [ rcr [ s's'' [ cs csv scs ] ] ] [ rcr' [ _ [ cs' csv' scs' ] ] ]. assert (setv onat n) as nv by constructor. destruct ptotincldetctotincldet with s'' as [ _ pdetcdet ]; try assumption; try auto. apply termred_progress in pdetcdet; try auto. destruct pdetcdet as [ s''' sv''' s''s''' [ cdet cdetv pdetcdet ] ]. simpl in pdetcdet. specialize (pdetcdet n nv x xv x' xv' s''' cs). unfold subst in pdetcdet. unfold mcomp in pdetcdet. unfold holds in pdetcdet. simpl in pdetcdet. apply termred_progress in pdetcdet; try apply Sv with s''; try auto. destruct pdetcdet as [ s'''' sv'''' s'''s'''' [ cdet' cdetv' pdetcdet' ] ]. specialize (pdetcdet' s'''' cs'). simpl in pdetcdet'. apply termred_progress in pdetcdet'; try apply Sv with s''; try auto. destruct pdetcdet' as [ s''''' sv''''' s''''s''''' [ cdet'' cdetv'' pdetcdet'' ] ]. apply pdetcdet''.
      unfold total. intros n nv. unfold imp. unfold subst. simpl. intros s'' cn sv'' s's'' cnv pncn. termred; try auto 10. pose proof ptotinclctotincl as pinclcincl'. destruct pinclcincl' with s'' as [ _ pinclcincl ]; try auto. revert pinclcincl. apply termred_mono; try auto. intros s''' cincl sv''' s''s''' cinclv pinclcincl. destruct ptotinclctotincl with s''' as [ ptotctot _ ]; try auto. revert ptotctot. apply termred_mono; try auto. intros s'''' ctot sv'''' s'''s'''' ctotv ptotctot. assert (CodeV s'''' cn) as cnv'''' by auto. specialize (ptotctot n nv s'''' cn sv'''' (frefl s'''' sv'''') cnv'''' pncn). unfold subst in ptotctot. unfold holds in ptotctot. simpl in ptotctot. revert ptotctot. apply termred_mono; try auto. intros s''''' cs sv''''' s''''s''''' csv scs. destruct scs as [ x xv scs ]. assert (Fut s''' s''''') as s'''s''''' by auto. specialize (pinclcincl n nv x xv s''''' cs sv''''' s'''s''''' csv scs). unfold subst in pinclcincl. unfold holds in pinclcincl. unfold mcomp in pinclcincl. simpl in pinclcincl. revert pinclcincl. apply termred_mono; try auto. intros s'''''' cr sv''''''' s'''''s'''''' crv rcr. exists x; try assumption. unfold holds. simpl. repeat split; try auto. exists cs; try auto. apply Sv with s'''''; auto.
     exists ccomplicate; try auto. intros [] s cc _ sv ccv pcccc. unfold ccomplicate. termred; try auto 15. unfold countable_choice. intros R Rv s' ctot sv' ss' ctotv ptotctot. termred; try auto 15. unfold sca_countable_choice in pcccc. specialize (pcccc R Rv s' ctot sv' ss' ctotv ptotctot). revert pcccc. apply termred_mono; try auto. clear s sv ss' cc ccv ctot ctotv ptotctot. intros s ctot sv _ ctotv. clear s' sv'. intros [ S Sv [ Sincl Sdet ] ptot ]. unfold subst in ptot. simpl in Sincl. simpl in Sdet. simpl in ptot. termred; try auto 10. exists S; try assumption. intros s' sv' ss'. unfold c2sel1. unfold c2sel2. unfold subst. simpl. split; termred; try auto 15.
      intros s'' sv'' s's''. unfold c2sel1. unfold c2sel2. split; termred; try auto 10.
       apply totalv with s; auto.
       intros n nv. unfold subst. unfold mprodi. unfold mcomp. simpl. intros x xv. unfold subst. unfold mprodi. unfold mcomp. simpl. unfold includes. unfold imp. unfold subst. unfold holds. simpl. intros. termred.
      unfold determined. intros n nv. unfold subst. intros x xv x' xv'. unfold imp. unfold holds. unfold mcomp. simpl. intros s'' cs. intros. termred. intros s''' cs'. intros. termred. unfold seq. unfold top. simpl. repeat split. apply Sdet with n s''' cs cs'; try auto. apply Sv with s''; auto.
  Qed.

End CCinSCA.
