Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
(**)
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
(**)
(** printing o1 $o_1$ *)
(** printing o2 $o_2$ *)
(** printing o3 $o_3$ *)
(** printing o4 $o_4$ *)
(** printing m1 $m_1$ *)
(** printing m2 $m_2$ *)
(** printing m3 $m_3$ *)
(** printing m12 $m_{12}$ *)
(** printing m23 $m_{23}$ *)
(** printing m34 $m_{34}$ *)
(** printing m12' $m_{12}'$ *)
(** printing m23' $m_{23}'$ *)


(** *** Definition of a Category *)
(** This definition is standard. We include here only the structural components so that the reader may be introduced the notation. *)

Module Type Category.

  Parameter Object : Type.
  Parameter ObjectV : Object -> Prop.

  Parameter Morphism : Object -> Object -> Type.
  Parameter MorphismV : forall {o1 o2 : Object}, Morphism o1 o2 -> Prop.
  Parameter MorphismE : forall {o1 o2 : Object}, Morphism o1 o2 -> Morphism o1 o2 -> Prop.

(* begin hide *)
  Parameter mrefl : forall o1 o2 : Object, forall m : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m m.
  Parameter msym : forall o1 o2 : Object, forall m1 m2 : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismE m1 m2 -> MorphismE m2 m1.
  Parameter mtrans : forall o1 o2 : Object, forall m1 m2 m3 : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismV m3 -> MorphismE m1 m2 -> MorphismE m2 m3 -> MorphismE m1 m3.

  Parameter mid : forall o : Object, Morphism o o.
  Parameter midv : forall o : Object, ObjectV o -> MorphismV (mid o).

  Parameter mcomp : forall {o1 o2 o3 : Object}, Morphism o1 o2 -> Morphism o2 o3 -> Morphism o1 o3.
  Parameter mcompv : forall o1 o2 o3 : Object, forall m12 : Morphism o1 o2, forall m23 : Morphism o2 o3, ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> MorphismV m12 -> MorphismV m23 -> MorphismV (mcomp m12 m23).
  Parameter mcompe : forall o1 o2 o3 : Object, forall m12 m12' : Morphism o1 o2, forall m23 m23' : Morphism o2 o3, ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> MorphismV m12 -> MorphismV m12' -> MorphismV m23 -> MorphismV m23' -> MorphismE m12 m12' -> MorphismE m23 m23' -> MorphismE (mcomp m12 m23) (mcomp m12' m23').

  Parameter mid_mcomp : forall o1 o2 : Object, forall m : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m (mcomp (mid o1) m).
  Parameter mcomp_mid : forall o1 o2 : Object, forall m : Morphism o1 o2, ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m (mcomp m (mid o2)).
  Parameter mcomp_assoc : forall o1 o2 o3 o4 : Object, forall m12 : Morphism o1 o2, forall m23 : Morphism o2 o3, forall m34 : Morphism o3 o4, ObjectV o1 -> ObjectV o2 -> ObjectV o3 -> ObjectV o4 -> MorphismV m12 -> MorphismV m23 -> MorphismV m34 -> MorphismE (mcomp (mcomp m12 m23) m34) (mcomp m12 (mcomp m23 m34)).
(* end hide *)

End Category.


(* begin hide *)
Module CategoryTools (Import Cat : Category).

  Hint Resolve mrefl midv mcompv mcompe mid_mcomp mcomp_mid mcomp_assoc.

End CategoryTools.
(* end hide *)
