Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
(**)
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
(**)
(** printing o1 $o_1$ *)
(** printing o2 $o_2$ *)
(** printing o3 $o_3$ *)
(** printing o4 $o_4$ *)
(** printing m' $m'$ *)
(** printing m1 $m_1$ *)
(** printing m2 $m_2$ *)
(** printing m3 $m_3$ *)
(** printing mz $m_z$ *)
(** printing ms $m_s$ *)
(** printing m12 $m_{12}$ *)
(** printing m23 $m_{23}$ *)
(** printing m34 $m_{34}$ *)
(** printing m12' $m_{12}'$ *)
(** printing m23' $m_{23}'$ *)


(** *** Definition of a Cartesian Category *)
(** This definition is standard. We include here only the structural components so that the reader may be introduced the notation. *)

Module Type CartesianCategory.
  Include Category.

  Parameter ounit : Object.
(* begin hide *)
  Parameter ounitv : ObjectV ounit.

(* end hide *)
  Parameter muniti : forall o : Object, Morphism o ounit.
(* begin hide *)
  Parameter munitiv : forall o : Object, ObjectV o -> MorphismV (muniti o).

  Parameter munitie : forall o : Object, forall m : Morphism o ounit, ObjectV o -> MorphismV m -> MorphismE (muniti o) m.
(* end hide *)

  Parameter oprod : Object -> Object -> Object.
(* begin hide *)
  Parameter oprodv : forall o1 o2 : Object, ObjectV o1 -> ObjectV o2 -> ObjectV (oprod o1 o2).

(* end hide *)
  Parameter mprodi : forall {o o1 o2 : Object}, Morphism o o1 -> Morphism o o2 -> Morphism o (oprod o1 o2).
(* begin hide *)
  Parameter mprodiv : forall o o1 o2 : Object, forall m1 : Morphism o o1, forall m2 : Morphism o o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismV (mprodi m1 m2).

(* end hide *)
  Parameter mprode1 : forall o1 o2 : Object, Morphism (oprod o1 o2) o1.
  Parameter mprode2 : forall o1 o2 : Object, Morphism (oprod o1 o2) o2.
(* begin hide *)
  Parameter mprode1v : forall o1 o2 : Object, ObjectV o1 -> ObjectV o2 -> MorphismV (mprode1 o1 o2).
  Parameter mprode2v : forall o1 o2 : Object, ObjectV o1 -> ObjectV o2 -> MorphismV (mprode2 o1 o2).

  Parameter mprodie : forall o o1 o2 : Object, forall m : Morphism o (oprod o1 o2), forall m1 : Morphism o o1, forall m2 : Morphism o o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismV m1 -> MorphismV m2 -> MorphismE m1 (mcomp m (mprode1 o1 o2)) -> MorphismE m2 (mcomp m (mprode2 o1 o2)) -> MorphismE m (mprodi m1 m2).
  Parameter mprode1e : forall o o1 o2 : Object, forall m1 : Morphism o o1, forall m2 : Morphism o o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismE m1 (mcomp (mprodi m1 m2) (mprode1 o1 o2)).
  Parameter mprode2e : forall o o1 o2 : Object, forall m1 : Morphism o o1, forall m2 : Morphism o o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m1 -> MorphismV m2 -> MorphismE m2 (mcomp (mprodi m1 m2) (mprode2 o1 o2)).
(* end hide *)

End CartesianCategory.


(* begin hide *)
Module CartesianCategoryTools (Import CC : CartesianCategory).
  Module CT := CategoryTools CC.
  Include CT.

  Hint Resolve ounitv munitiv munitie.

  Hint Resolve oprodv mprodiv mprode1v mprode2v mprodie mprode1e mprode2e.

End CartesianCategoryTools.
(* end hide *)


(** *** Definition of a Cartesian-Closed Category *)
(** This definition is standard. We include here only the structural components so that the reader may be introduced the notation. *)

Module Type CartesianClosedCategory.
  Include CartesianCategory.

  Parameter oexp : Object -> Object -> Object.
(* begin hide *)
  Parameter oexpv : forall o1 o2 : Object, ObjectV o1 -> ObjectV o2 -> ObjectV (oexp o1 o2).

(* end hide *)
  Parameter mexpi : forall {o o1 o2 : Object}, Morphism (oprod o o1) o2 -> Morphism o (oexp o1 o2).
(* begin hide *)
  Parameter mexpiv : forall o o1 o2 : Object, forall m : Morphism (oprod o o1) o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismV (mexpi m).

(* end hide *)
  Parameter mexpe : forall o1 o2 : Object, Morphism (oprod (oexp o1 o2) o1) o2.
(* begin hide *)
  Parameter mexpev : forall o1 o2 : Object, ObjectV o1 -> ObjectV o2 -> MorphismV (mexpe o1 o2).

  Parameter mexpie : forall o o1 o2 : Object, forall m : Morphism o (oexp o1 o2), forall m' : Morphism (oprod o o1) o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismV m' -> MorphismE m' (mcomp (mprodi (mcomp (mprode1 o o1) m) (mprode2 o o1)) (mexpe o1 o2)) -> MorphismE m (mexpi m').
  Parameter mexpee : forall o o1 o2 : Object, forall m : Morphism (oprod o o1) o2, ObjectV o -> ObjectV o1 -> ObjectV o2 -> MorphismV m -> MorphismE m (mcomp (mprodi (mcomp (mprode1 o o1) (mexpi m)) (mprode2 o o1)) (mexpe o1 o2)).
(* end hide *)

End CartesianClosedCategory.


(* begin hide *)
Module CartesianClosedCategoryTools (Import CCC : CartesianClosedCategory).
  Module CCT := CartesianCategoryTools CCC.
  Include CCT.

  Hint Resolve oexpv mexpiv mexpev mexpie mexpee.

End CartesianClosedCategoryTools.
(* end hide *)


(** *** Definition of a Nautral-Number Object *)
(** This definition is standard. We include here only the structural components so that the reader may be introduced the notation. *)

Module Type NaturalNumberObject (CC : CartesianCategory).
  Import CC.

  Parameter onat : Object.
(* begin hide *)
  Parameter onatv : ObjectV onat.
(* end hide *)

  Parameter mnatiz : Morphism ounit onat.
(* begin hide *)
  Parameter mnatizv : MorphismV mnatiz.

(* end hide *)
  Parameter mnatis : Morphism onat onat.
(* begin hide *)
  Parameter mnatisv : MorphismV mnatis.

(* end hide *)
  Parameter mnate : forall {o : Object}, Morphism ounit o -> Morphism o o -> Morphism onat o.
(* begin hide *)
  Parameter mnatev : forall o : Object, forall mz : Morphism ounit o, forall ms : Morphism o o, ObjectV o -> MorphismV mz -> MorphismV ms -> MorphismV (mnate mz ms).

  Parameter mnatze : forall o : Object, forall mz : Morphism ounit o, forall ms : Morphism o o, ObjectV o -> MorphismV mz -> MorphismV ms -> MorphismE mz (mcomp mnatiz (mnate mz ms)).
  Parameter mnatse : forall o : Object, forall mz : Morphism ounit o, forall ms : Morphism o o, ObjectV o -> MorphismV mz -> MorphismV ms -> MorphismE (mcomp (mnate mz ms) ms) (mcomp mnatis (mnate mz ms)).
  Parameter mnatee : forall o : Object, forall m : Morphism onat o, forall mz : Morphism ounit o, forall ms : Morphism o o, ObjectV o -> MorphismV m -> MorphismV mz -> MorphismV ms -> MorphismE mz (mcomp mnatiz m) -> MorphismE (mcomp m ms) (mcomp mnatis m) -> MorphismE m (mnate mz ms).
(* end hide *)

End NaturalNumberObject.


(* begin hide *)
Module NaturalNumberObjectTools (CC : CartesianCategory) (NNO : NaturalNumberObject CC).
  Import NNO.

  Hint Resolve onatv mnatizv mnatisv mnatev.

End NaturalNumberObjectTools.
(* end hide *)
