Require Import Common.
(** printing SET $\mathbf{Set}$ *)
(** printing Empty $\varnothing$ *)
(** printing True %\coqdockw{True}% *)
(** printing False %\coqdockw{False}% *)
(** printing exists $\exists$ *)
(** printing exists2 $\exists$ *)
(** printing exists3 $\exists$ *)
(** printing & $\mathrel{\wedge}$ *)
(** printing nat $\N$ *)
(** printing bool $\B$ *)
(** printing fun $\lambda\!$ *)
(** printing => $\mapsto$ *)
(** printing IV $\isa{I}$ *)
(** printing EV $\iseq{I}$ *)
(** printing <: $<:$ *)
(** printing None $\mathit{None}$ *)
(** printing Some $\mathit{Some}$ *)
(** printing {| $\{\mathord{\mid}$ *)
(** printing |} $\mathord{\mid}\}$ *)
Require Import Categories.
(** printing Object $\mathcal{O}$ *)
(** printing ObjectV $\isa{\mathcal{O}}$ *)
(** printing Morphism $\leadsto$ *)
(** printing MorphismV $\isa{\leadsto}$ *)
(** printing MorphismE $\iseq{\leadsto}$ *)
(** printing mid $\textit{id}$ *)
(** printing mcomp $\mathop{;}$ *)
Require Import Cartesian.
(** printing ounit $\mathbf{1}$ *)
(** printing muniti $\mathbf{!}$ *)
(** printing oprod $\times$ *)
(** printing mprodi $\langle \cdot, \cdot \rangle$ *)
(** printing mprode1 $\pi_1$ *)
(** printing mprode2 $\pi_2$ *)
(** printing oexp $\Rightarrow$ *)
(** printing mexpi $\Lambda$ *)
(** printing mexpe $\textbf{eval}$ *)
(** printing onat $\textbf{N}$ *)
(** printing mnatiz $\textbf{Z}$ *)
(** printing mnatis $\textbf{S}$ *)
(** printing mnate $\textbf{rec}_\textbf{N}$ *)
Require Import Sets.
(** printing set $\mathit{set}$ *)
(** printing setv $\isa{\coqdocvar{set}}$ *)
(** printing sete $\iseq{\coqdocvar{set}}$ *)
Require Import SCAs.
(** printing State $\Sigma$ *)
(** printing StateV $\isa{\Sigma}$ *)
(** printing Fut $\leq$ *)
(** printing Code $C$ *)
(** printing PCA.CodeV $\isa{C}$ *)
(** printing Red $\downarrow$ *)
(** printing EVar $V$ *)
(** printing ExprVar $E_?$ *)
(** printing evar $\mathit{evar}$ *)
(** printing eapp $\app$ *)
(** printing Expr $E_0$ *)
(** printing econst $\!\!$ *)
(** printing EVarV $\isa{V}$ *)
(** printing ExprVarV $\isa{E}$ *)
(** printing esubst $e[\cdot]$ *)
(** printing RedExpr $\downarrow_E$ *)
(** printing progress $\mathit{progress}$ *)
(** printing cencode $c_\lambda$ *)
Require Import HOFs.
(** printing PROP $\Phi$ *)
(** printing PROPV $\isa{\Phi}$ *)
(** printing Entails $\vdash$ *)
(** printing subst $\dot{\phi}[\cdot]$ *)
(** printing top $\top$ *)
(** printing conj $\conj$ *)
(** printing bot $\bot$ *)
(** printing disj $\disj$ *)
(** printing imp $\imp$ *)
(** printing sforall $\forall$ *)
(** printing sexists $\exists$ *)
(** printing seq $=$ *)
(** printing oprop $\Omega$ *)
(** printing character $\chi$ *)
(** printing holds $\mathit{holds}$ *)
(** printing isnat $\isnat$ *)
Require Import SCAstoHOFs.
(** printing cnat $c^\lambda_\cdot$ *)
Require Import CountableChoice.
(** printing cc $\cc$ *)
Require Import Lambdas.
(** printing Lambda $L$ *)
(** printing LambdaV $\isa{L}$ *)
(** printing lsubst $\ell[\cdot] *)
(** printing lcode $(\cdot)$ *)
(** printing lapp $\app$ *)
(** printing Prim $P$ *)
(** printing PrimV $\isa{P}$ *)
(** printing PCode $C_?$ *)
(** printing cprim $(\cdot)$ *)
(** printing clam $\lambda^\cdot$ *)
(** printing PCodeV $\isa{C_?}$ *)
Require Import FreeSCA.
(** printing RedLambda $\downarrow_c^\lambda$ *)
(** printing RedCode $\downarrow_c^{C_?}$ *)
(** printing RedPrim $\downarrow_c^p$ *)
(** printing TermLambda $\downarrow^\lambda$ *)
(** printing TermCode $\downarrow^{C_?}$ *)
(** printing TermPrim $\downarrow^p$ *)
Require Import Peano_dec.
Require Import PeanoNat.
Require Import List.
Require Import Plus.
Import Nat.
(**)
(** printing Loc $\mathcal{L}$ *)
(** printing pnd $\nd$ *)
(** printing palloc $\alloc$ *)
(** printing plookup $\lookup$ *)
(** printing RedLambdaFrozen $\downarrow^\lambda_\varsigma$ *)
(** printing RedCodeFrozen $\downarrow^{C_?}_\varsigma$ *)
(** printing RedPrimFrozen $\downarrow^p_\varsigma ?$ *)
(**)
(** printing s $\sigma$ *)
(** printing s' $\sigma'$ *)
(** printing s'' $\sigma''$ *)
(** printing cf $c_f$ *)
(** printing ca $c_a$ *)
(** printing cr $c_r$ *)
(** printing Pr $\phi_r$ *)
(** printing Pr' $\phi_r'$ *)
(** printing Pi $\phi_\cdot$ *)
(** printing ef $e_f$ *)
(** printing ea $e_a$ *)
(** printing pf $p_f$ *)
(** printing l $\ell$ *)
(** printing l' $\ell'$ *)
(** printing cnat $c^\lambda_\cdot$ *)
(**)
(** printing Prim' $P$ *)
(** printing State' $\Sigma$ *)
(** printing Fut' $\leq$ *)
(** printing PrimV' $\isa{P}$ *)
(** printing StateV' $\isa{\Sigma}$ *)
(** printing TermPrim' $\downarrow^p$ *)
(** printing RedCodeFrozen' $\Downarrow^{C_?}_\varsigma$ *)
(** printing RedPrimFrozen' $\Downarrow^p_\varsigma ?$ *)


(** *** Definition of %\Mem{}% *)
(** This is the formal definition of %\Mem{}% in Figure %\ref{fig:mem-sca}%.
    It uses the [FreeSCA] module for $\lambda$-terms, so the following module specifies the primitives and their behavior.
    There are a few differences between this definition and that in Figure %\ref{fig:mem-sca}%, all for the sake of reducing metatheoretic assumptions.
    In particular, [State] (i.e. the set of $\varsigma$s) is defined inductively as a sequence of allocation/memoization events, and [Fut] is simply to be defined to be prefix.
    This means that if a pre-state has two predecessors, then one of the those predecessors must be a future of the other.
    It also means that if a location-input pair has a memoization in the current pre-state, then we can determine via [sfirst] the first point in the past where that pair was allocated in the pre-state.
    Any subsequent futures will have that same first state for the given entry, as proven by [sfirst_fut_eq].
    This means that we can take a choice relation that is _not_ future-stable, and define from it a choice relation that _is_ future-stable by having every state instead the choice for a particular entry that was assigned to its first predecessor that had that entry (which might be itself).
    Beyond this, the proof is the same is given in %Theorem~\ref{mem-cc}%. *)

Module MemoizingApplicativeStructure <: PrimitiveApplicativeStructure.
  Import FreeStatefulCombinatoryCode.

(** **** Primitives and Pre-States *)

  Definition Loc : SET := nat.
  Inductive Prim' : SET := pnd | palloc | plookup (l : Loc).
(* begin hide *)
  Definition Prim : SET
  := Prim'.
(* end hide *)

  Inductive State' : SET := sempty | sallocate (s : State') (l : Loc) (cf : PCode Prim) | smemoize (s : State') (l : Loc) (n : nat) (cr : PCode Prim).
(* begin hide *)
  Definition State : SET
  := State'.
(* end hide *)

  Inductive Fut' (s : State) : State -> Prop
  := frefl' : Fut' s s
   | fallocate (s' : State) (l : Loc) (cf : PCode Prim) : Fut' s s' -> Fut' s (sallocate s' l cf)
   | fmemoize (s' : State) (l : Loc) (n : nat) (cr : PCode Prim) : Fut' s s' -> Fut' s (smemoize s' l n cr).
(* begin hide *)
  Definition Fut : State -> State -> Prop
  := Fut'.
(* end hide *)

  Lemma ftrans' (s s' s'' : State) : Fut s s' -> Fut s' s'' -> Fut s s''.
    intros ss' s's''. induction s's''; try constructor; assumption.
  Qed.

  Lemma flinear {s1 s2 s' : State} : Fut s1 s' -> Fut s2 s' -> Fut s1 s2 \/ Fut s2 s1.
    intros s1s' s2s'. induction s2s'.
     left. assumption.
     inversion s1s'; clear s1s'; subst.
      right. constructor. assumption.
      auto.
     inversion s1s'; clear s1s'; subst.
      right. constructor. assumption.
      auto.
  Qed.

  Inductive Allocated (s : State) (l : Loc) (cf : PCode Prim) : Prop := aallocate (sa : State) : Fut (sallocate sa l cf) s -> Allocated s l cf.
  Inductive Memoized (s : State) (l : Loc) (n : nat) (cr : PCode Prim) : Prop := mmemoize (sm : State) : Fut (smemoize sm l n cr) s -> Memoized s l n cr.
  Inductive PrimV' (s : State) : Prim -> Prop
  := pndv : PrimV' s pnd
   | pallocv : PrimV' s palloc
   | plookupv (n : nat) (cf : PCode Prim) : Allocated s n cf -> PrimV' s (plookup n).
(* begin hide *)
  Definition PrimV : State -> Prim -> Prop
  := PrimV'.
(* end hide *)

  Lemma allocated_fut (s s' : State) (l : Loc) (cf : PCode Prim) : Fut s s' -> Allocated s l cf -> Allocated s' l cf.
    intros ss' a. destruct a as [ sa sas ]. exists sa. apply ftrans' with s; assumption.
  Qed.
  Lemma memoized_fut (s s' : State) (l : Loc) (n : nat) (cr : PCode Prim) : Fut s s' -> Memoized s l n cr -> Memoized s' l n cr.
    intros ss' m. destruct m as [ sm sms ]. exists sm. apply ftrans' with s; assumption.
  Qed.
  Lemma primv_fut' (s s' : State) (p : Prim) : Fut s s' -> PrimV s p -> PrimV s' p.
    intros ss' pv. destruct pv as [ | | n cf a ]; try constructor. apply plookupv with cf. apply allocated_fut with s; assumption.
  Qed.
  Lemma pcodev_fut' (s s' : State) (c : PCode Prim) : Fut s s' -> PCodeV (PrimV s) c -> PCodeV (PrimV s') c.
   intro ss'. apply pcodev_mono. intro p. apply primv_fut'; assumption.
  Qed.

  Fixpoint cchurch {Prim : SET} (n : nat) : PCode Prim
  := match n with 0 => clam 1 (lvar 2 (Some None)) | S n => clam 1 (lapp (lvar 2 None) (lapp (lapp (lcode (cchurch n)) (lvar 2 None)) (lvar 2 (Some None)))) end.
(* begin hide *)
  Lemma cchurchv (Prim : SET) (PrimV : Prim -> Prop) (n : nat) : PCodeV PrimV (cchurch n).
    induction n; simpl; auto.
  Qed.
(* end hide *)

(** **** Application within a Pre-State *)
(** These define _frozen_ reduction within a pre-state. *)

  Inductive RedPrimFrozen (s : State) : Prim -> PCode Prim -> PCode Prim -> Prop
  := rpfnd (ca : PCode Prim) (n : nat) : RedPrimFrozen s pnd ca (cchurch n)
   | rpfalloc (cf : PCode Prim) (l : Loc) : Allocated s l cf -> RedPrimFrozen s palloc cf (cprim (plookup l))
   | rpflookup (l : Loc) (n : nat) (cr : PCode Prim) : Memoized s l n cr -> RedPrimFrozen s (plookup l) (cchurch n) cr.
  Inductive RedLambdaFrozen (RedCodeFrozen : PCode Prim -> PCode Prim -> PCode Prim -> Prop) : Lambda (PCode Prim) 0 -> PCode Prim -> Prop
  := rlfcode (c : PCode Prim) : RedLambdaFrozen RedCodeFrozen (lcode c) c
   | rlfapp (lf la : Lambda (PCode Prim) 0) (cf ca cr : PCode Prim) : RedLambdaFrozen RedCodeFrozen lf cf -> RedLambdaFrozen RedCodeFrozen la ca -> RedCodeFrozen cf ca cr -> RedLambdaFrozen RedCodeFrozen (lapp lf la) cr.
  Inductive RedCodeFrozen (s : State) : PCode Prim -> PCode Prim -> PCode Prim -> Prop
  := rcprim (pf : Prim) (ca : PCode Prim) (cr : PCode Prim) : RedPrimFrozen s pf ca cr -> RedCodeFrozen s (cprim pf) ca cr
   | rclam0 (lb : Lambda (PCode Prim) 1) (ca cr : PCode Prim) : RedLambdaFrozen (RedCodeFrozen s) (lsubst ca lb) cr -> RedCodeFrozen s (clam 0 lb) ca cr
   | rclamS (n : nat) (lb : Lambda (PCode Prim) (S (S n))) (ca : PCode Prim) : RedCodeFrozen s (clam (S n) lb) ca (clam n (lsubst ca lb)).

  Lemma red_lambda_frozen_fut (RedCodeFrozen RedCodeFrozen' : PCode Prim -> PCode Prim -> PCode Prim -> Prop) (l : Lambda (PCode Prim) 0) (cr : PCode Prim) : (forall cf ca cr : PCode Prim, RedCodeFrozen cf ca cr -> RedCodeFrozen' cf ca cr) -> RedLambdaFrozen RedCodeFrozen l cr -> RedLambdaFrozen RedCodeFrozen' l cr.
    intros inclRed. revert l cr. fix red_lambda_frozen_fut 3. intros l cr r. destruct r as [ c | lf la cf ca cr rf ra rc ].
     apply rlfcode.
     apply rlfapp with cf ca.
      revert rf. apply red_lambda_frozen_fut.
      revert ra. apply red_lambda_frozen_fut.
      revert rc. apply inclRed.
  Defined.
  Lemma red_prim_frozen_fut (s s' : State) (pf : Prim) (ca : PCode Prim) (cr : PCode Prim) : Fut s s' -> RedPrimFrozen s pf ca cr -> RedPrimFrozen s' pf ca cr.
    intros ss' r. destruct r as [ ca n | cf l [ sa sas ] | l n cr [ sm sms ] ].
     apply rpfnd.
     apply rpfalloc. exists sa. apply ftrans' with s; assumption.
     apply rpflookup. exists sm. apply ftrans' with s; assumption.
  Qed.
  Lemma red_code_frozen_fut (s s' : State) (cf ca cr : PCode Prim) : Fut s s' -> RedCodeFrozen s cf ca cr -> RedCodeFrozen s' cf ca cr.
    intros ss'. revert cf ca cr. fix red_code_frozen_fut 4. intros cf ca cr r. destruct r as [ pf ca cr rp | lb ca cr rl | n lb ca ].
     apply rcprim. revert rp. apply red_prim_frozen_fut. assumption.
     apply rclam0. revert rl. apply red_lambda_frozen_fut; assumption.
     apply rclamS.
  Qed.

  Inductive UnAllocated : State -> Loc -> Prop
  := uaempty (lf : Loc) : UnAllocated sempty lf
   | uaallocate (lf : Loc) (s : State) (l : Loc) (cf : PCode Prim) : UnAllocated s lf -> (lf = l -> False) -> UnAllocated (sallocate s l cf) lf
   | uamemoized (lf : Loc) (s : State) (l : Loc) (n : nat) (cr : PCode Prim) : UnAllocated s lf -> UnAllocated (smemoize s l n cr) lf.
  Inductive UnMemoized : State -> Loc -> nat -> Prop
  := umempty (lf : Loc) (nf : nat) : UnMemoized sempty lf nf
   | umallocate (lf : Loc) (nf : nat) (s : State) (l : Loc) (cf : PCode Prim) : UnMemoized s lf nf -> UnMemoized (sallocate s l cf) lf nf
   | ummemoized (lf : Loc) (nf : nat) (s : State) (l : Loc) (n : nat) (cr : PCode Prim) : UnMemoized s lf nf -> (lf = l -> nf = n -> False) -> UnMemoized (smemoize s l n cr) lf nf.

  Lemma memoized_unmemoized_false (s : State) (l : Loc) (n : nat) (cr : PCode Prim) : Memoized s l n cr -> UnMemoized s l n -> False.
    intros [ sm sms ] um. induction sms; inversion um; clear um; subst; auto.
  Qed.

(** **** States *)
(** Rather than defining state validity by the behaviors we need of states, as in %Figure~\ref{fig:mem-sca}, we define state validity inductively and prove that it implies the necessary behaviors. *)

  Inductive StateV' : State -> Prop
  := semptyv : StateV' sempty
   | sallocatev (s : State) (l : Loc) (cf : PCode Prim) : StateV' s -> UnAllocated s l -> PCodeV (PrimV s) cf -> StateV' (sallocate s l cf)
   | smemoizev (s : State) (l : Loc) (n : nat) (cr : PCode Prim) (cf : PCode Prim) : StateV' s -> Allocated s l cf -> UnMemoized s l n -> PCodeV (PrimV s) cr -> RedCodeFrozen s cf (cchurch n) cr -> StateV' (smemoize s l n cr).
(* begin hide *)
  Definition StateV : State -> Prop
  := StateV'.
(* end hide *)
  Lemma statev_fut (s s' : State) : Fut s s' -> StateV s' -> StateV s.
    intros ss' sv'. induction ss'; try assumption; inversion sv'; clear sv'; subst; auto.
  Qed.

  Lemma allocated_det (s : State) (sv : StateV s) (l : Loc) (cf cf' : PCode Prim) : Allocated s l cf -> Allocated s l cf' -> cf = cf'.
    intros [ sa sas ] [ sa' sa's ]. pose proof (flinear sas sa's) as [ sasa' | sa'sa ].
     apply statev_fut in sa's; try assumption. clear s sv sas. inversion sasa'; clear sasa'; subst.
      reflexivity.
      elimtype False. inversion sa's; clear sa's; subst. rename H0 into sasa'. rename H4 into ua. clear H3 H5. induction sasa'; inversion ua; clear ua; subst; auto.
     apply statev_fut in sas; try assumption. clear s sv sa's. inversion sa'sa; clear sa'sa; subst.
      reflexivity.
      elimtype False. inversion sas; clear sas; subst. rename H0 into sa'sa. rename H4 into ua. clear H3 H5. induction sa'sa; inversion ua; clear ua; subst; auto.
   Qed.
  Lemma memoized_det (s : State) (sv : StateV s) (l : Loc) (n : nat) (cr cr' : PCode Prim) : Memoized s l n cr -> Memoized s l n cr' -> cr = cr'.
    intros [ sm sms ] [ sm' sm's ]. pose proof (flinear sms sm's) as [ smsm' | sm'sm ].
     apply statev_fut in sm's; try assumption. clear s sv sms. inversion smsm'; clear smsm'; subst.
      reflexivity.
      elimtype False. inversion sm's; clear sm's; subst. rename H0 into smsm'. rename H6 into um. clear H4 H5 H7 H8. induction smsm'; inversion um; clear um; subst; auto.
     apply statev_fut in sms; try assumption. clear s sv sm's. inversion sm'sm; clear sm'sm; subst.
      reflexivity.
      elimtype False. inversion sms; clear sms; subst. rename H0 into sm'sm. rename H6 into um. clear H4 H5 H7 H8. induction sm'sm; inversion um; clear um; subst; auto.
  Qed.
  Lemma allocated_valid (s : State) (sv : StateV s) (l : Loc) (cf : PCode Prim) : Allocated s l cf -> PCodeV (PrimV s) cf.
    intros [ sa sas ]. apply pcodev_fut' with sa.
     apply ftrans' with (sallocate sa l cf); try assumption. constructor. apply frefl'.
     apply statev_fut in sas; try assumption. inversion sas; clear sas; subst; auto.
  Qed.
  Lemma memoized_valid (s : State) (sv : StateV s) (l : Loc) (n : nat) (cr : PCode Prim) : Memoized s l n cr -> PCodeV (PrimV s) cr.
    intros [ sm sms ]. apply pcodev_fut' with sm.
     apply ftrans' with (smemoize sm l n cr); try assumption. constructor. apply frefl'.
     apply statev_fut in sms; try assumption. inversion sms; clear sms; subst; auto.
  Qed.
  Lemma memoized_allocated (s : State) (sv : StateV s) (l : Loc) (n : nat) (cr : PCode Prim) : Memoized s l n cr -> exists cf : PCode Prim, Allocated s l cf.
    intros [ sm sms ]. assert (exists cf : PCode Prim, Allocated sm l cf) as [ cf a ].
     apply statev_fut in sms; try assumption. inversion sms; clear sms; subst; eauto.
     exists cf. apply allocated_fut with sm; try assumption. apply ftrans' with (smemoize sm l n cr); try assumption. constructor. apply frefl'.
  Qed.
  Lemma memoized_red (s : State) (sv : StateV s) (l : Loc) (cf : PCode Prim) (n : nat) (cr : PCode Prim) : Allocated s l cf -> Memoized s l n cr -> RedCodeFrozen s cf (cchurch n) cr.
    intros a [ sm sms ]. assert (Fut sm s) as sms'.
     apply ftrans' with (smemoize sm l n cr); try assumption. constructor. apply frefl'.
     apply red_code_frozen_fut with sm; try assumption. apply statev_fut in sms; try assumption. inversion sms; clear sms; subst. rename cf0 into cf'. replace cf with cf'; try assumption. apply (allocated_det s sv) with l; try assumption. apply allocated_fut with sm; assumption.
  Qed.

  Lemma sinhabited : exists s : State, StateV s.
    exists sempty. constructor.
  Qed.
  Lemma frefl (s : State) : StateV s -> Fut s s.
    intros _. apply frefl'.
  Qed.
  Lemma ftrans (s s' s'' : State) : StateV s -> StateV s' -> StateV s'' -> Fut s s' -> Fut s' s'' -> Fut s s''.
    intros _ _ _. apply ftrans'.
  Qed.
  Lemma primv_fut (s s' : State) (p : Prim) : StateV s -> StateV s' -> Fut s s' -> PrimV s p -> PrimV s' p.
    intros _ _. apply primv_fut'.
  Qed.
  Lemma pcodev_fut (s s' : State) (c : PCode Prim) : StateV s -> StateV s' -> Fut s s' -> PCodeV (PrimV s) c -> PCodeV (PrimV s') c.
   intros sv sv' ss'. apply pcodev_mono. intro p. apply primv_fut; assumption.
  Qed.

(** **** Application and Termination with States *)
(** This defines the application relation that _does_ mutate pre-state. *)

  Definition RedPrim (s : State) (pf : Prim) (ca : PCode Prim) (s' : State) (cr : PCode Prim) : Prop := Fut s s' /\ StateV s' /\ RedPrimFrozen s' pf ca cr.
  Inductive TermPrim' (s : State) : Prim -> PCode Prim -> Prop
  := tpfnd (ca : PCode Prim) : TermPrim' s pnd ca
   | tpfalloc (cf : PCode Prim) : TermPrim' s palloc cf
   | tpflookup (l : Loc) (n : nat) (cf : PCode Prim) : Allocated s l cf -> TermCode RedPrim TermPrim' s cf (cchurch n) -> TermPrim' s (plookup l) (cchurch n).
(* begin hide *)
  Definition TermPrim : State -> Prim -> PCode Prim -> Prop := TermPrim'.
(* end hide *)

(** **** Progress *)

  Lemma preservation_prim (s : State) (pf : Prim) (ca : PCode Prim) (s' : State) (cr : PCode Prim) : StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> RedPrim s pf ca s' cr -> StateV s' /\ Fut s s' /\ PCodeV (PrimV s') cr.
    intros sv pfv cav [ ss' [ sv' rp ] ]. repeat apply conj; try assumption. destruct rp.
     apply cchurchv.
     apply plookupv with cf. assumption.
     apply (memoized_valid s' sv') with l n. assumption.
  Qed.

(* begin hide *)
  Definition preservation_code := preservation_code StateV Fut PrimV RedPrim frefl ftrans primv_fut preservation_prim.
  Definition progress_code := progress_code StateV Fut PrimV RedPrim TermPrim frefl ftrans primv_fut preservation_prim.
  Definition preservation_lambda := preservation_lambda StateV Fut (fun s => PCodeV (PrimV s)) (RedCode RedPrim) frefl ftrans pcodev_fut preservation_code.
  Definition progress_lambda := progress_lambda StateV Fut (fun s => PCodeV (PrimV s)) (RedCode RedPrim) (TermCode RedPrim TermPrim) frefl ftrans pcodev_fut preservation_code.
(* end hide *)

  Lemma new (s : State) : (exists l : Loc, forall l' : Loc, l <= l' -> UnAllocated s l').
    induction s.
     exists 0. intros l' _. constructor.
     destruct IHs as [ lna na ]. exists (max lna (S l)). intros l' lnal'. pose proof lnal' as ll'. apply max_lub_l in lnal'. constructor.
      apply na. assumption.
      apply max_lub_r in ll'. intro e. destruct e. apply lt_irrefl in ll'. assumption.
     destruct IHs as [ lna na ]. exists lna. intros l' lnal'. constructor. apply na. assumption.
  Qed.
  Lemma memoized (s : State) (l : Loc) (n : nat) : (exists cr : PCode Prim, Memoized s l n cr) \/ (UnMemoized s l n).
   induction s.
    right. constructor.
    destruct IHs as [ [ cr [ sm sms ] ] | um ].
     left. exists cr. exists sm. constructor. assumption.
     right. constructor. assumption.
    destruct IHs as [ [ cr' [ sm sms ] ] | um ].
     left. exists cr'. exists sm. constructor. assumption.
     destruct (eq_nat_dec l l0) as [ le | nle ].
      destruct le. destruct (eq_nat_dec n n0) as [ ne | nne ].
       destruct ne. left. exists cr. exists s. apply frefl'.
       right. constructor; try assumption. intros _. assumption.
      right. constructor; try assumption. intros e _. auto.
  Qed.
  Lemma red_code_freeze (s : State) (cf ca : PCode Prim) (s' : State) (cr : PCode Prim) : StateV s -> PCodeV (PrimV s) cf -> PCodeV (PrimV s) ca -> RedCode RedPrim s cf ca s' cr -> RedCodeFrozen s' cf ca cr.
    revert s cf ca s' cr. fix red_code_freeze 9. intros s cf ca s' cr sv cfv cav rc. induction rc.
     rename H into rp. constructor. apply rp.
     rename H into rl. constructor. revert rl. assert (LambdaV (PCodeV (PrimV s)) (lsubst ca lb)) as lv; [ apply lsubstv; assumption | revert lv ]. generalize (lsubst ca lb). clear lb cfv ca cav. intros l lv rl. induction rl.
      constructor.
      rename rl1 into rf. rename rl2 into ra. rename IHrl1 into IHrf. rename IHrl2 into IHra. rename H into rc. destruct lv as [ lfv lav ]. apply preservation_lambda in rf; try assumption. destruct rf as [ sv' [ ss' cfv ] ]. apply lambdav_mono with (CodeV' := PCodeV (PrimV s')) in lav; try (intro c; apply pcodev_mono; intro p; apply primv_fut; assumption). apply preservation_lambda in ra; try assumption. destruct ra as [ sv'' [ s's'' cav ] ]. pose proof rc as rc'. apply pcodev_fut with (s' := s'') in cfv; try assumption. apply preservation_code in rc'; try assumption. destruct rc' as [ sv''' [ s''s''' crv ] ]. apply rlfapp with cf ca.
       apply red_lambda_frozen_fut with (RedCodeFrozen s'); try auto. clear s sv lf la lfv lav cf ca cr ss' cfv cav rc IHrf IHra crv. intros cf ca cr. apply red_code_frozen_fut. apply ftrans with s''; assumption.
       apply red_lambda_frozen_fut with (RedCodeFrozen s''); try auto. clear s sv lf la lfv lav s' cf ca cr sv' ss' cfv s's'' cav rc IHrf IHra crv. intros cf ca cr. apply red_code_frozen_fut. assumption.
       apply red_code_freeze in rc; assumption.
     constructor.
  Qed.
  Lemma red_code_thaw (s : State) (cf ca : PCode Prim) (cr : PCode Prim) : StateV s -> RedCodeFrozen s cf ca cr -> RedCode RedPrim s cf ca s cr.
    revert s cf ca cr. fix red_code_thaw 6. intros s cf ca cr sv rc. induction rc.
     rename H into rp. constructor. repeat split; try apply frefl; assumption.
     rename H into rl. constructor. revert rl. generalize (lsubst ca lb). clear lb ca. intros l rl. induction rl.
      constructor.
      clear rl1 rl2. rename IHrl1 into IHrf. rename IHrl2 into IHra. rename H into rc. apply rlapp with s cf s ca; try assumption. apply red_code_thaw; assumption.
     constructor.
  Qed.

  Lemma progress_prim (s : State) (pf : Prim) (ca : PCode Prim) : StateV s -> PrimV s pf -> PCodeV (PrimV s) ca -> TermPrim s pf ca -> exists s' : State, exists cr : PCode Prim, RedPrim s pf ca s' cr.
    revert s pf ca. fix progress_prim 7. intros s pf ca sv pfv cav t. destruct t as [ ca | cf | l n cf a t ].
     exists s. exists (cchurch 0). repeat apply conj.
      apply frefl'.
      assumption.
      constructor.
     pose proof (new s) as [ l na ]. exists (sallocate s l cf). exists (cprim (plookup l)). repeat apply conj.
      constructor. apply frefl'.
      constructor; try assumption. apply na. reflexivity.
      constructor. apply aallocate with s. apply frefl'.
     pose proof (memoized s l n) as [ [ cr m ] | _ ].
      exists s. exists cr. repeat apply conj.
       apply frefl'.
       assumption.
       constructor. assumption.
      pose proof a as cfv. apply (allocated_valid s sv) in cfv. apply progress_code in t; try assumption. destruct t as [ s' [ cr r ] ]. pose proof r as r'. apply preservation_code in r'; try assumption. destruct r' as [ sv' [ ss' crv ] ]. destruct (memoized s' l n) as [ [ cr' m ] | nm ].
       clear cr r crv. exists s'. exists cr'. repeat apply conj; try assumption. constructor. assumption.
       exists (smemoize s' l n cr). exists cr. repeat apply conj.
        constructor. assumption.
        clear progress_prim. apply smemoizev with cf; try assumption.
         apply allocated_fut with s; assumption.
         apply red_code_freeze in r; assumption.
        constructor. exists s'. apply frefl'.
  Qed.

End MemoizingApplicativeStructure.


(** *** Proof that %\Mem{}% is an SCA. *)
(** %\label{coq:mem-sca}%The proof of %Lemma~\ref{mem-sca}% is a trival application of the [FreeSCA] module. *)

Module MemoizingSCA := FreeStatefulCombinatoryAlgebra MemoizingApplicativeStructure.


(** *** Proof that %\Mem{}% Internally Models Countable Choice *)
(** %\label{coq:mem-cc}%The detailed proof of %Theorem~\ref{mem-cc}% is elided here, but we provide the primary lemmas to provide some insight. *)

Module MemoizingCC.
(* begin hide *)
  Import MemoizingApplicativeStructure.
  Import StatefulApplicativeExpression.
  Import MemoizingSCA.
  Module CCinSCA := CCinSCA MemoizingSCA.
  Import CCinSCA.
  Import HOF.
  Import InhabitedSets.
  Import InhabitedSetsNat.
  Import CC.
  Import SCAT.
(* end hide *)

(** Here we assume the axiom of countable choice in the metatheory, asserting without proof that the set of states [State] and the set of codes [C] are both countable, and that [StateV], [Fut], and [Memoized] are each recognizable predicates so that the subset of states and codes satisfying them is also countable. *)

  Axiom axiom_of_countable_choice : forall I : SET, forall IV : I -> Prop, forall s : State, forall l : Loc, forall R : nat -> I -> State -> Code -> Prop, (forall n : nat, forall s' : State, forall c : Code, StateV s' -> Fut s s' -> Memoized s' l n c -> exists2 i : I, IV i & R n i s' c) -> exists3 S : nat -> I -> State -> Code -> Prop, (forall n : nat, forall i : I, forall s' : State, forall c : Code, S n i s' c -> R n i s' c) & (forall n : nat, forall i i' : I, forall s' : State, forall c : Code, S n i s' c -> S n i' s' c -> i = i') & forall n : nat, forall s' : State, forall c : Code, StateV s' -> Fut s s' -> Memoized s' l n c -> exists2 i : I, IV i & S n i s' c.

(* begin hide *)
  Lemma cnat_cchurch (n : nat) : cnat n = cchurch n.
    induction n; simpl; unfold cencode; simpl; repeat f_equal. assumption.
  Qed.
  Lemma cchurch_mono (n n' : nat) : (@cchurch Prim n) = (@cchurch Prim n') -> n = n'.
    revert n'. induction n as [ | n IHn ]; intros [ | n' ]; simpl; intro e.
     reflexivity.
     inversion e; clear e; subst.
     inversion e; clear e; subst.
     inversion e; clear e; subst. f_equal. apply IHn. assumption.
  Qed.
(* end hide *)

(** **** First predecessor with a given entry *)

  Fixpoint sfirst (l : Loc) (n : nat) (s : State) : State
  := match s with
     | sempty => sempty
     | sallocate s l' cf => sfirst l n s
     | smemoize s l' n' cr => if eq_dec l l' then if eq_dec n n' then smemoize s l' n' cr else sfirst l n s else sfirst l n s
     end.
  Lemma smemoize_sfirst_fut (s s' : State) (l : Loc) (n : nat) (cr : Code) : Fut (smemoize s l n cr) s' -> Fut (smemoize s l n cr) (sfirst l n s').
    intro ss'. induction ss'; simpl.
     destruct (eq_dec l l) as [ _ | ne ]; [ | elimtype False; auto ]. destruct (eq_dec n n) as [ _ | ne ]; [ | elimtype False; auto ]. apply frefl'.
     assumption.
     rename l0 into l'. rename n0 into n'. destruct (eq_dec l l') as [ _ | _ ]; try assumption. destruct (eq_dec n n') as [ _ | _ ]; try assumption. constructor. assumption.
  Qed.
  Lemma sfirst_memoized (l : Loc) (n : nat) (s : State) (cr : Code) : Memoized s l n cr -> Memoized (sfirst l n s) l n cr.
    intros [ sm sms ]. exists sm. apply smemoize_sfirst_fut. assumption.
  Qed.
  Lemma sfirst_fut_eq (l : Loc) (n : nat) (s s' : State) (cr : Code) : StateV s' -> Fut s s' -> Memoized s l n cr -> sfirst l n s = sfirst l n s'.
    intros sv' ss' [ sm sms ]. induction ss'; simpl.
     reflexivity.
     inversion sv'; clear sv'; subst. auto.
     rename l0 into l'. rename n0 into n'. inversion sv'; clear sv'; subst. destruct (eq_dec l l') as [ el | nel ]; try auto. destruct el. destruct (eq_dec n n') as [ en | nen ]; try auto. destruct en. elimtype False. apply memoized_unmemoized_false with s' l n cr; try assumption. exists sm. apply ftrans' with s; assumption.
  Qed.
  Lemma sfirst_fut (l : Loc) (n : nat) (s : State) : Fut (sfirst l n s) s.
    induction s; simpl.
     apply frefl'.
     constructor. assumption.
     rename l0 into l'. rename n0 into n'. destruct (eq_dec l l'); destruct (eq_dec n n'); try constructor; assumption.
  Qed.
  Lemma sfirst_unmemoized (s : State) (l : Loc) (n : nat) (s' : State) (cr : Code) : UnMemoized s l n -> Memoized s' l n cr -> Fut s s' -> Fut s (sfirst l n s').
    intros um [ sm sms' ] ss'. pose proof (flinear ss' sms') as [ ssm | sms ].
     clear ss'. apply ftrans' with (smemoize sm l n cr); try assumption. clear s um ssm. induction sms'; simpl.
      destruct (eq_dec l l) as [ _ | ne ]; [ | elimtype False; auto ]. destruct (eq_dec n n) as [ _ | ne ]; [ | elimtype False; auto ]. apply frefl'.
      assumption.
      rename l0 into l'. rename n0 into n'. destruct (eq_dec l l') as [ _ | _ ]; try assumption. destruct (eq_dec n n') as [ _ | _ ]; try assumption. constructor. assumption.
     elimtype False. clear s' sms' ss'. induction sms; inversion um; clear um; subst; auto.
  Qed.

(** **** Countable Choice *)
(*! [palloc] is indeed the realizer of countable choice in %\Mem{}%. *)

  Definition cc : Code := cencode 0 (ecode (cprim palloc)).
(* begin hide *)
  Lemma ccv : forall s : State, StateV s -> CodeV s cc.
    intros s sv. apply pallocv.
  Qed.
  Hint Resolve ccv.
(* end hide *)
  Theorem countable_choice (o : Object) : ObjectV o -> Entails (top ounit) (countable_choice o).
    intros ov. apply trans with (sca_countable_choice o); try apply sca_countable_choice_equiv; try auto. exists cc; try auto. intros [] s0 c _ sv0 cv _. unfold cc. termred; try (apply ecodev; constructor). intros R Rv. unfold subst. simpl. intros s ctot sv _ ctotv ptotctot. clear s0 c sv0 cv. split.
     constructor. constructor.
     intros s' cr rc. assert (StateV s' /\ Fut s s' /\ PCodeV (PrimV s') cr) as [ sv' [ ss' crv ] ] by (revert rc; apply preservation; try constructor; auto). inversion rc; clear rc; subst. rename H1 into rp. destruct rp as [ _ [ _ rp ] ]. inversion rp; clear rp; subst. clear crv. rename H into a. pose proof (axiom_of_countable_choice (set o) (setv o) s' l R) as [ S SR Sdet Stot ].
      intros n s'' cr sv'' s's'' m. assert (Fut s s'') as ss''; [ apply ftrans with s'; assumption | ]. pose proof m as crv. apply (memoized_valid s'' sv'') in crv. apply (memoized_red s'' sv'') with (cf := ctot) in m.
       pose proof (ptotctot n Logic.I s'' (cchurch n) sv'' ss'' (cchurchv _ _ n) (cnat_cchurch n)) as ptotctot. apply ptotctot; try apply frefl; try assumption. clear ptotctot. apply red_code_thaw; assumption.
       apply allocated_fut with s'; assumption.
      exists (fun n x s'' c => Fut s' s'' /\ Memoized s'' l n c /\ exists3 x', setv o x' & sete o x x' & ((UnMemoized s' l n -> S n x' (sfirst l n s'') c) /\ (Memoized s' l n c -> S n x' s' c))); simpl.
       split.
        intros n _. split.
         intros x xv s'' s''' cs sv'' sv''' s''s''' csv [ s's'' [ m scs ] ]. repeat split.
          apply ftrans' with s''; assumption.
          apply memoized_fut with s''; assumption.
          destruct scs as [ x' xv' xx' scs ]. exists x'; try assumption. split.
           destruct scs as [ scs _ ]. intro um. pose proof (scs um) as scs. rewrite <- sfirst_fut_eq with (s := s'') (cr := cs); assumption.
           destruct scs as [ _ scs ]. assumption.
         intros x x' xv xv' xx' s'' cs sv'' csv. split; intros [ s's'' [ m [ x'' xv'' xe scs ] ] ]; repeat split; try assumption; exists x''; try assumption.
          apply strans with x; try assumption. apply ssym; assumption.
          apply strans with x'; assumption.
        intros n n' _ _ nn' x x' xv xv' xx' s'' cs sv'' csv. destruct nn'. split; intros [ s's'' [ m [ x'' xv'' xe scs ] ] ]; repeat split; try assumption; exists x''; try assumption.
         apply strans with x; try assumption. apply ssym; assumption.
         apply strans with x'; assumption.
       repeat apply Logic.conj; simpl.
        unfold sca_included. intros n x s'' cs xv sv'' csv [ s's'' [ m [ x' xv' xx' scs ] ] ]. assert (setv onat n) as nv by constructor. pose proof (memoized s' l n) as [ [ cs' m' ] | um ].
         destruct scs as [ _ scs ]. assert (cs = cs') as e.
          apply (memoized_det s'' sv'') with l n; try assumption. apply memoized_fut with s'; assumption.
          destruct e. pose proof (scs m') as scs. apply SR in scs. apply Rv with x'; try auto. revert scs. apply Rv; try assumption. apply memoized_valid in m'; assumption.
         destruct scs as [ scs _ ]. pose proof (scs um) as scs. apply SR in scs. apply Rv with x'; try auto. revert scs. apply sfirst_memoized in m. pose proof (sfirst_fut l n s'') as sfs''. pose proof sfs'' as sfv. apply statev_fut in sfv; try assumption. apply memoized_valid in m; try assumption. apply Rv; assumption.
        unfold sca_determined. intros n x x' s'' cs cs' xv xv' sv'' csv csv' [ s's'' [ m [ x'' xv'' xx'' scs ] ] ] [ _ [ m' [ x''' xv''' x'x''' scs' ] ] ]. assert (cs = cs') as e.
         apply (memoized_det s'' sv'') with l n; assumption.
         destruct e. pose proof (memoized s' l n) as [ [ cs' m'' ] | um ].
          assert (cs = cs') as e.
           apply (memoized_det s'' sv'') with l n; try assumption. apply memoized_fut with s'; assumption.
           destruct e. destruct scs as [ _ scs ]. pose proof (scs m'') as scs. destruct scs' as [ _ scs' ]. pose proof (scs' m'') as scs'. apply strans with x''; try assumption. apply ssym in x'x'''; try assumption. apply strans with x'''; try assumption. replace x''' with x''; try auto. revert scs scs'. apply Sdet.
          destruct scs as [ scs _ ]. pose proof (scs um) as scs. destruct scs' as [ scs' _ ]. pose proof (scs' um) as scs'. apply strans with x''; try assumption. apply ssym in x'x'''; try assumption. apply strans with x'''; try assumption. replace x''' with x''; try auto. revert scs scs'. apply Sdet.
        intros n nv s'' cn sv'' s's'' cnv pncn. unfold subst in pncn. simpl in pncn. rewrite <- pncn. rewrite cnat_cchurch. split.
         constructor. apply tpflookup with ctot.
          apply allocated_fut with s'; assumption.
          assert (Fut s s'') as ss''; [ apply ftrans with s'; assumption | ]. pose proof (ptotctot n Logic.I s'' cn sv'' ss'' cnv pncn) as ptotctot. destruct pncn. rewrite cnat_cchurch in ptotctot. apply ptotctot.
         intros s''' cr rc. assert (StateV s''' /\ Fut s'' s''' /\ CodeV s''' cr) as [ sv''' [ s''s''' crv ] ] by (revert rc; apply preservation; try auto using cchurchv; apply plookupv with ctot; try apply allocated_fut with s'; assumption). inversion rc; clear rc; subst. destruct H1 as [ _ [ _ rp ] ]. inversion rp; clear rp; subst. apply cchurch_mono in H0. subst. rename H1 into m. assert (Fut s' s''') as s's'''; [ apply ftrans with s''; assumption | ]. pose proof (memoized s' l n) as [ [ cr' m' ] | um ].
          assert (cr = cr') as e.
           apply (memoized_det s''' sv''') with l n; try assumption. apply memoized_fut with s'; assumption.
           destruct e. pose proof m' as x. apply Stot in x; try apply frefl'; try assumption. destruct x as [ x xv scr' ]. exists x; try assumption. repeat split; try assumption. simpl. exists x; try auto. split.
            intro um. elimtype False. apply memoized_unmemoized_false in m'; assumption.
            intros _. assumption.
          pose proof m as x. apply sfirst_memoized in x; try assumption. apply Stot in x; try assumption.
           destruct x as [ x xv scr ]. exists x; try assumption. repeat split; try assumption. simpl. exists x; try auto. split.
            intros _. assumption.
            intro m'. elimtype False. apply memoized_unmemoized_false in m'; assumption.
           apply statev_fut with s'''; try assumption. apply sfirst_fut.
           apply sfirst_unmemoized with cr; assumption.
  Qed.

End MemoizingCC.
