# Machine Functions
#
# 0.1 - Brittany Nkounkou, 17 Jun 2014
#       - defined canTerminate(machine)
# 0.2 - Stephen Longfield, 18 Jun 2014
#       - Added printGraphviz
# 0.3 - Stephen Longfield, 23 June 2014
#       - Editing printGraphviz to work with array par/seq

from machine_defs import *

# decides whether or not a machine can terminate
def canTerminate(machine):
	if machine.rep: return False
	
	type = machine.type
	content = machine.content
	
	if type == M_SMP:
		return True

	if type == M_GRD:
		return True
	
	elif type == M_SEQ:
		# Check termination condition in sequence
		for c in content:
			if canTerminate(c):
				continue
			else:
				return False
		return True
	
	elif type == M_PAR:
		# All of the parallel machines must be able to terminate
		return all([canTerminate(c) for c in content])
	
	elif type == M_SEL:
		# Check to see if any of them can terminate, early exit
		for mach in content:
			if canTerminate(mach):
				return True
		return False
	
	else:
		# For the NFA, call the procedure
		assert type == M_NFA
		return content.canTerminate()

# Inner recursion for printGraphviz
def printGraphvizRec(machine, n=0, n0=None):
	type = machine.type
	content = machine.content
	
	if type == M_SMP:
		if n0 is None:
			src = "gv" + str(n)
			n += 1
		else:
			src = n0
			n += 1
		tgt = "gv" + str(n)
		n += 1
		label = ""
		for p in machine.prbs:
			label += "#" + str(p) + " "
		for s in machine.snds:
			label += str(s) + "! "
		for r in machine.rcvs:
			label += str(r) + "? "
		for o in machine.occs: 
			label += str(o) + "!? " # Interrobang
		me = src + "->" + tgt
		if label != "":
			me += "[ label=\"" + label + "\"]"
		me += "\n"
		gv = ([src], [tgt], me, n)
	elif type == M_GRD:
		if n0 is None:
			src = "gv" + str(n)
			n += 1
		else:
			src = n0
			n += 1
		tgt = "gv" + str(n)
		n += 1
		label = ""
		for p in machine.prbs:
			label += "#" + str(p) + " "
		#if machine.content is not None:
	#		label += "w/o "
	#		for p in machine.content:
#				label += "#" + str(p) + " "
		me = src + "->" + tgt
		if label != "":
			me += "[ label=\"" + label + "\"]"
		me += "\n"
		gv = ([src], [tgt], me, n)
	elif type == M_SEQ:
		(src, tgt, me, n) = printGraphvizRec(content[0], n, n0)
		for c in content[1:]:
			if len(tgt) == 1:
				(s2, tgt, e, n) = printGraphvizRec(c, n-1, tgt[0])
				me += e
			else:
				jn = "gv" + str(n)
				n += 1
				for t in tgt:
					me += t + " -> " + jn + "\n"
				(s2, tgt, e, n) = printGraphvizRec(c, n, jn)
				me += e
		gv = (src, tgt, me, n)	
	elif type == M_PAR:
		src = []
		tgt = []
		# Put PAR inside a subgraph
		me = "subgraph cluster_par_" + str(n) + "{\n"
		n += 1
		for c in content:
			(s, t, e, n) = printGraphvizRec(c, n, None)
			me += e
			src += s
			tgt += t
		me += "label=\"||\";\n"
		me += "color=black;\n"
		me += "}\n"
		gv = (src, tgt, me, n)
	elif type == M_SEL:
		s = []
		t = []
		me = ""
		node0 = "gv" + str(n)
		n += 1
		# Put SEL inside a subgraph
		me = "subgraph cluster_sel_" + str(n) + "{\n"
		n += 1
		ms = ""
		for c in content:
			(sp, tp, mp, n) = printGraphvizRec(c, n, node0)
			s += sp
			t += tp
			ms += mp
		#for st in s:
		#	me += n0 + " -> " + st + "\n"
		me += ms
		me += "label=\"[]\";\n"
		me += "color=black;\n"
		me += "}\n"
		#me += str(t)
		gv = ([node0], t, me, n)
	else:
		assert type == M_NFA
		me = ""
		content.mergeNull()
		for e in content.edges:
			e = content.edgeLabel[e]
			me += str(e.head) + " -> " + str(e.tail) + "[ label=\"" + printLabel(e.label) + "\"]\n"
		gv = ([str(content.start)], [str(content.accept)], me, n) 
	
	# Check for repeat.  If so, connect targets to source through a new fake edge
	if machine.rep and type != M_NFA:
		if len(gv[0]) == len(gv[1]) == 1:
			me += gv[1][0] + " -> " + gv[0][0] + "\n"
			return (gv[0], [], me, n)
		else:
			rn = "gv" + str(n)
			n += 1
			for t in gv[1]:
				me += t + " -> " + rn + "\n"
			for s in gv[0]:
				me += rn + " -> " + s + "\n"
			return ([rn], [], me, n+1)
	else:
		return gv

# Prints out the NFA in a graphviz compatible format. This function mostly
#  just handles the outer formatting.
def printGraphviz(machine):
	me = "digraph G {\n"
	me += "node [shape=point];\n"
	(initial, final, gv, n) = printGraphvizRec(machine)
	me += gv + "\n"
	me += "}"
	return me
