#include "random.h"
#include "stdinc.h"

#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

static long IDUM = 314;
static long iy=0;
static long iv[NTAB];

void sRandom(long seed) {
	int j;
	long k;
	if(seed < 1) {
		fprintf(stderr, "Random seed must be positive.\n");
		exit(1);
	}
	IDUM = seed;
	for (j=NTAB+7;j>=0;j--) { 
		k= IDUM /IQ;
		IDUM = IA*( IDUM -k*IQ)-IR*k;
		if(IDUM < 0) IDUM += IM;
		if(j < NTAB) iv[j] = IDUM;
	}
	iy=iv[0];
}

float Random()
{
	int j;
	long k;
	float temp;

	k= IDUM / IQ; 
	IDUM = IA*(IDUM -k*IQ)-IR*k; 
	if(IDUM < 0) IDUM += IM; 
	j=iy/NDIV; 
	iy=iv[j]; 
	iv[j] = IDUM; 
	if ((temp=AM*iy) > RNMX) return RNMX; 
	else return temp;
}

