/***
*
* This file contains the core functions for the Gibbs-sampling algorithm. 
*
***/

#ifndef _GIBBS_ILR_H
#define _GIBBS_ILR_H

#include "gibbs_util.h"
#include "em_alg.h"


//------------------------------------------------------------
// Structs
//------------------------------------------------------------

//Struct for bookkeeping
typedef struct {
	char *fastafile; //filename of the sequence file
	int span; //given span of the motif (-l param)
	int numseqs; //number of sequences
	int numalphas; //set to 4 for nucleotides {A,C,G,T}

	//Gibbs options
	int numruns; // number of sampling runs (-t param)
	int trialIters; //number of trial updates iteration (less costly)
	int iterPlateauLen; // rapid convergence (-L param)

	long randseed; //random seed
	double pseudoweight; //pseudoweight is in [0,1]; default is 0.1
	int emStep; //number of EM steps

	//frequency of phase shifting [0,1]
	//setting phase shift to 1.0 will have column shift in every iteration
	double phaseShiftFreq; 


	//odds-ratio of each position in a sequence; dim = [max-length of sequences]
	double *posScore; 

	//Small (colder) temperature reduces the chance of the sampling step to go
	//astray from the correct motif. Smaller temperature (~ 0.9) seems to improve
	//the results. 
	double recipTemp; //reciprocal of temperature
	boolean useTemperature; //true if temperature == 1.0; false otherwise

	Dataset *data; 
	RunSet *runset; //stores results of all runs
	EmStruct *ems; //bookkeeping for EM algorithm
	FILE *fptr;

	//trackers - for output only
	int totalIters; //total number of iterations for all sampling runs
} Gibbs;

//---------------------------------------
// Functions
//---------------------------------------

//Main engine of Gibbs-sampling; returns the run-node of the best run
extern RunNode* runGibbs(Gibbs *gibbs);

//Deallocate the struct for bookkeeping and its children
extern void nilGibbs(Gibbs *gibbs );

#endif

