#ifndef _DATASET_IO_H
#define _DATASET_IO_H

#include "stdinc.h"

// A C G T
// 0 1 2 3

typedef struct {
	//sequence and site index starts at 0.
	char **seqs; //seqs[numseqs][seqLen[i]] = {0, 1, 2, 3}
	int numalphas;
	int	numseqs; //number of sequences
	int *seqLen; //length of each sequence
	int maxSeqLen;
	int pseudoweight;
	int	*count; // residue count
	int total; //sum(count)
	double *bgfreq;
	double *pseudocount;
	double sumOfPseudocount; 
} Dataset;

extern Dataset *openDataset(char *filename, int numalphas);
extern void initPseudocount(Dataset* data, double pseudoweight);
extern void printBackgroundFreq(FILE *fptr, Dataset *data);
extern char numToAlpha(char num);
extern void nilDataset(Dataset *);

#endif
