(* Brittany Nkounkou *)
(* August 2020 *)
(* Simulation Algorithm *)

Require Export Streams OpSrch.

Set Implicit Arguments.

Module MSimAlg (env : Environment).
Module Export M := MOpSrch env.

(* stream rewrite helper *)
Lemma stream_match_ (i : Stream nat) :
  i = match i with Cons n i' => Cons n i' end.
Proof.
  destruct i; auto.
Qed.

(* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *)

Module simtrace.

(* simtrace *)
CoInductive t : Type :=
| eps : t
| bag : bag.t -> t -> t
| dead : t.

(* simtrace rewrite helper *)
Lemma match_ st :
  st = match st with eps => eps | bag B st' => bag B st' | dead => dead end.
Proof.
  destruct st; auto.
Qed.

End simtrace.

(* equivalence between simtraces and traces *)
CoInductive equiv : simtrace.t -> trace.t -> Prop :=
| equiv_eps : equiv simtrace.eps trace.eps
| equiv_bag B st t : equiv st t -> equiv (simtrace.bag B st) (trace.bag B t).

(* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *)

(* top-level simulation function *)
CoFixpoint sim' ef nb c sig i : simtrace.t :=
  match i with Cons n i' =>
    match nthop ef nb c sig n with
    | Some None => simtrace.eps
    | Some (Some (B, c')) =>
        simtrace.bag B (sim' ef nb c' (bag.update sig B) i')
    | None => simtrace.dead
    end
  end.
Definition sim P i : simtrace.t :=
  sim' (prgm.ef P) (prgm.nb P) (prgm.init P) state.zero i.

(* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *)

CoFixpoint path P c (sig : state.t) (i : Stream nat) :
  petri.Reach (prgm.constr P) c -> path.t.
Proof.
  intros. destruct i. edestruct nthop_cases with (sig0:=sig) (n:=n)
      as [[[]|[?[?[]]]]|]. apply prgm.EfcFin. apply prgm.NthBag. eauto.
    apply path.fin. apply x.
    apply path.hop. apply x. apply x1. eapply path.
      apply (bag.update sig x0). apply i. destruct a as [?[?[?[]]]].
      econstructor 2. eapply petri.Reach_Efchain; eauto. eauto.
    apply path.fin. apply [].
Defined.

(* simulation soundness *)
Theorem sim_sound P i t : equiv (sim P i) t -> prgm.Feas P t.
Proof.
  assert (petri.Reach (prgm.constr P) (petri.init (prgm.constr P))).
    apply petri.Reach_init.
  unfold sim. split.
    apply prgm.Lang_sound. unfold petri.Lang. exists (path P state.zero i H).
      generalize dependent t. generalize dependent H. generalize dependent i.
      generalize state.zero. rewrite prgm.init_constr.
      generalize (petri.init (prgm.constr P)). cofix F. do 5 intro.
      rewrite (simtrace.match_ (sim' _ _ _ _ _)),
      (path.match_ (path _ _ _ _)). destruct i. simpl. intro.
      destruct nthop_cases as [[[?[]]|[?[?[?[?[?[?[]]]]]]]]|]; intros.
        rewrite H1 in H0. inversion H0. rewrite trace.lift_eps. constructor.
          auto.
        rewrite e in H0. inversion H0. rewrite trace.lift_bag. econstructor.
          eauto. auto. apply F. auto.
        rewrite e in H0. inversion H0.
    generalize dependent t. generalize dependent H. generalize dependent i.
      generalize state.zero. rewrite prgm.init_constr.
      generalize (petri.init (prgm.constr P)). cofix F. do 4 intro.
      rewrite (simtrace.match_ (sim' _ _ _ _ _)). destruct i. simpl.
      case_eq (nthop (prgm.ef P) (prgm.nb P) t t0 n); intros.
        destruct o.
          destruct p. edestruct nthop_Some_Some as [?[?[?[]]]]; eauto.
            apply prgm.NthBag. inversion H1. econstructor; eauto.
            eapply F. econstructor 2. eapply petri.Reach_Efchain; eauto. eauto.
              eauto.
          inversion H1. constructor.
        inversion H1.
Qed.

CoFixpoint stream P c sig t pi :
  trace.Feas sig t -> petri.Reach (prgm.constr P) c ->
  petri.Gen (prgm.constr P) c pi (trace.lift t) -> Stream nat.
Proof.
  intros. destruct t. apply (const 0). destruct pi. apply (const 0).
  rewrite trace.lift_bag in H1. edestruct
    (@nthop_n_Some_Some (prgm.constr P) (prgm.ef P)) as [?[?[]]].
    apply prgm.NthBag. eauto. inversion H. eauto.
    eapply petri.Efchain_eq_r. inversion H1. exists c'. split; eauto.
      eapply petri.Efchain_last; eauto.
    eapply petri.Firing_eq_l. inversion H1. exists c'. split; eauto.
      apply config.eq_sym. eapply petri.Efchain_last; eauto.
  constructor. apply x1. eapply stream. inversion H. eauto.
    apply a.
    inversion H1. eapply petri.Gen_Efchain. apply a. apply H9.
Defined.

(* simulation completeness *)
Theorem sim_complete P t : prgm.Feas P t -> exists i, equiv (sim P i) t.
Proof.
  unfold sim. intro. destruct H.
  assert (petri.Reach (prgm.constr P) (petri.init (prgm.constr P))).
    apply petri.Reach_init.
  assert (petri.Lang (prgm.constr P) (trace.lift t)).
    apply prgm.Lang_complete. auto.
  destruct H2. exists (stream _ H0 H1 H2). clear H. generalize dependent H2.
  generalize dependent H1. generalize dependent t. generalize dependent x.
  generalize state.zero. rewrite prgm.init_constr.
  generalize (petri.init (prgm.constr P)). cofix F. intros.
  rewrite (simtrace.match_ (sim' _ _ _ _ _)). simpl. destruct t1.
    rewrite (stream_match_ (const 0)). simpl. rewrite trace.lift_eps in H2.
      inversion H2. erewrite nthop_0_Some_None. constructor.
      apply prgm.EfcFin. auto. eauto.
    destruct x. rewrite trace.lift_bag in H2. inversion H2.
      destruct (nthop_n_Some_Some _ _ _ _). destruct s. destruct s.
      destruct a as [?[]]. rewrite e0. constructor. eapply F.
Qed.

End MSimAlg.

(* (c) 2020 Brittany Ro Nkounkou *)
