(* Brittany Nkounkou *)
(* August 2020 *)
(* Operation Search *)

Require Export Constr.

Set Implicit Arguments.

Module MOpSrch (env : Environment).
Module Export M := MConstr env.

(* finds the nth feasible operation from c (if any) *)
Definition nthop (ef : petri.efc_fin) (nb : petri.nth_bag) c sig n :
  option (option (bag.t * config.t)) :=
  let F B c n := Some (B, c, match n with 0 => None | S n' => Some n' end) in
  if ef c
  then
    match n with
    | 0 => Some None
    | S n' =>
      match nb c sig true F n' with
      | Some (B, c', _) => Some (Some (B, c'))
      | None => Some None
      end
    end
  else
    match nb c sig true F n with
    | Some (B, c', _) => Some (Some (B, c'))
    | None => None
    end.

(* nthop termination soundness *)
Definition nthop_Some_None N ef nb c sig n :
  petri.EfcFin N ef -> petri.Reach N c -> nthop ef nb c sig n = Some None ->
  {l | petri.Efchain N c l (petri.fin N)}.
Proof.
  unfold nthop. intros. apply X. auto. destruct (ef c). auto.
  destruct nb in H0. destruct p. destruct p. inversion H0. inversion H0.
Defined.

(* nthop generation soundness *)
Definition nthop_Some_Some N ef nb c sig n B c' :
  petri.nb_sound N nb -> petri.Reach N c ->
  nthop ef nb c sig n = Some (Some (B, c')) -> {l | bag.Feas sig B /\
  exists c'', petri.Efchain N c l c'' /\ petri.Firing N c'' (Some B) c'}.
Proof.
  unfold nthop. intros. destruct (ef c). destruct n. inversion H0.
    case_eq (nb c sig true (fun B c n =>
        Some (B, c, match n with 0 => None | S n' => Some n' end)) n); intros;
        rewrite H1 in H0.
      destruct p. destruct p. inversion H0. rewrite H3, H4 in H1.
        edestruct X; eauto. exists x. destruct s as [?[?[?[?[?[?[?[]]]]]]]].
        inversion H8. rewrite H10, H11 in *. split. split; auto. eauto.
      inversion H0.
    case_eq (nb c sig true (fun B c n =>
        Some (B, c, match n with 0 => None | S n' => Some n' end)) n); intros;
        rewrite H1 in H0.
      destruct p. destruct p. inversion H0. rewrite H3, H4 in H1.
        edestruct X; eauto. exists x. destruct s as [?[?[?[?[?[?[?[]]]]]]]].
        inversion H8. rewrite H10, H11 in *. split. split; auto. eauto.
      inversion H0.
Defined.

Definition nthop_cases N ef nb c sig n :
  petri.EfcFin N ef -> petri.nb_sound N nb -> petri.Reach N c ->
  {l | nthop ef nb c sig n = Some None /\ petri.Efchain N c l (petri.fin N)} +
  {l & {B & {c' | nthop ef nb c sig n = Some (Some (B, c')) /\ bag.Feas sig B /\
    exists c'', petri.Efchain N c l c'' /\ petri.Firing N c'' (Some B) c'}}} +
  {nthop ef nb c sig n = None}.
Proof.
  intros. case_eq (nthop ef nb c sig n); intros; auto. left. destruct o.
    right. destruct p. edestruct nthop_Some_Some; eauto.
    left. edestruct nthop_Some_None; eauto.
Defined.

(* nthop termination completeness *)
Lemma nthop_0_Some_None N ef nb c sig l :
  petri.EfcFin N ef -> petri.Reach N c -> petri.Efchain N c l (petri.fin N) ->
  nthop ef nb c sig 0 = Some None.
Proof.
  unfold nthop. intros. assert (ef c = true). eapply X; eauto.
  rewrite H1. auto.
Qed.

(* nthop generation completeness *)
Definition nthop_n_Some_Some N ef nb c sig l c' B c'' :
  petri.nb_complete N nb -> petri.Reach N c -> bag.Feas sig B ->
  petri.Efchain N c l c' -> petri.Firing N c' (Some B) c'' ->
  {c' & {l' & {n | petri.Reach N c' /\ petri.Efchain N c' l' c'' /\
    nthop ef nb c sig n = Some (Some (B, c'))}}}.
Proof.
  unfold nthop. intros. destruct H0. edestruct X with
      (F:=fun (B0 : bag.t) (c0 : config.t) n => Some (B0, c0,
      match n with 0 => None | S n'0 => Some n'0 end)) as [??[]]; eauto.
    do 5 intro. inversion H4.
    do 6 intro. exists (S n''). eauto.
    exists x, x0. destruct (s 0). destruct (ef c).
      exists (S x1). split; auto. split; auto. rewrite e0; eauto.
      exists x1. split; auto. split; auto. rewrite e0; eauto.
Defined.

End MOpSrch.

(* (c) 2020 Brittany Ro Nkounkou *)
