(* Brittany Nkounkou *)
(* August 2020 *)
(* The First Asynchronous Microprocessor Simulation Examples *)

Require Export FamDef.

Set Implicit Arguments.

Module Zeros.

(* instruction memory set to all zeros *)
Module I <: Imem.
  Definition imem : nat -> nat := fun _ => 0.
End I.

Module Import M := MFamDef I.

(* PRINT RESULT OF (observe 100 (sim FAM (const 0))) *)
Compute (observe 100 (sim FAM (const 0))).

(* PRINT RESULT OF (observe 100 (sim FAM (const 2))) *)
Compute (observe 100 (sim FAM (const 2))).

End Zeros.

(* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *)

Module FibSeq.

Module I <: Imem.

(* instruction memory set to write the Fibonacci sequence to dmem[0] *)
Definition imem n : nat :=
  match n with
  | 0 => 6002 (* r_2 := r_0(0) + *)
  | 1 => 0001 (* 1 *)
  | 2 => 0123 (* r_3 := r_1 + r_2 *)
  | 3 => 3003 (* dmem[r_0(0) + r_0(0)] := r_3 *)
  | 4 => 0021 (* r_1 := r_0(0) + r_2 *)
  | 5 => 0032 (* r_2 := r_0(0) + r_3 *)
  | 6 => 6003 (* r_3 := r_0(0) + *)
  | 7 => 0002 (* 2 *)
  | 8 => 8030 (* pc := r_3 *)
  | _ => 0
  end.

End I.

Module Import M := MFamDef I.

(* only display event bags that write to r[1], r[2], or dmem[0] *)
Fixpoint display (B : bag.t) : bool :=
  match B with
  | nil => false
  | event.assn v _ :: B' =>
      if dvar.dec v .r1 then true
      else if dvar.dec v .r2 then true
      else if dvar.dec v dmem[0] then true
      else display B'
  | event.recv _ (Some v) :: B' =>
      if dvar.dec v .r1 then true
      else if dvar.dec v .r2 then true
      else if dvar.dec v dmem[0] then true
      else display B'
  | _ :: B' => display B'
  end.

(* observation of simtrace with modified display *)
Fixpoint observe' n sig st : observation :=
  match st with
  | simtrace.eps => Eps
  | simtrace.bag B st' =>
    match n with
    | 0 => More
    | S n' =>
      if display B
      then
        Bag (map (obsevent.of_event sig) B) (observe' n' (bag.update sig B) st')
      else
        match observe' n' (bag.update sig B) st' with
        | Eps => Bag nil Eps
        | Bag nil o => Bag nil o
        | Bag B o => Bag nil (Bag B o)
        | More => Bag nil More
        | Dead => Bag nil Dead
        end
    end
  | simtrace.dead => Dead
  end.
Definition observe n st : observation :=
  observe' n state.zero st.

(* PRINT RESULT OF (observe 5000 (sim FAM (const 0))) *)
Compute (observe 5000 (sim FAM (const 0))).

End FibSeq.

(* (c) 2020 Brittany Ro Nkounkou *)
