(* Brittany Nkounkou *)
(* August 2020 *)
(* Basics *)

Require Export Equality List.
Export ListNotations.

Set Implicit Arguments.

(* decidable equality *)
Definition eq_dec t : Type :=
  forall x y : t, {x = y} + {x <> y}.

(* decidable type *)
Module Type DecidableType.
  Parameter t : Type.
  Parameter dec : eq_dec t.
End DecidableType.

(* environment *)
Module Type Environment.
  Declare Module val : DecidableType.
  Declare Module dvar : DecidableType.
  Declare Module chan : DecidableType.
  Declare Module expr : DecidableType.
  Parameter expr_In : dvar.t -> expr.t -> Prop.
  Parameter expr_eval : (dvar.t -> option val.t) -> expr.t -> option val.t.
  Parameter expr_eval_eq : forall f f' e,
    (forall x, expr_In x e -> f x = f' x) -> expr_eval f e = expr_eval f' e.
End Environment.

(* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *)

Module MBasics (Export env : Environment).

Module mut.

(* mutable *)
Inductive t : Type :=
| dvar : dvar.t -> t
| sprb : chan.t -> t
| rprb : chan.t -> t
| dprb : chan.t -> t.

End mut.

Module guard <: DecidableType.

(* guard *)
Inductive t' : Type :=
| bool : bool -> t'
| sprb : chan.t -> t'
| rprb : chan.t -> t'
| dprb : chan.t -> expr.t -> t'
| expr : expr.t -> expr.t -> t'
| neg : t' -> t'
| and : t' -> t' -> t'
| or : t' -> t' -> t'.
Definition t : Type := t'.

(* decidable guard equality *)
Definition dec : eq_dec t.
Proof.
  unfold eq_dec, t. repeat decide equality;
    try apply chan.dec; try apply expr.dec.
Defined.

End guard.

End MBasics.

(* (c) 2020 Brittany Ro Nkounkou *)
