/* Generated by CIL v. 1.3.2 */
/* print_CIL_Input is true */

typedef unsigned int size_t;
typedef long __off_t;
typedef long long __off64_t;
typedef long __time_t;
typedef __time_t time_t;
struct __anonstruct___sigset_t_7 {
   unsigned long __val[(int )(1024U / (8U * sizeof(unsigned long )))] ;
};
typedef struct __anonstruct___sigset_t_7 __sigset_t;
typedef __sigset_t sigset_t;
struct __sched_param {
   int __sched_priority ;
};
struct __pthread_attr_s {
   int __detachstate ;
   int __schedpolicy ;
   struct __sched_param __schedparam ;
   int __inheritsched ;
   int __scope ;
   size_t __guardsize ;
   int __stackaddr_set ;
   void *__stackaddr ;
   size_t __stacksize ;
};
typedef struct __pthread_attr_s pthread_attr_t;
typedef unsigned long pthread_t;
struct _IO_FILE;
typedef struct _IO_FILE FILE;
typedef void _IO_lock_t;
struct _IO_marker {
   struct _IO_marker *_next ;
   struct _IO_FILE *_sbuf ;
   int _pos ;
};
struct _IO_FILE {
   int _flags ;
   char *_IO_read_ptr ;
   char *_IO_read_end ;
   char *_IO_read_base ;
   char *_IO_write_base ;
   char *_IO_write_ptr ;
   char *_IO_write_end ;
   char *_IO_buf_base ;
   char *_IO_buf_end ;
   char *_IO_save_base ;
   char *_IO_backup_base ;
   char *_IO_save_end ;
   struct _IO_marker *_markers ;
   struct _IO_FILE *_chain ;
   int _fileno ;
   int _flags2 ;
   __off_t _old_offset ;
   unsigned short _cur_column ;
   signed char _vtable_offset ;
   char _shortbuf[1] ;
   _IO_lock_t *_lock ;
   __off64_t _offset ;
   void *__pad1 ;
   void *__pad2 ;
   int _mode ;
   char _unused2[(int )(15U * sizeof(int ) - 2U * sizeof(void *))] ;
};
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned short sa_family_t;
struct sockaddr {
   sa_family_t sa_family ;
   char sa_data[14] ;
};
typedef uint16_t in_port_t;
typedef uint32_t in_addr_t;
struct in_addr {
   in_addr_t s_addr ;
};
struct sockaddr_in {
   sa_family_t sin_family ;
   in_port_t sin_port ;
   struct in_addr sin_addr ;
   unsigned char sin_zero[(int )(((sizeof(struct sockaddr ) - sizeof(unsigned short )) -
                                  sizeof(in_port_t )) - sizeof(struct in_addr ))] ;
};
struct request {
   char host[1024] ;
   char url[1024] ;
   char file[512] ;
   char lfile[512] ;
   char ip[16] ;
   char username[512] ;
   char password[512] ;
   int port ;
   int clength ;
   unsigned char proto ;
};
struct thread_data {
   struct sockaddr_in sin ;
   char getstr[256] ;
   long soffset ;
   long foffset ;
   long offset ;
   long clength ;
   int fd ;
   pthread_t tid ;
   unsigned char status ;
};
struct hist_data {
   struct request req ;
   int nthreads ;
   int bwritten ;
   struct thread_data wthread[25] ;
};
typedef int __ssize_t;
typedef __ssize_t ssize_t;
typedef __builtin_va_list __gnuc_va_list;
typedef __gnuc_va_list va_list;
typedef unsigned int __socklen_t;
typedef __socklen_t socklen_t;
struct hostent {
   char *h_name ;
   char **h_aliases ;
   int h_addrtype ;
   int h_length ;
   char **h_addr_list ;
};
struct _pthread_fastlock {
   long __status ;
   int __spinlock ;
};
struct _pthread_descr_struct;
typedef struct _pthread_descr_struct *_pthread_descr;
struct __anonstruct_pthread_mutex_t_17 {
   int __m_reserved ;
   int __m_count ;
   _pthread_descr __m_owner ;
   int __m_kind ;
   struct _pthread_fastlock __m_lock ;
};
typedef struct __anonstruct_pthread_mutex_t_17 pthread_mutex_t;
extern char *optarg ;
extern int optind ;
extern int getopt(int ___argc , char * const  *___argv , char const   *__shortopts ) ;
extern int atoi(char const   *__nptr )  __attribute__((__pure__)) ;
extern void *calloc(size_t __nmemb , size_t __size )  __attribute__((__malloc__)) ;
extern  __attribute__((__noreturn__)) void exit(int __status ) ;
extern struct _IO_FILE *stderr ;
extern int fprintf(FILE * __restrict  __stream , char const   * __restrict  __format 
                   , ...) ;
extern int printf(char const   * __restrict  __format  , ...) ;
extern char *strncpy(char * __restrict  __dest , char const   * __restrict  __src ,
                     size_t __n ) ;
extern char *strdup(char const   *__s )  __attribute__((__malloc__)) ;
extern char *strerror(int __errnum ) ;
extern int sigemptyset(sigset_t *__set ) ;
extern int sigaddset(sigset_t *__set , int __signo ) ;
extern int pthread_sigmask(int __how , __sigset_t const   * __restrict  __newmask ,
                           __sigset_t * __restrict  __oldmask ) ;
extern int pthread_create(pthread_t * __restrict  __threadp , pthread_attr_t const   * __restrict  __attr ,
                          void *(*__start_routine)(void * ) , void * __restrict  __arg ) ;
void parse_url(char *url , struct request *req___0 ) ;
void usage(void) ;
void Log(char *fmt  , ...) ;
time_t t_start  ;
time_t t_finish  ;
int read_log(struct hist_data *h ) ;
void get(struct request *req___0 ) ;
void resume_get(struct hist_data *h ) ;
sigset_t signal_set  ;
void *signal_waiter(void *arg ) ;
char *fullurl  ;
int nthreads  ;
int fsuggested  =    0;
struct request *req  ;
pthread_t hthread  ;
struct thread_data *wthread  ;
extern int errno ;
int main(int argc , char **argv ) 
{ int c ;
  int error ;
  int ret ;
  struct hist_data h ;
  int retlog ;
  char *tmp___0 ;

  {
  error = 0;
  req = (struct request *)calloc(1U, sizeof(struct request ));
  sigemptyset(& signal_set);
  sigaddset(& signal_set, 2);
  sigaddset(& signal_set, 14);
  pthread_sigmask(0, (__sigset_t const   * __restrict  )(& signal_set), (__sigset_t * __restrict  )((void *)0));
  ret = pthread_create((pthread_t * __restrict  )(& hthread), (pthread_attr_t const   * __restrict  )((void *)0),
                       & signal_waiter, (void * __restrict  )((void *)0));
  if (ret != 0) {
    tmp___0 = strerror(errno);
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"main: cannot create signal_waiter thread: %s, exiting...\n",
            tmp___0);
    exit(-1);
  }
  while (1) {
    if (! error) {
      c = getopt(argc, (char * const  *)argv, "p:l:n:hfv");
      if (! (c != -1)) {
        break;
      }
    } else {
      break;
    }
    switch (c) {
    case 112: 
    req->port = atoi((char const   *)optarg);
    break;
    case 102: 
    fsuggested = 1;
    break;
    case 108: 
    strncpy((char * __restrict  )(req->lfile), (char const   * __restrict  )optarg,
            512U);
    break;
    case 110: 
    nthreads = atoi((char const   *)optarg);
    if (nthreads > 25) {
      Log((char *)"Error: Maximum # of threads allowed is %d\n", 25);
      nthreads = 0;
    }
    break;
    case 104: 
    printf((char const   * __restrict  )"%s\n", "EnderUNIX Aget v0.4");
    usage();
    exit(0);
    break;
    case 118: 
    printf((char const   * __restrict  )"%s\nby Murat BALABAN <murat@enderunix.org>\n",
           "EnderUNIX Aget v0.4");
    exit(0);
    break;
    default: 
    error = 1;
    usage();
    exit(1);
    break;
    }
  }
  if (error) {
    usage();
    exit(1);
  }
  if (fsuggested == 1) {
    if (nthreads == 0) {
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\nERROR: -f and -n should be used together!, exiting...\n\n");
      usage();
      exit(1);
    }
  }
  if (argc == 2) {
    fullurl = strdup((char const   *)(*(argv + 1)));
  } else {
    if (optind < argc) {
      if (argc > 2) {
        fullurl = strdup((char const   *)(*(argv + optind)));
      } else {
        usage();
        exit(1);
      }
    } else {
      if (optind == argc) {
        usage();
        exit(1);
      }
    }
  }
  parse_url(fullurl, req);
  retlog = read_log(& h);
  if (retlog != -1) {
    resume_get(& h);
  } else {
    get(req);
  }
  return (0);
}
}
extern int ( /* format attribute */  snprintf)(char * __restrict  __s , size_t __maxlen ,
                                               char const   * __restrict  __format 
                                               , ...) ;
extern void *malloc(size_t __size )  __attribute__((__malloc__)) ;
extern void free(void *__ptr ) ;
extern void *memcpy(void * __restrict  __dest , void const   * __restrict  __src ,
                    size_t __n ) ;
extern size_t strlen(char const   *__s )  __attribute__((__pure__)) ;
extern time_t time(time_t *__timer ) ;
extern int pthread_join(pthread_t __th , void **__thread_return ) ;
extern int pthread_cancel(pthread_t __cancelthread ) ;
extern __off_t lseek(int __fd , __off_t __offset , int __whence ) ;
extern int close(int __fd ) ;
extern ssize_t write(int __fd , void const   *__buf , size_t __n ) ;
extern int dup(int __fd ) ;
extern int open(char const   *__file , int __oflag  , ...) ;
extern uint16_t htons(uint16_t __hostshort )  __attribute__((__const__)) ;
extern in_addr_t inet_addr(char const   *__cp ) ;
void http_head_req(struct request *req___0 ) ;
int calc_offset(int total , int part , int nthreads___0 ) ;
int numofthreads(int size ) ;
void *http_get(void *arg ) ;
void get(struct request *req___0 ) 
{ int i ;
  int ret ;
  int fd ;
  int diff_sec ;
  int nok ;
  long soffset ;
  long foffset ;
  char *fmt ;
  char *tmp___0 ;
  char *tmp___1 ;
  size_t tmp___2 ;
  char *tmp___3 ;
  __off_t tmp___4 ;
  char *tmp___5 ;
  ssize_t tmp___6 ;

  {
  nok = 0;
  if ((int )req___0->proto == 255) {
    http_head_req(req___0);
  }
  ret = numofthreads(req___0->clength);
  if (fsuggested == 0) {
    if (ret == 0) {
      nthreads = 1;
    } else {
      nthreads = ret;
    }
  }
  wthread = (struct thread_data *)malloc((unsigned int )nthreads * sizeof(struct thread_data ));
  Log((char *)"Downloading %s (%d bytes) from site %s(%s:%d). Number of Threads: %d",
      req___0->url, req___0->clength, req___0->host, req___0->ip, req___0->port, nthreads);
  tmp___2 = strlen((char const   *)(req___0->lfile));
  if (tmp___2 != 0U) {
    fd = open((char const   *)(req___0->lfile), 66, 448);
    if (fd == -1) {
      tmp___0 = strerror(errno);
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"get: cannot open file %s for writing: %s\n",
              req___0->lfile, tmp___0);
      exit(1);
    }
  } else {
    fd = open((char const   *)(req___0->file), 66, 448);
    if (fd == -1) {
      tmp___1 = strerror(errno);
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"get: cannot open file %s for writing: %s\n",
              req___0->lfile, tmp___1);
      exit(1);
    }
  }
  tmp___4 = lseek(fd, (long )(req___0->clength - 1), 0);
  if (tmp___4 == -1L) {
    tmp___3 = strerror(errno);
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"get: couldn\'t lseek:  %s\n",
            tmp___3);
    exit(1);
  }
  tmp___6 = write(fd, (void const   *)"0", 1U);
  if (tmp___6 == -1) {
    tmp___5 = strerror(errno);
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"get: couldn\'t allocate space for download file: %s\n",
            tmp___5);
    exit(1);
  }
  fmt = (char *)calloc(254U, sizeof(char ));
  time(& t_start);
  i = 0;
  while (i < nthreads) {
    soffset = (long )calc_offset(req___0->clength, i, nthreads);
    foffset = (long )calc_offset(req___0->clength, i + 1, nthreads);
    (wthread + i)->soffset = soffset;
    if (i == nthreads - 1) {
      (wthread + i)->foffset = (long )req___0->clength;
    } else {
      (wthread + i)->foffset = foffset;
    }
    (wthread + i)->sin.sin_family = (unsigned short)2;
    (wthread + i)->sin.sin_addr.s_addr = inet_addr((char const   *)(req___0->ip));
    (wthread + i)->sin.sin_port = htons((unsigned short )req___0->port);
    (wthread + i)->fd = dup(fd);
    (wthread + i)->clength = (long )req___0->clength;
    snprintf((char * __restrict  )fmt, 256U, (char const   * __restrict  )"GET %s HTTP/1.1\r\nHost: %s\r\nUser-Agent: %s\r\nRange: bytes=%ld-\r\nConnection: close\r\n\r\n",
             req___0->url, req___0->host, "EnderUNIX Aget v0.4", soffset);
    strncpy((char * __restrict  )((wthread + i)->getstr), (char const   * __restrict  )fmt,
            256U);
    pthread_create((pthread_t * __restrict  )(& (wthread + i)->tid), (pthread_attr_t const   * __restrict  )((void *)0),
                   & http_get, (void * __restrict  )(wthread + i));
    i ++;
  }
  free((void *)fmt);
  i = 0;
  while (i < nthreads) {
    pthread_join((wthread + i)->tid, (void **)((void *)0));
    if ((int )(wthread + i)->status == 255) {
      nok ++;
    }
    i ++;
  }
  if (nok == nthreads) {
    pthread_cancel(hthread);
  } else {
    pthread_join(hthread, (void **)((void *)0));
  }
  time(& t_finish);
  diff_sec = (int )(t_finish - t_start);
  if (diff_sec == 0) {
    diff_sec = 1;
  }
  Log((char *)"Download completed, job completed in %d seconds. (%d Kb/sec)", diff_sec,
      (req___0->clength / diff_sec) / 1024);
  Log((char *)"Shutting down...");
  close(fd);
  return;
}
}
void resume_get(struct hist_data *h ) 
{ int i ;
  int fd ;
  int diff_sec ;
  int nok ;
  char *fmt ;
  char *tmp___1 ;
  char *tmp___2 ;
  size_t tmp___3 ;

  {
  nok = 0;
  nthreads = h->nthreads;
  fmt = (char *)calloc(254U, sizeof(char ));
  wthread = (struct thread_data *)malloc((unsigned int )nthreads * sizeof(struct thread_data ));
  memcpy((void * __restrict  )req, (void const   * __restrict  )(& h->req), sizeof(struct request ));
  memcpy((void * __restrict  )wthread, (void const   * __restrict  )(h->wthread),
         sizeof(struct thread_data ) * (unsigned int )nthreads);
  Log((char *)"Resuming download %s (%d bytes) from site %s(%s:%d). Number of Threads: %d",
      req->url, req->clength, req->host, req->ip, req->port, nthreads);
  tmp___3 = strlen((char const   *)(req->lfile));
  if (tmp___3 != 0U) {
    fd = open((char const   *)(req->lfile), 2, 448);
    if (fd == -1) {
      tmp___1 = strerror(errno);
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"get: cannot open file %s for writing: %s\n",
              req->lfile, tmp___1);
      exit(1);
    }
  } else {
    fd = open((char const   *)(req->file), 2, 448);
    if (fd == -1) {
      tmp___2 = strerror(errno);
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"get: cannot open file %s for writing: %s\n",
              req->lfile, tmp___2);
      exit(1);
    }
  }
  time(& t_start);
  i = 0;
  while (i < nthreads) {
    (wthread + i)->soffset = (wthread + i)->offset;
    (wthread + i)->fd = dup(fd);
    snprintf((char * __restrict  )fmt, 256U, (char const   * __restrict  )"GET %s HTTP/1.1\r\nHost: %s\r\nUser-Agent: %s\r\nRange: bytes=%ld-\r\nConnection: close\r\n\r\n",
             req->url, req->host, "EnderUNIX Aget v0.4", (wthread + i)->offset);
    strncpy((char * __restrict  )((wthread + i)->getstr), (char const   * __restrict  )fmt,
            256U);
    pthread_create((pthread_t * __restrict  )(& (wthread + i)->tid), (pthread_attr_t const   * __restrict  )((void *)0),
                   & http_get, (void * __restrict  )(wthread + i));
    i ++;
  }
  i = 0;
  while (i < nthreads) {
    pthread_join((wthread + i)->tid, (void **)((void *)0));
    i ++;
  }
  i = 0;
  while (i < nthreads) {
    pthread_join((wthread + i)->tid, (void **)((void *)0));
    if ((int )(wthread + i)->status == 255) {
      nok ++;
    }
    i ++;
  }
  if (nok == nthreads) {
    pthread_cancel(hthread);
  } else {
    pthread_join(hthread, (void **)((void *)0));
  }
  time(& t_finish);
  diff_sec = (int )(t_finish - t_start);
  if (diff_sec == 0) {
    diff_sec = 1;
  }
  Log((char *)"Download completed, job completed in %d seconds. (%d Kb/sec)", diff_sec,
      ((req->clength - h->bwritten) / diff_sec) / 1024);
  Log((char *)"Shutting down...");
  close(fd);
  return;
}
}
extern struct _IO_FILE *stdout ;
extern int fflush(FILE *__stream ) ;
extern int sprintf(char * __restrict  __s , char const   * __restrict  __format  , ...) ;
extern int vfprintf(FILE * __restrict  __s , char const   * __restrict  __format ,
                    __gnuc_va_list __arg ) ;
extern int putchar(int __c ) ;
extern void *memset(void *__s , int __c , size_t __n ) ;
extern int strncmp(char const   *__s1 , char const   *__s2 , size_t __n )  __attribute__((__pure__)) ;
extern char *strstr(char const   *__haystack , char const   *__needle )  __attribute__((__pure__)) ;
extern int *__errno_location(void)  __attribute__((__const__)) ;
void revstr(char *str ) ;
void updateProgressBar(float cur , float tot ) ;
void handleHttpRetcode(char *rbuf ) ;
void parse_url(char *url , struct request *req___0 ) 
{ char *s ;
  int i ;
  int j ;
  int k ;
  int tmp ;
  int tmp___0 ;
  int tmp___1 ;
  int tmp___2 ;

  {
  k = 0;
  j = k;
  i = j;
  s = url;
  tmp___0 = strncmp((char const   *)url, "ftp://", 6U);
  if (tmp___0 == 0) {
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Error: Currently Aget doesn\'t support FTP requests...\n");
    exit(1);
  } else {
    tmp = strncmp((char const   *)url, "http://", 7U);
    if (tmp != 0) {
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Error: URL should be of the form http://...\n");
      exit(1);
    }
  }
  if (req___0->port == 0) {
    req___0->port = 80;
    req___0->proto = (unsigned char)255;
  }
  s = url + 7;
  i = 0;
  while ((int )(*s) != 47) {
    if (i > 1024) {
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Error: Cannot get hostname from URL...\n");
      exit(1);
    }
    if ((int )(*s) == 58) {
      while ((int )(*s) != 47) {
        tmp___1 = j;
        j ++;
        s --;
        req___0->username[tmp___1] = (*s);
        i --;
      }
      j --;
      req___0->username[j] = (char )'\000';
      revstr(req___0->username);
      while (1) {
        if ((int )(*s) == 58) {
          while ((int )(*s) != 64) {
            if (k > 512) {
              fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Error: Cannot get password from URL...\n");
              exit(1);
            }
            tmp___2 = k;
            k ++;
            s ++;
            req___0->password[tmp___2] = (*s);
          }
          break;
        }
        s ++;
      }
      k --;
      req___0->password[k] = (char )'\000';
    }
    req___0->host[i] = (*s);
    i ++;
    s ++;
  }
  req___0->host[i] = (char )'\000';
  i = 0;
  while ((int )(*s) != 0) {
    if (i > 1024) {
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Error: Cannot get remote file name from URL...\n");
      exit(1);
    }
    req___0->url[i] = (*s);
    i ++;
    s ++;
  }
  req___0->url[i] = (char )'\000';
  s --;
  i = 0;
  while ((int )(*s) != 47) {
    if (i > 512) {
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Error: Cannot get local file name from URL...\n");
      exit(1);
    }
    req___0->file[i] = (*s);
    i ++;
    s --;
  }
  req___0->file[i] = (char )'\000';
  revstr(req___0->file);
  return;
}
}
int numofthreads(int size ) 
{ 

  {
  if (size == 0) {
    return (0);
  } else {
    if (size < 16384) {
      return (1);
    } else {
      if (size >= 16384) {
        if (size < 32768) {
          return (2);
        } else {
          goto _L___5;
        }
      } else {
        _L___5: /* CIL Label */ 
        if (size >= 32768) {
          if (size < 65536) {
            return (3);
          } else {
            goto _L___4;
          }
        } else {
          _L___4: /* CIL Label */ 
          if (size >= 65536) {
            if (size < 131072) {
              return (4);
            } else {
              goto _L___3;
            }
          } else {
            _L___3: /* CIL Label */ 
            if (size >= 131072) {
              if (size < 262144) {
                return (5);
              } else {
                goto _L___2;
              }
            } else {
              _L___2: /* CIL Label */ 
              if (size >= 262144) {
                if (size < 524288) {
                  return (6);
                } else {
                  goto _L___1;
                }
              } else {
                _L___1: /* CIL Label */ 
                if (size >= 524288) {
                  if (size < 1048576) {
                    return (7);
                  } else {
                    goto _L___0;
                  }
                } else {
                  _L___0: /* CIL Label */ 
                  if (size >= 1048576) {
                    if (size < 2097152) {
                      return (8);
                    } else {
                      goto _L;
                    }
                  } else {
                    _L: /* CIL Label */ 
                    if (size >= 2097152) {
                      if (size < 4194304) {
                        return (9);
                      } else {
                        return (10);
                      }
                    } else {
                      return (10);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
}
}
int calc_offset(int total , int part , int nthreads___0 ) 
{ 

  {
  return (part * (total / nthreads___0));
}
}
void usage(void) 
{ 

  {
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"usage: aget [options] url\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\toptions:\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\t\t-p port number\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\t\t-l local file name\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\t\t-n suggested number of threads\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\t\t-f force using suggested number of threads\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\t\t-h this screen\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\t\t-v version info\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\n");
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"http//www.enderunix.org/aget/\n");
  return;
}
}
void revstr(char *str ) 
{ char *p ;
  char *s ;
  int i ;
  int size ;

  {
  size = (int )strlen((char const   *)str);
  if (size == 0) {
    return;
  }
  p = (char *)calloc((unsigned int )size, sizeof(char ));
  s = p;
  i = size;
  while (i >= 0) {
    (*s) = (*((str + i) - 1));
    i --;
    s ++;
  }
  (*s) = (char )'\000';
  memset((void *)str, 0, (unsigned int )size);
  strncpy((char * __restrict  )str, (char const   * __restrict  )p, (unsigned int )size);
  free((void *)p);
  return;
}
}
void Log(char *fmt  , ...) 
{ va_list ap ;
  char *lfmt ;
  size_t tmp ;
  int *tmp___1 ;
  char *tmp___2 ;
  size_t tmp___3 ;

  {
  tmp = strlen((char const   *)fmt);
  lfmt = (char *)calloc(7U + tmp, sizeof(char ));
  sprintf((char * __restrict  )lfmt, (char const   * __restrict  )"<LOG> %s", fmt);
  fflush(stdout);
  __builtin_stdarg_start(ap, fmt);
  vfprintf((FILE * __restrict  )stderr, (char const   * __restrict  )lfmt, ap);
  __builtin_va_end(ap);
  if ((int )(*(fmt + 0)) != 0) {
    tmp___3 = strlen((char const   *)fmt);
    if ((int )(*(fmt + (tmp___3 - 1U))) == 58) {
      tmp___1 = __errno_location();
      tmp___2 = strerror((*tmp___1));
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )" %s", tmp___2);
    }
  }
  fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"\n");
  free((void *)lfmt);
  return;
}
}
static float prev  =    (float )-1;
void updateProgressBar(float cur , float tot ) 
{ float rat ;
  int ndot ;
  int i ;

  {
  rat = cur / tot;
  ndot = (int )(rat * (float )100);
  if ((float )ndot < prev + (float )5) {
    if (ndot != 100) {
      return;
    }
  }
  i = 0;
  while (i < ndot) {
    putchar('.');
    i += 2;
  }
  i = ndot - 1;
  while (i < 100) {
    putchar(' ');
    i += 2;
  }
  printf((char const   * __restrict  )"[%d%% completed]\n", ndot);
  prev = (float )ndot;
  return;
}
}
void handleHttpRetcode(char *rbuf ) 
{ char *tmp ;
  char *tmp___0 ;
  char *tmp___1 ;

  {
  tmp___1 = strstr((char const   *)rbuf, "HTTP/1.1 416");
  if ((unsigned int )tmp___1 != (unsigned int )((void *)0)) {
    Log((char *)"Server returned HTTP/1.1 416 - Requested Range Not Satisfiable\n");
    exit(1);
  } else {
    tmp___0 = strstr((char const   *)rbuf, "HTTP/1.1 403");
    if ((unsigned int )tmp___0 != (unsigned int )((void *)0)) {
      Log((char *)"<Server returned HTTP/1.1 403 - Permission Denied\n");
      exit(1);
    } else {
      tmp = strstr((char const   *)rbuf, "HTTP/1.1 404");
      if ((unsigned int )tmp != (unsigned int )((void *)0)) {
        Log((char *)"<Server returned HTTP/1.1 404 - File Not Found\n");
        exit(1);
      }
    }
  }
  return;
}
}
extern char *strtok(char * __restrict  __s , char const   * __restrict  __delim ) ;
extern void bzero(void *__s , size_t __n ) ;
extern int socket(int __domain , int __type , int __protocol ) ;
extern int connect(int __fd , struct sockaddr  const  *__addr , socklen_t __len ) ;
extern ssize_t send(int __fd , void const   *__buf , size_t __n , int __flags ) ;
extern ssize_t recv(int __fd , void *__buf , size_t __n , int __flags ) ;
extern int *__h_errno_location(void)  __attribute__((__const__)) ;
extern char const   *hstrerror(int __err_num ) ;
extern struct hostent *gethostbyname(char const   *__name ) ;
extern char *inet_ntoa(struct in_addr __in ) ;
void http_head_req(struct request *req___0 ) 
{ struct sockaddr_in sin ;
  struct hostent *he ;
  int sd ;
  char *sbuf ;
  char *rbuf ;
  char *tok ;
  char *s ;
  int clength ;
  size_t tmp ;
  int *tmp___2 ;
  char const   *tmp___3 ;
  char const   * __restrict  tmp___4 ;
  char *tmp___5 ;
  char *tmp___6 ;
  int tmp___7 ;
  char *tmp___8 ;
  size_t tmp___9 ;
  ssize_t tmp___10 ;
  char *tmp___11 ;
  ssize_t tmp___12 ;
  size_t tmp___13 ;
  char *tmp___14 ;
  char *tmp___15 ;

  {
  tmp = strlen((char const   *)(req___0->url));
  sbuf = (char *)calloc(512U + tmp, sizeof(char ));
  rbuf = (char *)calloc(512U, sizeof(char ));
  he = gethostbyname((char const   *)(req___0->host));
  if ((unsigned int )he == (unsigned int )((void *)0)) {
    tmp___2 = __h_errno_location();
    tmp___3 = hstrerror((*tmp___2));
    Log((char *)"Error: Cannot resolve hostname for %s: %s", req___0->host, tmp___3);
    exit(1);
  }
  tmp___4 = inet_ntoa((*((struct in_addr *)(*(he->h_addr_list + 0)))));
  strncpy((char * __restrict  )(req___0->ip), tmp___4, 16U);
  time(& t_start);
  bzero((void *)(& sin), sizeof(sin));
  sin.sin_family = (unsigned short)2;
  sin.sin_addr.s_addr = inet_addr((char const   *)(req___0->ip));
  sin.sin_port = htons((unsigned short )req___0->port);
  sd = socket(2, 1, 0);
  if (sd == -1) {
    tmp___5 = strerror(errno);
    Log((char *)"Socket creation failed for Head Request: %s", tmp___5);
    exit(1);
  }
  tmp___7 = connect(sd, (struct sockaddr  const  *)(& sin), sizeof(sin));
  if (tmp___7 == -1) {
    tmp___6 = strerror(errno);
    Log((char *)"Connection failed for Head Request: %s", tmp___6);
    exit(1);
  }
  Log((char *)"Head-Request Connection established");
  sprintf((char * __restrict  )sbuf, (char const   * __restrict  )"HEAD %s HTTP/1.1\r\nHost: %s\r\nUser-Agent: %s\r\n\r\n",
          req___0->url, req___0->host, "EnderUNIX Aget v0.4");
  tmp___9 = strlen((char const   *)sbuf);
  tmp___10 = send(sd, (void const   *)sbuf, tmp___9, 0);
  if (tmp___10 == -1) {
    tmp___8 = strerror(errno);
    Log((char *)"send failed for Head Request: %s", tmp___8);
    exit(1);
  }
  tmp___12 = recv(sd, (void *)rbuf, 512U, 0);
  if (tmp___12 == -1) {
    tmp___11 = strerror(errno);
    Log((char *)"recv failed for Head Request: %s", tmp___11);
    exit(1);
  }
  handleHttpRetcode(rbuf);
  tok = strtok((char * __restrict  )rbuf, (char const   * __restrict  )"\r\n");
  tmp___15 = strstr((char const   *)tok, "HTTP/1.1 200");
  if ((unsigned int )tmp___15 != (unsigned int )((void *)0)) {
    while (1) {
      tok = strtok((char * __restrict  )((void *)0), (char const   * __restrict  )"\r\n");
      if (! ((unsigned int )tok != (unsigned int )((void *)0))) {
        break;
      }
      tmp___14 = strstr((char const   *)tok, "Content-Length");
      if ((unsigned int )tmp___14 != (unsigned int )((void *)0)) {
        tmp___13 = strlen("Content-Length: ");
        s = tok + tmp___13;
        clength = atoi((char const   *)s);
        req___0->clength = clength;
      }
    }
  }
  free((void *)sbuf);
  free((void *)rbuf);
  return;
}
}
extern int sigwait(sigset_t const   * __restrict  __set , int * __restrict  __sig ) ;
extern unsigned int alarm(unsigned int __seconds ) ;
void sigint_handler(void) ;
void sigalrm_handler(void) ;
void save_log(void) ;
int bwritten ;
void *signal_waiter(void *arg ) 
{ int signal___0 ;

  {
  arg = (void *)0;
  pthread_sigmask(1, (__sigset_t const   * __restrict  )(& signal_set), (__sigset_t * __restrict  )((void *)0));
  while (1) {
    sigwait((sigset_t const   * __restrict  )(& signal_set), (int * __restrict  )(& signal___0));
    switch (signal___0) {
    case 2: 
    sigint_handler();
    break;
    case 14: 
    sigalrm_handler();
    break;
    }
  }
  return ((void *)0);
}
}
void sigint_handler(void) 
{ int i ;

  {
  printf((char const   * __restrict  )"^C caught, saving download job...\n");
  i = 0;
  while (i < nthreads) {
    pthread_cancel((wthread + i)->tid);
    (wthread + i)->status = (unsigned char )((int )(wthread + i)->status & 15);
    i ++;
  }
  save_log();
  exit(0);
}
}
void sigalrm_handler(void) 
{ 

  {
  printf((char const   * __restrict  )"Signal Alarm came\n");
  updateProgressBar((float )bwritten, (float )req->clength);
  alarm(1U);
  return;
}
}
extern ssize_t pwrite(int __fd , void const   *__buf , size_t __n , __off_t __offset ) ;
extern pthread_t pthread_self(void) ;
extern  __attribute__((__noreturn__)) void pthread_exit(void *__retval ) ;
extern int pthread_mutex_lock(pthread_mutex_t *__mutex ) ;
extern int pthread_mutex_unlock(pthread_mutex_t *__mutex ) ;
extern int pthread_setcanceltype(int __type , int *__oldtype ) ;
int bwritten  =    0;
struct __anonstruct_pthread_mutex_t_17 bwritten_mutex  =    {0, 0, (_pthread_descr )0, 0, {0L, 0}};
void *http_get(void *arg ) 
{ struct thread_data *td ;
  int sd ;
  char *rbuf ;
  char *s ;
  int dr ;
  int dw ;
  int i ;
  long foffset ;
  pthread_t tid ;
  char *tmp___0 ;
  char *tmp___1 ;
  int tmp___2 ;
  char *tmp___3 ;
  size_t tmp___4 ;
  ssize_t tmp___5 ;
  char *tmp___6 ;
  char *tmp___7 ;

  {
  tid = pthread_self();
  pthread_sigmask(0, (__sigset_t const   * __restrict  )(& signal_set), (__sigset_t * __restrict  )((void *)0));
  pthread_setcanceltype(1, (int *)((void *)0));
  td = (struct thread_data *)arg;
  foffset = td->foffset;
  rbuf = (char *)calloc(8192U, sizeof(char ));
  sd = socket(2, 1, 0);
  if (sd == -1) {
    tmp___0 = strerror(errno);
    Log((char *)"<THREAD #%ld> socket creation failed: %s", tid, tmp___0);
    pthread_exit((void *)1);
  }
  tmp___2 = connect(sd, (struct sockaddr  const  *)(& td->sin), sizeof(struct sockaddr ));
  if (tmp___2 == -1) {
    tmp___1 = strerror(errno);
    Log((char *)"<THREAD #%ld> connection failed: %s", tid, tmp___1);
    pthread_exit((void *)1);
  }
  tmp___4 = strlen((char const   *)(td->getstr));
  tmp___5 = send(sd, (void const   *)(td->getstr), tmp___4, 0);
  if (tmp___5 == -1) {
    tmp___3 = strerror(errno);
    Log((char *)"<THREAD #%ld> send failed: %s", tid, tmp___3);
    pthread_exit((void *)1);
  }
  dr = recv(sd, (void *)rbuf, 8192U, 0);
  if (dr == -1) {
    tmp___6 = strerror(errno);
    Log((char *)"<THREAD #%ld> recv failed: %s", tid, tmp___6);
    pthread_exit((void *)1);
  }
  handleHttpRetcode(rbuf);
  tmp___7 = strstr((char const   *)rbuf, "HTTP/1.1 206");
  if ((unsigned int )tmp___7 == (unsigned int )((void *)0)) {
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"Something unhandled happened, shutting down...\n");
    exit(1);
  }
  s = rbuf;
  i = 0;
  while (1) {
    if ((int )(*s) == 10) {
      if ((int )(*(s - 1)) == 13) {
        if ((int )(*(s - 2)) == 10) {
          if ((int )(*(s - 3)) == 13) {
            s ++;
            i ++;
            break;
          }
        }
      }
    }
    s ++;
    i ++;
  }
  td->offset = td->soffset;
  if ((long )(dr - i) > foffset) {
    dw = pwrite(td->fd, (void const   *)s, (unsigned int )(foffset - (long )i), td->soffset);
  } else {
    dw = pwrite(td->fd, (void const   *)s, (unsigned int )(dr - i), td->soffset);
  }
  td->offset = td->soffset + (long )dw;
  pthread_mutex_lock(& bwritten_mutex);
  bwritten = bwritten + dw;
  pthread_mutex_unlock(& bwritten_mutex);
  while (td->offset < foffset) {
    memset((void *)rbuf, 8192, 0U);
    dr = recv(sd, (void *)rbuf, 8192U, 0);
    if (td->offset + (long )dr > foffset) {
      dw = pwrite(td->fd, (void const   *)rbuf, (unsigned int )(foffset - td->offset),
                  td->offset);
    } else {
      dw = pwrite(td->fd, (void const   *)rbuf, (unsigned int )dr, td->offset);
    }
    td->offset = td->offset + (long )dw;
    pthread_mutex_lock(& bwritten_mutex);
    bwritten = bwritten + dw;
    pthread_mutex_unlock(& bwritten_mutex);
    updateProgressBar((float )bwritten, (float )td->clength);
  }
  if (td->offset == td->foffset) {
    td->status = (unsigned char)255;
  }
  close(sd);
  pthread_exit((void *)0);
  return ((void *)0);
}
}
extern int fclose(FILE *__stream ) ;
extern FILE *fopen(char const   * __restrict  __filename , char const   * __restrict  __modes ) ;
extern size_t fread(void * __restrict  __ptr , size_t __size , size_t __n , FILE * __restrict  __stream ) ;
extern size_t fwrite(void const   * __restrict  __ptr , size_t __size , size_t __n ,
                     FILE * __restrict  __s ) ;
extern int unlink(char const   *__name ) ;
void save_log(void) 
{ char *logfile ;
  struct hist_data h ;
  FILE *fp ;
  size_t tmp___0 ;
  int *tmp___1 ;
  char *tmp___2 ;

  {
  logfile = (char *)calloc(255U, sizeof(char ));
  tmp___0 = strlen((char const   *)((req + 0)->lfile));
  if (tmp___0 == 0U) {
    snprintf((char * __restrict  )logfile, 255U, (char const   * __restrict  )"aget-%s.log",
             (req + 0)->file);
  } else {
    snprintf((char * __restrict  )logfile, 255U, (char const   * __restrict  )"aget-%s.log",
             (req + 0)->lfile);
  }
  fp = fopen((char const   * __restrict  )logfile, (char const   * __restrict  )"w");
  if ((unsigned int )fp == (unsigned int )((void *)0)) {
    tmp___1 = __errno_location();
    tmp___2 = strerror((*tmp___1));
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"cannot open log file %s for writing: %s\n",
            logfile, tmp___2);
    exit(1);
  }
  memcpy((void * __restrict  )(& h.req), (void const   * __restrict  )req, sizeof(struct request ));
  memcpy((void * __restrict  )(& h.wthread), (void const   * __restrict  )wthread,
         sizeof(struct thread_data ) * (unsigned int )nthreads);
  h.nthreads = nthreads;
  h.bwritten = bwritten;
  printf((char const   * __restrict  )"--> Logfile is: %s, so far %d bytes have been transferred\n",
         logfile, h.bwritten);
  fwrite((void const   * __restrict  )(& h), sizeof(struct hist_data ), 1U, (FILE * __restrict  )fp);
  fclose(fp);
  free((void *)logfile);
  return;
}
}
int read_log(struct hist_data *h ) 
{ char *logfile ;
  FILE *fp ;
  size_t tmp___0 ;
  int *tmp___1 ;
  char *tmp___2 ;
  int *tmp___3 ;
  int *tmp___4 ;
  char *tmp___5 ;
  int tmp___6 ;

  {
  logfile = (char *)calloc(255U, sizeof(char ));
  tmp___0 = strlen((char const   *)((req + 0)->lfile));
  if (tmp___0 == 0U) {
    snprintf((char * __restrict  )logfile, 255U, (char const   * __restrict  )"aget-%s.log",
             (req + 0)->file);
  } else {
    snprintf((char * __restrict  )logfile, 255U, (char const   * __restrict  )"aget-%s.log",
             (req + 0)->lfile);
  }
  Log((char *)"Attempting to read log file %s for resuming download job...", logfile);
  fp = fopen((char const   * __restrict  )logfile, (char const   * __restrict  )"r");
  if ((unsigned int )fp == (unsigned int )((void *)0)) {
    tmp___3 = __errno_location();
    if ((*tmp___3) == 2) {
      Log((char *)"Couldn\'t find log file for this download, starting a clean job...");
      return (-1);
    } else {
      tmp___1 = __errno_location();
      tmp___2 = strerror((*tmp___1));
      fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"cannot open log file %s for reading: %s\n",
              logfile, tmp___2);
      exit(1);
    }
  }
  fread((void * __restrict  )h, sizeof(struct hist_data ), 1U, (FILE * __restrict  )fp);
  bwritten = h->bwritten;
  fclose(fp);
  Log((char *)"%d bytes already transferred", bwritten);
  tmp___6 = unlink((char const   *)logfile);
  if (tmp___6 == -1) {
    tmp___4 = __errno_location();
    tmp___5 = strerror((*tmp___4));
    fprintf((FILE * __restrict  )stderr, (char const   * __restrict  )"read_log: cannot remove stale log file %s: %s\n",
            logfile, tmp___5);
  }
  free((void *)logfile);
  return (0);
}
}
