/*
 * rcwGenerator.h
 * 
 * Kiyan Ahmadizadeh
 * Cornell University 2010
 */

#ifndef RCWGENERATOR_H_
#define RCWGENERATOR_H_

// Number of kms by which to increase search radius
// for initial territories.
#define SEARCH_RADIUS_INCR 50
#include<vector>
#include<map>
#include<set>
#include<algorithm>
using namespace std;

struct parcel_record {
	int	parcel_index;
	// Sum of suitabilities of territories within
	int	terr_count;
	//parcel (used for average later).
	double suit_sum;
};
// Used to sort parcels by average territory suitability.
static bool pr_lessthan(parcel_record* p1, parcel_record* p2) {
	return (p1->suit_sum / p1->terr_count) <
		(p2 ->suit_sum / p2->terr_count);
}


class rcwGenerator {
private:
	// Data extracted from GIS layer.
	int numTerr, numParcel, maxSuitability;
	vector<double> xCoords;
	vector<double> yCoords;
	vector<int> baseSuitabilities;
	set<int> parcels;
	vector<int> terrToParcel;
	// Map gis index to zero based index.
	map<int,int> parcelIndex;
	// Ranges from which parcel costs are chosen.  One range
	// is created for each suitability value.
	vector<int> costMins;
	vector<int> costMaxes;
	// Data set randomly.
	vector<double> parcelCosts;
	vector<bool> initialTerritories;
	vector<int> suitabilities;


public:
	rcwGenerator(char* gisfname, char* costsfname, int maxSuit);
	void generateInstance(long seed, int numInitials);
	void printCurrentMap();
	virtual ~rcwGenerator();
};

#endif /* RCWGENERATOR_H_ */
