/*
 * generate_map.cpp
 *
 * Kiyan Ahmadizadeh
 * Cornell University 2010
 */

#include "rcwGenerator.h"
#include <getopt.h>
#include <iostream>
using namespace std;

void usage() {
	cout << "./generate_map [options]" << endl;
	cout << "Generates a random map instance, based on the provided" << endl;
	cout << "GIS data, and outputs this instance to stdout.\n\n";
	cout << "options:\n";
	cout << "-h \t\t\t Prints this message\n";
	cout << "--gisfile=<file> \t Path to a file containing the base GIS data\n";
	cout << "\t\t\t to generate map instance from. \n";
	cout << "--costfile=<file> \t Path to a file containing a list of cost ranges \n";
	cout << "\t\t\t for each suitability score on map.\n";
	cout << "--ninit=<int> \t\t Number of initial territories to choose.\n";
	cout << "--seed=<int> \t\t Random seed to use for generation.\n";

}
int main(int argc, char* argv[]) {
	char *gisfname;
	char *costfname;
	int numInitTerr;
	long seed;
	bool gf_flag = false;
	bool cf_flag = false;
	bool ni_flag = false;
	bool s_flag = false;

	// Read in the required arguments.
	int c;
	while (true) {
        static struct option long_options[] =
          {
            {"gisfile",     required_argument,       0, 'a'},
            {"costfile",  required_argument,       0, 'b'},
            {"ninit",  required_argument, 0, 'c'},
            {"seed",  required_argument, 0, 'd'},
            {0, 0, 0, 0}
          };
        /* getopt_long stores the option index here. */
        int option_index = 0;
        c = getopt_long (argc, argv, "a:b:c:d:h",
                         long_options, &option_index);
        /* Detect the end of the options. */
        if (c == -1)
          break;
        switch (c) {
        case 'h':
        	usage();
        	exit(0);
        	break;
        case 'a':
        	gisfname = optarg;
        	gf_flag = true;
        	break;
        case 'b':
        	costfname = optarg;
        	cf_flag = true;
        	break;
        case 'c':
        	numInitTerr = atoi(optarg);
        	ni_flag = true;
        	break;
        case 'd':
        	seed = atoi(optarg);
        	s_flag = true;
        	break;
        default:
        	cerr << "Unrecognized argument.\n ";
        	usage();
        	exit(-1);
        }

	}
    if (!gf_flag) {
    	cerr << "Missing argument --gisfile" << endl;
    	usage();
    	exit(-1);
    }
    if (!cf_flag) {
    	usage();
    	cerr << "Missing argument --costfile" << endl;
    	exit(-1);
    }
    if (!ni_flag) {
    	usage();
    	cerr << "Missing argument --ninit" << endl;
    	exit(-1);
    }
    if (!s_flag) {
    	usage();
    	cerr << "Missing argument --seed" << endl;
    	exit(-1);
    }

    // Create a generator.
    rcwGenerator generator(gisfname, costfname, 10);
    generator.generateInstance(seed, numInitTerr);
    generator.printCurrentMap();

}
