/*
 * uct_dumb_test.cpp
 *
 *  Created on: Aug 2, 2010
 *      Author: kiyan
 */
#include "Evaluator.h"
#include "RCWEvaluatorFixed.h"
#include <cmath>
#include <getopt.h>
#include <iostream>
#include <time.h>
#include <fstream>
using namespace std;

void usage() {
	cout << "./rcw-prob-gen" << endl;
	cout << "RCW Mixed Integer Program Generator" << endl;
	cout << "Generates a MIP instance that encodes the selection of  " << endl;
	cout << "of a set of land parcels with cost that maximize the " << endl;
	cout << "number of land patches occupied by the Red-Cockaded " << endl;
	cout << "Woodpecker across a sample of simulations." << endl;
	cout << "Options: " << endl;
	cout << "--outfile \t File model is written to.\n";
	cout << "--mapfile \t File containing map information.\n";
	cout << "--colfile \t File containing probabilities for simulation\n";
	cout << "--horizon \t Time horizon of simulations.\n";
	cout << "--bper \t\t Float in [0,1] giving the percentage of the total\n";
	cout << "\t\t cost of all land parcels to use as budget.\n";
	cout << "--seed \t\t The random seed to use for simulation\n";
	cout << "--nsamp \t The number of simulations to sample and encode\n";
	cout << "\t\t in the MIP.\n";
}
int main(int argc, char* argv[]) {
	// Arguments from the cmd line.
	char* outFile;
	char* mapFile;
	char* colFile;
	int horizon;
	double bper;
	int seed;
	int simSetSize;

	// Parse from the cmd line.
    int c;

    while (true)
      {
        static struct option long_options[] =
          {
            /* Set the trim flag. */
            {"outfile",    required_argument, 0, 'e'},
            {"mapfile",	required_argument, 0, 'f'},
            {"colfile", required_argument, 0, 'g'},
            {"horizon", required_argument, 0, 'h'},
            {"bper", required_argument, 0, 'i'},
            {"seed", required_argument, 0, 'j'},
            {"nsamp", required_argument, 0, 'm'},
            {"help", no_argument, 0, 'n'},
            {0, 0, 0, 0}
          };
        /* getopt_long stores the option index here. */
        int option_index = 0;

        c = getopt_long (argc, argv, "e:f:g:h:i:j:m:n",
                         long_options, &option_index);

        /* Detect the end of the options. */
        if (c == -1)
          break;
        switch (c)
          {

          case 'e':
            outFile = optarg;
            break;
          case 'f':
        	  mapFile = optarg;
        	  break;
          case 'g':
        	  colFile = optarg;
        	  break;
          case 'h':
        	  horizon = atoi(optarg);
        	  break;
          case 'i':
        	  bper = atof(optarg);
        	  break;
          case 'j':
        	  seed = atoi(optarg);
        	  break;
          case 'm':
        	  simSetSize = atoi(optarg);
        	  break;
          case 'n':
        	  usage();
        	  exit(0);
          default:
        	  cerr << "Unknown argument.\n";
            abort ();
          }
      }

	// Create the evaluator.
	RCWEvaluatorFixed* evaluator = new RCWEvaluatorFixed(mapFile,
			colFile, horizon, 0.30, 0.01, simSetSize, 5, simSetSize);
	cout << "Done loading problem data." << endl;
	cout << "Num Territories: " << evaluator->getNumTerritories() << endl;
	cout << "Num Parcels: " << evaluator->getNumParcels() << endl;

	// Find the correct budget to use.
	double* parcelCosts = evaluator->getParcelCosts();
	double totalCost = 0;
	for (int i=0; i < evaluator->getNumParcels(); i++) {
		totalCost += parcelCosts[i];
	}
	double budget = totalCost * bper;
	cout << "Available Budget: " << budget << endl;

	cout << "Performing simulations";
	// Generate the simulation set.
	for (int i=0; i < simSetSize; i++) {
		evaluator->simulateAndStore(rand(), i);
		cout << ".";
	} cout << endl;

	cout << "Writing model."  << endl;
	// Write the model.
	evaluator->writeModel(outFile, round(budget));
	cout << "Done." << endl;
}
