/*
 * RCWEvaluator.h
 *
 *  Created on: Aug 3, 2010
 *      Author: kiyan
 */

#ifndef RCWEVALUATORFIXED_H_
#define RCWEVALUATORFIXED_H_

#define	CONVERGE_CNT 20

#include "Evaluator.h"
#include "Colonization.h"
#include <vector>
#include <set>
#include<time.h>

using namespace std;

class RCWEvaluatorFixed: public Evaluator {
private:
	double*			xCoords;
	double*			yCoords;
	int				numTerritories;
	int				numParcels;
	double*			parcelCosts;
	int*			suitabilities;
	int*			terrToParcel;
	bool*			initialTerritories;
	bool*			initialParcels;
	double*			suitProbs;
	//bool**			occupations;
	set<int>***		occupationsLists;
	set<int>****	spreads;
	int				horizon;
	double			extinctionProb;
	vector<int>*	adjacencyList;
	Colonization*	colMatrix;
	double			evalConvergeEpi;
	double			maxEvalSims;
	vector<int>		genSeeds;
	int				numConvergeItrs;
	int*			touchCounts;
	clock_t			totalTime;
	int				numSimulations;
//	IloEnv env;
//	IloModel model;
//	IloCplex cplex;
//    IloNumVarArray   buy;
//    IloNumVarArray3  activity;
//    IloNumVarArray   objective;


public:
	RCWEvaluatorFixed(char* terrfile, char* colfile, int _horizon,
			double _extinctionProb, double _evalConvergeEpi, int _maxEvalSims,
			int _numConvergeItrs, int _numSimulations);
	int	simulateAndStore(int seed, int simNum);
	int getNumTerritories();
	double* getParcelCosts() {return parcelCosts; }
	int getNumParcels() {return numParcels; }
	bool* getInitialParcels() {return initialParcels; }
	double virtual evaluate(bool* decisions, int seed);
	int getUntouchables(set<int>* untouchables, int thresh);
	void trimAdjacency(int thresh);
	double getEvalTimeInSeconds();
	int simulateForTouch(int seed);
	int simulate(bool* decisions, int seed);
	double forwardPass(bool* decisions, int sim);
	void writeModel(char* fname, int budget);
	virtual ~RCWEvaluatorFixed();
};

#endif /* RCWEVALUATOR_H_ */
