/*
 * RCWEvaluator.cpp
 *
 *  Created on: Aug 3, 2010
 *      Author: kiyan
 */

#include "RCWEvaluatorFixed.h"
#include <fstream>
#include <iostream>
#include <vector>
#include <cmath>
using namespace std;

RCWEvaluatorFixed::RCWEvaluatorFixed(char* terrfile, char* colfile, int _horizon,
		double _extinctionProb, double _evalConvergeEpi, int _maxEvalSims,
		int _numConvergeItrs, int _numSimulations)  {
	totalTime = 0;
	horizon = _horizon;
	extinctionProb = _extinctionProb;
	evalConvergeEpi = _evalConvergeEpi;
	maxEvalSims = _maxEvalSims;
	numConvergeItrs = _numConvergeItrs;
	numSimulations = _numSimulations;

	fstream terrstream;
	terrstream.open(terrfile, fstream::in);
	// Read in the number of territories and parcels.
	terrstream >> numTerritories;
	terrstream >> numParcels;
	// Initialize class fields.
	//cout << "got here" << numTerritories <<  " " << numParcels << endl;

	parcelCosts = new double[numParcels];
	suitabilities = new int[numTerritories];
	terrToParcel = new int[numTerritories];
	initialTerritories = new bool[numTerritories];
	initialParcels = new bool[numParcels];
	xCoords = new double[numTerritories];
	yCoords = new double[numTerritories];

	// Read in parcel costs.
	double tempCost = 0;
	char comma;
	for (int i=0; i < numParcels; i++) {
		initialParcels[i] = false;
	}
	for (int i=0; i < numParcels; i++) {
		terrstream >> tempCost;
		if (i != numParcels-1)
			terrstream >> comma;
		parcelCosts[i] = tempCost;
	}
	int initialFlag;
	// Read a line for each territory.
	for (int i=0; i < numTerritories; i++) {
		terrstream >> xCoords[i];
		terrstream >> comma;
		terrstream >> yCoords[i];
		terrstream >> comma;
		terrstream >> suitabilities[i];
		terrstream >> comma;
		terrstream >> terrToParcel[i];
		terrstream >> comma;
		terrstream >> initialFlag;
		if (initialFlag){
			initialTerritories[i] = true;
			initialParcels[terrToParcel[i]] = true;
		} else {
			initialTerritories[i] = false;
		}
	}

	suitProbs = new double[numTerritories];
	for (int i=0; i < numTerritories; i++) {
		suitProbs[i] = suitabilities[i] / 9.0;
	}

	terrstream.close();

	occupationsLists = new set<int>**[numSimulations];
	for (int i=0; i < numSimulations; i++) {
		occupationsLists[i] = new set<int>*[horizon];
		for (int j=0; j < horizon; j++) {
			occupationsLists[i][j] = new set<int>();
		}
	}
	spreads = new set<int>***[numSimulations];
	for (int i=0; i < numSimulations; i++) {
		spreads[i] = new set<int>**[horizon];
		for (int j=0; j < horizon; j++) {
			spreads[i][j] = new set<int>*[numTerritories];
			for (int k=0; k < numTerritories; k++) {
				spreads[i][j][k] = new set<int>();
			}
		}
	}

	for (int i=0; i < numTerritories; i++) {
		if (initialTerritories[i]) {
			for (int j=0; j < numSimulations; j++) {
				occupationsLists[j][0]->insert(i);
			}
		}
	}

	adjacencyList = new vector<int>[numTerritories];
	colMatrix = new Colonization(numTerritories, colfile, 12, adjacencyList);
//	cout << "Territory Information" << endl;
//	for (int i=0; i < numTerritories; i++) {
//		cout << xCoords[i] << "\t" << yCoords[i] << "\t"
//			<< suitabilities[i] << "\t" << suitProbs[i] <<
//			"\t" << terrToParcel[i] << "\t" << initialTerritories[i] << "\n";
//
//	}
//	cout << "Parcel Information" << endl;
//	for (int i=0; i < numParcels; i++) {
//		cout << parcelCosts[i] << "\t" << initialParcels[i] << endl;
//	}
//	cout << "Adjacency Lists." << endl;
//	for (int i=0; i < numTerritories; i++) {
//		for (unsigned j=0; j < adjacencyList[i].size(); j++)
//			cout << adjacencyList[i][j] << " ";
//		cout << endl;
//	}

	touchCounts = new int[numParcels];
	for (int i=0; i < numParcels; i++)
		touchCounts[i] = 0;
}

int RCWEvaluatorFixed::getUntouchables(set<int>* untouchables, int thresh) {
	int cutCount = 0;
	for (int i=0; i < numParcels; i++) {
		if (touchCounts[i] < thresh) {
			untouchables->insert(i);
			cutCount++;
		}
	}
	return cutCount;
}

void RCWEvaluatorFixed::trimAdjacency(int thresh) {
	set<int> untouchables;
	this->getUntouchables(&untouchables, thresh);
	for (int i=0; i < numTerritories; i++) {
		for (vector<int>::iterator itr=adjacencyList[i].begin();
				itr < adjacencyList[i].end(); itr++) {
//			cout << "start.\n";
			if (untouchables.count(terrToParcel[*itr]) == 1) {
				adjacencyList[i].erase(itr);
			}
//			cout << "end.\n";
		}
	}
	cout << "big end.\n";
}

int RCWEvaluatorFixed::simulate(bool* decisions, int seed) {
//	cout << "SIMULATION DECISIONS:" << endl;
//	for (int i=0; i < getNumParcels(); i++) {
//		if (decisions[i])
//			cout << i << " " ;
//	} cout << endl;
//	cout << "Terr to parcel" << endl;
//	for (int i=0; i < numTerritories; i++) {
//		cout << i << "\t" << terrToParcel[i] << endl;
//	}
//	srand(seed);
//	cout << "Extinction Prob: " << extinctionProb << endl;
	set<int> toccupationsLists[horizon];
	for (int i=0; i < numTerritories; i++) {
		if (initialTerritories[i])
			toccupationsLists[0].insert(i);
	}
//	bool** toccupations = new bool[horizon][numTerritories];
	for (int i=0; i < horizon-1; i++) {
		// For every occupied territory at this step.
		for (set<int>::iterator terr1 = toccupationsLists[i].begin();
				terr1 != toccupationsLists[i].end(); terr1++) {
			for (unsigned j=0; j < adjacencyList[*terr1].size(); j++) {
				int terr2 = adjacencyList[*terr1][j];
				if (*terr1 != terr2 &&
						decisions[terrToParcel[terr2]] &&
						(((double)rand())/RAND_MAX) <= colMatrix->getProbability(*terr1, terr2) &&
						(((double)rand())/RAND_MAX) <= suitProbs[terr2] )
					{
//					cout << ".";
//					occupations[i+1][terr2] = true;
					toccupationsLists[i+1].insert(terr2);

				} else if (*terr1 == terr2) {
					if ((((double)rand())/RAND_MAX) <= 0.70) {
	//					cout << "*" << endl;
	//					occupations[i+1][terr2] = true;
						toccupationsLists[i+1].insert(terr2);

					}
//					cout << "ext: " << extinctionProb << endl;
//					cout << (((double)rand())/RAND_MAX) << endl;
				}
			}
		}
	}
	int objective = toccupationsLists[horizon-1].size();
	return objective;
}

int RCWEvaluatorFixed::simulateForTouch(int seed) {
//	cout << "SIMULATION DECISIONS:" << endl;
//	for (int i=0; i < getNumParcels(); i++) {
//		if (decisions[i])
//			cout << i << " " ;
//	} cout << endl;
//	cout << "Terr to parcel" << endl;
//	for (int i=0; i < numTerritories; i++) {
//		cout << i << "\t" << terrToParcel[i] << endl;
//	}
//	srand(seed);
//	cout << "Extinction Prob: " << extinctionProb << endl;
	set<int> toccupationsLists[horizon];
	for (int i=0; i < numTerritories; i++) {
		if (initialTerritories[i])
			toccupationsLists[0].insert(i);
	}
//	bool** toccupations = new bool[horizon][numTerritories];
	for (int i=0; i < horizon-1; i++) {
		// For every occupied territory at this step.
		for (set<int>::iterator terr1 = toccupationsLists[i].begin();
				terr1 != toccupationsLists[i].end(); terr1++) {
			for (unsigned j=0; j < adjacencyList[*terr1].size(); j++) {
				int terr2 = adjacencyList[*terr1][j];
				if (*terr1 != terr2 &&
						/*decisions[terrToParcel[terr2]] &&*/
						(((double)rand())/RAND_MAX) <= colMatrix->getProbability(*terr1, terr2) &&
						(((double)rand())/RAND_MAX) <= suitProbs[terr2] )
					{
//					cout << ".";
//					occupations[i+1][terr2] = true;
					toccupationsLists[i+1].insert(terr2);

				} else if (*terr1 == terr2) {
					if ((((double)rand())/RAND_MAX) <= 0.70) {
	//					cout << "*" << endl;
	//					occupations[i+1][terr2] = true;
						toccupationsLists[i+1].insert(terr2);

					}
//					cout << "ext: " << extinctionProb << endl;
//					cout << (((double)rand())/RAND_MAX) << endl;
				}
			}
		}
	}
	int objective = toccupationsLists[horizon-1].size();
	for (int i=1; i < horizon; i++) {
//		cout << i <<": " << occupationsLists[i].size() << endl;
		for (set<int>::iterator itr = toccupationsLists[i].begin();
				itr  != toccupationsLists[i].end(); itr++) {
//			occupations[i][*itr] = false;
			touchCounts[terrToParcel[*itr]] ++;
		}
		toccupationsLists[i].clear();
	}
	return objective;
}

int RCWEvaluatorFixed::simulateAndStore(int seed, int simNum) {
//	cout << "SIMULATION DECISIONS:" << endl;
//	for (int i=0; i < getNumParcels(); i++) {
//		if (decisions[i])
//			cout << i << " " ;
//	} cout << endl;
//	cout << "Terr to parcel" << endl;
//	for (int i=0; i < numTerritories; i++) {
//		cout << i << "\t" << terrToParcel[i] << endl;
//	}
//	srand(seed);
//	cout << "Extinction Prob: " << extinctionProb << endl;
	for (int i=0; i < horizon-1; i++) {
		// For every occupied territory at this step.
		for (set<int>::iterator terr1 = occupationsLists[simNum][i]->begin();
				terr1 != occupationsLists[simNum][i]->end(); terr1++) {
			for (unsigned j=0; j < adjacencyList[*terr1].size(); j++) {
				int terr2 = adjacencyList[*terr1][j];
				if (*terr1 != terr2 &&
						(((double)rand())/RAND_MAX) <= colMatrix->getProbability(*terr1, terr2) &&
						(((double)rand())/RAND_MAX) <= suitProbs[terr2] )
					{
//					cout << ".";
//					occupations[i+1][terr2] = true;
					occupationsLists[simNum][i+1]->insert(terr2);
					spreads[simNum][i+1][terr2]->insert(*terr1);

				} else if (*terr1 == terr2) {
					if ((((double)rand())/RAND_MAX) <= 0.70) {
						occupationsLists[simNum][i+1]->insert(terr2);
						spreads[simNum][i+1][terr2]->insert(*terr1);

					}
//					cout << "ext: " << extinctionProb << endl;
//					cout << (((double)rand())/RAND_MAX) << endl;
				}
			}
		}
	}
	return occupationsLists[simNum][horizon-1]->size();

}

double RCWEvaluatorFixed::forwardPass(bool* decisions, int sim) {
	set<int> toccupationsLists[horizon];
	// Choose a random simulation to evaluate the decisions on.
	//int sim = rand() % numSimulations;
	// Get initials.
	toccupationsLists[0].insert(occupationsLists[sim][0]->begin(),
			occupationsLists[sim][0]->end());

	for (int i=1; i < horizon; i++) {
		for (set<int>::iterator itr = occupationsLists[sim][i]->begin();
				itr != occupationsLists[sim][i]->end(); itr++) {
			// This territory should be occupied under the decisions
			// if there is a spread from a territory occupied in the
			// previous timestep.
			if (!decisions[terrToParcel[*itr]]) continue;
			for (set<int>::iterator itr2 = spreads[sim][i][*itr]->begin();
					itr2 != spreads[sim][i][*itr]->end(); itr2++) {
				if (toccupationsLists[i-1].count(*itr2)) {
					toccupationsLists[i].insert(*itr);
					break;
				}
			}
		}
	}
	double objective = (double)toccupationsLists[horizon-1].size();
	return objective;
}

double RCWEvaluatorFixed::evaluate(bool* decisions, int seed) {
	clock_t start = clock();
	double evalSum = 0;
	int numEvals = 0;
	for (; numEvals < maxEvalSims; numEvals++) {
		evalSum += (this->forwardPass(decisions, numEvals));
	}
	clock_t end = clock();
	totalTime += (end-start);
	return evalSum / numEvals;
}

double RCWEvaluatorFixed::getEvalTimeInSeconds() {
	return (double) (totalTime / CLOCKS_PER_SEC);
}
int RCWEvaluatorFixed::getNumTerritories() {
	return numTerritories;
}

void RCWEvaluatorFixed::writeModel(char* fname, int budget) {
	fstream lp;
	lp.open(fname, ios::out);

	// Add the objective
	lp << "MAXIMIZE" << endl;
	for (int k = 0; k < maxEvalSims; k++)
	{
		for (int i = 0; i < numTerritories; i++)
		{
			// ignore unreachable targets
			if (occupationsLists[k][horizon-1]->count(i) )
			{
				lp << " + A#"<<k<<"#"<<horizon-1<<"#"<<i<<  " " << endl;
			}
		}
	}

	lp << "SUBJECT TO" << endl;

	// Initial constraints
	// purchase initial parcels at time 0.
	for (int i=0; i < numParcels; i++) {
		if (initialParcels[i]) {
			lp << "P#" << i << " = 1" << endl;
		}
	}
	// Initially active territories.
	for (int i=0; i < maxEvalSims; i++) {
		for (int j=0; j < numTerritories; j++) {
			lp << "A#"<<i<<"#0#"<<j;
			if (initialTerritories[j]) {
				lp << " = 1" << endl;
			} else lp << " = 0" << endl;
		}
	}

	// If terr is active at time j, it was purchased
	for (int i=0; i < maxEvalSims; i++) {
		for (int j=0; j < horizon; j++) {
			for (int k=0; k < numTerritories; k++) {
				lp << "- A#"<<i<<"#"<<j<<"#"<<k << " + P#" << terrToParcel[k] << " >= 0" << endl;
			}
		}
	}

	// activity constraints from samples.
	for (int i=0; i < maxEvalSims; i++) {
		for (int j=1; j < horizon; j++) {
			for (int k=0; k < numTerritories; k++) {
				// If terr k not occupied in cascade, not active.
				if (!occupationsLists[i][j]->count(k)) {
					lp << "A#" << i << "#" << j << "#" << k << " = 0" << endl;
				} else {
					// For terr k to be active at time j, one of its
					// incoming edges was active at time j-1.
					lp << "- A#" << i << "#" << j << "#" << k << " ";
					for(set<int>::iterator itr = spreads[i][j][k]->begin();
							itr != spreads[i][j][k]->end(); itr++) {
						lp << "+ A#" << i << "#" << j-1 << "#" << *itr << " " << endl;
					}
					lp << ">= 0" << endl;
				}
			}
		}
	}

	// Budget constraint
	for (int a = 0; a < numParcels; a++)
	{
		lp << parcelCosts[a] << " P#" << a << " ";
		if (a != numParcels-1) lp << "+ ";
		lp << endl;

		//cout << "COST " << parcelCosts[a] << endl;
	}
	lp << "<= " << budget << endl;

	// Indicate bounds on continuous vars.
	for (int i=0; i < maxEvalSims; i++) {
		for (int j=0; j < horizon; j++) {
			for (int k=0; k < numTerritories; k++) {
				lp << "A#" << i << "#" << j <<"#" << k << " <= 1" << endl;
				lp << "A#" << i << "#" << j <<"#" << k << " >= 0" << endl;

			}
		}
	}

	// Indicate binary vars
	lp << "BINARY" << endl;
	for (int a=0; a < numParcels; a++) {
		lp << "P#" << a << endl;
	}

	lp << "END" << endl;
	lp.close();

}



RCWEvaluatorFixed::~RCWEvaluatorFixed() {
	delete xCoords;
	delete yCoords;
	delete suitabilities;
	delete terrToParcel;
	delete initialTerritories;
	delete initialParcels;
//	for (int i=0; i < horizon; i++) {
//		delete occupations[i];
//	}
//	delete occupations;
	// non-aligned pointer being freed?
	//delete occupationsLists;
}
