/*
 * Colonization.cpp
 *
 *  Created on: Aug 3, 2010
 *      Author: kiyan
 */

#include "Colonization.h"
#include<fstream>
#include<cmath>
#include<iostream>
using namespace std;

Colonization::Colonization(int _numTerritories, char* colfile,
		double cutoff, vector<int>* adjacencyList) {
	numTerritories = _numTerritories;
	probMatrix = new map<int, double>[numTerritories];

	// Open the colonization file.
	fstream colstream;
	double prob = 0;
	char comma;
	colstream.open(colfile, ios::in);
	// Read a line for each territory.
	for (int i=0; i < numTerritories; i++) {
		// Read the probability for each neighbor.
		for (int j=0; j < numTerritories; j++) {
			colstream >> prob;

//			if (j != numTerritories-1)
//				colstream >> comma;
			// Omit any entries that are zero to "cutoff" sig figs.
//			if (i==j || prob * pow(10.0, cutoff) > 1.0) {
				probMatrix[i][j] = prob;
				adjacencyList[i].push_back(j);
//			}
		}
	}
//	cout << "ADJACENCY LIST: " << endl;
//	for (int i=0; i < numTerritories; i++) {
//		for (int j=0; j < adjacencyList[i].size(); j++) {
//			cout << adjacencyList[i][j] << " ";
//		}
//		cout << endl;
//	}
	colstream.close();
//	fstream colout;
//	colout.open("coloutput.dat", ios::out);
//	for (int i=0; i < numTerritories; i++) {
//		for (int j=0; j < numTerritories; j++) {
//			colout << probMatrix[i][j];
//			if (j != numTerritories-1)
//				colout << "   ";
//		}
//		colout << endl;
//	}
}

double Colonization::getProbability(int i, int j) {
	if (probMatrix[i].count(j))
		return probMatrix[i][j];
	else return 0;
}
Colonization::~Colonization() {
	delete probMatrix;
}
