#lang typed/racket

(require benchmark-util)

(require/typed/check "data.rkt"
  [#:struct posn ([x : Real]
                  [y : Real])]
  [#:struct snake ([dir : Dir]
                   [segs : NEPosnList])]
  [#:struct world ([snake : Snake]
                   [food  : Posn])]
  [#:struct posncons ([car : Posn]
                      [cdr : PosnList])])

(define-type NEPosnList PosnCons)
(define-type PosnCons posncons)
(define-type PosnList (U PosnCons Null))
(define-type Dir (U "up" "down" "left" "right"))
(define-type Snake snake)
(define-type World world)
(define-type Posn  posn)

(provide
 (struct-out posn)
 (struct-out snake)
 (struct-out world)
 (struct-out posncons)
 Dir
 Snake
 World
 Posn
 NEPosnList
 PosnCons
 PosnList)
